/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.ActionButton;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BoxLayout;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ActionPanel
extends NonOpaquePanel {
    private final List<ActionButton> buttons = new ArrayList<ActionButton>();
    private final JBTabsImpl tabs;
    private final TabInfo info;
    private boolean myAutoHide;
    private boolean myActionsIsVisible = false;
    private boolean myMarkModified = false;

    public ActionPanel(JBTabsImpl tabs, TabInfo tabInfo, Consumer<? super MouseEvent> pass, Consumer<? super Boolean> hover) {
        this.tabs = tabs;
        this.info = tabInfo;
        ActionGroup group = tabInfo.getTabLabelActions() != null ? tabInfo.getTabLabelActions() : new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        List children = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.of(o -> {
            AnAction[] anActionArray;
            if (o instanceof DefaultActionGroup) {
                DefaultActionGroup g = (DefaultActionGroup)((Object)o);
                anActionArray = g.getChildren(actionManager);
            } else {
                anActionArray = AnAction.EMPTY_ARRAY;
            }
            return anActionArray;
        }).withRoot((Object)group)).filter(o -> o.getActionUpdateThread() == ActionUpdateThread.EDT)).toList();
        if (LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred() && !UISettings.getInstance().getCloseTabButtonOnTheRight()) {
            children = ContainerUtil.reverse((List)children);
        }
        this.setFocusable(false);
        NonOpaquePanel wrapper = new NonOpaquePanel(new BorderLayout());
        wrapper.setFocusable(false);
        NonOpaquePanel inner = new NonOpaquePanel();
        inner.setLayout(new BoxLayout(inner, 0));
        wrapper.add((Component)inner, "Center");
        for (AnAction each : children) {
            ActionButton eachButton = new ActionButton(this, tabInfo, each, tabInfo.getTabActionPlace(), pass, hover, tabs.getTabActionsMouseDeadZone$intellij_platform_ide()){

                @Override
                protected void repaintComponent(Component c) {
                    TabLabel tabLabel = (TabLabel)SwingUtilities.getAncestorOfClass(TabLabel.class, c);
                    if (tabLabel != null) {
                        Point point = SwingUtilities.convertPoint(c, new Point(0, 0), tabLabel);
                        Dimension d = c.getSize();
                        tabLabel.repaint(point.x, point.y, d.width, d.height);
                    } else {
                        super.repaintComponent(c);
                    }
                }
            };
            this.buttons.add(eachButton);
            InplaceButton component = eachButton.getComponent();
            component.setFocusable(false);
            inner.add(component);
        }
        this.add(wrapper);
        UIUtil.uiTraverser((Component)wrapper).forEach(c -> c.setFocusable(false));
    }

    @Override
    public void paint(Graphics g) {
        boolean isSelected;
        TabLabel label2 = this.tabs.getTabLabel(this.info);
        boolean isHovered = label2 != null && label2.isHovered();
        boolean bl = isSelected = this.tabs.getSelectedInfo() == this.info;
        if (ExperimentalUI.isNewUI() && this.tabs instanceof JBEditorTabs && !isSelected && !isHovered && !this.myMarkModified && !this.info.isPinned()) {
            return;
        }
        super.paint(g);
    }

    public boolean update() {
        if (this.getRootPane() == null) {
            return false;
        }
        boolean changed = false;
        boolean anyVisible = false;
        boolean anyModified = false;
        for (ActionButton each : this.buttons) {
            changed |= each.update();
            each.setMouseDeadZone(this.tabs.getTabActionsMouseDeadZone$intellij_platform_ide());
            anyVisible |= each.getComponent().isVisible();
            Boolean markModified = (Boolean)each.getPrevPresentation().getClientProperty(JBEditorTabs.MARK_MODIFIED_KEY);
            if (markModified == null) continue;
            anyModified |= markModified.booleanValue();
        }
        this.myActionsIsVisible = anyVisible;
        this.myMarkModified = anyModified;
        return changed;
    }

    public boolean isAutoHide() {
        return this.myAutoHide;
    }

    public void setAutoHide(boolean autoHide) {
        this.myAutoHide = autoHide;
        for (ActionButton each : this.buttons) {
            each.setAutoHide(this.myAutoHide);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myActionsIsVisible ? super.getPreferredSize() : new Dimension(0, 0);
    }

    public void toggleShowActions(boolean show) {
        for (ActionButton each : this.buttons) {
            each.toggleShowActions(show);
        }
    }
}

