/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;

public abstract class BaseButtonBehavior {
    public static final int MOUSE_PRESSED_RELEASED = -1;
    private final JComponent myComponent;
    private boolean myHovered;
    private boolean myFocused;
    private boolean myPressedByMouse;
    private boolean myPressedByKeyboard;
    private final TimedDeadzone myMouseDeadzone;
    private int myActionTrigger;

    protected BaseButtonBehavior(JComponent component, Void sig) {
        this(component, TimedDeadzone.DEFAULT, sig);
    }

    protected BaseButtonBehavior(JComponent component, TimedDeadzone.Length mouseDeadzoneTime, Void sig) {
        this.myComponent = component;
        this.myMouseDeadzone = new TimedDeadzone(mouseDeadzoneTime);
    }

    public void setupListeners() {
        this.myComponent.addMouseListener(new MyMouseListener());
        this.myComponent.addMouseMotionListener(new MyMouseMotionListener());
        this.myComponent.addKeyListener(new PressedKeyListener());
        this.myComponent.addFocusListener(new ButtonFocusListener());
        this.setActionTrigger(502);
    }

    @Deprecated
    public BaseButtonBehavior(JComponent component) {
        this(component, TimedDeadzone.DEFAULT);
    }

    @Deprecated
    public BaseButtonBehavior(JComponent component, TimedDeadzone.Length mouseDeadzoneTime) {
        this.myComponent = component;
        this.myMouseDeadzone = new TimedDeadzone(mouseDeadzoneTime);
        this.setupListeners();
    }

    public void setActionTrigger(int trigger) {
        assert (trigger == 501 || trigger == 502 || trigger == -1);
        this.myActionTrigger = trigger;
    }

    public final boolean isHovered() {
        return this.myHovered;
    }

    private void setHovered(boolean hovered) {
        this.myHovered = hovered;
        this.repaintComponent();
    }

    public final boolean isFocused() {
        return this.myFocused;
    }

    private void setFocused(boolean isFocused) {
        this.myFocused = isFocused;
        this.repaintComponent();
    }

    public final boolean isPressedByMouse() {
        return this.myPressedByMouse;
    }

    private void setPressedByMouse(boolean pressedByMouse) {
        this.myPressedByMouse = pressedByMouse;
        this.repaintComponent();
    }

    public final boolean isPressedByKeyboard() {
        return this.myPressedByKeyboard;
    }

    private void setPressedByKeyboard(boolean isPressedByKeyboard) {
        this.myPressedByKeyboard = isPressedByKeyboard;
        this.repaintComponent();
    }

    public void setMouseDeadzone(TimedDeadzone.Length deadZone) {
        this.myMouseDeadzone.setLength(deadZone);
    }

    protected void repaintComponent() {
        this.repaint(this.myComponent);
    }

    protected void repaint(Component c) {
        c.repaint();
    }

    protected abstract void execute(MouseEvent var1);

    protected void pass(MouseEvent e) {
    }

    private class MyMouseListener
    extends MouseAdapter {
        private boolean myWasPressedOnFocusTransfer;

        private MyMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            BaseButtonBehavior.this.myMouseDeadzone.enter(e);
            BaseButtonBehavior.this.setHovered(true);
            BaseButtonBehavior.this.repaintComponent();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BaseButtonBehavior.this.myMouseDeadzone.clear();
            BaseButtonBehavior.this.setHovered(false);
            BaseButtonBehavior.this.setPressedByMouse(false);
            BaseButtonBehavior.this.repaintComponent();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Component owner2 = IdeFocusManager.getInstance(null).getFocusOwner();
            boolean bl = this.myWasPressedOnFocusTransfer = owner2 == null;
            if (this.isDeadZone()) {
                return;
            }
            if (BaseButtonBehavior.this.myActionTrigger == 502 && UIUtil.isActionClick((MouseEvent)e, (int)501)) {
                BaseButtonBehavior.this.setPressedByMouse(true);
            }
            if (this.passIfNeeded(e)) {
                return;
            }
            if (BaseButtonBehavior.this.myActionTrigger == 501 || BaseButtonBehavior.this.myActionTrigger == -1) {
                this.execute(e);
            } else {
                BaseButtonBehavior.this.repaintComponent();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            try {
                if (this.isDeadZone()) {
                    return;
                }
                if (UIUtil.isActionClick((MouseEvent)e, (int)502)) {
                    BaseButtonBehavior.this.setPressedByMouse(false);
                }
                if (this.passIfNeeded(e)) {
                    return;
                }
                if (BaseButtonBehavior.this.myActionTrigger == 502 || BaseButtonBehavior.this.myActionTrigger == -1) {
                    this.execute(e);
                } else {
                    BaseButtonBehavior.this.repaintComponent();
                }
            }
            finally {
                this.myWasPressedOnFocusTransfer = false;
            }
        }

        private boolean execute(MouseEvent e) {
            Point point = e.getPoint();
            if (point.x < 0 || point.x > BaseButtonBehavior.this.myComponent.getWidth()) {
                return true;
            }
            if (point.y < 0 || point.y > BaseButtonBehavior.this.myComponent.getHeight()) {
                return true;
            }
            BaseButtonBehavior.this.repaintComponent();
            WriteIntentReadAction.run(() -> BaseButtonBehavior.this.execute(e));
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!BaseButtonBehavior.this.myComponent.isShowing()) {
                    BaseButtonBehavior.this.setHovered(false);
                    BaseButtonBehavior.this.myMouseDeadzone.clear();
                }
            });
            return false;
        }

        private boolean passIfNeeded(MouseEvent e) {
            boolean actionClick;
            boolean bl = BaseButtonBehavior.this.myActionTrigger == -1 ? UIUtil.isActionClick((MouseEvent)e, (int)501) || UIUtil.isActionClick((MouseEvent)e, (int)502) : (actionClick = UIUtil.isActionClick((MouseEvent)e, (int)BaseButtonBehavior.this.myActionTrigger));
            if (actionClick) {
                return false;
            }
            BaseButtonBehavior.this.pass(e);
            return true;
        }

        private boolean isDeadZone() {
            boolean considerDeadZone = !this.myWasPressedOnFocusTransfer;
            return considerDeadZone && BaseButtonBehavior.this.myMouseDeadzone.isWithin();
        }
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            BaseButtonBehavior.this.myMouseDeadzone.enter(e);
        }
    }

    private class PressedKeyListener
    extends KeyAdapter {
        private PressedKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                BaseButtonBehavior.this.setPressedByKeyboard(true);
                BaseButtonBehavior.this.repaintComponent();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                e.consume();
                RelativePoint point = RelativePoint.getCenterOf((JComponent)BaseButtonBehavior.this.myComponent);
                BaseButtonBehavior.this.execute(point.toMouseEvent());
                BaseButtonBehavior.this.setPressedByKeyboard(false);
                BaseButtonBehavior.this.repaintComponent();
                return;
            }
            super.keyReleased(e);
        }
    }

    private class ButtonFocusListener
    extends FocusAdapter {
        private ButtonFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            BaseButtonBehavior.this.setFocused(true);
            BaseButtonBehavior.this.repaintComponent();
        }

        @Override
        public void focusLost(FocusEvent e) {
            BaseButtonBehavior.this.setFocused(false);
            BaseButtonBehavior.this.setPressedByKeyboard(false);
            BaseButtonBehavior.this.repaintComponent();
        }
    }
}

