/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport.changes;

import com.intellij.openapi.externalSystem.autoimport.ExternalSystemModificationType;
import com.intellij.openapi.externalSystem.autoimport.changes.AsyncFileChangesListener;
import com.intellij.openapi.externalSystem.autoimport.changes.vfs.VirtualFileChangesListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/AsyncVirtualFilesChangesListener;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/vfs/VirtualFileChangesListener;", "isIgnoreInternalChanges", "", "listener", "Lcom/intellij/openapi/externalSystem/autoimport/changes/AsyncFileChangesListener;", "<init>", "(ZLcom/intellij/openapi/externalSystem/autoimport/changes/AsyncFileChangesListener;)V", "init", "", "apply", "isRelevant", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "updateFile", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public final class AsyncVirtualFilesChangesListener
implements VirtualFileChangesListener {
    private final boolean isIgnoreInternalChanges;
    @NotNull
    private final AsyncFileChangesListener listener;

    public AsyncVirtualFilesChangesListener(boolean isIgnoreInternalChanges, @NotNull AsyncFileChangesListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.isIgnoreInternalChanges = isIgnoreInternalChanges;
        this.listener = listener2;
    }

    @Override
    public void init() {
        this.listener.init();
    }

    @Override
    public void apply() {
        this.listener.apply();
    }

    @Override
    public boolean isRelevant(@NotNull VirtualFile file, @NotNull VFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return !this.isIgnoreInternalChanges || !event.isFromSave();
    }

    @Override
    public void updateFile(@NotNull VirtualFile file, @NotNull VFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ExternalSystemModificationType modificationType = event.isFromRefresh() ? ExternalSystemModificationType.EXTERNAL : ExternalSystemModificationType.INTERNAL;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.listener.onFileChange(string, file.getModificationStamp(), modificationType);
    }
}

