/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.nameGenerator.ModuleNameGenerator;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeModelsProviderImpl
implements IdeModelsProvider {
    private static final Logger LOG = Logger.getInstance(IdeModelsProviderImpl.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    private final Map<ModuleData, Module> myIdeModulesCache;
    private final Map<Module, Map<String, List<ModuleOrderEntry>>> myIdeModuleToModuleDepsCache;

    public IdeModelsProviderImpl(@NotNull Project project) {
        if (project == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(0);
        }
        this.myIdeModulesCache = new WeakHashMap<ModuleData, Module>();
        this.myIdeModuleToModuleDepsCache = new WeakHashMap<Module, Map<String, List<ModuleOrderEntry>>>();
        this.myProject = project;
    }

    public Module @NotNull [] getModules() {
        Module[] moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (moduleArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(1);
        }
        return moduleArray;
    }

    public Module @NotNull [] getModules(@NotNull ProjectData projectData) {
        if (projectData == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(2);
        }
        List modules = ContainerUtil.filter((Object[])this.getModules(), module -> ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module) && StringUtil.equals((CharSequence)projectData.getLinkedExternalProjectPath(), (CharSequence)ExternalSystemApiUtil.getExternalRootProjectPath((Module)module)));
        Module[] moduleArray = modules.toArray(Module.EMPTY_ARRAY);
        if (moduleArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(3);
        }
        return moduleArray;
    }

    public OrderEntry @NotNull [] getOrderEntries(@NotNull Module module) {
        if (module == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(4);
        }
        OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module).getOrderEntries();
        if (orderEntryArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(5);
        }
        return orderEntryArray;
    }

    @Nullable
    public Module findIdeModule(@NotNull ModuleData module) {
        Module cachedIdeModule;
        if (module == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(6);
        }
        if ((cachedIdeModule = this.myIdeModulesCache.get(module)) == null) {
            for (String candidate : this.suggestModuleNameCandidates(module)) {
                Module ideModule = this.findIdeModule(candidate);
                if (ideModule == null || !IdeModelsProviderImpl.isApplicableIdeModule(module, ideModule)) continue;
                this.myIdeModulesCache.put(module, ideModule);
                return ideModule;
            }
        } else {
            return cachedIdeModule;
        }
        return null;
    }

    protected Iterable<String> suggestModuleNameCandidates(@NotNull ModuleData module) {
        AbstractExternalSystemSettings settings;
        ExternalProjectSettings projectSettings;
        if (module == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(7);
        }
        String delimiter = (projectSettings = (settings = ExternalSystemApiUtil.getSettings((Project)this.myProject, (ProjectSystemId)module.getOwner())).getLinkedProjectSettings(module.getLinkedExternalProjectPath())) != null && !projectSettings.isUseQualifiedModuleNames() ? "-" : ".";
        return ModuleNameGenerator.generate(module, delimiter);
    }

    private static boolean isApplicableIdeModule(@NotNull ModuleData moduleData, @NotNull Module ideModule) {
        if (moduleData == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(8);
        }
        if (ideModule == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(9);
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)ideModule).getContentRoots()) {
            if (!VfsUtilCore.pathEqualsTo((VirtualFile)root, (String)moduleData.getLinkedExternalProjectPath())) continue;
            return true;
        }
        return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)moduleData.getOwner(), (Module)ideModule) && FileUtil.pathsEqual((String)ExternalSystemApiUtil.getExternalProjectPath((Module)ideModule), (String)moduleData.getLinkedExternalProjectPath());
    }

    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        if (ideModuleName == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(10);
        }
        return ModuleManager.getInstance((Project)this.myProject).findModuleByName(ideModuleName);
    }

    @Nullable
    public UnloadedModuleDescription getUnloadedModuleDescription(@NotNull ModuleData moduleData) {
        if (moduleData == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(11);
        }
        for (String moduleName : this.suggestModuleNameCandidates(moduleData)) {
            UnloadedModuleDescription unloadedModuleDescription = ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescription(moduleName);
            if (unloadedModuleDescription == null) continue;
            return unloadedModuleDescription;
        }
        return null;
    }

    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        if (libraryData == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(12);
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject);
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @Nullable
    public ModuleOrderEntry findIdeModuleDependency(@NotNull ModuleDependencyData dependency, @NotNull Module module) {
        Map namesToEntries;
        List candidates;
        if (dependency == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(13);
        }
        if (module == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(14);
        }
        if ((candidates = (List)(namesToEntries = this.myIdeModuleToModuleDepsCache.computeIfAbsent(module, m -> Arrays.stream(this.getOrderEntries((Module)m)).filter(ModuleOrderEntry.class::isInstance).map(ModuleOrderEntry.class::cast).collect(Collectors.groupingBy(ModuleOrderEntry::getModuleName)))).get(dependency.getInternalName())) == null) {
            return null;
        }
        for (ModuleOrderEntry candidate : candidates) {
            if (!candidate.getScope().equals((Object)dependency.getScope())) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    public OrderEntry findIdeModuleOrderEntry(@NotNull DependencyData data) {
        Module ownerIdeModule;
        if (data == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(15);
        }
        if ((ownerIdeModule = this.findIdeModule(data.getOwnerModule())) == null) {
            return null;
        }
        LibraryDependencyData libraryDependencyData = null;
        ModuleDependencyData moduleDependencyData = null;
        if (data instanceof LibraryDependencyData) {
            libraryDependencyData = (LibraryDependencyData)data;
        } else if (data instanceof ModuleDependencyData) {
            moduleDependencyData = (ModuleDependencyData)data;
        } else {
            return null;
        }
        for (OrderEntry entry : this.getOrderEntries(ownerIdeModule)) {
            String entryName;
            if (entry instanceof LibraryOrderEntry && libraryDependencyData != null) {
                if (((LibraryOrderEntry)entry).isModuleLevel() && libraryDependencyData.getLevel() != LibraryLevel.MODULE) continue;
                if (StringUtil.isEmpty((String)((LibraryOrderEntry)entry).getLibraryName())) {
                    Set paths = ContainerUtil.map2Set((Collection)((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY), PathUtil::getLocalPath);
                    Set entryPaths = ContainerUtil.map2Set((Object[])((LibraryOrderEntry)entry).getRootUrls(OrderRootType.CLASSES), s -> PathUtil.getLocalPath((String)VfsUtilCore.urlToPath((String)s)));
                    if (!entryPaths.equals(paths) || ((LibraryOrderEntry)entry).getScope() != data.getScope()) continue;
                    return entry;
                }
            }
            String string = entryName = libraryDependencyData != null ? libraryDependencyData.getInternalName() : moduleDependencyData.getInternalName();
            if (!entryName.equals(entry.getPresentableName()) || entry instanceof ExportableOrderEntry && ((ExportableOrderEntry)entry).getScope() != data.getScope()) continue;
            return entry;
        }
        return null;
    }

    @NotNull
    public Map<LibraryOrderEntry, LibraryDependencyData> findIdeModuleLibraryOrderEntries(@NotNull ModuleData moduleData, @NotNull List<LibraryDependencyData> libraryDependencyDataList) {
        if (moduleData == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(16);
        }
        if (libraryDependencyDataList == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(17);
        }
        if (libraryDependencyDataList.isEmpty()) {
            Map<LibraryOrderEntry, LibraryDependencyData> map = Collections.emptyMap();
            if (map == null) {
                IdeModelsProviderImpl.$$$reportNull$$$0(18);
            }
            return map;
        }
        Module ownerIdeModule = this.findIdeModule(moduleData);
        if (ownerIdeModule == null) {
            Map<LibraryOrderEntry, LibraryDependencyData> map = Collections.emptyMap();
            if (map == null) {
                IdeModelsProviderImpl.$$$reportNull$$$0(19);
            }
            return map;
        }
        HashMap<Set, LibraryDependencyData> libraryDependencyDataMap = new HashMap<Set, LibraryDependencyData>();
        for (LibraryDependencyData libraryDependencyData : libraryDependencyDataList) {
            if (libraryDependencyData.getLevel() == LibraryLevel.PROJECT) {
                LOG.warn("Library data \"" + libraryDependencyData.getInternalName() + "\" not a module level dependency");
                continue;
            }
            if (libraryDependencyData.getOwnerModule() != moduleData) {
                LOG.warn("Library data \"" + libraryDependencyData.getInternalName() + "\" not belong to the module: " + ownerIdeModule.getName());
                continue;
            }
            libraryDependencyDataMap.put(ContainerUtil.map2Set((Collection)((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY), PathUtil::getLocalPath), libraryDependencyData);
        }
        HashMap<LibraryOrderEntry, LibraryDependencyData> result = new HashMap<LibraryOrderEntry, LibraryDependencyData>();
        for (OrderEntry entry : this.getOrderEntries(ownerIdeModule)) {
            Set entryPaths;
            LibraryDependencyData libraryDependencyData;
            LibraryOrderEntry libraryOrderEntry;
            if (!(entry instanceof LibraryOrderEntry) || !(libraryOrderEntry = (LibraryOrderEntry)entry).isModuleLevel() || (libraryDependencyData = (LibraryDependencyData)libraryDependencyDataMap.get(entryPaths = ContainerUtil.map2Set((Object[])libraryOrderEntry.getRootUrls(OrderRootType.CLASSES), s -> PathUtil.getLocalPath((String)VfsUtilCore.urlToPath((String)s))))) == null || libraryOrderEntry.getScope() != libraryDependencyData.getScope()) continue;
            result.put(libraryOrderEntry, libraryDependencyData);
        }
        HashMap<LibraryOrderEntry, LibraryDependencyData> hashMap = result;
        if (hashMap == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(20);
        }
        return hashMap;
    }

    public VirtualFile @NotNull [] getContentRoots(Module module) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (virtualFileArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(21);
        }
        return virtualFileArray;
    }

    public VirtualFile @NotNull [] getSourceRoots(Module module) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getSourceRoots();
        if (virtualFileArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(22);
        }
        return virtualFileArray;
    }

    public VirtualFile @NotNull [] getSourceRoots(Module module, boolean includingTests) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getSourceRoots(includingTests);
        if (virtualFileArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(23);
        }
        return virtualFileArray;
    }

    public Library @NotNull [] getAllLibraries() {
        Library[] libraryArray = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraries();
        if (libraryArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(24);
        }
        return libraryArray;
    }

    @Nullable
    public Library getLibraryByName(String name) {
        return LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraryByName(name);
    }

    public String @NotNull [] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type) {
        if (library == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(25);
        }
        if (type == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(26);
        }
        String[] stringArray = library.getUrls(type);
        if (stringArray == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(27);
        }
        return stringArray;
    }

    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module) {
        if (module == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(28);
        }
        List list = ModuleUtilCore.getAllDependentModules((Module)module);
        if (list == null) {
            IdeModelsProviderImpl.$$$reportNull$$$0(29);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 18, 19, 20, 21, 22, 23, 24, 27, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 14: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModuleName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryData";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDependencyDataList";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findIdeModuleLibraryOrderEntries";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLibraries";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryUrls";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependentModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestModuleNameCandidates";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableIdeModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUnloadedModuleDescription";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findIdeLibrary";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModuleDependency";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModuleOrderEntry";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModuleLibraryOrderEntries";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryUrls";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependentModules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 18, 19, 20, 21, 22, 23, 24, 27, 29 -> new IllegalStateException(string);
        };
    }
}

