/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemTelemetryUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import io.opentelemetry.api.trace.Span;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModuleDataService<E extends ModuleData>
extends AbstractProjectDataService<E, Module> {
    public static final Key<ModuleData> MODULE_DATA_KEY = Key.create((String)"MODULE_DATA_KEY");
    public static final Key<Module> MODULE_KEY = Key.create((String)"LINKED_MODULE");
    public static final Key<Map<OrderEntry, OrderAware>> ORDERED_DATA_MAP_KEY = Key.create((String)"ORDER_ENTRY_DATA_MAP");
    private static final Key<Set<Path>> ORPHAN_MODULE_FILES = Key.create((String)"ORPHAN_FILES");
    private static final Key<AtomicInteger> ORPHAN_MODULE_HANDLERS_COUNTER = Key.create((String)"ORPHAN_MODULE_HANDLERS_COUNTER");
    private static final Logger LOG = Logger.getInstance(AbstractModuleDataService.class);
    @NotNull
    private static final String UNDEFINED_MODULE_TYPE = "UNDEFINED_MODULE_TYPE";

    @Nullable
    public String getExternalModuleType() {
        return UNDEFINED_MODULE_TYPE;
    }

    public void importData(@NotNull Collection<? extends DataNode<E>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Module module;
        if (toImport == null) {
            AbstractModuleDataService.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AbstractModuleDataService.$$$reportNull$$$0(1);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(2);
        }
        if (toImport.isEmpty()) {
            return;
        }
        Collection<DataNode<E>> toCreate = this.filterExistingModules(toImport, modelsProvider);
        if (!toCreate.isEmpty()) {
            this.createModules(toCreate, modelsProvider);
        }
        for (DataNode<E> node : toImport) {
            module = (Module)node.getUserData(MODULE_KEY);
            if (module == null) continue;
            String productionModuleId = ((ModuleData)node.getData()).getProductionModuleId();
            modelsProvider.setTestModuleProperties(module, productionModuleId);
            this.setModuleOptions(module, node);
            ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
            AbstractModuleDataService.syncPaths(module, modifiableRootModel, (ModuleData)node.getData());
        }
        for (DataNode<E> node : toImport) {
            module = (Module)node.getUserData(MODULE_KEY);
            if (module == null) continue;
            String[] groupPath = ((ModuleData)node.getData()).getIdeModuleGroup();
            ModifiableModuleModel modifiableModel = modelsProvider.getModifiableModuleModel();
            modifiableModel.setModuleGroupPath(module, groupPath);
        }
    }

    @NotNull
    protected Module createModule(@NotNull DataNode<E> module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (module == null) {
            AbstractModuleDataService.$$$reportNull$$$0(3);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(4);
        }
        ModuleData data = (ModuleData)module.getData();
        Module module2 = modelsProvider.newModule(data);
        if (module2 == null) {
            AbstractModuleDataService.$$$reportNull$$$0(5);
        }
        return module2;
    }

    private void createModules(@NotNull Collection<? extends DataNode<E>> toCreate, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toCreate == null) {
            AbstractModuleDataService.$$$reportNull$$$0(6);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(7);
        }
        for (DataNode<E> module : toCreate) {
            Module created = this.createModule(module, modelsProvider);
            module.putUserData(MODULE_KEY, (Object)created);
            final ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(created);
            RootPolicy<Object> visitor = new RootPolicy<Object>(this){

                public Object visitLibraryOrderEntry(@NotNull LibraryOrderEntry libraryOrderEntry, Object value) {
                    if (libraryOrderEntry == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    modifiableRootModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
                    return value;
                }

                public Object visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, Object value) {
                    if (moduleOrderEntry == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    modifiableRootModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
                    return value;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "libraryOrderEntry";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "moduleOrderEntry";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLibraryOrderEntry";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitModuleOrderEntry";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            for (OrderEntry orderEntry : modifiableRootModel.getOrderEntries()) {
                orderEntry.accept((RootPolicy)visitor, null);
            }
        }
    }

    @NotNull
    private Collection<DataNode<E>> filterExistingModules(@NotNull Collection<? extends DataNode<E>> modules, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modules == null) {
            AbstractModuleDataService.$$$reportNull$$$0(8);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(9);
        }
        ArrayList<DataNode<DataNode<E>>> result = new ArrayList<DataNode<DataNode<E>>>();
        for (DataNode<E> node : modules) {
            ModuleData moduleData = (ModuleData)node.getData();
            Module module = modelsProvider.findIdeModule(moduleData);
            if (module == null) {
                UnloadedModuleDescription unloadedModuleDescription = modelsProvider.getUnloadedModuleDescription(moduleData);
                if (unloadedModuleDescription != null) continue;
                result.add(node);
                continue;
            }
            node.putUserData(MODULE_KEY, (Object)module);
        }
        ArrayList<DataNode<DataNode<E>>> arrayList = result;
        if (arrayList == null) {
            AbstractModuleDataService.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static void syncPaths(@NotNull Module module, @NotNull ModifiableRootModel modifiableModel, @NotNull ModuleData data) {
        CompilerModuleExtension extension;
        if (module == null) {
            AbstractModuleDataService.$$$reportNull$$$0(11);
        }
        if (modifiableModel == null) {
            AbstractModuleDataService.$$$reportNull$$$0(12);
        }
        if (data == null) {
            AbstractModuleDataService.$$$reportNull$$$0(13);
        }
        if ((extension = (CompilerModuleExtension)modifiableModel.getModuleExtension(CompilerModuleExtension.class)) == null) {
            LOG.debug(String.format("No compiler extension is found for '%s', compiler output path will not be synced.", module.getName()));
            return;
        }
        String compileOutputPath = data.getCompileOutputPath(ExternalSystemSourceType.SOURCE);
        extension.setCompilerOutputPath(compileOutputPath != null ? VfsUtilCore.pathToUrl((String)compileOutputPath) : null);
        String testCompileOutputPath = data.getCompileOutputPath(ExternalSystemSourceType.TEST);
        extension.setCompilerOutputPathForTests(testCompileOutputPath != null ? VfsUtilCore.pathToUrl((String)testCompileOutputPath) : null);
        extension.inheritCompilerOutputPath(data.isInheritProjectCompileOutputPath());
    }

    @NotNull
    public Computable<Collection<Module>> computeOrphanData(@NotNull Collection<? extends DataNode<E>> toImport, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            AbstractModuleDataService.$$$reportNull$$$0(14);
        }
        if (projectData == null) {
            AbstractModuleDataService.$$$reportNull$$$0(15);
        }
        if (project == null) {
            AbstractModuleDataService.$$$reportNull$$$0(16);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(17);
        }
        Computable computable = () -> {
            ProjectSystemId externalSystemId = projectData.getOwner();
            String externalRootProjectPath = projectData.getLinkedExternalProjectPath();
            String externalModuleType = this.getExternalModuleType();
            SmartList result = new SmartList();
            if (!Objects.equals(externalModuleType, UNDEFINED_MODULE_TYPE)) {
                result.addAll(AbstractModuleDataService.computeRemovedModules(modelsProvider, externalSystemId, externalRootProjectPath, externalModuleType));
            }
            result.addAll(this.computeModulesWithUsedContentRoots(modelsProvider, externalSystemId, toImport));
            return result;
        };
        if (computable == null) {
            AbstractModuleDataService.$$$reportNull$$$0(18);
        }
        return computable;
    }

    @NotNull
    private static List<Module> computeRemovedModules(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ProjectSystemId externalSystemId, @NotNull String externalRootProjectPath, @Nullable String externalModuleType) {
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(19);
        }
        if (externalSystemId == null) {
            AbstractModuleDataService.$$$reportNull$$$0(20);
        }
        if (externalRootProjectPath == null) {
            AbstractModuleDataService.$$$reportNull$$$0(21);
        }
        SmartList result = new SmartList();
        for (Module module : modelsProvider.getModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)externalSystemId, (Module)module) || !Objects.equals(ExternalSystemApiUtil.getExternalModuleType((Module)module), externalModuleType) || !Objects.equals(ExternalSystemApiUtil.getExternalRootProjectPath((Module)module), externalRootProjectPath) || module.getUserData(MODULE_DATA_KEY) != null) continue;
            result.add((Object)module);
        }
        SmartList smartList = result;
        if (smartList == null) {
            AbstractModuleDataService.$$$reportNull$$$0(22);
        }
        return smartList;
    }

    @NotNull
    private List<Module> computeModulesWithUsedContentRoots(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ProjectSystemId externalSystemId, @NotNull Collection<? extends DataNode<E>> moduleNodes) {
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(23);
        }
        if (externalSystemId == null) {
            AbstractModuleDataService.$$$reportNull$$$0(24);
        }
        if (moduleNodes == null) {
            AbstractModuleDataService.$$$reportNull$$$0(25);
        }
        HashSet<String> usedContentRoots = new HashSet<String>();
        for (DataNode<E> moduleNode : moduleNodes) {
            usedContentRoots.add(((ModuleData)moduleNode.getData()).getLinkedExternalProjectPath());
        }
        SmartList result = new SmartList();
        block1: for (Module module : modelsProvider.getModules()) {
            if (ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)externalSystemId, (Module)module)) continue;
            for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                if (!usedContentRoots.contains(contentRoot.getPath())) continue;
                result.add((Object)module);
                continue block1;
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            AbstractModuleDataService.$$$reportNull$$$0(26);
        }
        return smartList;
    }

    public void removeData(Computable<? extends Collection<? extends Module>> toRemoveComputable, @NotNull Collection<? extends DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toIgnore == null) {
            AbstractModuleDataService.$$$reportNull$$$0(27);
        }
        if (projectData == null) {
            AbstractModuleDataService.$$$reportNull$$$0(28);
        }
        if (project == null) {
            AbstractModuleDataService.$$$reportNull$$$0(29);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(30);
        }
        Collection toRemove = (Collection)toRemoveComputable.compute();
        SmartList modules = new SmartList(toRemove);
        for (DataNode<E> moduleDataNode : toIgnore) {
            Module module = modelsProvider.findIdeModule((ModuleData)moduleDataNode.getData());
            ContainerUtil.addIfNotNull((Collection)modules, (Object)module);
        }
        if (modules.isEmpty()) {
            return;
        }
        ContainerUtil.removeDuplicates((Collection)modules);
        ProjectSystemId projectSystemId = projectData.getOwner();
        ExternalSystemTelemetryUtil.runWithSpan(projectSystemId, "Remove external system options from workspace model", arg_0 -> AbstractModuleDataService.lambda$removeData$2((List)modules, projectSystemId, arg_0));
        ExternalSystemApiUtil.executeOnEdt((boolean)true, () -> AbstractModuleDataService.lambda$removeData$3(project, projectData, (List)modules, modelsProvider));
    }

    public void onSuccessImport(@NotNull Collection<DataNode<E>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        Set orphanModules;
        if (imported == null) {
            AbstractModuleDataService.$$$reportNull$$$0(31);
        }
        if (project == null) {
            AbstractModuleDataService.$$$reportNull$$$0(32);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(33);
        }
        if ((orphanModules = (Set)project.getUserData(ORPHAN_MODULE_FILES)) == null || orphanModules.isEmpty()) {
            return;
        }
        AtomicInteger counter = (AtomicInteger)project.getUserData(ORPHAN_MODULE_HANDLERS_COUNTER);
        if (counter == null) {
            return;
        }
        if (counter.decrementAndGet() == 0) {
            project.putUserData(ORPHAN_MODULE_FILES, null);
            project.putUserData(ORPHAN_MODULE_HANDLERS_COUNTER, null);
            StringBuilder modulesToRestoreText = new StringBuilder();
            ArrayList<Pair> modulesToRestore = new ArrayList<Pair>();
            for (Path modulePath : orphanModules) {
                try {
                    String path = FileUtil.loadFile((File)modulePath.resolveSibling(String.valueOf(modulePath.getFileName()) + ".path").toFile());
                    modulesToRestoreText.append(FileUtilRt.getNameWithoutExtension((String)new File(path).getName())).append("\n");
                    modulesToRestore.add(Pair.create((Object)path, (Object)modulePath));
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
            String buildSystem = projectData != null ? projectData.getOwner().getReadableName() : "build system";
            String content = ExternalSystemBundle.message((String)"orphan.modules.text", (Object[])new Object[]{buildSystem, StringUtil.shortenTextWithEllipsis((String)modulesToRestoreText.toString(), (int)50, (int)0)});
            Notification cleanUpNotification = NotificationGroupManager.getInstance().getNotificationGroup("Build sync orphan modules").createNotification(content, NotificationType.INFORMATION).setListener((notification, event) -> {
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                if (AbstractModuleDataService.showRemovedOrphanModules(modulesToRestore, project)) {
                    notification.expire();
                }
            }).whenExpired(() -> {
                List filesToRemove = ContainerUtil.map((Collection)orphanModules, Path::toFile);
                List toRemove2 = ContainerUtil.map((Collection)orphanModules, path -> path.resolveSibling(String.valueOf(path.getFileName()) + ".path").toFile());
                FileUtil.asyncDelete((Collection)ContainerUtil.concat((List)filesToRemove, (List)toRemove2));
            });
            Disposer.register((Disposable)project, () -> ((Notification)cleanUpNotification).expire());
            cleanUpNotification.notify(project);
        }
    }

    public void onFailureImport(Project project) {
        project.putUserData(ORPHAN_MODULE_FILES, null);
        project.putUserData(ORPHAN_MODULE_HANDLERS_COUNTER, null);
    }

    private static boolean showRemovedOrphanModules(@NotNull List<? extends Pair<String, Path>> orphanModules, @NotNull Project project) {
        CheckBoxList orphanModulesList;
        DialogWrapper dialog;
        if (orphanModules == null) {
            AbstractModuleDataService.$$$reportNull$$$0(34);
        }
        if (project == null) {
            AbstractModuleDataService.$$$reportNull$$$0(35);
        }
        if ((dialog = new DialogWrapper(project, orphanModulesList = new CheckBoxList(), orphanModules){
            final /* synthetic */ CheckBoxList val$orphanModulesList;
            final /* synthetic */ List val$orphanModules;
            {
                this.val$orphanModulesList = checkBoxList;
                this.val$orphanModules = list;
                super(arg0);
                this.setTitle(ExternalSystemBundle.message((String)"orphan.modules.dialog.title", (Object[])new Object[0]));
                this.init();
            }

            protected JComponent createCenterPanel() {
                this.val$orphanModulesList.setSelectionMode(2);
                this.val$orphanModulesList.setItems(this.val$orphanModules, module -> FileUtilRt.getNameWithoutExtension((String)new File((String)module.getFirst()).getName()));
                this.val$orphanModulesList.setBorder(JBUI.Borders.empty((int)5));
                JScrollPane myModulesScrollPane = ScrollPaneFactory.createScrollPane((Component)this.val$orphanModulesList, (int)20, (int)30);
                myModulesScrollPane.setBorder(new MatteBorder(0, 0, 1, 0, JBColor.border()));
                myModulesScrollPane.setMaximumSize(new Dimension(-1, 300));
                JPanel content = new JPanel(new BorderLayout());
                content.add((Component)myModulesScrollPane, "Center");
                return content;
            }

            @NotNull
            protected JComponent createNorthPanel() {
                GridBagConstraints gbConstraints = new GridBagConstraints();
                JPanel panel = new JPanel(new GridBagLayout());
                gbConstraints.insets = JBUI.insets((int)4, (int)0, (int)10, (int)8);
                panel.add((Component)new JLabel(ExternalSystemBundle.message((String)"orphan.modules.dialog.text", (Object[])new Object[0])), gbConstraints);
                JPanel jPanel = panel;
                if (jPanel == null) {
                    2.$$$reportNull$$$0(0);
                }
                return jPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService$2", "createNorthPanel"));
            }
        }).showAndGet()) {
            ExternalSystemApiUtil.doWriteAction(() -> {
                for (int i2 = 0; i2 < orphanModules.size(); ++i2) {
                    Pair pair = (Pair)orphanModules.get(i2);
                    String originalPath = (String)pair.first;
                    Path savedPath = (Path)pair.second;
                    if (!orphanModulesList.isItemSelected(i2) || !savedPath.toFile().isFile()) continue;
                    try {
                        File file = new File(originalPath);
                        FileUtil.copy((File)savedPath.toFile(), (File)file);
                        ModuleManager.getInstance((Project)project).loadModule(file.toPath());
                        continue;
                    }
                    catch (ModuleWithNameAlreadyExists | IOException e) {
                        LOG.warn(e);
                    }
                }
            });
            return true;
        }
        return false;
    }

    public static void unlinkModuleFromExternalSystem(@NotNull Module module) {
        if (module == null) {
            AbstractModuleDataService.$$$reportNull$$$0(36);
        }
        ExternalSystemModulePropertyManager.getInstance((Module)module).unlinkExternalOptions();
    }

    protected void setModuleOptions(@NotNull Module module, @NotNull DataNode<E> moduleNode) {
        if (module == null) {
            AbstractModuleDataService.$$$reportNull$$$0(37);
        }
        if (moduleNode == null) {
            AbstractModuleDataService.$$$reportNull$$$0(38);
        }
        ModuleData moduleData = (ModuleData)moduleNode.getData();
        module.putUserData(MODULE_DATA_KEY, (Object)moduleData);
        ExternalSystemModulePropertyManager externalModuleOptions = ExternalSystemModulePropertyManager.getInstance((Module)module);
        externalModuleOptions.setExternalOptions(moduleData.getOwner(), moduleData, (ProjectData)moduleNode.getData(ProjectKeys.PROJECT));
        String moduleType = this.getExternalModuleType();
        if (!Objects.equals(moduleType, UNDEFINED_MODULE_TYPE)) {
            externalModuleOptions.setExternalModuleType(moduleType);
        }
    }

    public void postProcess(@NotNull Collection<? extends DataNode<E>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            AbstractModuleDataService.$$$reportNull$$$0(39);
        }
        if (project == null) {
            AbstractModuleDataService.$$$reportNull$$$0(40);
        }
        if (modelsProvider == null) {
            AbstractModuleDataService.$$$reportNull$$$0(41);
        }
        for (DataNode<E> moduleDataNode : toImport) {
            Module module = (Module)moduleDataNode.getUserData(MODULE_KEY);
            if (module == null) continue;
            Map orderAwareMap = (Map)moduleDataNode.getUserData(ORDERED_DATA_MAP_KEY);
            if (orderAwareMap != null) {
                this.rearrangeOrderEntries(orderAwareMap, modelsProvider.getModifiableRootModel(module));
            }
            moduleDataNode.putUserData(MODULE_KEY, null);
            moduleDataNode.putUserData(ORDERED_DATA_MAP_KEY, null);
        }
        for (Module module : modelsProvider.getModules()) {
            module.putUserData(MODULE_DATA_KEY, null);
        }
    }

    protected void rearrangeOrderEntries(@NotNull Map<OrderEntry, OrderAware> orderEntryDataMap, @NotNull ModifiableRootModel modifiableRootModel) {
        Pair pair;
        int i2;
        if (orderEntryDataMap == null) {
            AbstractModuleDataService.$$$reportNull$$$0(42);
        }
        if (modifiableRootModel == null) {
            AbstractModuleDataService.$$$reportNull$$$0(43);
        }
        Object[] orderEntries = modifiableRootModel.getOrderEntries();
        int length = orderEntries.length;
        Object[] newOrder = new OrderEntry[length];
        PriorityQueue<Pair> priorityQueue = new PriorityQueue<Pair>(11, (o1, o2) -> {
            int order2;
            int order1 = ((OrderAware)o1.second).getOrder();
            if (order1 != (order2 = ((OrderAware)o2.second).getOrder())) {
                return order1 < order2 ? -1 : 1;
            }
            return ((OrderAware)o1.second).toString().compareTo(((OrderAware)o2.second).toString());
        });
        ArrayList<OrderEntry> noOrderAwareItems = new ArrayList<OrderEntry>();
        for (i2 = 0; i2 < length; ++i2) {
            OrderEntry orderEntry = orderEntries[i2];
            OrderAware orderAware = orderEntryDataMap.get(orderEntry);
            if (orderAware == null) {
                noOrderAwareItems.add(orderEntry);
                continue;
            }
            priorityQueue.add(Pair.create((Object)orderEntry, (Object)orderAware));
        }
        for (i2 = 0; i2 < noOrderAwareItems.size(); ++i2) {
            newOrder[i2] = (OrderEntry)noOrderAwareItems.get(i2);
        }
        int index = noOrderAwareItems.size();
        while ((pair = (Pair)priorityQueue.poll()) != null) {
            newOrder[index] = (OrderEntry)pair.first;
            ++index;
        }
        if (LOG.isTraceEnabled()) {
            boolean changed = !Arrays.equals(orderEntries, newOrder);
            LOG.trace(String.format("rearrange status (%s): %s", modifiableRootModel.getModule(), changed ? "modified" : "not modified"));
        }
        modifiableRootModel.rearrangeOrderEntries((OrderEntry[])newOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$removeData$3(Project project, ProjectData projectData, List modules, IdeModifiableModelsProvider modelsProvider) {
        AtomicInteger counter = (AtomicInteger)project.getUserData(ORPHAN_MODULE_HANDLERS_COUNTER);
        if (counter == null) {
            counter = new AtomicInteger();
            project.putUserData(ORPHAN_MODULE_HANDLERS_COUNTER, (Object)counter);
        }
        counter.incrementAndGet();
        LinkedHashSet<Path> orphanModules = (LinkedHashSet<Path>)project.getUserData(ORPHAN_MODULE_FILES);
        if (orphanModules == null) {
            orphanModules = new LinkedHashSet<Path>();
            project.putUserData(ORPHAN_MODULE_FILES, orphanModules);
        }
        LocalHistoryAction historyAction = LocalHistory.getInstance().startAction(ExternalSystemBundle.message((String)"local.history.remove.orphan.modules", (Object[])new Object[0]));
        try {
            String rootProjectPathKey = String.valueOf(projectData.getLinkedExternalProjectPath().hashCode());
            Path unlinkedModulesDir = ExternalProjectsDataStorage.getProjectConfigurationDir(project).resolve("orphanModules").resolve(rootProjectPathKey);
            if (!FileUtil.createDirectory((File)unlinkedModulesDir.toFile())) {
                LOG.warn("Unable to create " + String.valueOf(unlinkedModulesDir));
                return;
            }
            AbstractExternalSystemLocalSettings localSettings = ExternalSystemApiUtil.getLocalSettings((Project)project, (ProjectSystemId)projectData.getOwner());
            AbstractExternalSystemLocalSettings.SyncType syncType = (AbstractExternalSystemLocalSettings.SyncType)localSettings.getProjectSyncType().get(projectData.getLinkedExternalProjectPath());
            for (Module module : modules) {
                if (module.isDisposed()) continue;
                String path = module.getModuleFilePath();
                if (!ApplicationManager.getApplication().isHeadlessEnvironment() && syncType == AbstractExternalSystemLocalSettings.SyncType.RE_IMPORT) {
                    try {
                        StoreUtil.saveSettings((ComponentManager)module);
                        VirtualFile moduleFile = module.getModuleFile();
                        if (moduleFile != null) {
                            Path orphanModulePath = unlinkedModulesDir.resolve(String.valueOf(path.hashCode()));
                            FileUtil.writeToFile((File)orphanModulePath.toFile(), (byte[])moduleFile.contentsToByteArray());
                            Path orphanModuleOriginPath = unlinkedModulesDir.resolve(path.hashCode() + ".path");
                            FileUtil.writeToFile((File)orphanModuleOriginPath.toFile(), (String)path);
                            orphanModules.add(orphanModulePath);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                }
                modelsProvider.getModifiableModuleModel().disposeModule(module);
            }
        }
        finally {
            historyAction.finish();
        }
    }

    private static /* synthetic */ void lambda$removeData$2(List modules, ProjectSystemId projectSystemId, Span __) {
        for (Module module : modules) {
            if (module.isDisposed()) continue;
            ExternalSystemTelemetryUtil.runWithSpan(projectSystemId, "Remove options for " + module.getName(), ___ -> AbstractModuleDataService.unlinkModuleFromExternalSystem(module));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10, 18, 22, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 1: 
            case 16: 
            case 29: 
            case 32: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 17: 
            case 19: 
            case 23: 
            case 30: 
            case 33: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 3: 
            case 11: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 10: 
            case 18: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCreate";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalRootProjectPath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNodes";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imported";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orphanModules";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNode";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntryDataMap";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableRootModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/AbstractModuleDataService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterExistingModules";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "computeOrphanData";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRemovedModules";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "computeModulesWithUsedContentRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 5: 
            case 10: 
            case 18: 
            case 22: 
            case 26: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createModules";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterExistingModules";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "syncPaths";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeOrphanData";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeRemovedModules";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "computeModulesWithUsedContentRoots";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "onSuccessImport";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "showRemovedOrphanModules";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "unlinkModuleFromExternalSystem";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setModuleOptions";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "rearrangeOrderEntries";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 10, 18, 22, 26 -> new IllegalStateException(string);
        };
    }
}

