/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManager;
import com.intellij.openapi.externalSystem.statistics.HasSharedSourcesUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.ExcludeUrlEntity;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Order(value=-2147483618)
@ApiStatus.Internal
public final class ContentRootDataService
extends AbstractProjectDataService<ContentRootData, ContentEntry> {
    public static final com.intellij.openapi.util.Key<Boolean> CREATE_EMPTY_DIRECTORIES = com.intellij.openapi.util.Key.create((String)"createEmptyDirectories");
    private static final Logger LOG = Logger.getInstance(ContentRootDataService.class);

    @NotNull
    public Key<ContentRootData> getTargetDataKey() {
        Key key = ProjectKeys.CONTENT_ROOT;
        if (key == null) {
            ContentRootDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    @NotNull
    public Computable<Collection<ContentEntry>> computeOrphanData(@NotNull Collection<? extends DataNode<ContentRootData>> toImport, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            ContentRootDataService.$$$reportNull$$$0(1);
        }
        if (projectData == null) {
            ContentRootDataService.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ContentRootDataService.$$$reportNull$$$0(3);
        }
        if (modelsProvider == null) {
            ContentRootDataService.$$$reportNull$$$0(4);
        }
        Computable computable = () -> {
            SmartList orphanIdeModules = new SmartList();
            MultiMap byModule = ExternalSystemApiUtil.groupBy((Collection)toImport, ModuleData.class);
            List modulesWithContentRoots = ContainerUtil.map((Collection)byModule.keySet(), moduleData -> modelsProvider.findIdeModule((ModuleData)moduleData.getData()));
            Module[] modules = modelsProvider.getModules(projectData);
            Arrays.stream(modules).filter(module -> !modulesWithContentRoots.contains(module)).forEach(arg_0 -> ContentRootDataService.lambda$computeOrphanData$2(modelsProvider, (List)orphanIdeModules, arg_0));
            return orphanIdeModules;
        };
        if (computable == null) {
            ContentRootDataService.$$$reportNull$$$0(5);
        }
        return computable;
    }

    public void removeData(Computable<? extends Collection<? extends ContentEntry>> toRemoveComputable, @NotNull Collection<? extends DataNode<ContentRootData>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toIgnore == null) {
            ContentRootDataService.$$$reportNull$$$0(6);
        }
        if (projectData == null) {
            ContentRootDataService.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ContentRootDataService.$$$reportNull$$$0(8);
        }
        if (modelsProvider == null) {
            ContentRootDataService.$$$reportNull$$$0(9);
        }
        Map<Module, List<ContentEntry>> byModule = ((Collection)toRemoveComputable.compute()).stream().collect(Collectors.groupingBy(contentEntry -> contentEntry.getRootModel().getModule()));
        for (Map.Entry<Module, List<ContentEntry>> entry : byModule.entrySet()) {
            Collection toRemove = entry.getValue();
            ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(entry.getKey());
            toRemove.forEach(arg_0 -> ((ModifiableRootModel)modifiableRootModel).removeContentEntry(arg_0));
        }
    }

    public void importData(@NotNull Collection<? extends DataNode<ContentRootData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            ContentRootDataService.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ContentRootDataService.$$$reportNull$$$0(11);
        }
        if (modelsProvider == null) {
            ContentRootDataService.$$$reportNull$$$0(12);
        }
        ContentRootDataService.logUnitTest("Importing data. Data size is [" + toImport.size() + "]", new Object[0]);
        if (toImport.isEmpty()) {
            return;
        }
        boolean isNewlyImportedProject = project.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE;
        boolean forceDirectoriesCreation = false;
        DataNode projectDataNode = ExternalSystemApiUtil.findParent(toImport.iterator().next(), (Key)ProjectKeys.PROJECT);
        if (projectDataNode != null) {
            forceDirectoriesCreation = projectDataNode.getUserData(CREATE_EMPTY_DIRECTORIES) == Boolean.TRUE;
        }
        Set modulesToExpand = CollectionFactory.createSmallMemoryFootprintSet();
        MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, ModuleData.class);
        ContentRootDataService.filterAndReportDuplicatingContentRoots((MultiMap<DataNode<ModuleData>, DataNode<ContentRootData>>)byModule, project);
        for (Map.Entry entry : byModule.entrySet()) {
            Module module = (Module)((DataNode)entry.getKey()).getUserData(AbstractModuleDataService.MODULE_KEY);
            Module module2 = module = module != null ? module : modelsProvider.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData());
            if (module == null) {
                LOG.warn(String.format("Can't import content roots. Reason: target module (%s) is not found at the ide. Content roots: %s", entry.getKey(), entry.getValue()));
                continue;
            }
            ContentRootDataService.importData(project, modelsProvider, (Collection)entry.getValue(), module, forceDirectoriesCreation, projectData == null ? null : projectData.getOwner());
            if (!forceDirectoriesCreation && (!isNewlyImportedProject || projectData == null || !projectData.getLinkedExternalProjectPath().equals(ExternalSystemApiUtil.getExternalProjectPath((Module)module)))) continue;
            modulesToExpand.add(module);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !modulesToExpand.isEmpty()) {
            for (Module module : modulesToExpand) {
                VirtualFile[] roots;
                String productionModuleName = modelsProvider.getProductionModuleName(module);
                if (productionModuleName != null && modulesToExpand.contains(modelsProvider.findIdeModule(productionModuleName)) || (roots = modelsProvider.getModifiableRootModel(module).getContentRoots()).length <= 0) continue;
                VirtualFile virtualFile = roots[0];
                StartupManager.getInstance((Project)project).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater(() -> {
                    ProjectView projectView = ProjectView.getInstance((Project)project);
                    projectView.changeViewCB("ProjectPane", null).doWhenProcessed(() -> projectView.selectCB(null, virtualFile, false));
                }, ModalityState.nonModal(), project.getDisposed()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void importData(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Collection<? extends DataNode<ContentRootData>> data, @NotNull Module module, boolean forceDirectoriesCreation, @Nullable ProjectSystemId owner) {
        void var13_15;
        if (project == null) {
            ContentRootDataService.$$$reportNull$$$0(13);
        }
        if (modelsProvider == null) {
            ContentRootDataService.$$$reportNull$$$0(14);
        }
        if (data == null) {
            ContentRootDataService.$$$reportNull$$$0(15);
        }
        if (module == null) {
            ContentRootDataService.$$$reportNull$$$0(16);
        }
        ContentRootDataService.logUnitTest("Import data for module [" + module.getName() + "], data size [" + data.size() + "]", new Object[0]);
        SourceFolderManager sourceFolderManager = SourceFolderManager.getInstance((Project)project);
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        ContentEntry[] contentEntries = modifiableRootModel.getContentEntries();
        HashMap<String, ContentEntry> contentEntriesMap = new HashMap<String, ContentEntry>();
        HashMap<String, ContentEntry> filePathToContentEntryMap = new HashMap<String, ContentEntry>();
        ContentEntry[] contentEntryArray = contentEntries;
        int n = contentEntryArray.length;
        boolean bl = false;
        while (var13_15 < n) {
            ContentEntry contentEntry = contentEntryArray[var13_15];
            contentEntriesMap.put(contentEntry.getUrl(), contentEntry);
            VirtualFile file = contentEntry.getFile();
            if (file != null) {
                filePathToContentEntryMap.put(ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file), contentEntry);
            }
            ++var13_15;
        }
        sourceFolderManager.removeSourceFolders(module);
        ReferenceOpenHashSet importedContentEntries = new ReferenceOpenHashSet();
        for (DataNode<ContentRootData> dataNode : data) {
            ContentRootData contentRoot = (ContentRootData)dataNode.getData();
            ContentEntry contentEntry = ContentRootDataService.findOrCreateContentRoot(modifiableRootModel, contentRoot, filePathToContentEntryMap);
            if (!importedContentEntries.contains(contentEntry)) {
                ContentRootDataService.removeSourceFoldersIfAbsent(contentEntry, contentRoot);
                ContentRootDataService.removeImportedExcludeFolders(contentEntry, modelsProvider, owner, project);
                importedContentEntries.add(contentEntry);
            }
            ContentRootDataService.logTrace("Importing content root '%s' for module '%s' forceDirectoriesCreation=[%b]", contentRoot.getRootPath(), module.getName(), forceDirectoriesCreation);
            HashSet<String> updatedSourceRoots = new HashSet<String>();
            for (ExternalSystemSourceType externalSrcType : ExternalSystemSourceType.values()) {
                JpsModuleSourceRootType<?> type = ContentRootDataService.getJavaSourceRootType(externalSrcType);
                if (type == null) continue;
                for (ContentRootData.SourceRoot sourceRoot : contentRoot.getPaths(externalSrcType)) {
                    boolean createSourceFolder;
                    String sourceRootPath = sourceRoot.getPath();
                    boolean bl2 = createSourceFolder = !updatedSourceRoots.contains(sourceRootPath);
                    if (createSourceFolder) {
                        ContentRootDataService.createOrReplaceSourceFolder(sourceFolderManager, contentEntry, sourceRoot, module, type, forceDirectoriesCreation, ExternalSystemApiUtil.toExternalSource((ProjectSystemId)contentRoot.getOwner()));
                        if (externalSrcType == ExternalSystemSourceType.SOURCE || externalSrcType == ExternalSystemSourceType.TEST) {
                            updatedSourceRoots.add(sourceRootPath);
                        }
                    }
                    ContentRootDataService.configureSourceFolder(sourceFolderManager, contentEntry, sourceRoot, createSourceFolder, externalSrcType.isGenerated());
                }
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.EXCLUDED)) {
                ContentRootDataService.createExcludedRootIfAbsent(contentEntry, path, module.getName());
            }
            contentEntriesMap.remove(contentEntry.getUrl());
        }
        for (ContentEntry contentEntry : contentEntriesMap.values()) {
            modifiableRootModel.removeContentEntry(contentEntry);
        }
    }

    private static void removeImportedExcludeFolders(@NotNull ContentEntry contentEntry, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable ProjectSystemId owner, @NotNull Project project) {
        if (contentEntry == null) {
            ContentRootDataService.$$$reportNull$$$0(17);
        }
        if (modelsProvider == null) {
            ContentRootDataService.$$$reportNull$$$0(18);
        }
        if (project == null) {
            ContentRootDataService.$$$reportNull$$$0(19);
        }
        if (owner == null) {
            return;
        }
        if (modelsProvider instanceof IdeModifiableModelsProviderImpl) {
            IdeModifiableModelsProviderImpl impl = (IdeModifiableModelsProviderImpl)modelsProvider;
            MutableEntityStorage diff = impl.getActualStorageBuilder();
            VirtualFileUrl vfu = WorkspaceModel.getInstance((Project)project).getVirtualFileUrlManager().getOrCreateFromUrl(contentEntry.getUrl());
            WorkspaceEntity workspaceEntity = (WorkspaceEntity)ContainerUtil.find((Iterator)diff.getVirtualFileUrlIndex().findEntitiesByUrl(vfu).iterator(), entity -> entity instanceof ContentRootEntity);
            if (workspaceEntity instanceof ContentRootEntity) {
                ContentRootEntity contentRootEntity = (ContentRootEntity)workspaceEntity;
                for (ExcludeUrlEntity excludeEntity : contentRootEntity.getExcludedUrls()) {
                    if (!ContentRootDataService.isImportedEntity(owner, excludeEntity)) continue;
                    diff.removeEntity((WorkspaceEntity)excludeEntity);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isImportedEntity(@NotNull ProjectSystemId owner, @NotNull ExcludeUrlEntity excludeEntity) {
        EntitySource entitySource;
        if (owner == null) {
            ContentRootDataService.$$$reportNull$$$0(20);
        }
        if (excludeEntity == null) {
            ContentRootDataService.$$$reportNull$$$0(21);
        }
        if (!((entitySource = excludeEntity.getEntitySource()) instanceof JpsImportedEntitySource)) return false;
        JpsImportedEntitySource importedEntitySource = (JpsImportedEntitySource)entitySource;
        if (!owner.getId().equals(importedEntitySource.getExternalSystemId())) return false;
        return true;
    }

    @Nullable
    private static JpsModuleSourceRootType<?> getJavaSourceRootType(ExternalSystemSourceType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ExternalSystemSourceType.SOURCE, ExternalSystemSourceType.SOURCE_GENERATED -> JavaSourceRootType.SOURCE;
            case ExternalSystemSourceType.TEST, ExternalSystemSourceType.TEST_GENERATED -> JavaSourceRootType.TEST_SOURCE;
            case ExternalSystemSourceType.EXCLUDED -> null;
            case ExternalSystemSourceType.RESOURCE, ExternalSystemSourceType.RESOURCE_GENERATED -> JavaResourceRootType.RESOURCE;
            case ExternalSystemSourceType.TEST_RESOURCE, ExternalSystemSourceType.TEST_RESOURCE_GENERATED -> JavaResourceRootType.TEST_RESOURCE;
        };
    }

    @NotNull
    private static ContentEntry findOrCreateContentRoot(@NotNull ModifiableRootModel model, @NotNull ContentRootData contentRootData, @NotNull Map<String, ContentEntry> contentEntryMap) {
        String path;
        if (model == null) {
            ContentRootDataService.$$$reportNull$$$0(22);
        }
        if (contentRootData == null) {
            ContentRootDataService.$$$reportNull$$$0(23);
        }
        if (contentEntryMap == null) {
            ContentRootDataService.$$$reportNull$$$0(24);
        }
        if (contentEntryMap.containsKey(path = contentRootData.getRootPath())) {
            ContentEntry contentEntry = contentEntryMap.get(path);
            if (contentEntry == null) {
                ContentRootDataService.$$$reportNull$$$0(25);
            }
            return contentEntry;
        }
        ContentEntry contentEntry = model.addContentEntry(VfsUtilCore.pathToUrl((String)path), ExternalSystemApiUtil.toExternalSource((ProjectSystemId)contentRootData.getOwner()));
        if (contentEntry == null) {
            ContentRootDataService.$$$reportNull$$$0(26);
        }
        return contentEntry;
    }

    private static Set<String> getSourceRoots(@NotNull ContentRootData contentRoot) {
        if (contentRoot == null) {
            ContentRootDataService.$$$reportNull$$$0(27);
        }
        Set sourceRoots = CollectionFactory.createFilePathSet();
        for (ExternalSystemSourceType externalSrcType : ExternalSystemSourceType.values()) {
            JpsModuleSourceRootType<?> type = ContentRootDataService.getJavaSourceRootType(externalSrcType);
            if (type == null) continue;
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(externalSrcType)) {
                if (path == null) continue;
                sourceRoots.add(path.getPath());
            }
        }
        return sourceRoots;
    }

    private static void removeSourceFoldersIfAbsent(@NotNull ContentEntry contentEntry, @NotNull ContentRootData contentRoot) {
        SourceFolder[] sourceFolders;
        if (contentEntry == null) {
            ContentRootDataService.$$$reportNull$$$0(28);
        }
        if (contentRoot == null) {
            ContentRootDataService.$$$reportNull$$$0(29);
        }
        if ((sourceFolders = contentEntry.getSourceFolders()).length == 0) {
            return;
        }
        Set<String> sourceRoots = ContentRootDataService.getSourceRoots(contentRoot);
        for (SourceFolder sourceFolder : sourceFolders) {
            String url = sourceFolder.getUrl();
            String path = VfsUtilCore.urlToPath((String)url);
            if (sourceRoots.contains(path)) continue;
            contentEntry.removeSourceFolder(sourceFolder);
        }
    }

    private static void createOrReplaceSourceFolder(@NotNull SourceFolderManager sourceFolderManager, @NotNull ContentEntry contentEntry, @NotNull ContentRootData.SourceRoot sourceRoot, @NotNull Module module, @NotNull JpsModuleSourceRootType<?> sourceRootType, boolean createEmptyContentRootDirectories, @NotNull ProjectModelExternalSource externalSource) {
        SourceFolder folder;
        if (sourceFolderManager == null) {
            ContentRootDataService.$$$reportNull$$$0(30);
        }
        if (contentEntry == null) {
            ContentRootDataService.$$$reportNull$$$0(31);
        }
        if (sourceRoot == null) {
            ContentRootDataService.$$$reportNull$$$0(32);
        }
        if (module == null) {
            ContentRootDataService.$$$reportNull$$$0(33);
        }
        if (sourceRootType == null) {
            ContentRootDataService.$$$reportNull$$$0(34);
        }
        if (externalSource == null) {
            ContentRootDataService.$$$reportNull$$$0(35);
        }
        String path = sourceRoot.getPath();
        if (SystemInfo.isWindows && !path.isEmpty() && StringUtil.isWhiteSpace((char)path.charAt(path.length() - 1))) {
            LOG.warn("Source root ending with a space found. Such directories is not properly supported by JDK on Windows, see https://bugs.java.com/bugdatabase/view_bug.do?bug_id=8190546. The source root will not be added: '" + path + "'");
            return;
        }
        if (createEmptyContentRootDirectories) {
            ContentRootDataService.createEmptyDirectory(path);
        }
        if ((folder = ContentRootDataService.findSourceFolder(contentEntry, sourceRoot)) != null) {
            JpsModuleSourceRootType folderRootType = folder.getRootType();
            if (sourceRootType.equals((Object)folderRootType)) {
                return;
            }
            contentEntry.removeSourceFolder(folder);
        }
        String url = VfsUtilCore.pathToUrl((String)path);
        if (!Files.exists(Path.of(path, new String[0]), new LinkOption[0])) {
            ContentRootDataService.logTrace("Source folder [%s] does not exist and will not be created, will add when dir is created", url);
            ContentRootDataService.logUnitTest("Adding source folder listener to watch [%s] for creation in project [hashCode=%d]", url, module.getProject().hashCode());
            sourceFolderManager.addSourceFolder(module, url, sourceRootType);
        } else {
            contentEntry.addSourceFolder(url, sourceRootType, externalSource);
        }
    }

    private static void configureSourceFolder(@NotNull SourceFolderManager sourceFolderManager, @NotNull ContentEntry contentEntry, @NotNull ContentRootData.SourceRoot sourceRoot, boolean updatePackagePrefix, boolean generated) {
        if (sourceFolderManager == null) {
            ContentRootDataService.$$$reportNull$$$0(36);
        }
        if (contentEntry == null) {
            ContentRootDataService.$$$reportNull$$$0(37);
        }
        if (sourceRoot == null) {
            ContentRootDataService.$$$reportNull$$$0(38);
        }
        String packagePrefix = sourceRoot.getPackagePrefix();
        String url = VfsUtilCore.pathToUrl((String)sourceRoot.getPath());
        ContentRootDataService.logTrace("Importing root '%s' with packagePrefix=[%s] generated=[%b]", sourceRoot, packagePrefix, generated);
        SourceFolder folder = ContentRootDataService.findSourceFolder(contentEntry, sourceRoot);
        if (folder == null) {
            if (updatePackagePrefix) {
                sourceFolderManager.setSourceFolderPackagePrefix(url, packagePrefix);
            }
            if (generated) {
                sourceFolderManager.setSourceFolderGenerated(url, true);
            }
        } else {
            if (updatePackagePrefix && StringUtil.isNotEmpty((String)packagePrefix)) {
                folder.setPackagePrefix(packagePrefix);
            }
            if (generated) {
                ContentRootDataService.setForGeneratedSources(folder, true);
            }
        }
    }

    private static void createEmptyDirectory(@NotNull String path) {
        if (path == null) {
            ContentRootDataService.$$$reportNull$$$0(39);
        }
        if (Files.exists(Path.of(path, new String[0]), new LinkOption[0])) {
            return;
        }
        ExternalSystemApiUtil.doWriteAction(() -> {
            try {
                VfsUtil.createDirectoryIfMissing((String)path);
            }
            catch (IOException e) {
                LOG.warn(String.format("Unable to create directory for the path: %s", path), (Throwable)e);
            }
        });
    }

    @Nullable
    private static SourceFolder findSourceFolder(@NotNull ContentEntry contentEntry, @NotNull ContentRootData.SourceRoot sourceRoot) {
        if (contentEntry == null) {
            ContentRootDataService.$$$reportNull$$$0(40);
        }
        if (sourceRoot == null) {
            ContentRootDataService.$$$reportNull$$$0(41);
        }
        for (SourceFolder folder : contentEntry.getSourceFolders()) {
            String rootPath;
            String folderPath;
            VirtualFile file = folder.getFile();
            if (file == null || !(folderPath = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file)).equals(rootPath = sourceRoot.getPath())) continue;
            return folder;
        }
        return null;
    }

    private static void setForGeneratedSources(@NotNull SourceFolder folder, boolean generated) {
        JpsModuleSourceRoot jpsElement;
        JpsElement properties;
        if (folder == null) {
            ContentRootDataService.$$$reportNull$$$0(42);
        }
        if ((properties = (jpsElement = folder.getJpsElement()).getProperties(jpsElement.getRootType())) instanceof JavaSourceRootProperties) {
            JavaSourceRootProperties p = (JavaSourceRootProperties)properties;
            p.setForGeneratedSources(generated);
        } else if (properties instanceof JavaResourceRootProperties) {
            JavaResourceRootProperties p = (JavaResourceRootProperties)properties;
            p.setForGeneratedSources(generated);
        }
    }

    private static void logUnitTest(@NotNull String format, Object ... args) {
        if (format == null) {
            ContentRootDataService.$$$reportNull$$$0(43);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info(String.format(format, args));
        }
    }

    private static void logTrace(@NotNull String format, Object ... args) {
        if (format == null) {
            ContentRootDataService.$$$reportNull$$$0(44);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format(format, args));
        }
    }

    private static void createExcludedRootIfAbsent(@NotNull ContentEntry entry, @NotNull ContentRootData.SourceRoot root, @NotNull String moduleName) {
        if (entry == null) {
            ContentRootDataService.$$$reportNull$$$0(45);
        }
        if (root == null) {
            ContentRootDataService.$$$reportNull$$$0(46);
        }
        if (moduleName == null) {
            ContentRootDataService.$$$reportNull$$$0(47);
        }
        String rootPath = root.getPath();
        for (VirtualFile file : entry.getExcludeFolderFiles()) {
            if (!ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file).equals(rootPath)) continue;
            return;
        }
        ContentRootDataService.logTrace("Importing excluded root '%s' for content root '%s' of module '%s'", root, entry.getUrl(), moduleName);
        entry.addExcludeFolder(VfsUtilCore.pathToUrl((String)rootPath), true);
    }

    private static void filterAndReportDuplicatingContentRoots(@NotNull MultiMap<DataNode<ModuleData>, DataNode<ContentRootData>> moduleNodeToRootNodes, @NotNull Project project) {
        String notificationMessage;
        if (moduleNodeToRootNodes == null) {
            ContentRootDataService.$$$reportNull$$$0(48);
        }
        if (project == null) {
            ContentRootDataService.$$$reportNull$$$0(49);
        }
        boolean duplicatesAreAllowed = CodeInsightContexts.isSharedSourceSupportEnabled((Project)project);
        LinkedHashMap<String, DuplicateModuleReport> filter2 = new LinkedHashMap<String, DuplicateModuleReport>();
        for (Map.Entry entry : moduleNodeToRootNodes.entrySet()) {
            ModuleData moduleData = (ModuleData)((DataNode)entry.getKey()).getData();
            Collection crDataNodes = (Collection)entry.getValue();
            Iterator iterator = crDataNodes.iterator();
            while (iterator.hasNext()) {
                DataNode crDataNode = (DataNode)iterator.next();
                String rootPath = ((ContentRootData)crDataNode.getData()).getRootPath();
                DuplicateModuleReport report = filter2.putIfAbsent(rootPath, new DuplicateModuleReport(moduleData));
                if (report == null) continue;
                report.addDuplicate(moduleData);
                if (duplicatesAreAllowed) continue;
                iterator.remove();
                crDataNode.clear(true);
            }
        }
        Map toReport = filter2.entrySet().stream().filter(e -> ((DuplicateModuleReport)e.getValue()).hasDuplicates()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (r1, r2) -> {
            LOG.warn("Unexpected duplicates in keys while collecting filtered reports");
            return r2;
        }, LinkedHashMap::new));
        boolean hasDuplicates = !toReport.isEmpty();
        HasSharedSourcesUtil.setHasSharedSources(project, hasDuplicates);
        if (hasDuplicates && !duplicatesAreAllowed && (notificationMessage = ContentRootDataService.prepareMessageAndLogWarnings(toReport)) != null) {
            ContentRootDataService.showNotificationsPopup(project, toReport.size(), notificationMessage);
        }
    }

    @Nullable
    @Nls
    private static String prepareMessageAndLogWarnings(@NotNull Map<String, DuplicateModuleReport> toReport) {
        if (toReport == null) {
            ContentRootDataService.$$$reportNull$$$0(50);
        }
        String firstMessage = null;
        LOG.warn("Duplicating content roots detected.");
        for (Map.Entry<String, DuplicateModuleReport> entry : toReport.entrySet()) {
            String path = entry.getKey();
            DuplicateModuleReport report = entry.getValue();
            String message = ExternalSystemBundle.message((String)"duplicate.content.roots.removed", (Object[])new Object[]{path, report.getOriginalName(), StringUtil.join(report.getDuplicatesNames(), (String)", ")});
            if (firstMessage == null) {
                firstMessage = message;
            }
            LOG.warn(message);
        }
        return firstMessage;
    }

    private static void showNotificationsPopup(@NotNull Project project, int reportsCount, @NotNull @Nls String notificationMessage) {
        int extraReportsCount;
        if (project == null) {
            ContentRootDataService.$$$reportNull$$$0(51);
        }
        if (notificationMessage == null) {
            ContentRootDataService.$$$reportNull$$$0(52);
        }
        if ((extraReportsCount = reportsCount - 1) > 0) {
            notificationMessage = (String)notificationMessage + ExternalSystemBundle.message((String)"duplicate.content.roots.extra", (Object[])new Object[]{extraReportsCount});
        }
        Notification notification = new Notification("Content root duplicates", ExternalSystemBundle.message((String)"duplicate.content.roots.detected", (Object[])new Object[0]), (String)notificationMessage, NotificationType.WARNING);
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    private static /* synthetic */ void lambda$computeOrphanData$2(IdeModifiableModelsProvider modelsProvider, List orphanIdeModules, Module module) {
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        orphanIdeModules.addAll(List.of(modifiableRootModel.getContentEntries()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 13: 
            case 19: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 16: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 17: 
            case 28: 
            case 31: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeEntity";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRootData";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntryMap";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolderManager";
                break;
            }
            case 32: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoot";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRootType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSource";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNodeToRootNodes";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReport";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeOrphanData";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateContentRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeOrphanData";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeImportedExcludeFolders";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isImportedEntity";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateContentRoot";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoots";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceFoldersIfAbsent";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createOrReplaceSourceFolder";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "configureSourceFolder";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyDirectory";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findSourceFolder";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setForGeneratedSources";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "logUnitTest";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "logTrace";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createExcludedRootIfAbsent";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "filterAndReportDuplicatingContentRoots";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "prepareMessageAndLogWarnings";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "showNotificationsPopup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52 -> new IllegalArgumentException(string);
        };
    }

    private static final class DuplicateModuleReport {
        private final ModuleData myOriginal;
        private final List<ModuleData> myDuplicates;

        private DuplicateModuleReport(@NotNull ModuleData original) {
            if (original == null) {
                DuplicateModuleReport.$$$reportNull$$$0(0);
            }
            this.myDuplicates = new ArrayList<ModuleData>();
            this.myOriginal = original;
        }

        public void addDuplicate(@NotNull ModuleData duplicate) {
            if (duplicate == null) {
                DuplicateModuleReport.$$$reportNull$$$0(1);
            }
            this.myDuplicates.add(duplicate);
        }

        public boolean hasDuplicates() {
            return !this.myDuplicates.isEmpty();
        }

        public String getOriginalName() {
            return this.myOriginal.getInternalName();
        }

        public Collection<String> getDuplicatesNames() {
            return ContainerUtil.map(this.myDuplicates, AbstractNamedData::getInternalName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "duplicate";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService$DuplicateModuleReport";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addDuplicate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

