/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNode;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNodeDescriptor;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExternalSystemTasksTreeModel
extends DefaultTreeModel {
    @NotNull
    private static final Comparator<TreeNode> NODE_COMPARATOR = (t1, t2) -> {
        Object e1 = ((ExternalSystemNode)t1).getDescriptor().getElement();
        Object e2 = ((ExternalSystemNode)t2).getDescriptor().getElement();
        if (e1 instanceof ExternalProjectPojo) {
            if (e2 instanceof ExternalTaskExecutionInfo) {
                return 1;
            }
            return ((ExternalProjectPojo)e1).getName().compareTo(((ExternalProjectPojo)e2).getName());
        }
        if (e2 instanceof ExternalProjectPojo) {
            return -1;
        }
        return ExternalSystemTasksTreeModel.getTaskName((ExternalTaskExecutionInfo)e1).compareTo(ExternalSystemTasksTreeModel.getTaskName((ExternalTaskExecutionInfo)e2));
    };
    @NotNull
    private final ExternalSystemUiAware myUiAware;

    public ExternalSystemTasksTreeModel(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(0);
        }
        super(new ExternalSystemNode<String>(new ExternalSystemNodeDescriptor<String>("", "", "", null)));
        this.myUiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
    }

    private static String getTaskName(@NotNull ExternalTaskExecutionInfo taskInfo) {
        if (taskInfo == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(1);
        }
        return (String)taskInfo.getSettings().getTaskNames().get(0);
    }

    @NotNull
    public ExternalSystemNode<ExternalProjectPojo> ensureProjectNodeExists(@NotNull ExternalProjectPojo project) {
        if (project == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(2);
        }
        Object root = this.getRoot();
        for (int i2 = ((DefaultMutableTreeNode)root).getChildCount() - 1; i2 >= 0; --i2) {
            ExternalProjectPojo pojo;
            TreeNode child = ((ExternalSystemNode)root).getChildAt(i2);
            ExternalSystemNodeDescriptor descriptor2 = ((ExternalSystemNode)child).getDescriptor();
            Object element = descriptor2.getElement();
            if (!(element instanceof ExternalProjectPojo) || !(pojo = (ExternalProjectPojo)element).getPath().equals(project.getPath())) continue;
            if (!pojo.getName().equals(project.getName())) {
                pojo.setName(project.getName());
                descriptor2.setName(project.getName());
                this.nodeChanged(child);
            }
            TreeNode treeNode = child;
            if (treeNode == null) {
                ExternalSystemTasksTreeModel.$$$reportNull$$$0(3);
            }
            return treeNode;
        }
        ExternalProjectPojo element = new ExternalProjectPojo(project.getName(), project.getPath());
        ExternalSystemNodeDescriptor<ExternalProjectPojo> descriptor3 = ExternalSystemTasksTreeModel.descriptor(element, this.myUiAware.getProjectIcon());
        ExternalSystemNode<ExternalProjectPojo> result = new ExternalSystemNode<ExternalProjectPojo>(descriptor3);
        this.insertNodeInto(result, (MutableTreeNode)root);
        ExternalSystemNode<ExternalProjectPojo> externalSystemNode = result;
        if (externalSystemNode == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(4);
        }
        return externalSystemNode;
    }

    public void ensureSubProjectsStructure(@NotNull ExternalProjectPojo topLevelProject, @NotNull Collection<? extends ExternalProjectPojo> subProjects) {
        if (topLevelProject == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(5);
        }
        if (subProjects == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(6);
        }
        ExternalSystemNode<ExternalProjectPojo> topLevelProjectNode = this.ensureProjectNodeExists(topLevelProject);
        HashMap<String, ExternalProjectPojo> toAdd = new HashMap<String, ExternalProjectPojo>();
        for (ExternalProjectPojo externalProjectPojo : subProjects) {
            toAdd.put(externalProjectPojo.getPath(), externalProjectPojo);
        }
        toAdd.remove(topLevelProject.getPath());
        for (int i2 = 0; i2 < topLevelProjectNode.getChildCount(); ++i2) {
            TreeNode treeNode = topLevelProjectNode.getChildAt(i2);
            Object childElement = ((ExternalSystemNode)treeNode).getDescriptor().getElement();
            if (childElement instanceof ExternalTaskExecutionInfo || toAdd.remove(((ExternalProjectPojo)childElement).getPath()) != null) continue;
            this.removeNodeFromParent((MutableTreeNode)treeNode);
            --i2;
        }
        if (!toAdd.isEmpty()) {
            for (Map.Entry entry : toAdd.entrySet()) {
                ExternalProjectPojo element = new ExternalProjectPojo(((ExternalProjectPojo)entry.getValue()).getName(), ((ExternalProjectPojo)entry.getValue()).getPath());
                this.insertNodeInto(new ExternalSystemNode<ExternalProjectPojo>(ExternalSystemTasksTreeModel.descriptor(element, this.myUiAware.getProjectIcon())), topLevelProjectNode);
            }
        }
    }

    @NotNull
    private static <T> ExternalSystemNodeDescriptor<T> descriptor(@NotNull T element, @Nullable Icon icon) {
        if (element == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(7);
        }
        return ExternalSystemTasksTreeModel.descriptor(element, "", icon);
    }

    @NotNull
    private static <T> ExternalSystemNodeDescriptor<T> descriptor(@NotNull T element, @NotNull @Nls String description, @Nullable Icon icon) {
        if (element == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(8);
        }
        if (description == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(9);
        }
        return new ExternalSystemNodeDescriptor<T>(element, element.toString(), description, icon);
    }

    @Override
    @NotNull
    public ExternalSystemNode<?> getRoot() {
        ExternalSystemNode externalSystemNode = (ExternalSystemNode)super.getRoot();
        if (externalSystemNode == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(10);
        }
        return externalSystemNode;
    }

    public void insertNodeInto(MutableTreeNode child, MutableTreeNode parent) {
        int index = ExternalSystemTasksTreeModel.findIndexFor(child, parent);
        super.insertNodeInto(child, parent, index);
    }

    @Override
    public void insertNodeInto(MutableTreeNode child, MutableTreeNode parent, int i2) {
        this.insertNodeInto(child, parent);
    }

    private static int findIndexFor(MutableTreeNode child, MutableTreeNode parent) {
        int childCount = parent.getChildCount();
        if (childCount == 0) {
            return 0;
        }
        if (childCount == 1) {
            return NODE_COMPARATOR.compare(child, parent.getChildAt(0)) <= 0 ? 0 : 1;
        }
        return ExternalSystemTasksTreeModel.findIndexFor(child, parent, 0, childCount - 1);
    }

    private static int findIndexFor(MutableTreeNode child, MutableTreeNode parent, int i1, int i2) {
        if (i1 == i2) {
            return NODE_COMPARATOR.compare(child, parent.getChildAt(i1)) <= 0 ? i1 : i1 + 1;
        }
        int half = (i1 + i2) / 2;
        if (NODE_COMPARATOR.compare(child, parent.getChildAt(half)) <= 0) {
            return ExternalSystemTasksTreeModel.findIndexFor(child, parent, i1, half);
        }
        return ExternalSystemTasksTreeModel.findIndexFor(child, parent, half + 1, i2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelProject";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subProjects";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureProjectNodeExists";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTaskName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "ensureProjectNodeExists";
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ensureSubProjectsStructure";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "descriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 10 -> new IllegalStateException(string);
        };
    }
}

