/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui.completion;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.externalSystem.service.ui.completion.TextCompletionPopup;
import com.intellij.openapi.externalSystem.service.ui.completion.TextCompletionRenderer;
import com.intellij.openapi.externalSystem.service.ui.completion.collector.TextCompletionCollector;
import com.intellij.openapi.observable.util.ListenerUiUtil;
import com.intellij.openapi.observable.util.ListenerWithValueUiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.containers.DisposableWrapperList;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.event.CaretEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002>?B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000b\u0010#\u001a\u00070$\u00a2\u0006\u0002\b%J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'H\u0002J\u0015\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010*J(\u0010+\u001a\u00020\"2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\"0!H\u0002J\u0015\u0010/\u001a\u00020\"2\u0006\u0010)\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010*J\u0015\u00100\u001a\u00020\"2\u0006\u0010)\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010*J\b\u00101\u001a\u00020$H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u000205H\u0002J\b\u00107\u001a\u000208H\u0002J\u000e\u00109\u001a\u00020\"2\u0006\u0010:\u001a\u00020\u001cJ\b\u00109\u001a\u00020\"H\u0002J\b\u0010;\u001a\u00020\"H\u0002J\b\u0010<\u001a\u00020\"H\u0002J&\u0010=\u001a\u00020\"2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\"0!R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00148%X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\"0!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionField;", "T", "Lcom/intellij/ui/components/fields/ExtendableTextField;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "renderer", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionRenderer;", "getRenderer", "()Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionRenderer;", "setRenderer", "(Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionRenderer;)V", "completionType", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionField$CompletionType;", "getCompletionType", "()Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionField$CompletionType;", "setCompletionType", "(Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionField$CompletionType;)V", "completionCollector", "Lcom/intellij/openapi/externalSystem/service/ui/completion/collector/TextCompletionCollector;", "getCompletionCollector", "()Lcom/intellij/openapi/externalSystem/service/ui/completion/collector/TextCompletionCollector;", "updateMutex", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastUpdateCompletionPopupTime", "", "lastUpdateCompletionPopupEvent", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionField$UpdatePopupType;", "popup", "Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionPopup;", "completionVariantChosenListeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lkotlin/Function1;", "", "getTextToComplete", "", "Lcom/intellij/openapi/util/NlsSafe;", "getFilteredCompletionVariants", "", "fireVariantChosen", "variant", "(Ljava/lang/Object;)V", "whenCompletionVariantChosen", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "replaceText", "replaceWordUnderCaret", "getWordUnderCaret", "getWordRange", "Lkotlin/ranges/IntRange;", "offset", "", "getBoundedCaretPosition", "isFocused", "", "updatePopup", "type", "showPopup", "hidePopup", "whenTextChangedFromUi", "UpdatePopupType", "CompletionType", "intellij.platform.externalSystem.impl"})
@SourceDebugExtension(value={"SMAP\nTextCompletionField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextCompletionField.kt\ncom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionField\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 BindUtil.kt\ncom/intellij/openapi/observable/util/BindUtil\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n777#2:224\n873#2,2:225\n1915#2,2:230\n32#3,3:227\n37#3,3:232\n32#3,8:236\n32#3,8:244\n1#4:235\n*S KotlinDebug\n*F\n+ 1 TextCompletionField.kt\ncom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionField\n*L\n55#1:224\n55#1:225,2\n64#1:230,2\n59#1:227,3\n59#1:232,3\n200#1:236,8\n205#1:244,8\n*E\n"})
public abstract class TextCompletionField<T>
extends ExtendableTextField {
    @Nullable
    private final Project project;
    @NotNull
    private TextCompletionRenderer<T> renderer;
    @NotNull
    private CompletionType completionType;
    @NotNull
    private final AtomicBoolean updateMutex;
    private long lastUpdateCompletionPopupTime;
    @NotNull
    private UpdatePopupType lastUpdateCompletionPopupEvent;
    @Nullable
    private TextCompletionPopup<T> popup;
    @NotNull
    private final DisposableWrapperList<Function1<T, Unit>> completionVariantChosenListeners;

    public TextCompletionField(@Nullable Project project) {
        this.project = project;
        this.renderer = new TextCompletionRenderer.Default();
        this.completionType = CompletionType.REPLACE_TEXT;
        this.updateMutex = new AtomicBoolean();
        this.lastUpdateCompletionPopupEvent = UpdatePopupType.HIDE;
        this.completionVariantChosenListeners = new DisposableWrapperList();
        ListenerUiUtil.whenFocusGained$default((Component)((Component)((Object)this)), null, arg_0 -> TextCompletionField._init_$lambda$0(this, arg_0), (int)1, null);
        ListenerUiUtil.onceWhenFocusGained$default((Component)((Component)((Object)this)), null, arg_0 -> TextCompletionField._init_$lambda$1(this, arg_0), (int)1, null);
        String[] stringArray = new String[]{"CodeCompletion"};
        UiUtils.addKeyboardAction((JComponent)((JComponent)((Object)this)), (List)UiUtils.getKeyStrokes((String[])stringArray), arg_0 -> TextCompletionField._init_$lambda$2(this, arg_0));
        ListenerUiUtil.whenCaretMoved$default((JTextComponent)((JTextComponent)((Object)this)), null, arg_0 -> TextCompletionField._init_$lambda$3(this, arg_0), (int)1, null);
        ListenerWithValueUiUtil.whenTextChanged$default((JTextComponent)((JTextComponent)((Object)this)), null, arg_0 -> TextCompletionField._init_$lambda$4(this, arg_0), (int)1, null);
    }

    @NotNull
    public final TextCompletionRenderer<T> getRenderer() {
        return this.renderer;
    }

    public final void setRenderer(@NotNull TextCompletionRenderer<T> textCompletionRenderer) {
        Intrinsics.checkNotNullParameter(textCompletionRenderer, (String)"<set-?>");
        this.renderer = textCompletionRenderer;
    }

    @NotNull
    public final CompletionType getCompletionType() {
        return this.completionType;
    }

    public final void setCompletionType(@NotNull CompletionType completionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)completionType), (String)"<set-?>");
        this.completionType = completionType;
    }

    @ApiStatus.OverrideOnly
    @NotNull
    protected abstract TextCompletionCollector<T> getCompletionCollector();

    @NotNull
    public final String getTextToComplete() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.completionType.ordinal()]) {
            case 1: {
                String string2 = this.getText();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                break;
            }
            case 2: {
                string = this.getWordUnderCaret();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<T> getFilteredCompletionVariants() {
        void $this$filterTo$iv$iv;
        String textToComplete = this.getTextToComplete();
        boolean isPassAllVariances = this.lastUpdateCompletionPopupEvent == UpdatePopupType.SHOW_ALL_VARIANCES;
        Iterable $this$filter$iv = this.getCompletionCollector().getCompletionVariants();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(isPassAllVariances || StringsKt.contains$default((CharSequence)this.renderer.getText(it), (CharSequence)textToComplete, (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fireVariantChosen(T variant) {
        AtomicBoolean $this$lockOrSkip$iv = this.updateMutex;
        boolean $i$f$lockOrSkip = false;
        if ($this$lockOrSkip$iv.compareAndSet(false, true)) {
            try {
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[this.completionType.ordinal()]) {
                    case 1: {
                        this.replaceText(variant);
                        break;
                    }
                    case 2: {
                        this.replaceWordUnderCaret(variant);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Iterable $this$forEach$iv = (Iterable)this.completionVariantChosenListeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function1 listener2 = (Function1)element$iv;
                    boolean bl2 = false;
                    listener2.invoke(variant);
                }
            }
            finally {
                $this$lockOrSkip$iv.set(false);
            }
        }
    }

    private final void whenCompletionVariantChosen(Disposable parentDisposable, Function1<? super T, Unit> listener2) {
        if (parentDisposable == null) {
            v0 = this.completionVariantChosenListeners.add(listener2);
        } else {
            Disposable disposable = this.completionVariantChosenListeners.add(listener2, parentDisposable);
            v0 = disposable;
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"add(...)");
        }
    }

    static /* synthetic */ void whenCompletionVariantChosen$default(TextCompletionField textCompletionField, Disposable disposable, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: whenCompletionVariantChosen");
        }
        if ((n & 1) != 0) {
            disposable = null;
        }
        textCompletionField.whenCompletionVariantChosen(disposable, function1);
    }

    private final void replaceText(T variant) {
        this.setText(this.renderer.getText(variant));
    }

    private final void replaceWordUnderCaret(T variant) {
        String variantText = this.renderer.getText(variant);
        int caretPosition = this.getBoundedCaretPosition();
        IntRange wordRange = this.getWordRange(caretPosition);
        this.getDocument().remove(wordRange.getFirst(), wordRange.getLast() - wordRange.getFirst() + 1);
        this.getDocument().insertString(wordRange.getFirst(), variantText, null);
    }

    private final String getWordUnderCaret() {
        int caretPosition = this.getBoundedCaretPosition();
        IntRange wordRange = this.getWordRange(caretPosition);
        IntRange textToCompleteRange = RangesKt.until((int)wordRange.getFirst(), (int)caretPosition);
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.substring((String)string, (IntRange)textToCompleteRange);
    }

    private final IntRange getWordRange(int offset) {
        int wordStartPosition = 0;
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String[] stringArray = new String[]{" "};
        for (String word : StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            int wordEndPosition = wordStartPosition + word.length();
            boolean bl = wordStartPosition <= offset ? offset <= wordEndPosition : false;
            if (bl) {
                return RangesKt.until((int)wordStartPosition, (int)wordEndPosition);
            }
            wordStartPosition = wordEndPosition + 1;
        }
        throw new BadLocationException(this.getText(), offset);
    }

    private final int getBoundedCaretPosition() {
        return Math.max(0, Math.min(this.getText().length(), this.getCaretPosition()));
    }

    private final boolean isFocused() {
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.project);
        Window frame = focusManager.getLastFocusedIdeWindow();
        Component focusOwner = focusManager.getLastFocusedFor(frame);
        return Intrinsics.areEqual((Object)focusOwner, (Object)((Object)this));
    }

    public final void updatePopup(@NotNull UpdatePopupType type) {
        long updatePopupTime;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!this.isShowing() || !this.isFocused()) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                this.showPopup();
                break;
            }
            case 2: {
                this.hidePopup();
                break;
            }
            case 3: {
                this.updatePopup();
                break;
            }
            case 4: {
                this.showPopup();
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                return;
            }
            case 3: {
                return;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.lastUpdateCompletionPopupTime = updatePopupTime = System.currentTimeMillis();
        this.lastUpdateCompletionPopupEvent = type;
        ModalityState modalityState = ModalityState.stateForComponent((Component)((Component)((Object)this)));
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
        ModalityState modalityState2 = modalityState;
        this.getCompletionCollector().collectCompletionVariants(modalityState2, arg_0 -> TextCompletionField.updatePopup$lambda$0(this, updatePopupTime, arg_0));
    }

    private final void updatePopup() {
        block0: {
            TextCompletionPopup<T> textCompletionPopup = this.popup;
            if (textCompletionPopup == null) break block0;
            textCompletionPopup.update();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showPopup() {
        if (this.popup == null) {
            void $this$showPopup_u24lambda_u241;
            TextCompletionPopup<T> it;
            TextCompletionPopup<T> textCompletionPopup;
            TextCompletionPopup.Contributor contributor2 = new TextCompletionPopup.Contributor<T>(this){
                final /* synthetic */ TextCompletionField<T> this$0;
                {
                    this.this$0 = $receiver;
                }

                public List<T> getItems() {
                    return TextCompletionField.access$getFilteredCompletionVariants(this.this$0);
                }

                public void fireItemChosen(T item) {
                    TextCompletionField.access$fireVariantChosen(this.this$0, item);
                }
            };
            TextCompletionPopup<T> textCompletionPopup2 = textCompletionPopup = new TextCompletionPopup<T>(this.project, this, contributor2, this.renderer);
            TextCompletionField textCompletionField = this;
            boolean bl = false;
            Disposer.register((Disposable)((Disposable)it), () -> TextCompletionField.showPopup$lambda$0$0(this));
            it = textCompletionPopup;
            boolean bl2 = false;
            $this$showPopup_u24lambda_u241.showUnderneathOfTextComponent();
            textCompletionField.popup = textCompletionPopup;
        }
        this.updatePopup();
    }

    private final void hidePopup() {
        TextCompletionPopup<T> textCompletionPopup = this.popup;
        if (textCompletionPopup != null) {
            textCompletionPopup.cancel();
        }
        this.popup = null;
    }

    public final void whenTextChangedFromUi(@Nullable Disposable parentDisposable, @NotNull Function1<? super String, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        ListenerUiUtil.whenTextChangedFromUi((JTextComponent)((JTextComponent)((Object)this)), (Disposable)parentDisposable, listener2);
        this.whenCompletionVariantChosen(parentDisposable, arg_0 -> TextCompletionField.whenTextChangedFromUi$lambda$0(this, listener2, arg_0));
    }

    public static /* synthetic */ void whenTextChangedFromUi$default(TextCompletionField textCompletionField, Disposable disposable, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: whenTextChangedFromUi");
        }
        if ((n & 1) != 0) {
            disposable = null;
        }
        textCompletionField.whenTextChangedFromUi(disposable, (Function1<String, Unit>)function1);
    }

    private static final Unit updatePopup$lambda$0(TextCompletionField this$0, long $updatePopupTime, List completion) {
        Intrinsics.checkNotNullParameter((Object)completion, (String)"completion");
        if (this$0.lastUpdateCompletionPopupTime == $updatePopupTime) {
            switch (WhenMappings.$EnumSwitchMapping$1[this$0.lastUpdateCompletionPopupEvent.ordinal()]) {
                case 3: {
                    break;
                }
                case 1: {
                    this$0.updatePopup();
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    this$0.updatePopup();
                    break;
                }
                case 5: {
                    if (!(!((Collection)completion).isEmpty())) break;
                    this$0.showPopup();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final void showPopup$lambda$0$0(TextCompletionField this$0) {
        this$0.popup = null;
    }

    private static final Unit whenTextChangedFromUi$lambda$0$0(Function1 $listener, TextCompletionField this$0) {
        String string = this$0.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        $listener.invoke((Object)string);
        return Unit.INSTANCE;
    }

    private static final Unit whenTextChangedFromUi$lambda$0(TextCompletionField this$0, Function1 $listener, Object it) {
        ActionsKt.invokeLater((ModalityState)ModalityState.stateForComponent((Component)((Component)((Object)this$0))), () -> TextCompletionField.whenTextChangedFromUi$lambda$0$0($listener, this$0));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$4$0$0(TextCompletionField this$0) {
        this$0.updatePopup(UpdatePopupType.SHOW_IF_HAS_VARIANCES);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(TextCompletionField this$0, FocusEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = this$0.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() == 0) {
            this$0.updatePopup(UpdatePopupType.SHOW_IF_HAS_VARIANCES);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(TextCompletionField this$0, FocusEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updatePopup(UpdatePopupType.SHOW_IF_HAS_VARIANCES);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(TextCompletionField this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updatePopup(UpdatePopupType.SHOW);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit _init_$lambda$3(TextCompletionField this$0, CaretEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AtomicBoolean $this$lockOrSkip$iv = this$0.updateMutex;
        boolean $i$f$lockOrSkip = false;
        if ($this$lockOrSkip$iv.compareAndSet(false, true)) {
            try {
                boolean bl = false;
                this$0.updatePopup(UpdatePopupType.UPDATE);
            }
            finally {
                $this$lockOrSkip$iv.set(false);
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit _init_$lambda$4(TextCompletionField this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AtomicBoolean $this$lockOrSkip$iv = this$0.updateMutex;
        boolean $i$f$lockOrSkip = false;
        if ($this$lockOrSkip$iv.compareAndSet(false, true)) {
            try {
                boolean bl = false;
                ActionsKt.invokeLater$default(null, () -> TextCompletionField.lambda$4$0$0(this$0), (int)1, null);
            }
            finally {
                $this$lockOrSkip$iv.set(false);
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ List access$getFilteredCompletionVariants(TextCompletionField $this) {
        return $this.getFilteredCompletionVariants();
    }

    public static final /* synthetic */ void access$fireVariantChosen(TextCompletionField $this, Object variant) {
        $this.fireVariantChosen(variant);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionField$CompletionType;", "", "<init>", "(Ljava/lang/String;I)V", "REPLACE_WORD", "REPLACE_TEXT", "intellij.platform.externalSystem.impl"})
    public static final class CompletionType
    extends Enum<CompletionType> {
        public static final /* enum */ CompletionType REPLACE_WORD = new CompletionType();
        public static final /* enum */ CompletionType REPLACE_TEXT = new CompletionType();
        private static final /* synthetic */ CompletionType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CompletionType[] values() {
            return (CompletionType[])$VALUES.clone();
        }

        public static CompletionType valueOf(String value) {
            return Enum.valueOf(CompletionType.class, value);
        }

        @NotNull
        public static EnumEntries<CompletionType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = completionTypeArray = new CompletionType[]{CompletionType.REPLACE_WORD, CompletionType.REPLACE_TEXT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/completion/TextCompletionField$UpdatePopupType;", "", "<init>", "(Ljava/lang/String;I)V", "UPDATE", "SHOW", "HIDE", "SHOW_IF_HAS_VARIANCES", "SHOW_ALL_VARIANCES", "intellij.platform.externalSystem.impl"})
    public static final class UpdatePopupType
    extends Enum<UpdatePopupType> {
        public static final /* enum */ UpdatePopupType UPDATE = new UpdatePopupType();
        public static final /* enum */ UpdatePopupType SHOW = new UpdatePopupType();
        public static final /* enum */ UpdatePopupType HIDE = new UpdatePopupType();
        public static final /* enum */ UpdatePopupType SHOW_IF_HAS_VARIANCES = new UpdatePopupType();
        public static final /* enum */ UpdatePopupType SHOW_ALL_VARIANCES = new UpdatePopupType();
        private static final /* synthetic */ UpdatePopupType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UpdatePopupType[] values() {
            return (UpdatePopupType[])$VALUES.clone();
        }

        public static UpdatePopupType valueOf(String value) {
            return Enum.valueOf(UpdatePopupType.class, value);
        }

        @NotNull
        public static EnumEntries<UpdatePopupType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = updatePopupTypeArray = new UpdatePopupType[]{UpdatePopupType.UPDATE, UpdatePopupType.SHOW, UpdatePopupType.HIDE, UpdatePopupType.SHOW_IF_HAS_VARIANCES, UpdatePopupType.SHOW_ALL_VARIANCES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CompletionType.values().length];
            try {
                nArray[CompletionType.REPLACE_TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompletionType.REPLACE_WORD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[UpdatePopupType.values().length];
            try {
                nArray[UpdatePopupType.SHOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdatePopupType.HIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdatePopupType.UPDATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdatePopupType.SHOW_ALL_VARIANCES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdatePopupType.SHOW_IF_HAS_VARIANCES.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

