/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.xmlSchemeGenerator.compatDataGenerator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.css.xmlSchemeGenerator.compatDataGenerator.BrowserSpecificData;
import com.intellij.css.xmlSchemeGenerator.compatDataGenerator.CssCompatDataSchemaGeneratorKt;
import com.intellij.css.xmlSchemeGenerator.webrefGenerator.CssWebrefSchemaGenerator;
import com.intellij.css.xmlSchemeGenerator.webrefGenerator.XmlBuilderImpl;
import com.intellij.css.xmlSchemeGenerator.webrefGenerator.XmlBuilderKt;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0019\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0019J\"\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0019J$\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020%2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u0019H\u0002J<\u0010*\u001a.\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00190,j\b\u0012\u0004\u0012\u00020\u0019`-\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00190,j\b\u0012\u0004\u0012\u00020\u0019`-0+2\u0006\u0010.\u001a\u00020 H\u0002J\"\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00192\b\u00101\u001a\u0004\u0018\u00010\u0019H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010 2\u0006\u0010(\u001a\u00020%H\u0002J\u0010\u00103\u001a\u00020\u00192\u0006\u0010(\u001a\u00020%H\u0002J!\u00104\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010#\u001a\u00020\u0019\u00a2\u0006\u0002\u00105J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020%H\u0002J\u0010\u00109\u001a\u0002072\u0006\u0010:\u001a\u00020%H\u0002J\u0006\u0010;\u001a\u00020<R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006="}, d2={"Lcom/intellij/css/xmlSchemeGenerator/compatDataGenerator/CssCompatDataSchemaGenerator;", "", "<init>", "()V", "xmlBuilder", "Lcom/intellij/css/xmlSchemeGenerator/webrefGenerator/XmlBuilderImpl;", "getXmlBuilder", "()Lcom/intellij/css/xmlSchemeGenerator/webrefGenerator/XmlBuilderImpl;", "setXmlBuilder", "(Lcom/intellij/css/xmlSchemeGenerator/webrefGenerator/XmlBuilderImpl;)V", "cssDescriptorsFactory", "Lcom/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2;", "getCssDescriptorsFactory", "()Lcom/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2;", "generate", "", "generateXmlDefinitionsFromFiles", "listFiles", "", "Ljava/io/File;", "([Ljava/io/File;)V", "generateXmlDefinitionsFromFile", "file", "saveToFile", "filePath", "", "browserPrefixes", "", "getBrowserPrefixes", "()Ljava/util/List;", "handleDataEntities", "languageEntities", "Lcom/google/gson/JsonObject;", "languageEntityKind", "handleDataEntity", "languageEntityName", "languageEntityObject", "Lcom/google/gson/JsonElement;", "generateXmlDefinitionsFrom", "name", "cssEntityObject", "defaultCssEntityKind", "getPrefixesAndAlternativeNamesSets", "Lkotlin/Pair;", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "browsersSupportObject", "generateXmlDefinition", "xmlEntityKind", "prefix", "getBrowsersSupportObject", "getDescription", "generateListOfExclusion", "([Ljava/io/File;Ljava/lang/String;)V", "isImplementedInBrowser", "", "browserSupportObject", "hasAnyBrowserSupport", "propertyObject", "getMapOfCompatValues", "Lcom/intellij/css/xmlSchemeGenerator/compatDataGenerator/BrowserSpecificData;", "intellij.css.xmlSchemeGenerator"})
@SourceDebugExtension(value={"SMAP\nCssCompatDataSchemaGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CssCompatDataSchemaGenerator.kt\ncom/intellij/css/xmlSchemeGenerator/compatDataGenerator/CssCompatDataSchemaGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,334:1\n1#2:335\n1915#3,2:336\n1915#3,2:338\n1586#3:340\n1661#3,3:341\n*S KotlinDebug\n*F\n+ 1 CssCompatDataSchemaGenerator.kt\ncom/intellij/css/xmlSchemeGenerator/compatDataGenerator/CssCompatDataSchemaGenerator\n*L\n119#1:336,2\n132#1:338,2\n285#1:340\n285#1:341,3\n*E\n"})
public final class CssCompatDataSchemaGenerator {
    @NotNull
    private XmlBuilderImpl xmlBuilder = new XmlBuilderImpl();
    @NotNull
    private final CssElementDescriptorFactory2 cssDescriptorsFactory = new CssElementDescriptorFactory2();
    @NotNull
    private final List<String> browserPrefixes;

    @NotNull
    public final XmlBuilderImpl getXmlBuilder() {
        return this.xmlBuilder;
    }

    public final void setXmlBuilder(@NotNull XmlBuilderImpl xmlBuilderImpl) {
        Intrinsics.checkNotNullParameter((Object)xmlBuilderImpl, (String)"<set-?>");
        this.xmlBuilder = xmlBuilderImpl;
    }

    @NotNull
    public final CssElementDescriptorFactory2 getCssDescriptorsFactory() {
        return this.cssDescriptorsFactory;
    }

    public CssCompatDataSchemaGenerator() {
        Object[] objectArray = new String[]{"-moz-", "-webkit-", "-ms-"};
        this.browserPrefixes = CollectionsKt.listOf((Object[])objectArray);
        this.cssDescriptorsFactory.reload();
    }

    public final void generate() {
        String[] stringArray = new String[]{"types", "properties", "selectors"};
        for (String languageEntity : stringArray) {
            String path = "plugins/css/xmlSchemeGenerator/resources/sources/browserCompatDataJsons/" + languageEntity;
            File directory = new File(path);
            if (!directory.exists() || !directory.isDirectory()) {
                return;
            }
            File[] listFiles = directory.listFiles();
            Intrinsics.checkNotNull((Object)listFiles);
            this.generateListOfExclusion(listFiles, languageEntity);
            this.generateXmlDefinitionsFromFiles(listFiles);
            this.saveToFile("plugins/css/xmlSchemeGenerator/resources/generated-xmls/browser-specific/prefixed-" + languageEntity + ".xml");
        }
    }

    public final void generateXmlDefinitionsFromFiles(@NotNull File[] listFiles) {
        Intrinsics.checkNotNullParameter((Object)listFiles, (String)"listFiles");
        this.xmlBuilder = new XmlBuilderImpl();
        this.xmlBuilder.addTag("definitions", (Function1<? super Element, Unit>)((Function1)arg_0 -> CssCompatDataSchemaGenerator.generateXmlDefinitionsFromFiles$lambda$0(listFiles, this, arg_0)));
    }

    public final void generateXmlDefinitionsFromFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileReader reader = new FileReader(file);
        JsonObject rootElementObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        if (rootElementObject != null) {
            JsonObject cssElementObject = rootElementObject.getAsJsonObject("css");
            JsonObject types = cssElementObject.getAsJsonObject("types");
            JsonObject properties = cssElementObject.getAsJsonObject("properties");
            JsonObject selectors = cssElementObject.getAsJsonObject("selectors");
            if (types != null || selectors != null) {
                JsonObject jsonObject = types;
                if (jsonObject == null) {
                    jsonObject = selectors;
                }
                JsonObject jsonObject2 = jsonObject;
                Intrinsics.checkNotNull((Object)jsonObject2);
                CssCompatDataSchemaGenerator.handleDataEntities$default(this, jsonObject2, null, 2, null);
            }
            if (properties != null) {
                this.handleDataEntities(properties, "property");
            }
        }
    }

    public final void saveToFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File xmlFile = new File(filePath);
        xmlFile.createNewFile();
        XmlBuilderKt.saveToFile(this.xmlBuilder, xmlFile);
    }

    @NotNull
    public final List<String> getBrowserPrefixes() {
        return this.browserPrefixes;
    }

    public final void handleDataEntities(@NotNull JsonObject languageEntities, @Nullable String languageEntityKind) {
        Intrinsics.checkNotNullParameter((Object)languageEntities, (String)"languageEntities");
        for (Map.Entry entry : languageEntities.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            String languageEntityName = (String)entry.getKey();
            JsonElement languageEntityObject = (JsonElement)entry.getValue();
            Intrinsics.checkNotNull((Object)languageEntityName);
            Intrinsics.checkNotNull((Object)languageEntityObject);
            this.handleDataEntity(languageEntityName, languageEntityObject, languageEntityKind);
        }
    }

    public static /* synthetic */ void handleDataEntities$default(CssCompatDataSchemaGenerator cssCompatDataSchemaGenerator, JsonObject jsonObject, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        cssCompatDataSchemaGenerator.handleDataEntities(jsonObject, string);
    }

    public final void handleDataEntity(@NotNull String languageEntityName, @NotNull JsonElement languageEntityObject, @Nullable String languageEntityKind) {
        Intrinsics.checkNotNullParameter((Object)languageEntityName, (String)"languageEntityName");
        Intrinsics.checkNotNullParameter((Object)languageEntityObject, (String)"languageEntityObject");
        for (Map.Entry entry : languageEntityObject.getAsJsonObject().entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            String dataObjectName = (String)entry.getKey();
            JsonElement dataObject = (JsonElement)entry.getValue();
            if (Intrinsics.areEqual((Object)dataObjectName, (Object)"__compat")) {
                if (CssCompatDataSchemaGeneratorKt.getExcludeProperties().contains(languageEntityName)) continue;
                this.generateXmlDefinitionsFrom(languageEntityName, languageEntityObject, languageEntityKind);
                continue;
            }
            Intrinsics.checkNotNull((Object)dataObjectName);
            Intrinsics.checkNotNull((Object)dataObject);
            CssCompatDataSchemaGenerator.handleDataEntity$default(this, dataObjectName, dataObject, null, 4, null);
        }
    }

    public static /* synthetic */ void handleDataEntity$default(CssCompatDataSchemaGenerator cssCompatDataSchemaGenerator, String string, JsonElement jsonElement, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        cssCompatDataSchemaGenerator.handleDataEntity(string, jsonElement, string2);
    }

    private final void generateXmlDefinitionsFrom(String name, JsonElement cssEntityObject, String defaultCssEntityKind) {
        String cssEntityKind;
        boolean isSelector;
        Object v1;
        HashSet alternativeNames;
        HashSet uniquePrefixes;
        block12: {
            JsonObject jsonObject = this.getBrowsersSupportObject(cssEntityObject);
            if (jsonObject == null) {
                return;
            }
            JsonObject browsersSupportObject = jsonObject;
            Pair<HashSet<String>, HashSet<String>> pair = this.getPrefixesAndAlternativeNamesSets(browsersSupportObject);
            uniquePrefixes = (HashSet)pair.component1();
            alternativeNames = (HashSet)pair.component2();
            Iterable iterable = this.browserPrefixes;
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                v1 = t;
                break block12;
            }
            v1 = null;
        }
        String prefixInName = v1;
        if (uniquePrefixes.isEmpty() && alternativeNames.isEmpty() && prefixInName == null) {
            return;
        }
        String description = this.getDescription(cssEntityObject);
        String string = defaultCssEntityKind;
        if (string == null) {
            string = CssWebrefSchemaGenerator.Companion.getCssEntityType(description);
        }
        boolean bl = isSelector = Intrinsics.areEqual((Object)(cssEntityKind = string), (Object)"pseudo-class") || Intrinsics.areEqual((Object)cssEntityKind, (Object)"pseudo-element");
        if (prefixInName != null && isSelector) {
            this.generateXmlDefinition(cssEntityKind, name, null);
        }
        if (cssEntityKind == null) {
            System.out.println((Object)name);
            System.out.println((Object)description);
            return;
        }
        if (Intrinsics.areEqual((Object)cssEntityKind, (Object)"named-value") || Intrinsics.areEqual((Object)cssEntityKind, (Object)"feature name")) {
            return;
        }
        if (prefixInName != null && Intrinsics.areEqual((Object)cssEntityKind, (Object)"property")) {
            this.generateXmlDefinition(cssEntityKind, StringsKt.removePrefix((String)name, (CharSequence)prefixInName), prefixInName);
            return;
        }
        Iterable $this$forEach$iv = uniquePrefixes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String prefix = (String)element$iv;
            boolean bl2 = false;
            if (isSelector) {
                this.generateXmlDefinition(cssEntityKind, prefix + name, null);
                continue;
            }
            if (Intrinsics.areEqual((Object)cssEntityKind, (Object)"function")) {
                this.xmlBuilder.addTag("prefixed-function", (Function1<? super Element, Unit>)((Function1)arg_0 -> CssCompatDataSchemaGenerator.generateXmlDefinitionsFrom$lambda$1$0(name, prefix, arg_0)));
                continue;
            }
            this.generateXmlDefinition(cssEntityKind, name, prefix);
        }
        $this$forEach$iv = alternativeNames;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String alternativeName = (String)element$iv;
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)cssEntityKind, (Object)"property")) continue;
            this.xmlBuilder.addTag("property", (Function1<? super Element, Unit>)((Function1)arg_0 -> CssCompatDataSchemaGenerator.generateXmlDefinitionsFrom$lambda$2$0(alternativeName, this, name, arg_0)));
        }
    }

    static /* synthetic */ void generateXmlDefinitionsFrom$default(CssCompatDataSchemaGenerator cssCompatDataSchemaGenerator, String string, JsonElement jsonElement, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        cssCompatDataSchemaGenerator.generateXmlDefinitionsFrom(string, jsonElement, string2);
    }

    private final Pair<HashSet<String>, HashSet<String>> getPrefixesAndAlternativeNamesSets(JsonObject browsersSupportObject) {
        HashSet<String> uniquePrefixes = new HashSet<String>();
        HashSet<String> alternativeNamesSet = new HashSet<String>();
        for (Map.Entry entry : browsersSupportObject.entrySet()) {
            Iterator iterator;
            Intrinsics.checkNotNull((Object)entry);
            String browserId = (String)entry.getKey();
            JsonElement browserSupportObject = (JsonElement)entry.getValue();
            if (Intrinsics.areEqual((Object)browserId, (Object)"ie")) continue;
            if (browserSupportObject.isJsonObject()) {
                JsonPrimitive prefix;
                JsonPrimitive alternativeName = browserSupportObject.getAsJsonObject().getAsJsonPrimitive("alternative_name");
                if (alternativeName != null) {
                    Intrinsics.checkNotNull((Object)browserSupportObject);
                    if (this.isImplementedInBrowser(browserSupportObject)) {
                        alternativeNamesSet.add(alternativeName.getAsString());
                    }
                }
                if ((prefix = browserSupportObject.getAsJsonObject().getAsJsonPrimitive("prefix")) == null) continue;
                Intrinsics.checkNotNull((Object)browserSupportObject);
                if (!this.isImplementedInBrowser(browserSupportObject)) continue;
                uniquePrefixes.add(prefix.getAsString());
                continue;
            }
            if (!browserSupportObject.isJsonArray()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)browserSupportObject.getAsJsonArray().iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                JsonPrimitive prefix;
                JsonElement browserSupportObject2 = (JsonElement)iterator.next();
                JsonPrimitive alternativeName = browserSupportObject2.getAsJsonObject().getAsJsonPrimitive("alternative_name");
                if (alternativeName != null) {
                    Intrinsics.checkNotNull((Object)browserSupportObject2);
                    if (this.isImplementedInBrowser(browserSupportObject2)) {
                        alternativeNamesSet.add(alternativeName.getAsString());
                    }
                }
                if ((prefix = browserSupportObject2.getAsJsonObject().getAsJsonPrimitive("prefix")) == null) continue;
                Intrinsics.checkNotNull((Object)browserSupportObject2);
                if (!this.isImplementedInBrowser(browserSupportObject2)) continue;
                uniquePrefixes.add(prefix.getAsString());
            }
        }
        return new Pair(uniquePrefixes, alternativeNamesSet);
    }

    private final void generateXmlDefinition(String xmlEntityKind, String name, String prefix) {
        Object tagName = prefix == null ? xmlEntityKind : "prefixed-" + xmlEntityKind;
        this.xmlBuilder.addTag((String)tagName, (Function1<? super Element, Unit>)((Function1)arg_0 -> CssCompatDataSchemaGenerator.generateXmlDefinition$lambda$0(name, prefix, arg_0)));
    }

    private final JsonObject getBrowsersSupportObject(JsonElement cssEntityObject) {
        JsonObject jsonObject = cssEntityObject.getAsJsonObject();
        return jsonObject != null && (jsonObject = jsonObject.getAsJsonObject("__compat")) != null ? jsonObject.getAsJsonObject("support") : null;
    }

    private final String getDescription(JsonElement cssEntityObject) {
        String string;
        String string2;
        String string3;
        JsonPrimitive jsonPrimitive;
        JsonObject jsonObject;
        JsonObject jsonObject2 = cssEntityObject.getAsJsonObject();
        return jsonObject2 != null && (jsonObject = jsonObject2.getAsJsonObject("__compat")) != null && (jsonPrimitive = jsonObject.getAsJsonPrimitive("description")) != null && (string3 = jsonPrimitive.getAsString()) != null && (string2 = StringsKt.removePrefix((String)string3, (CharSequence)"`")) != null && (string = StringsKt.removeSuffix((String)string2, (CharSequence)"`")) != null ? string : "";
    }

    public final void generateListOfExclusion(@NotNull File[] listFiles, @NotNull String languageEntityName) {
        Intrinsics.checkNotNullParameter((Object)listFiles, (String)"listFiles");
        Intrinsics.checkNotNullParameter((Object)languageEntityName, (String)"languageEntityName");
        for (File file : listFiles) {
            FileReader reader = new FileReader(file);
            JsonObject rootElementObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (rootElementObject == null) continue;
            JsonObject cssElementObject = rootElementObject.getAsJsonObject("css");
            JsonObject languageEntities = cssElementObject.getAsJsonObject(languageEntityName);
            for (Map.Entry entry : languageEntities.entrySet()) {
                String string;
                Object v1;
                Object object;
                String cssEntityName;
                block5: {
                    Intrinsics.checkNotNull((Object)entry);
                    cssEntityName = (String)entry.getKey();
                    JsonElement cssEntityObject = (JsonElement)entry.getValue();
                    Intrinsics.checkNotNull((Object)cssEntityObject);
                    if (!this.hasAnyBrowserSupport(cssEntityObject)) {
                        List<String> list = CssCompatDataSchemaGeneratorKt.getExcludeProperties();
                        Intrinsics.checkNotNull((Object)cssEntityName);
                        list.add(cssEntityName);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)languageEntityName, (Object)"selectors")) continue;
                    object = this.browserPrefixes;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        String it = (String)t;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)cssEntityName);
                        if (!StringsKt.startsWith$default((String)cssEntityName, (String)it, (boolean)false, (int)2, null)) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                if ((string = (String)v1) == null) {
                    string = "";
                }
                String prefixInName = string;
                Intrinsics.checkNotNull((Object)cssEntityName);
                String unprefixedPropertyName = StringsKt.removePrefix((String)cssEntityName, (CharSequence)prefixInName);
                object = languageEntityName;
                Collection unprefixedDefinition = Intrinsics.areEqual((Object)object, (Object)"properties") ? this.cssDescriptorsFactory.findProperty(unprefixedPropertyName) : (Intrinsics.areEqual((Object)object, (Object)"types") ? this.cssDescriptorsFactory.findFunction(unprefixedPropertyName) : null);
                if (!((object = unprefixedDefinition) == null || object.isEmpty())) continue;
                CssCompatDataSchemaGeneratorKt.getExcludeProperties().add(cssEntityName);
            }
        }
    }

    private final boolean isImplementedInBrowser(JsonElement browserSupportObject) {
        JsonPrimitive added = browserSupportObject.getAsJsonObject().getAsJsonPrimitive("version_added");
        JsonPrimitive removed = browserSupportObject.getAsJsonObject().getAsJsonPrimitive("version_removed");
        return !Intrinsics.areEqual((Object)added.getAsString(), (Object)"false") && removed == null;
    }

    private final boolean hasAnyBrowserSupport(JsonElement propertyObject) {
        JsonObject browsersSupportObject = this.getBrowsersSupportObject(propertyObject);
        if (browsersSupportObject == null) {
            return false;
        }
        for (Map.Entry entry : browsersSupportObject.entrySet()) {
            Iterator iterator;
            Intrinsics.checkNotNull((Object)entry);
            String browserName = (String)entry.getKey();
            JsonElement browserSupportObject = (JsonElement)entry.getValue();
            if (Intrinsics.areEqual((Object)browserName, (Object)"mirror")) continue;
            if (browserSupportObject.isJsonObject()) {
                Intrinsics.checkNotNull((Object)browserSupportObject);
                if (this.isImplementedInBrowser(browserSupportObject)) {
                    return true;
                }
            }
            if (!browserSupportObject.isJsonArray()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)browserSupportObject.getAsJsonArray().iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                JsonElement supportObject = (JsonElement)iterator.next();
                Intrinsics.checkNotNull((Object)supportObject);
                if (!this.isImplementedInBrowser(supportObject)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BrowserSpecificData getMapOfCompatValues() {
        BrowserSpecificData browserSpecificData = new BrowserSpecificData();
        String path = "plugins/css/xmlSchemeGenerator/resources/sources/browserCompatDataJsons/properties";
        File directory = new File(path);
        if (!directory.exists() || !directory.isDirectory()) {
            return browserSpecificData;
        }
        File[] listFiles = directory.listFiles();
        Intrinsics.checkNotNull((Object)listFiles);
        for (File file : listFiles) {
            FileReader reader = new FileReader(file);
            JsonObject rootElementObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (rootElementObject == null) continue;
            JsonObject cssElementObject = rootElementObject.getAsJsonObject("css");
            JsonObject properties = cssElementObject.getAsJsonObject("properties");
            for (Map.Entry entry : properties.entrySet()) {
                Object v0;
                String propertyNameKey;
                JsonElement propertyObject;
                String propertyName;
                block7: {
                    Intrinsics.checkNotNull((Object)entry);
                    propertyName = (String)entry.getKey();
                    propertyObject = (JsonElement)entry.getValue();
                    if (CssCompatDataSchemaGeneratorKt.getExcludeProperties().contains(propertyName)) continue;
                    propertyNameKey = propertyName;
                    Object object = this.browserPrefixes;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        String it = (String)t;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)propertyName);
                        if (!StringsKt.startsWith$default((String)propertyName, (String)it, (boolean)false, (int)2, null)) continue;
                        v0 = t;
                        break block7;
                    }
                    v0 = null;
                }
                String prefixInName = v0;
                if (prefixInName != null) {
                    Intrinsics.checkNotNull((Object)propertyName);
                    propertyNameKey = StringsKt.removePrefix((String)propertyName, (CharSequence)prefixInName);
                }
                for (Object object : propertyObject.getAsJsonObject().entrySet()) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    JsonObject browsersSupportObject;
                    Intrinsics.checkNotNull((Object)object);
                    String valueName = (String)object.getKey();
                    JsonElement valueObject = (JsonElement)object.getValue();
                    if (Intrinsics.areEqual((Object)valueName, (Object)"__compat")) continue;
                    Intrinsics.checkNotNull((Object)valueObject);
                    if (this.getBrowsersSupportObject(valueObject) == null) continue;
                    Pair<HashSet<String>, HashSet<String>> pair = this.getPrefixesAndAlternativeNamesSets(browsersSupportObject);
                    HashSet uniquePrefixes = (HashSet)pair.component1();
                    HashSet alternativeNames = (HashSet)pair.component2();
                    String description = this.getDescription(valueObject);
                    String type = CssWebrefSchemaGenerator.Companion.getCssEntityType(description);
                    if (uniquePrefixes.isEmpty() && alternativeNames.isEmpty() || Intrinsics.areEqual((Object)type, (Object)"function")) continue;
                    Set browserSpecificNames = new LinkedHashSet();
                    Object object2 = uniquePrefixes;
                    Set set = browserSpecificNames;
                    boolean $i$f$map = false;
                    void var32_33 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add((String)it + valueName);
                    }
                    set.addAll((List)destination$iv$iv);
                    browserSpecificNames.addAll(alternativeNames);
                    object2 = propertyNameKey;
                    Intrinsics.checkNotNull((Object)object2);
                    Intrinsics.checkNotNull((Object)valueName);
                    browserSpecificData.addValue((String)object2, valueName, browserSpecificNames);
                }
            }
        }
        return browserSpecificData;
    }

    private static final Unit generateXmlDefinitionsFromFiles$lambda$0(File[] $listFiles, CssCompatDataSchemaGenerator this$0, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("xmlns", "urn:schemas-jetbrains-com:css-xml");
        for (File file : $listFiles) {
            this$0.generateXmlDefinitionsFromFile(file);
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateXmlDefinitionsFrom$lambda$1$0(String $name, String $prefix, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("id", $name);
        element.setAttribute("prefix", StringsKt.removeSuffix((String)StringsKt.removePrefix((String)$prefix, (CharSequence)"-"), (CharSequence)"-"));
        return Unit.INSTANCE;
    }

    private static final Unit generateXmlDefinitionsFrom$lambda$2$0$0(String $name, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("id", $name);
        return Unit.INSTANCE;
    }

    private static final Unit generateXmlDefinitionsFrom$lambda$2$0(String $alternativeName, CssCompatDataSchemaGenerator this$0, String $name, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("id", $alternativeName);
        element.setAttribute("declared-in", "0");
        this$0.xmlBuilder.addTag("property", (Function1<? super Element, Unit>)((Function1)arg_0 -> CssCompatDataSchemaGenerator.generateXmlDefinitionsFrom$lambda$2$0$0($name, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit generateXmlDefinition$lambda$0(String $name, String $prefix, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("id", $name);
        if ($prefix != null) {
            element.setAttribute("prefix", StringsKt.removeSuffix((String)StringsKt.removePrefix((String)$prefix, (CharSequence)"-"), (CharSequence)"-"));
        } else {
            element.setAttribute("declared-in", "0");
        }
        return Unit.INSTANCE;
    }
}

