/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.editor.lists.ListRenumberUtils;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListItemCreatingTypedHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "<init>", "()V", "charTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownListItemCreatingTypedHandlerDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownListItemCreatingTypedHandlerDelegate.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListItemCreatingTypedHandlerDelegate\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,58:1\n66#2,2:59\n*S KotlinDebug\n*F\n+ 1 MarkdownListItemCreatingTypedHandlerDelegate.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListItemCreatingTypedHandlerDelegate\n*L\n52#1:59,2\n*E\n"})
public final class MarkdownListItemCreatingTypedHandlerDelegate
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof MarkdownFile) || c != ' ') {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!((MarkdownCodeInsightSettings.State)MarkdownCodeInsightSettings.Companion.getInstance().getState()).getRenumberListsOnType()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        Caret caret = editor2.getCaretModel().getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCurrentCaret(...)");
        Caret caret2 = caret;
        PsiElement element2 = ((MarkdownFile)file).findElementAt(caret2.getOffset() - 1);
        if (element2 == null || !MarkdownTokenTypeSets.LIST_MARKERS.contains(PsiTreeUtilKt.getElementType((PsiElement)element2))) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (caret2.getOffset() <= ListUtils.INSTANCE.getLineIndentRange(document2, caret2.getLogicalPosition().line).getEndOffset()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        int markerEnd = PsiTreeUtilKt.getEndOffset((PsiElement)element2) - 1;
        if (CharArrayUtil.shiftBackward((CharSequence)document2.getCharsSequence(), (int)markerEnd, (String)" ") < markerEnd - 1) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        PsiElement $this$parentOfType_u24default$iv = element2;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, MarkdownList.class, (boolean)true);
        Intrinsics.checkNotNull((Object)psiElement);
        ListRenumberUtils.renumberInBulk$default(ListRenumberUtils.INSTANCE, (MarkdownList)psiElement, document2, false, false, false, false, 24, null);
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        PsiElement psiElement2 = ((MarkdownFile)file).findElementAt(caret2.getOffset() - 1);
        caret2.moveToOffset(psiElement2 != null ? PsiTreeUtilKt.getEndOffset((PsiElement)psiElement2) : caret2.getOffset());
        return TypedHandlerDelegate.Result.STOP;
    }
}

