/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.editor.lists.ListItemIndentInfo;
import org.intellij.plugins.markdown.editor.lists.ListItemIndentUnindentHandlerBase;
import org.intellij.plugins.markdown.editor.lists.ListItemInfo;
import org.intellij.plugins.markdown.editor.lists.ListRenumberUtils;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.Replacement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListItemUnindentHandler;", "Lorg/intellij/plugins/markdown/editor/lists/ListItemIndentUnindentHandlerBase;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "doIndentUnindent", "", "item", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "document", "Lcom/intellij/openapi/editor/Document;", "removeLeadingSpaces", "decreaseNestingLevel", "", "outerItem", "updateNumbering", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownListItemUnindentHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownListItemUnindentHandler.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListItemUnindentHandler\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,63:1\n66#2,2:64\n*S KotlinDebug\n*F\n+ 1 MarkdownListItemUnindentHandler.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListItemUnindentHandler\n*L\n23#1:64,2\n*E\n"})
public final class MarkdownListItemUnindentHandler
extends ListItemIndentUnindentHandlerBase {
    public MarkdownListItemUnindentHandler(@Nullable EditorActionHandler baseHandler) {
        super(baseHandler);
    }

    @Override
    protected boolean doIndentUnindent(@NotNull MarkdownListItem item, @NotNull MarkdownFile file, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)item;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        MarkdownListItem outerItem = (MarkdownListItem)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, MarkdownListItem.class, (boolean)true);
        if (outerItem == null) {
            return this.removeLeadingSpaces(item, document);
        }
        this.decreaseNestingLevel(item, outerItem, file, document);
        return true;
    }

    private final boolean removeLeadingSpaces(MarkdownListItem item, Document document) {
        ListItemInfo itemInfo = new ListItemInfo(item, document);
        TextRange indentRange = ListUtils.INSTANCE.getLineIndentRange(document, itemInfo.getLines().getFirst());
        if (!indentRange.isEmpty()) {
            Replacement.Companion.replaceSafelyIn$intellij_markdown(itemInfo.changeIndent(0), document);
        }
        return !indentRange.isEmpty();
    }

    private final void decreaseNestingLevel(MarkdownListItem item, MarkdownListItem outerItem, MarkdownFile file, Document document) {
        ListItemInfo itemInfo = new ListItemInfo(item, document);
        ListItemInfo outerInfo = new ListItemInfo(outerItem, document);
        int newSiblingsIndent = ListItemIndentInfo.with$default(itemInfo.getIndentInfo(), outerInfo.getIndentInfo().getIndent(), 0, 2, null).subItemIndent();
        int siblingLine = outerInfo.getLines().getLast();
        int n = itemInfo.getLines().getLast() + 1;
        if (n <= siblingLine) {
            while (true) {
                Replacement replacement = itemInfo.getIndentInfo().changeLineIndent(siblingLine, newSiblingsIndent, document, (PsiFile)file);
                if (replacement != null) {
                    replacement.apply(document);
                }
                if (siblingLine == n) break;
                --siblingLine;
            }
        }
        Replacement.Companion.replaceSafelyIn$intellij_markdown(itemInfo.changeIndent(outerInfo.getIndentInfo().getIndent()), document);
    }

    @Override
    protected void updateNumbering(@NotNull MarkdownListItem item, @NotNull MarkdownFile file, @NotNull Document document) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            ListRenumberUtils.renumberInBulk$default(ListRenumberUtils.INSTANCE, ListUtils.INSTANCE.getList(item), document, false, false, false, false, 24, null);
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            MarkdownList markdownList = (MarkdownList)CollectionsKt.firstOrNull(ListUtils.INSTANCE.getSublists(item));
            if (markdownList == null) break block0;
            ListRenumberUtils.renumberInBulk$default(ListRenumberUtils.INSTANCE, markdownList, document, false, true, false, false, 24, null);
        }
    }
}

