/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.lists.ListRenumberUtils;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.MarkdownListMarkerBackspaceHandlerDelegate$charDeleted$;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListMarkerBackspaceHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandlerDelegate;", "<init>", "()V", "item", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "codeInsightSettings", "Lorg/intellij/plugins/markdown/settings/MarkdownCodeInsightSettings$State;", "getCodeInsightSettings", "()Lorg/intellij/plugins/markdown/settings/MarkdownCodeInsightSettings$State;", "beforeCharDeleted", "", "c", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "charDeleted", "", "listWillBeSplitToTwoLists", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownListMarkerBackspaceHandlerDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownListMarkerBackspaceHandlerDelegate.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListMarkerBackspaceHandlerDelegate\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n66#2,2:113\n223#2,2:115\n80#2:119\n479#3:117\n1#4:118\n*S KotlinDebug\n*F\n+ 1 MarkdownListMarkerBackspaceHandlerDelegate.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListMarkerBackspaceHandlerDelegate\n*L\n53#1:113,2\n64#1:115,2\n108#1:119\n64#1:117\n*E\n"})
public final class MarkdownListMarkerBackspaceHandlerDelegate
extends BackspaceHandlerDelegate {
    @Nullable
    private MarkdownListItem item;

    private final MarkdownCodeInsightSettings.State getCodeInsightSettings() {
        return (MarkdownCodeInsightSettings.State)MarkdownCodeInsightSettings.Companion.getInstance().getState();
    }

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        int nonWsStartOffset;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.item = null;
        if (!this.getCodeInsightSettings().getSmartEnterAndBackspace()) {
            return;
        }
        int deletedOffset = editor2.getCaretModel().getOffset() - 1;
        if (!(file instanceof MarkdownFile) || deletedOffset < 0) {
            return;
        }
        PsiDocumentManager.getInstance((Project)((MarkdownFile)file).getProject()).commitDocument(editor2.getDocument());
        PsiElement psiElement = ((MarkdownFile)file).findElementAt(deletedOffset);
        if (psiElement == null) {
            return;
        }
        PsiElement marker = psiElement;
        if (MarkdownTokenTypeSets.LIST_MARKERS.contains(PsiTreeUtilKt.getElementType((PsiElement)marker)) && (nonWsStartOffset = CharArrayUtil.shiftForward((CharSequence)editor2.getDocument().getCharsSequence(), (int)PsiTreeUtilKt.getStartOffset((PsiElement)marker), (String)" \t")) <= deletedOffset) {
            PsiElement $this$parentOfType_u24default$iv = marker;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            this.item = (MarkdownListItem)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, MarkdownListItem.class, (boolean)true);
        }
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        block4: {
            Integer n;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            MarkdownListItem markdownListItem = this.item;
            if (markdownListItem == null) {
                return false;
            }
            MarkdownListItem item = markdownListItem;
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            boolean createsNewList = this.listWillBeSplitToTwoLists(item, document2);
            PsiElement $this$descendantsOfType_u24default$iv = (PsiElement)ListUtils.INSTANCE.getList(item);
            boolean childrenFirst$iv = false;
            boolean $i$f$descendantsOfType = false;
            Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.descendants$default((PsiElement)$this$descendantsOfType_u24default$iv, (boolean)childrenFirst$iv, null, (int)2, null);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)charDeleted$$inlined$descendantsOfType$default$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            MarkdownListItem markdownListItem2 = (MarkdownListItem)SequencesKt.firstOrNull((Sequence)SequencesKt.drop((Sequence)SequencesKt.dropWhile((Sequence)sequence, arg_0 -> MarkdownListMarkerBackspaceHandlerDelegate.charDeleted$lambda$0(item, arg_0)), (int)1));
            if (markdownListItem2 != null) {
                MarkdownListItem it = markdownListItem2;
                boolean bl = false;
                n = document2.getLineNumber(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)it)));
            } else {
                n = null;
            }
            Integer nextItemFirstLine = n;
            PsiElement psiElement = item.getMarkerElement();
            Intrinsics.checkNotNull((Object)psiElement);
            TextRange range = psiElement.getTextRange();
            ActionsKt.runWriteAction(() -> MarkdownListMarkerBackspaceHandlerDelegate.charDeleted$lambda$2(document2, range));
            if (nextItemFirstLine == null || createsNewList || !this.getCodeInsightSettings().getRenumberListsOnType()) break block4;
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document2);
            MarkdownListItem updatedItem = ListUtils.INSTANCE.getListItemAtLine((PsiFile)((MarkdownFile)file), nextItemFirstLine, document2);
            MarkdownCompositePsiElementBase markdownCompositePsiElementBase = updatedItem;
            if (markdownCompositePsiElementBase != null && (markdownCompositePsiElementBase = ListUtils.INSTANCE.getList((MarkdownListItem)markdownCompositePsiElementBase)) != null) {
                ListRenumberUtils.renumberInBulk$default(ListRenumberUtils.INSTANCE, (MarkdownList)markdownCompositePsiElementBase, document2, false, false, false, false, 24, null);
            }
        }
        return true;
    }

    private final boolean listWillBeSplitToTwoLists(MarkdownListItem item, Document document) {
        int itemFirstLine = document.getLineNumber(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)item)));
        int itemLastLine = document.getLineNumber(Math.min(PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)item)) - 1, document.getTextLength()));
        boolean emptyLineBefore = itemFirstLine > 0 && DocumentUtil.isLineEmpty((Document)document, (int)(itemFirstLine - 1));
        boolean emptyLineAfter = itemLastLine + 1 < document.getLineCount() && DocumentUtil.isLineEmpty((Document)document, (int)(itemFirstLine + 1));
        boolean nearEmptyLine = emptyLineBefore || emptyLineAfter;
        CharSequence charSequence = document.getText();
        PsiElement psiElement = item.getMarkerElement();
        Intrinsics.checkNotNull((Object)psiElement);
        boolean onlyMarkerLine = CharArrayUtil.shiftForward((CharSequence)charSequence, (int)(PsiTreeUtilKt.getEndOffset((PsiElement)psiElement) - 1), (String)" \t") == document.getLineEndOffset(itemFirstLine);
        PsiElement $this$parentsOfType_u24default$iv = (PsiElement)item;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        boolean hasPreviousItem = !Intrinsics.areEqual((Object)CollectionsKt.first(ListUtils.INSTANCE.getItems((MarkdownList)SequencesKt.last((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, MarkdownList.class, (boolean)withSelf$iv)))), (Object)item);
        return hasPreviousItem && nearEmptyLine && onlyMarkerLine;
    }

    private static final boolean charDeleted$lambda$0(MarkdownListItem $item, MarkdownListItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)$item);
    }

    private static final Unit charDeleted$lambda$2(Document $document, TextRange $range) {
        $document.deleteString($range.getStartOffset(), $range.getEndOffset() - 1);
        return Unit.INSTANCE;
    }
}

