/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.export;

import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowsRange;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.MarkdownFileActionsBaseDialog;
import org.intellij.plugins.markdown.fileActions.export.MarkdownExportProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001 B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0014J\f\u0010\u0018\u001a\u00020\u0013*\u00020\u0019H\u0014J\f\u0010\u001a\u001a\u00020\u0013*\u00020\u0019H\u0014J\n\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0002J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportDialog;", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionsBaseDialog;", "targetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "suggestedFilePath", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "fileTypeSelector", "Lcom/intellij/openapi/ui/ComboBox;", "Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportProvider;", "selectedFileType", "supportedExportProviders", "", "getSupportedExportProviders", "()Ljava/util/List;", "doAction", "", "selectedFileUrl", "getFileNameIfExist", "dir", "fileNameWithoutExtension", "createFileTypeField", "Lcom/intellij/ui/dsl/builder/Panel;", "createSettingsComponents", "findFirstValidProvider", "validateFileType", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "combobox", "FileTypeRenderer", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownExportDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownExportDialog.kt\norg/intellij/plugins/markdown/fileActions/export/MarkdownExportDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1#2:113\n1#2:125\n1642#3,10:114\n1915#3:124\n1916#3:126\n1652#3:127\n*S KotlinDebug\n*F\n+ 1 MarkdownExportDialog.kt\norg/intellij/plugins/markdown/fileActions/export/MarkdownExportDialog\n*L\n70#1:125\n70#1:114,10\n70#1:124\n70#1:126\n70#1:127\n*E\n"})
public final class MarkdownExportDialog
extends MarkdownFileActionsBaseDialog {
    private ComboBox<MarkdownExportProvider> fileTypeSelector;
    private MarkdownExportProvider selectedFileType;

    public MarkdownExportDialog(@NotNull VirtualFile targetFile, @NotNull String suggestedFilePath, @NotNull Project project) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)suggestedFilePath, (String)"suggestedFilePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, suggestedFilePath, targetFile);
        this.setTitle(MarkdownBundle.message("markdown.export.from.docx.dialog.title", new Object[0]));
        this.setOKButtonText(MarkdownBundle.message("markdown.export.dialog.ok.button", new Object[0]));
        Action action = this.getOKAction();
        MarkdownExportProvider markdownExportProvider = this.selectedFileType;
        if (markdownExportProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedFileType");
            markdownExportProvider = null;
        }
        action.setEnabled((charSequence = (CharSequence)markdownExportProvider.validate(project, targetFile)) == null || charSequence.length() == 0);
    }

    private final List<MarkdownExportProvider> getSupportedExportProviders() {
        return MarkdownExportProvider.Companion.getAllProviders();
    }

    @Override
    protected void doAction(@NotNull String selectedFileUrl) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)selectedFileUrl, (String)"selectedFileUrl");
            Iterable iterable = this.getSupportedExportProviders();
            for (Object t : iterable) {
                MarkdownExportProvider it = (MarkdownExportProvider)t;
                boolean bl = false;
                MarkdownExportProvider markdownExportProvider = this.selectedFileType;
                if (markdownExportProvider == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"selectedFileType");
                    markdownExportProvider = null;
                }
                if (!Intrinsics.areEqual((Object)it, (Object)markdownExportProvider)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        MarkdownExportProvider markdownExportProvider = v1;
        if (markdownExportProvider == null) {
            return;
        }
        MarkdownExportProvider provider = markdownExportProvider;
        String outputFile = selectedFileUrl + "." + provider.getFormatDescription().getExtension();
        provider.exportFile(this.getProject(), this.getFile(), outputFile);
    }

    @Override
    @Nullable
    protected String getFileNameIfExist(@NotNull String dir, @NotNull String fileNameWithoutExtension) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
        ComboBox<MarkdownExportProvider> comboBox = this.fileTypeSelector;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileTypeSelector");
            comboBox = null;
        }
        String fullName = fileNameWithoutExtension + "." + ((MarkdownExportProvider)comboBox.getItem()).getFormatDescription().getExtension();
        String[] stringArray = new String[]{dir, fullName};
        return FileUtil.exists((String)FileUtil.join((String[])stringArray)) ? fullName : null;
    }

    @Override
    protected void createFileTypeField(@NotNull Panel $this$createFileTypeField) {
        Intrinsics.checkNotNullParameter((Object)$this$createFileTypeField, (String)"<this>");
        Panel.row$default((Panel)$this$createFileTypeField, null, arg_0 -> MarkdownExportDialog.createFileTypeField$lambda$0(this, arg_0), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void createSettingsComponents(@NotNull Panel $this$createSettingsComponents) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$createSettingsComponents, (String)"<this>");
        Iterable $this$mapNotNull$iv = this.getSupportedExportProviders();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MarkdownExportProvider it = (MarkdownExportProvider)element$iv$iv;
            boolean bl2 = false;
            MarkdownExportProvider $this$createSettingsComponents_u24lambda_u240_u240 = it;
            boolean bl3 = false;
            VirtualFile file = VfsUtil.findFileByIoFile((File)new File(this.getSuggestedFilePath()), (boolean)true);
            if (file != null) {
                RowsRange rowsRange = $this$createSettingsComponents_u24lambda_u240_u240.createSettingsComponent($this$createSettingsComponents, this.getProject(), file);
                if (rowsRange != null) {
                    ComboBox<MarkdownExportProvider> comboBox = this.fileTypeSelector;
                    if (comboBox == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"fileTypeSelector");
                        comboBox = null;
                    }
                    rowsRange.visibleIf(ComponentPredicateKt.selectedValueIs((JComboBox)((JComboBox)comboBox), (Object)it));
                }
            }
            Unit it$iv$iv = Unit.INSTANCE;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final MarkdownExportProvider findFirstValidProvider() {
        Object v0;
        block1: {
            Iterable iterable = this.getSupportedExportProviders();
            for (Object t : iterable) {
                MarkdownExportProvider it = (MarkdownExportProvider)t;
                boolean bl = false;
                if (!(it.validate(this.getProject(), this.getFile()) == null)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final ValidationInfo validateFileType(ValidationInfoBuilder $this$validateFileType, ComboBox<MarkdownExportProvider> combobox) {
        ValidationInfo validationInfo;
        String errorMessage;
        MarkdownExportProvider provider = (MarkdownExportProvider)combobox.getItem();
        String string = errorMessage = provider.validate(this.getProject(), this.getFile());
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            validationInfo = $this$validateFileType.error(p0);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final MarkdownExportProvider createFileTypeField$lambda$0$0(MarkdownExportDialog this$0) {
        MarkdownExportProvider markdownExportProvider = this$0.selectedFileType;
        if (markdownExportProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedFileType");
            markdownExportProvider = null;
        }
        return markdownExportProvider;
    }

    private static final Unit createFileTypeField$lambda$0$1(MarkdownExportDialog this$0, MarkdownExportProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.selectedFileType = it;
        CharSequence charSequence = it.validate(this$0.getProject(), this$0.getFile());
        this$0.getOKAction().setEnabled(charSequence == null || charSequence.length() == 0);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createFileTypeField$lambda$0$2(MarkdownExportDialog this$0, ValidationInfoBuilder $this$validationOnApply, ComboBox it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.validateFileType($this$validationOnApply, (ComboBox<MarkdownExportProvider>)it);
    }

    private static final Unit createFileTypeField$lambda$0(MarkdownExportDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        GraphProperty fileTypeProperty = new PropertyGraph(null, false, 3, null).lazyProperty(() -> MarkdownExportDialog.createFileTypeField$lambda$0$0(this$0));
        fileTypeProperty.afterChange(arg_0 -> MarkdownExportDialog.createFileTypeField$lambda$0$1(this$0, arg_0));
        MarkdownExportProvider markdownExportProvider = this$0.findFirstValidProvider();
        if (markdownExportProvider == null) {
            markdownExportProvider = (MarkdownExportProvider)CollectionsKt.first(this$0.getSupportedExportProviders());
        }
        this$0.selectedFileType = markdownExportProvider;
        String string = MarkdownBundle.message("markdown.export.dialog.filetype.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        this$0.fileTypeSelector = (ComboBox)ComboBoxKt.bindItem((Cell)$this$row.comboBox((Collection)this$0.getSupportedExportProviders(), (ListCellRenderer)((Object)this$0.new FileTypeRenderer())), (ObservableMutableProperty)((ObservableMutableProperty)fileTypeProperty)).validationOnApply((arg_0, arg_1) -> MarkdownExportDialog.createFileTypeField$lambda$0$2(this$0, arg_0, arg_1)).focused().getComponent();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J:\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportDialog$FileTypeRenderer;", "Lcom/intellij/ui/SimpleListCellRenderer;", "Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportProvider;", "<init>", "(Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportDialog;)V", "customize", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.markdown"})
    private final class FileTypeRenderer
    extends SimpleListCellRenderer<MarkdownExportProvider> {
        public void customize(@NotNull JList<? extends MarkdownExportProvider> list2, @Nullable MarkdownExportProvider value, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            if (value == null) {
                return;
            }
            this.setText(value.getFormatDescription().getFormatName());
            String errorMessage = value.validate(MarkdownExportDialog.this.getProject(), MarkdownExportDialog.this.getFile());
            if (errorMessage != null) {
                this.setEnabled(false);
                this.setToolTipText(errorMessage);
            } else {
                this.setEnabled(true);
            }
        }
    }
}

