/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.listeners;

import com.intellij.codeInsight.completion.actions.CodeCompletionAction;
import com.intellij.codeInsight.lookup.impl.actions.ChooseItemAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.BackspaceAction;
import com.intellij.openapi.editor.actions.CopyAction;
import com.intellij.openapi.editor.actions.CutAction;
import com.intellij.openapi.editor.actions.EscapeAction;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.featuresSuggester.SuggestingUtils;
import training.featuresSuggester.actions.BeforeCompletionChooseItemAction;
import training.featuresSuggester.actions.BeforeEditorBackspaceAction;
import training.featuresSuggester.actions.BeforeEditorCodeCompletionAction;
import training.featuresSuggester.actions.BeforeEditorCopyAction;
import training.featuresSuggester.actions.BeforeEditorCutAction;
import training.featuresSuggester.actions.BeforeEditorEscapeAction;
import training.featuresSuggester.actions.BeforeEditorFindAction;
import training.featuresSuggester.actions.BeforeEditorPasteAction;
import training.featuresSuggester.actions.CompletionChooseItemAction;
import training.featuresSuggester.actions.EditorBackspaceAction;
import training.featuresSuggester.actions.EditorCodeCompletionAction;
import training.featuresSuggester.actions.EditorCopyAction;
import training.featuresSuggester.actions.EditorCutAction;
import training.featuresSuggester.actions.EditorEscapeAction;
import training.featuresSuggester.actions.EditorFindAction;
import training.featuresSuggester.actions.EditorPasteAction;
import training.featuresSuggester.settings.FeatureSuggesterSettings;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\r\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0010H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0010H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0007H\u0002\u00a8\u0006\u0018"}, d2={"Ltraining/featuresSuggester/listeners/EditorActionsListener;", "Lcom/intellij/openapi/actionSystem/ex/AnActionListener;", "<init>", "()V", "afterActionPerformed", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "result", "Lcom/intellij/openapi/actionSystem/AnActionResult;", "beforeActionPerformed", "getCachedEventData", "Lkotlin/Triple;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/psi/PsiFile;", "getSelectedText", "", "getCaretOffset", "", "isSupportedAction", "", "intellij.featuresTrainer"})
public final class EditorActionsListener
implements AnActionListener {
    public void afterActionPerformed(@NotNull AnAction action, @NotNull AnActionEvent event, @NotNull AnActionResult result) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        FeatureSuggesterSettings.Companion.instance().updateWorkingDays();
        if (!this.isSupportedAction(action)) {
            return;
        }
        Triple<Project, Editor, PsiFile> triple = this.getCachedEventData(event);
        Project project = (Project)triple.component1();
        Editor editor = (Editor)triple.component2();
        PsiFile psiFile = (PsiFile)triple.component3();
        if (project == null || editor == null) {
            return;
        }
        if (!SuggestingUtils.INSTANCE.isActionsProcessingEnabled(project)) {
            return;
        }
        AnAction anAction = action;
        if (anAction instanceof CopyAction) {
            Object object = CopyPasteManager.getInstance().getContents();
            if (object == null || (object = SuggestingUtils.INSTANCE.asString((Transferable)object)) == null) {
                return;
            }
            Object copiedText = object;
            SuggestingUtils.INSTANCE.handleAction(project, new EditorCopyAction((String)copiedText, editor, psiFile, System.currentTimeMillis()));
        } else if (anAction instanceof CutAction) {
            Object object = CopyPasteManager.getInstance().getContents();
            if (object == null || (object = SuggestingUtils.INSTANCE.asString((Transferable)object)) == null) {
                return;
            }
            Object text = object;
            SuggestingUtils.INSTANCE.handleAction(project, new EditorCutAction((String)text, editor, psiFile, System.currentTimeMillis()));
        } else if (anAction instanceof PasteAction) {
            Object object = CopyPasteManager.getInstance().getContents();
            if (object == null || (object = SuggestingUtils.INSTANCE.asString((Transferable)object)) == null) {
                return;
            }
            Object pastedText = object;
            int caretOffset = this.getCaretOffset(editor);
            SuggestingUtils.INSTANCE.handleAction(project, new EditorPasteAction((String)pastedText, caretOffset, editor, psiFile, System.currentTimeMillis()));
        } else if (anAction instanceof BackspaceAction) {
            SuggestingUtils.INSTANCE.handleAction(project, new EditorBackspaceAction(SuggestingUtils.INSTANCE.getSelection(editor), this.getCaretOffset(editor), editor, psiFile, System.currentTimeMillis()));
        } else if (anAction instanceof IncrementalFindAction) {
            SuggestingUtils.INSTANCE.handleAction(project, new EditorFindAction(editor, psiFile, System.currentTimeMillis()));
        } else if (anAction instanceof CodeCompletionAction) {
            SuggestingUtils.INSTANCE.handleAction(project, new EditorCodeCompletionAction(editor.getCaretModel().getOffset(), editor, psiFile, System.currentTimeMillis()));
        } else if (anAction instanceof ChooseItemAction.FocusedOnly) {
            SuggestingUtils.INSTANCE.handleAction(project, new CompletionChooseItemAction(editor.getCaretModel().getOffset(), editor, psiFile, System.currentTimeMillis()));
        } else if (anAction instanceof EscapeAction) {
            SuggestingUtils.INSTANCE.handleAction(project, new EditorEscapeAction(editor.getCaretModel().getOffset(), editor, psiFile, System.currentTimeMillis()));
        }
    }

    public void beforeActionPerformed(@NotNull AnAction action, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isSupportedAction(action)) {
            return;
        }
        Triple<Project, Editor, PsiFile> triple = this.getCachedEventData(event);
        Project project = (Project)triple.component1();
        Editor editor = (Editor)triple.component2();
        PsiFile psiFile = (PsiFile)triple.component3();
        if (project == null || editor == null) {
            return;
        }
        if (!SuggestingUtils.INSTANCE.isActionsProcessingEnabled(project)) {
            return;
        }
        AnAction anAction = action;
        if (anAction instanceof CopyAction) {
            String string = this.getSelectedText(editor);
            if (string == null) {
                return;
            }
            String selectedText = string;
            SuggestingUtils.INSTANCE.handleAction(project, new BeforeEditorCopyAction(selectedText, editor, psiFile, System.currentTimeMillis()));
        } else if (anAction instanceof CutAction) {
            SuggestingUtils.INSTANCE.handleAction(project, new BeforeEditorCutAction(SuggestingUtils.INSTANCE.getSelection(editor), editor, psiFile, System.currentTimeMillis()));
        } else if (anAction instanceof PasteAction) {
            Object object = CopyPasteManager.getInstance().getContents();
            if (object == null || (object = SuggestingUtils.INSTANCE.asString((Transferable)object)) == null) {
                return;
            }
            Object pastedText = object;
            int caretOffset = this.getCaretOffset(editor);
            SuggestingUtils.INSTANCE.handleAction(project, new BeforeEditorPasteAction((String)pastedText, caretOffset, editor, psiFile, System.currentTimeMillis()));
        } else if (anAction instanceof BackspaceAction) {
            SuggestingUtils.INSTANCE.handleAction(project, new BeforeEditorBackspaceAction(SuggestingUtils.INSTANCE.getSelection(editor), this.getCaretOffset(editor), editor, psiFile, System.currentTimeMillis()));
        } else if (anAction instanceof IncrementalFindAction) {
            SuggestingUtils.INSTANCE.handleAction(project, new BeforeEditorFindAction(editor, psiFile, System.currentTimeMillis()));
        } else if (anAction instanceof CodeCompletionAction) {
            SuggestingUtils.INSTANCE.handleAction(project, new BeforeEditorCodeCompletionAction(editor.getCaretModel().getOffset(), editor, psiFile, System.currentTimeMillis()));
        } else if (anAction instanceof ChooseItemAction.FocusedOnly) {
            SuggestingUtils.INSTANCE.handleAction(project, new BeforeCompletionChooseItemAction(editor.getCaretModel().getOffset(), editor, psiFile, System.currentTimeMillis()));
        } else if (anAction instanceof EscapeAction) {
            SuggestingUtils.INSTANCE.handleAction(project, new BeforeEditorEscapeAction(editor.getCaretModel().getOffset(), editor, psiFile, System.currentTimeMillis()));
        }
    }

    private final Triple<Project, Editor, PsiFile> getCachedEventData(AnActionEvent event) {
        DataContext context;
        DataContext dataContext;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            dataContext = event.getDataContext();
        } else {
            DataContext dataContext2 = event.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            dataContext = Utils.getCachedOnlyDataContext((DataContext)dataContext2);
        }
        DataContext dataContext3 = dataContext;
        Intrinsics.checkNotNull((Object)dataContext3);
        DataContext it = context = dataContext3;
        boolean bl = false;
        return new Triple(CommonDataKeys.PROJECT.getData(it), CommonDataKeys.EDITOR.getData(it), CommonDataKeys.PSI_FILE.getData(it));
    }

    private final String getSelectedText(Editor $this$getSelectedText) {
        return $this$getSelectedText.getSelectionModel().getSelectedText();
    }

    private final int getCaretOffset(Editor $this$getCaretOffset) {
        return $this$getCaretOffset.getCaretModel().getOffset();
    }

    private final boolean isSupportedAction(AnAction $this$isSupportedAction) {
        return $this$isSupportedAction instanceof CopyAction || $this$isSupportedAction instanceof CutAction || $this$isSupportedAction instanceof PasteAction || $this$isSupportedAction instanceof BackspaceAction || $this$isSupportedAction instanceof IncrementalFindAction || $this$isSupportedAction instanceof CodeCompletionAction || $this$isSupportedAction instanceof ChooseItemAction.FocusedOnly || $this$isSupportedAction instanceof EscapeAction;
    }
}

