/*
 * Decompiled with CFR 0.152.
 */
package training.learn.lesson.general;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.dsl.LessonContext;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.dsl.LessonUtil;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.dsl.TaskTestContext;
import training.learn.LessonsBundle;
import training.learn.course.KLesson;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Ltraining/learn/lesson/general/MultipleSelectionHtmlLesson;", "Ltraining/learn/course/KLesson;", "helpUrl", "", "<init>", "(Ljava/lang/String;)V", "languageId", "getLanguageId", "()Ljava/lang/String;", "sampleFilePath", "getSampleFilePath", "sample", "Ltraining/dsl/LessonSample;", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "checkMultiChange", "", "Ltraining/dsl/TaskRuntimeContext;", "helpLinks", "", "getHelpLinks", "()Ljava/util/Map;", "intellij.featuresTrainer"})
public final class MultipleSelectionHtmlLesson
extends KLesson {
    @NotNull
    private final String helpUrl;
    @NotNull
    private final String languageId;
    @NotNull
    private final String sampleFilePath;
    @NotNull
    private final LessonSample sample;

    public MultipleSelectionHtmlLesson(@NotNull String helpUrl) {
        Intrinsics.checkNotNullParameter((Object)helpUrl, (String)"helpUrl");
        super("Multiple selections", LessonsBundle.INSTANCE.message("multiple.selections.lesson.name", new Object[0]));
        this.helpUrl = helpUrl;
        this.languageId = "HTML";
        this.sampleFilePath = "Learning.html";
        this.sample = LessonSampleKt.parseLessonSample("<!doctype html>\n<html lang=\"en\">\n    <head>\n        <meta charset=\"UTF-8\">\n        <title>Multiple selections</title>\n    </head>\n    <body>\n        <table>\n            <tr>\n                <<caret>th>Firstname</th>\n                <th>Lastname</th>\n                <th>Points</th>\n            </tr>\n            <tr>\n                <td>Eve</td>\n                <td>Jackson</td>\n                <td>94</td>\n            </tr>\n        </table>\n    </body>\n</html>");
    }

    public /* synthetic */ MultipleSelectionHtmlLesson(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "multicursor.html";
        }
        this(string);
    }

    @Override
    @NotNull
    public String getLanguageId() {
        return this.languageId;
    }

    @Override
    @NotNull
    public String getSampleFilePath() {
        return this.sampleFilePath;
    }

    @Override
    @NotNull
    protected Function1<LessonContext, Unit> getLessonContent() {
        return arg_0 -> MultipleSelectionHtmlLesson._get_lessonContent_$lambda$0(this, arg_0);
    }

    private final boolean checkMultiChange(TaskRuntimeContext $this$checkMultiChange) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)$this$checkMultiChange.getProject()).getPsiFile($this$checkMultiChange.getEditor().getDocument());
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)psiFile), HtmlTag.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        Collection childrenOfType1 = collection;
        int count = 0;
        for (HtmlTag htmlTag : childrenOfType1) {
            if (Intrinsics.areEqual((Object)htmlTag.getName(), (Object)"th")) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)htmlTag.getName(), (Object)"td")) continue;
            ++count;
        }
        return count == 6;
    }

    @Override
    @NotNull
    public Map<String, String> getHelpLinks() {
        return MapsKt.mapOf((Pair)new Pair((Object)LessonsBundle.INSTANCE.message("multiple.selections.help.multiple.carets", new Object[0]), (Object)LessonUtil.INSTANCE.getHelpLink(this.helpUrl)));
    }

    private static final boolean _get_lessonContent_$lambda$0$1$0(MultipleSelectionHtmlLesson this$0, TaskRuntimeContext $this$restoreState) {
        Intrinsics.checkNotNullParameter((Object)$this$restoreState, (String)"$this$restoreState");
        return !Intrinsics.areEqual((Object)this$0.sample.getText(), (Object)$this$restoreState.getEditor().getDocument().getText()) || !Intrinsics.areEqual((Object)$this$restoreState.getEditor().getSelectionModel().getSelectedText(), (Object)"th");
    }

    private static final boolean _get_lessonContent_$lambda$0$2$0(MultipleSelectionHtmlLesson this$0, TaskRuntimeContext $this$restoreState) {
        Intrinsics.checkNotNullParameter((Object)$this$restoreState, (String)"$this$restoreState");
        return !Intrinsics.areEqual((Object)this$0.sample.getText(), (Object)$this$restoreState.getEditor().getDocument().getText()) || $this$restoreState.getEditor().getCaretModel().getCaretCount() < 2;
    }

    private static final boolean _get_lessonContent_$lambda$0$4$0(TaskRuntimeContext $this$restoreState) {
        Intrinsics.checkNotNullParameter((Object)$this$restoreState, (String)"$this$restoreState");
        return $this$restoreState.getEditor().getCaretModel().getCaretCount() != 6;
    }

    private static final boolean _get_lessonContent_$lambda$0$4$1(MultipleSelectionHtmlLesson this$0, TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return this$0.checkMultiChange($this$stateCheck);
    }

    private static final Unit _get_lessonContent_$lambda$0$4$2(TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        $this$test.type("td");
        return Unit.INSTANCE;
    }

    private static final boolean _get_lessonContent_$lambda$0$5$0(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return $this$stateCheck.getEditor().getCaretModel().getCaretCount() < 2;
    }

    private static final Unit _get_lessonContent_$lambda$0$5$1(String $it, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        String[] stringArray = new String[]{$it};
        $this$test.actions(stringArray);
        return Unit.INSTANCE;
    }

    private static final String _get_lessonContent_$lambda$0$0(TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LessonUtil.restoreIfModifiedOrMoved$default(LessonUtil.INSTANCE, $this$actionTask, null, 1, null);
        Object[] objectArray = new Object[]{$this$actionTask.action(it)};
        return LessonsBundle.INSTANCE.message("multiple.selections.select.symbol", objectArray);
    }

    private static final String _get_lessonContent_$lambda$0$1(MultipleSelectionHtmlLesson this$0, TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TaskContext.restoreState$default($this$actionTask, null, 0, null, arg_0 -> MultipleSelectionHtmlLesson._get_lessonContent_$lambda$0$1$0(this$0, arg_0), 7, null);
        Object[] objectArray = new Object[]{$this$actionTask.action(it)};
        return LessonsBundle.INSTANCE.message("multiple.selections.select.next.symbol", objectArray);
    }

    private static final String _get_lessonContent_$lambda$0$2(MultipleSelectionHtmlLesson this$0, TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TaskContext.restoreState$default($this$actionTask, null, 0, null, arg_0 -> MultipleSelectionHtmlLesson._get_lessonContent_$lambda$0$2$0(this$0, arg_0), 7, null);
        Object[] objectArray = new Object[]{$this$actionTask.action(it)};
        return LessonsBundle.INSTANCE.message("multiple.selections.deselect.symbol", objectArray);
    }

    private static final String _get_lessonContent_$lambda$0$3(TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LessonUtil.restoreIfModifiedOrMoved$default(LessonUtil.INSTANCE, $this$actionTask, null, 1, null);
        Object[] objectArray = new Object[]{$this$actionTask.action(it)};
        return LessonsBundle.INSTANCE.message("multiple.selections.select.all", objectArray);
    }

    private static final Unit _get_lessonContent_$lambda$0$4(MultipleSelectionHtmlLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.code("td"), $this$task.code("th")};
        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("multiple.selections.replace", objectArray), null, 2, null);
        TaskContext.restoreState$default($this$task, null, 0, null, MultipleSelectionHtmlLesson::_get_lessonContent_$lambda$0$4$0, 7, null);
        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)arg_0 -> MultipleSelectionHtmlLesson._get_lessonContent_$lambda$0$4$1(this$0, arg_0)));
        TaskContext.test$default($this$task, false, MultipleSelectionHtmlLesson::_get_lessonContent_$lambda$0$4$2, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit _get_lessonContent_$lambda$0$5(TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)MultipleSelectionHtmlLesson::_get_lessonContent_$lambda$0$5$0));
        Object[] objectArray = new Object[]{$this$task.action(it)};
        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("multiple.selections.escape", objectArray), null, 2, null);
        TaskContext.test$default($this$task, false, arg_0 -> MultipleSelectionHtmlLesson._get_lessonContent_$lambda$0$5$1(it, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit _get_lessonContent_$lambda$0(MultipleSelectionHtmlLesson this$0, LessonContext lessonContext) {
        Intrinsics.checkNotNullParameter((Object)lessonContext, (String)"<this>");
        LessonContext.prepareSample$default(lessonContext, this$0.sample, false, 2, null);
        lessonContext.actionTask("SelectNextOccurrence", (Function2<? super TaskContext, ? super String, String>)((Function2)MultipleSelectionHtmlLesson::_get_lessonContent_$lambda$0$0));
        lessonContext.actionTask("SelectNextOccurrence", (Function2<? super TaskContext, ? super String, String>)((Function2)(arg_0, arg_1) -> MultipleSelectionHtmlLesson._get_lessonContent_$lambda$0$1(this$0, arg_0, arg_1)));
        lessonContext.actionTask("UnselectPreviousOccurrence", (Function2<? super TaskContext, ? super String, String>)((Function2)(arg_0, arg_1) -> MultipleSelectionHtmlLesson._get_lessonContent_$lambda$0$2(this$0, arg_0, arg_1)));
        lessonContext.actionTask("SelectAllOccurrences", (Function2<? super TaskContext, ? super String, String>)((Function2)MultipleSelectionHtmlLesson::_get_lessonContent_$lambda$0$3));
        lessonContext.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> MultipleSelectionHtmlLesson._get_lessonContent_$lambda$0$4(this$0, arg_0)));
        lessonContext.task("EditorEscape", (Function2<? super TaskContext, ? super String, Unit>)((Function2)MultipleSelectionHtmlLesson::_get_lessonContent_$lambda$0$5));
        return Unit.INSTANCE;
    }

    public MultipleSelectionHtmlLesson() {
        this(null, 1, null);
    }
}

