/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner.log;

import com.intellij.diagnostic.CoroutineDumperKt;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.log.QodanaThreadDumpLoggingActivity;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"LOG_INTERVAL", "Ljava/time/Duration;", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "dumpThreads", "", "prefix", "", "fileName", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaThreadDumpLoggingActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaThreadDumpLoggingActivity.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/log/QodanaThreadDumpLoggingActivityKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,44:1\n13#2:45\n*S KotlinDebug\n*F\n+ 1 QodanaThreadDumpLoggingActivity.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/log/QodanaThreadDumpLoggingActivityKt\n*L\n17#1:45\n*E\n"})
public final class QodanaThreadDumpLoggingActivityKt {
    @NotNull
    private static final Duration LOG_INTERVAL;
    @NotNull
    private static final Logger LOGGER;

    private static final void dumpThreads(String prefix, String fileName) {
        String string = ThreadDumper.dumpThreadsToString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dumpThreadsToString(...)");
        String threadDump = string;
        String coroutines = CoroutineDumperKt.dumpCoroutines$default(null, (boolean)false, (boolean)false, (int)7, null);
        try {
            String string2 = PathManager.getLogPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLogPath(...)");
            String string3 = string2;
            String[] stringArray = new String[]{fileName};
            Path path = Paths.get(string3, Arrays.copyOf(stringArray, stringArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path logFile2 = path;
            LOGGER.info("Writing thread dump and coroutines dump to: " + logFile2);
            File file2 = logFile2.toFile().getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            File file3 = logFile2.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
            FilesKt.writeText$default((File)file3, (String)(prefix + "\n\n" + threadDump + "\n\nCoroutines dump: " + coroutines), null, (int)2, null);
        }
        catch (IOException e) {
            LOGGER.warn("Failed writing thread dump file", (Throwable)e);
        }
    }

    public static final /* synthetic */ Duration access$getLOG_INTERVAL$p() {
        return LOG_INTERVAL;
    }

    public static final /* synthetic */ void access$dumpThreads(String prefix, String fileName) {
        QodanaThreadDumpLoggingActivityKt.dumpThreads(prefix, fileName);
    }

    static {
        Duration duration = Duration.ofMinutes(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        LOG_INTERVAL = duration;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(QodanaThreadDumpLoggingActivity.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }
}

