/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.frontend.carets;

import com.intellij.cwm.plugin.common.carets.RemoteCaretHighlighterRenderer;
import com.intellij.cwm.plugin.common.carets.RemoteCaretHighlighterService;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.codeWithMe.model.RemoteCaretHighlighterModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/cwm/frontend/carets/RemoteCaretProtocolModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "initialize", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "compare", "move", "startOffset", "", "endOffset", "intellij.cwm.frontend"})
public final class RemoteCaretProtocolModelHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    private final Project project;

    public RemoteCaretProtocolModelHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public boolean accept(@NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return model instanceof RemoteCaretHighlighterModel;
    }

    public void initialize(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        RemoteCaretHighlighterModel cfr_ignored_0 = (RemoteCaretHighlighterModel)model;
        RemoteCaretHighlighterService caretHighlighterService = RemoteCaretHighlighterService.Companion.getInstance(this.project);
        caretHighlighterService.initializeHighlighter((RangeHighlighterEx)highlighter, ((RemoteCaretHighlighterModel)model).getData(), new TextRange(model.getStart(), model.getEnd()));
        if (new RemoteCaretHighlighterRenderer(((RemoteCaretHighlighterModel)model).getData()).shouldShow()) {
            caretHighlighterService.showRemoteCaret(((RemoteCaretHighlighterModel)model).getData(), (RangeHighlighterEx)highlighter);
        }
    }

    public boolean compare(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        RemoteCaretHighlighterModel cfr_ignored_0 = (RemoteCaretHighlighterModel)model;
        CustomHighlighterRenderer customHighlighterRenderer = highlighter.getCustomRenderer();
        RemoteCaretHighlighterRenderer renderer = customHighlighterRenderer instanceof RemoteCaretHighlighterRenderer ? (RemoteCaretHighlighterRenderer)customHighlighterRenderer : null;
        RemoteCaretHighlighterRenderer remoteCaretHighlighterRenderer = renderer;
        return Intrinsics.areEqual((Object)((RemoteCaretHighlighterModel)model).getData(), (Object)(remoteCaretHighlighterRenderer != null ? remoteCaretHighlighterRenderer.getRemoteCaretData() : null));
    }

    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        RemoteCaretHighlighterModel $this$move_u24lambda_u240 = (RemoteCaretHighlighterModel)model;
        boolean bl = false;
        return (HighlighterModel)new RemoteCaretHighlighterModel($this$move_u24lambda_u240.getData(), $this$move_u24lambda_u240.getLayer(), $this$move_u24lambda_u240.isExactRange(), $this$move_u24lambda_u240.getDocumentVersion(), $this$move_u24lambda_u240.isGreedyToLeft(), $this$move_u24lambda_u240.isGreedyToRight(), $this$move_u24lambda_u240.isThinErrorStripeMark(), $this$move_u24lambda_u240.getTextToHighlight(), $this$move_u24lambda_u240.getTextAttributesKey(), $this$move_u24lambda_u240.getId(), $this$move_u24lambda_u240.getProperties(), startOffset, endOffset);
    }
}

