/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.frontend.toolbar;

import com.intellij.cwm.frontend.CodeWithMeFrontendBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.wm.impl.DefaultToolbarComboButtonModel;
import com.intellij.openapi.wm.impl.ExpandableComboAction;
import com.intellij.openapi.wm.impl.ToolbarComboButton;
import com.intellij.platform.frontend.split.FrontendProcessInfo;
import com.intellij.ui.JBColor;
import com.jetbrains.rd.ide.model.RdCodeWithMeProject;
import com.jetbrains.rd.platform.RdConstants;
import com.jetbrains.thinclient.connection.ThinClientProjectInitializer;
import java.awt.Color;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0017\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/cwm/frontend/toolbar/ThinClientProjectWidgetAction;", "Lcom/intellij/openapi/wm/impl/ExpandableComboAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateCustomComponent", "component", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "createPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "event", "update", "getInfo", "Lcom/jetbrains/rd/ide/model/RdCodeWithMeProject;", "Lorg/jetbrains/annotations/Nullable;", "project", "Lcom/intellij/openapi/project/Project;", "createCustomComponent", "Lcom/intellij/openapi/wm/impl/ToolbarComboButton;", "place", "", "intellij.cwm.frontend"})
public final class ThinClientProjectWidgetAction
extends ExpandableComboAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public void updateCustomComponent(@NotNull JComponent component, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        super.updateCustomComponent(component, presentation);
        ToolbarComboButton toolbarComboButton = component instanceof ToolbarComboButton ? (ToolbarComboButton)component : null;
        if (toolbarComboButton == null) {
            return;
        }
        ToolbarComboButton widget = toolbarComboButton;
        widget.setText(presentation.getText());
        widget.setToolTipText(presentation.getDescription());
        if (!FrontendProcessInfo.INSTANCE.isController()) {
            widget.setLeftIcons(CollectionsKt.listOf((Object)AllIcons.CodeWithMe.CwmLogoToolbar));
            widget.setHoverBackground(null);
            widget.setTransparentHoverBackground(null);
        }
    }

    @Nullable
    public JBPopup createPopup(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return null;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        String string = project2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String projName = string;
        e.getPresentation().setText(projName, false);
        RdCodeWithMeProject rdCodeWithMeProject = this.getInfo(project2);
        if (rdCodeWithMeProject != null) {
            RdCodeWithMeProject it = rdCodeWithMeProject;
            boolean bl = false;
            Object[] objectArray = new Object[2];
            CharSequence charSequence = it.getHostUserName();
            Regex regex = RdConstants.INSTANCE.getNotAllowedNameCharactersRegex();
            String string2 = "_";
            objectArray[0] = regex.replace(charSequence, string2);
            charSequence = it.getProjectName();
            regex = RdConstants.INSTANCE.getNotAllowedNameCharactersRegex();
            string2 = "_";
            objectArray[1] = regex.replace(charSequence, string2);
            e.getPresentation().setDescription(CodeWithMeFrontendBundle.INSTANCE.message("project.title.full", objectArray));
        }
        e.getPresentation().setEnabled(e.isFromActionToolbar());
    }

    private final RdCodeWithMeProject getInfo(Project project) {
        return (RdCodeWithMeProject)project.getUserData(ThinClientProjectInitializer.INSTANCE.getProjectRdCodeWithMe());
    }

    @NotNull
    public ToolbarComboButton createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        DefaultToolbarComboButtonModel defaultToolbarComboButtonModel = new DefaultToolbarComboButtonModel();
        return new ToolbarComboButton(defaultToolbarComboButtonModel){

            public void updateUI() {
                super.updateUI();
                this.setHoverBackground((Color)JBColor.namedColor((String)"MainToolbar.Dropdown.background", (Color)JBColor.foreground()));
            }
        };
    }
}

