/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.indexing.shared.download.IndexDownloadConsentDecision;
import com.intellij.indexing.shared.download.IndexDownloadConsentDecisionKey;
import com.intellij.indexing.shared.download.ShadeIndexDumbModeTrackerTopicListener;
import com.intellij.indexing.shared.download.SharedIndexConfigurable;
import com.intellij.indexing.shared.download.SharedIndexConsentStoreKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadConsentStore;
import com.intellij.indexing.shared.download.SharedIndexDownloadService;
import com.intellij.indexing.shared.download.SharedIndexDumbModeTrackingKt;
import com.intellij.indexing.shared.download.SharedIndexSuggestion;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0002\u001a\u00020\u0003J\u0014\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R(\u0010\b\u001a\u001c\u0012\u0018\u0012\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/indexing/shared/download/IndexDownloadConsentService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myPendingNotification", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Pair;", "", "Lcom/intellij/indexing/shared/download/IndexDownloadConsentDecisionKey;", "Lcom/intellij/notification/Notification;", "dispose", "", "askForMoreDownloads", "suggestions", "", "Lcom/intellij/indexing/shared/download/SharedIndexSuggestion;", "showNotifications", "NotificationAlwaysDownload", "NotificationAllowOnce", "NotificationDeny", "NotificationConfigure", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexDownloadConsent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexDownloadConsent.kt\ncom/intellij/indexing/shared/download/IndexDownloadConsentService\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,151:1\n42#2,3:152\n1220#3,2:155\n1249#3,4:157\n1586#3:168\n1661#3,3:169\n1586#3:172\n1661#3,3:173\n540#4:161\n525#4,6:162\n*S KotlinDebug\n*F\n+ 1 SharedIndexDownloadConsent.kt\ncom/intellij/indexing/shared/download/IndexDownloadConsentService\n*L\n51#1:152,3\n53#1:155,2\n53#1:157,4\n63#1:168\n63#1:169,3\n66#1:172\n66#1:173,3\n54#1:161\n54#1:162,6\n*E\n"})
public final class IndexDownloadConsentService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicReference<Pair<Set<IndexDownloadConsentDecisionKey>, Notification>> myPendingNotification;

    public IndexDownloadConsentService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myPendingNotification = new AtomicReference<Object>(null);
        this.project.getMessageBus().connect((Disposable)this).subscribe(SharedIndexDumbModeTrackingKt.getShadeIndexDumbModeTrackerTopic(), (Object)new ShadeIndexDumbModeTrackerTopicListener(){

            @Override
            public void onStableSmartModeDetected() {
                block0: {
                    Pair pair = (Pair)myPendingNotification.get();
                    if (pair == null || (pair = (Notification)pair.getSecond()) == null) break block0;
                    Pair it = pair;
                    boolean bl = false;
                    ActionsKt.invokeLater$default(null, () -> 1.onStableSmartModeDetected$lambda$0$0((Notification)it), (int)1, null);
                }
            }

            private static final Unit onStableSmartModeDetected$lambda$0$0(Notification $it) {
                $it.hideBalloon();
                return Unit.INSTANCE;
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void dispose() {
        block0: {
            Pair pair = this.myPendingNotification.getAndSet(null);
            if (pair == null || (pair = (Notification)pair.getSecond()) == null) break block0;
            pair.expire();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void askForMoreDownloads(@NotNull List<? extends SharedIndexSuggestion> suggestions, @NotNull Project project) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$associateByTo$iv$iv;
        Map $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean $i$f$service = false;
        Object serviceClass$iv = SharedIndexDownloadConsentStore.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + ((Class)serviceClass$iv).getName() + " (classloader=" + ((Class)serviceClass$iv).getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        SharedIndexDownloadConsentStore consentStore = (SharedIndexDownloadConsentStore)((Object)object);
        serviceClass$iv = suggestions;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateBy$iv), (int)10)), (int)16);
        void var8_10 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(SharedIndexConsentStoreKt.toKey((SharedIndexSuggestion)it), element$iv$iv);
        }
        $this$associateBy$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        void capacity$iv22 = $this$filter$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(consentStore.decisionFor((IndexDownloadConsentDecisionKey)it.getKey(), project) == IndexDownloadConsentDecision.UNKNOWN)) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        SortedMap keysToAsk = MapsKt.toSortedMap((Map)destination$iv$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IndexDownloadConsentDecisionKey it = (IndexDownloadConsentDecisionKey)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getKind());
                it = (IndexDownloadConsentDecisionKey)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getKind())));
            }
        });
        Collection collection = keysToAsk.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        this.showNotifications(CollectionsKt.toList((Iterable)collection));
    }

    /*
     * WARNING - void declaration
     */
    public final void showNotifications(@NotNull List<? extends SharedIndexSuggestion> suggestions) {
        void $this$mapTo$iv$iv;
        List keysToAsk;
        Collection collection;
        block8: {
            block7: {
                void $this$mapTo$iv$iv2;
                Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
                if (suggestions.isEmpty()) {
                    return;
                }
                Iterable $this$map$iv = suggestions;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(SharedIndexConsentStoreKt.toKey((SharedIndexSuggestion)it));
                }
                keysToAsk = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                if (keysToAsk.isEmpty()) break block7;
                Object object = this.myPendingNotification.get();
                boolean bl = object != null && (object = (Set)object.getFirst()) != null ? object.containsAll(keysToAsk) : false;
                if (!bl) break block8;
            }
            return;
        }
        Iterable $this$map$iv = suggestions;
        boolean $i$f$map = false;
        Iterable $i$f$mapTo = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSharedIndexConsentNotificationKindPresentableText());
        }
        String string = NlsMessages.formatAndList((Collection)CollectionsKt.toList((Iterable)CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE))));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatAndList(...)");
        String mergedKinds = string;
        Object[] objectArray = new Object[]{mergedKinds};
        String string2 = SharedIndexesBundle.message("notification.consent.content", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String notificationContent = string2;
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Shared Indexes Recommendations");
        String string3 = SharedIndexesBundle.message("notification.consent.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        objectArray = notificationGroup.createNotification(string3, notificationContent, NotificationType.INFORMATION).setImportantSuggestion(true).setSuggestionType(true).setCollapseDirection(Notification.CollapseActionsDirection.KEEP_LEFTMOST).setDropDownText(SharedIndexesBundle.message("notification.consent.action.moreActions", new Object[0])).addAction((AnAction)NotificationAction.createSimpleExpiring((String)SharedIndexesBundle.message("notification.consent.action.alwaysAllow", new Object[0]), (Runnable)new NotificationAlwaysDownload(this.project, keysToAsk))).addAction((AnAction)NotificationAction.createSimpleExpiring((String)SharedIndexesBundle.message("notification.consent.action.allowOnce", new Object[0]), (Runnable)new NotificationAllowOnce(this.project, suggestions))).addAction((AnAction)NotificationAction.createSimpleExpiring((String)SharedIndexesBundle.message("notification.consent.action.doNotShow", new Object[0]), (Runnable)new NotificationDeny(keysToAsk))).addAction((AnAction)NotificationAction.createSimpleExpiring((String)SharedIndexesBundle.message("notification.consent.action.configure", new Object[0]), (Runnable)new NotificationConfigure(this.project)));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"addAction(...)");
        Object[] notification = objectArray;
        notification.whenExpired(() -> IndexDownloadConsentService.showNotifications$lambda$2(this, (Notification)notification));
        Notification notification2 = this.myPendingNotification.getAndSet((Pair<Set<IndexDownloadConsentDecisionKey>, Notification>)TuplesKt.to((Object)CollectionsKt.toSet((Iterable)keysToAsk), (Object)notification));
        if (notification2 != null && (notification2 = (Notification)notification2.getSecond()) != null) {
            notification2.expire();
        }
        notification.notify(this.project);
    }

    private static final Pair showNotifications$lambda$2$0(Notification $notification, Pair oldNotification) {
        return oldNotification == null ? null : (Intrinsics.areEqual((Object)oldNotification.getSecond(), (Object)$notification) ? null : oldNotification);
    }

    private static final void showNotifications$lambda$2(IndexDownloadConsentService this$0, Notification $notification) {
        this$0.myPendingNotification.updateAndGet(arg_0 -> IndexDownloadConsentService.showNotifications$lambda$2$0($notification, arg_0));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/indexing/shared/download/IndexDownloadConsentService$NotificationAllowOnce;", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "suggestions", "", "Lcom/intellij/indexing/shared/download/SharedIndexSuggestion;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "run", "", "intellij.indexing.shared"})
    @SourceDebugExtension(value={"SMAP\nSharedIndexDownloadConsent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexDownloadConsent.kt\ncom/intellij/indexing/shared/download/IndexDownloadConsentService$NotificationAllowOnce\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,151:1\n42#2,3:152\n*S KotlinDebug\n*F\n+ 1 SharedIndexDownloadConsent.kt\ncom/intellij/indexing/shared/download/IndexDownloadConsentService$NotificationAllowOnce\n*L\n134#1:152,3\n*E\n"})
    private static final class NotificationAllowOnce
    implements Runnable {
        @NotNull
        private final Project project;
        @NotNull
        private final List<SharedIndexSuggestion> suggestions;

        public NotificationAllowOnce(@NotNull Project project, @NotNull List<? extends SharedIndexSuggestion> suggestions) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
            this.project = project;
            this.suggestions = suggestions;
        }

        @Override
        public void run() {
            boolean $i$f$service = false;
            Class<SharedIndexDownloadService> serviceClass$iv = SharedIndexDownloadService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((SharedIndexDownloadService)object).applySuggestions(this.project, this.suggestions);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/indexing/shared/download/IndexDownloadConsentService$NotificationAlwaysDownload;", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "toAllowKeys", "", "Lcom/intellij/indexing/shared/download/IndexDownloadConsentDecisionKey;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "run", "", "intellij.indexing.shared"})
    @SourceDebugExtension(value={"SMAP\nSharedIndexDownloadConsent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexDownloadConsent.kt\ncom/intellij/indexing/shared/download/IndexDownloadConsentService$NotificationAlwaysDownload\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,151:1\n42#2,3:152\n42#2,3:155\n*S KotlinDebug\n*F\n+ 1 SharedIndexDownloadConsent.kt\ncom/intellij/indexing/shared/download/IndexDownloadConsentService$NotificationAlwaysDownload\n*L\n123#1:152,3\n125#1:155,3\n*E\n"})
    private static final class NotificationAlwaysDownload
    implements Runnable {
        @NotNull
        private final Project project;
        @NotNull
        private final List<IndexDownloadConsentDecisionKey> toAllowKeys;

        public NotificationAlwaysDownload(@NotNull Project project, @NotNull List<IndexDownloadConsentDecisionKey> toAllowKeys) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(toAllowKeys, (String)"toAllowKeys");
            this.project = project;
            this.toAllowKeys = toAllowKeys;
        }

        @Override
        public void run() {
            boolean $i$f$service = false;
            Class serviceClass$iv = SharedIndexDownloadConsentStore.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((SharedIndexDownloadConsentStore)((Object)object)).setDecisionFor((Collection<IndexDownloadConsentDecisionKey>)this.toAllowKeys, IndexDownloadConsentDecision.ALLOWED);
            $i$f$service = false;
            serviceClass$iv = SharedIndexDownloadService.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((SharedIndexDownloadService)object2).rescanNow(this.project);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/indexing/shared/download/IndexDownloadConsentService$NotificationConfigure;", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "run", "", "intellij.indexing.shared"})
    private static final class NotificationConfigure
    implements Runnable {
        @NotNull
        private final Project project;

        public NotificationConfigure(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @Override
        public void run() {
            ShowSettingsUtil.getInstance().showSettingsDialog(this.project, SharedIndexConfigurable.class);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/indexing/shared/download/IndexDownloadConsentService$NotificationDeny;", "Ljava/lang/Runnable;", "toDenyKeys", "", "Lcom/intellij/indexing/shared/download/IndexDownloadConsentDecisionKey;", "<init>", "(Ljava/util/List;)V", "run", "", "intellij.indexing.shared"})
    @SourceDebugExtension(value={"SMAP\nSharedIndexDownloadConsent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexDownloadConsent.kt\ncom/intellij/indexing/shared/download/IndexDownloadConsentService$NotificationDeny\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,151:1\n42#2,3:152\n*S KotlinDebug\n*F\n+ 1 SharedIndexDownloadConsent.kt\ncom/intellij/indexing/shared/download/IndexDownloadConsentService$NotificationDeny\n*L\n140#1:152,3\n*E\n"})
    private static final class NotificationDeny
    implements Runnable {
        @NotNull
        private final List<IndexDownloadConsentDecisionKey> toDenyKeys;

        public NotificationDeny(@NotNull List<IndexDownloadConsentDecisionKey> toDenyKeys) {
            Intrinsics.checkNotNullParameter(toDenyKeys, (String)"toDenyKeys");
            this.toDenyKeys = toDenyKeys;
        }

        @Override
        public void run() {
            boolean $i$f$service = false;
            Class<SharedIndexDownloadConsentStore> serviceClass$iv = SharedIndexDownloadConsentStore.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((SharedIndexDownloadConsentStore)((Object)object)).setDecisionFor((Collection<IndexDownloadConsentDecisionKey>)this.toDenyKeys, IndexDownloadConsentDecision.DENIED);
        }
    }
}

