/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.indexing.shared.download.SharedIndexDownloadJson;
import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.indexing.shared.download.SharedIndexListLookup;
import com.intellij.indexing.shared.download.SharedIndexListLookupKt;
import com.intellij.indexing.shared.download.SharedIndexListLookupResult;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexNetworkCache;
import com.intellij.indexing.shared.download.SharedIndexNetworkCacheScope;
import com.intellij.indexing.shared.download.SharedIndexUrlDecision;
import com.intellij.indexing.shared.download.UrlSiblingsChecker;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000U\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0011\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001f B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0006J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0006J(\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexListLookup;", "", "<init>", "()V", "groupUrsByListPaths", "", "", "", "urls", "collectUrlsToProcess", "request", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "extractListBaseUrl", "url", "cache", "com/intellij/indexing/shared/download/SharedIndexListLookup$cache$1", "Lcom/intellij/indexing/shared/download/SharedIndexListLookup$cache$1;", "invalidateCaches", "", "cacheSize", "", "lookupListFor", "Lcom/intellij/indexing/shared/download/SharedIndexListLookupResult;", "listUrl", "parseListJson", "", "lookupUrl", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "ListLookupRequest", "ListLookupCacheEntry", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexListLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexListLookup.kt\ncom/intellij/indexing/shared/download/SharedIndexListLookup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,176:1\n1642#2,10:177\n1915#2:187\n1916#2:189\n1652#2:190\n1525#2:191\n1557#2,3:192\n1560#2,3:202\n777#2:205\n873#2,2:206\n1642#2,10:208\n1915#2:218\n1916#2:220\n1652#2:221\n1#3:188\n1#3:219\n383#4,7:195\n*S KotlinDebug\n*F\n+ 1 SharedIndexListLookup.kt\ncom/intellij/indexing/shared/download/SharedIndexListLookup\n*L\n40#1:177,10\n40#1:187\n40#1:189\n40#1:190\n41#1:191\n41#1:192,3\n41#1:202,3\n75#1:205\n75#1:206,2\n156#1:208,10\n156#1:218\n156#1:220\n156#1:221\n40#1:188\n156#1:219\n41#1:195,7\n*E\n"})
public final class SharedIndexListLookup {
    @NotNull
    private final cache.1 cache = new SharedIndexNetworkCache<ListLookupRequest, ListLookupCacheEntry>(){

        protected Instant getCreated(ListLookupCacheEntry $this$created) {
            Intrinsics.checkNotNullParameter((Object)$this$created, (String)"<this>");
            return $this$created.getComputed();
        }
    };

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<String>> groupUrsByListPaths(@NotNull List<String> urls) {
        void $this$groupByTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Iterable $this$mapNotNull$iv = urls;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String string = this.extractListBaseUrl(it);
            if ((string != null ? TuplesKt.to((Object)string, (Object)it) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-SharedIndexListLookup$groupUrsByListPaths$42 = false;
            String key$iv$iv = (String)it2.getFirst();
            Object bl = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-SharedIndexListLookup$groupUrsByListPaths$42 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl5 = false;
            list.add((String)it.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> collectUrlsToProcess(@NotNull SharedIndexLookupRequest request, @NotNull ProgressIndicator indicator) {
        void $this$filterTo$iv$iv;
        Object listBase;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        List<String> urls = request.indexUrls();
        if (!request.getUseListJsonIndexToSkipUrls() || !Registry.Companion.is("shared.indexes.use.cdn.list")) {
            return urls;
        }
        Map<String, List<String>> checkBases = this.groupUrsByListPaths(urls);
        HashSet skipUrls = new HashSet();
        for (Map.Entry<String, List<String>> entry : checkBases.entrySet()) {
            listBase = entry.getKey();
            List<String> listUrls = entry.getValue();
            if (!StringsKt.startsWith$default((String)listBase, (String)request.baseUrl(), (boolean)false, (int)2, null)) continue;
            SharedIndexListLookupResult lookup = this.lookupListFor(request, indicator, (String)listBase);
            for (String url : listUrls) {
                if (lookup.testUrl(request, url) != SharedIndexUrlDecision.SKIP) continue;
                ((Collection)skipUrls).add(url);
                SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Shared index download URL " + url + " is not listed, will be skipped");
            }
        }
        Iterable $this$filter$iv = urls;
        boolean $i$f$filter = false;
        listBase = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!skipUrls.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final String extractListBaseUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        char[] cArray = new char[]{'/'};
        String url2 = StringsKt.trim((String)url, (char[])cArray);
        int idx = StringsKt.lastIndexOf$default((CharSequence)url2, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (idx <= 0 || idx + 1 == url2.length()) {
            return null;
        }
        String string = url2.substring(0, idx);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        char[] cArray2 = new char[]{'/'};
        return StringsKt.trim((String)string, (char[])cArray2);
    }

    public final void invalidateCaches() {
        this.cache.invalidateCaches();
    }

    @VisibleForTesting
    public final int cacheSize() {
        return this.cache.cacheSize();
    }

    @NotNull
    public final SharedIndexListLookupResult lookupListFor(@NotNull SharedIndexLookupRequest request, @NotNull ProgressIndicator indicator, @NotNull String listUrl) {
        SharedIndexListLookupResult sharedIndexListLookupResult;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)listUrl, (String)"listUrl");
        ListLookupCacheEntry listLookupCacheEntry = (ListLookupCacheEntry)SharedIndexNetworkCache.lookupOrCompute$default(this.cache, new ListLookupRequest(listUrl), indicator, null, arg_0 -> SharedIndexListLookup.lookupListFor$lambda$0(listUrl, request, indicator, this, arg_0), 4, null);
        return listLookupCacheEntry != null && (sharedIndexListLookupResult = listLookupCacheEntry.getChecker()) != null ? sharedIndexListLookupResult : (SharedIndexListLookupResult)SharedIndexListLookupKt.access$getRejectAllListLookupResult$p();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> parseListJson(String lookupUrl, SharedIndexLookupRequest request, ObjectNode json) {
        void $this$mapNotNullTo$iv$iv;
        String listVersion;
        JsonNode jsonNode = json.get("list_version");
        String string = listVersion = jsonNode != null ? jsonNode.asText() : null;
        if (!Intrinsics.areEqual((Object)listVersion, (Object)"1")) {
            SharedIndexDownloadLoggerKt.getDownloadLogger().trace("List Index data version mismatch. The current version is " + listVersion + " in " + lookupUrl + " for " + request);
            return null;
        }
        JsonNode jsonNode2 = json.get("names");
        ArrayNode arrayNode = jsonNode2 instanceof ArrayNode ? (ArrayNode)jsonNode2 : null;
        if (arrayNode == null) {
            SharedIndexListLookup $this$parseListJson_u24lambda_u240 = this;
            boolean bl = false;
            SharedIndexDownloadLoggerKt.getDownloadLogger().trace("Index data format is incomplete. Missing 'entries' element in " + lookupUrl + " for " + request);
            return null;
        }
        ArrayNode names = arrayNode;
        Iterable $this$mapNotNull$iv = (Iterable)names;
        boolean $i$f$mapNotNull = false;
        Iterable $this$parseListJson_u24lambda_u240 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JsonNode it = (JsonNode)element$iv$iv;
            boolean bl2 = false;
            if (it.asText() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final ListLookupCacheEntry lookupListFor$lambda$0(String $listUrl, SharedIndexLookupRequest $request, ProgressIndicator $indicator, SharedIndexListLookup this$0, SharedIndexNetworkCacheScope $this$lookupOrCompute) {
        SharedIndexListLookupResult sharedIndexListLookupResult;
        Intrinsics.checkNotNullParameter((Object)$this$lookupOrCompute, (String)"$this$lookupOrCompute");
        char[] cArray = new char[]{'/'};
        String lookupUrl = StringsKt.trim((String)$listUrl, (char[])cArray) + "/list.json.xz";
        ObjectNode json = SharedIndexDownloadJson.INSTANCE.downloadJsonXz($request, lookupUrl, $indicator);
        if (json == null) {
            SharedIndexDownloadLoggerKt.getDownloadLogger().info("Failed to download the list of allowed URLs from " + lookupUrl + ". It looks like there is no internet connection. The " + $request + " is skipped");
            sharedIndexListLookupResult = SharedIndexListLookupKt.access$getRejectAllListLookupResult$p();
        } else {
            Set<String> siblings = this$0.parseListJson(lookupUrl, $request, json);
            Collection collection = siblings;
            if (collection == null || collection.isEmpty()) {
                SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Invalid data is downloaded as the list of allowed URLs from " + lookupUrl + ". The " + $request + " is skipped");
                sharedIndexListLookupResult = SharedIndexListLookupKt.access$getRejectAllListLookupResult$p();
            } else {
                sharedIndexListLookupResult = new UrlSiblingsChecker($listUrl, siblings);
            }
        }
        SharedIndexListLookupResult checker = sharedIndexListLookupResult;
        return new ListLookupCacheEntry($this$lookupOrCompute.getNow(), checker);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexListLookup$ListLookupCacheEntry;", "", "computed", "Ljava/time/Instant;", "checker", "Lcom/intellij/indexing/shared/download/SharedIndexListLookupResult;", "<init>", "(Ljava/time/Instant;Lcom/intellij/indexing/shared/download/SharedIndexListLookupResult;)V", "getComputed", "()Ljava/time/Instant;", "getChecker", "()Lcom/intellij/indexing/shared/download/SharedIndexListLookupResult;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.indexing.shared"})
    private static final class ListLookupCacheEntry {
        @NotNull
        private final Instant computed;
        @Nullable
        private final SharedIndexListLookupResult checker;

        public ListLookupCacheEntry(@NotNull Instant computed, @Nullable SharedIndexListLookupResult checker) {
            Intrinsics.checkNotNullParameter((Object)computed, (String)"computed");
            this.computed = computed;
            this.checker = checker;
        }

        @NotNull
        public final Instant getComputed() {
            return this.computed;
        }

        @Nullable
        public final SharedIndexListLookupResult getChecker() {
            return this.checker;
        }

        @NotNull
        public final Instant component1() {
            return this.computed;
        }

        @Nullable
        public final SharedIndexListLookupResult component2() {
            return this.checker;
        }

        @NotNull
        public final ListLookupCacheEntry copy(@NotNull Instant computed, @Nullable SharedIndexListLookupResult checker) {
            Intrinsics.checkNotNullParameter((Object)computed, (String)"computed");
            return new ListLookupCacheEntry(computed, checker);
        }

        public static /* synthetic */ ListLookupCacheEntry copy$default(ListLookupCacheEntry listLookupCacheEntry, Instant instant, SharedIndexListLookupResult sharedIndexListLookupResult, int n, Object object) {
            if ((n & 1) != 0) {
                instant = listLookupCacheEntry.computed;
            }
            if ((n & 2) != 0) {
                sharedIndexListLookupResult = listLookupCacheEntry.checker;
            }
            return listLookupCacheEntry.copy(instant, sharedIndexListLookupResult);
        }

        @NotNull
        public String toString() {
            return "ListLookupCacheEntry(computed=" + this.computed + ", checker=" + this.checker + ")";
        }

        public int hashCode() {
            int result = this.computed.hashCode();
            result = result * 31 + (this.checker == null ? 0 : this.checker.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ListLookupCacheEntry)) {
                return false;
            }
            ListLookupCacheEntry listLookupCacheEntry = (ListLookupCacheEntry)other;
            if (!Intrinsics.areEqual((Object)this.computed, (Object)listLookupCacheEntry.computed)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.checker, (Object)listLookupCacheEntry.checker);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\r\u001a\u00020\u000eH\u00d6\u0081\u0004J\n\u0010\u000f\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexListLookup$ListLookupRequest;", "", "listUrl", "", "<init>", "(Ljava/lang/String;)V", "getListUrl", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.indexing.shared"})
    private static final class ListLookupRequest {
        @NotNull
        private final String listUrl;

        public ListLookupRequest(@NotNull String listUrl) {
            Intrinsics.checkNotNullParameter((Object)listUrl, (String)"listUrl");
            this.listUrl = listUrl;
        }

        @NotNull
        public final String getListUrl() {
            return this.listUrl;
        }

        @NotNull
        public final String component1() {
            return this.listUrl;
        }

        @NotNull
        public final ListLookupRequest copy(@NotNull String listUrl) {
            Intrinsics.checkNotNullParameter((Object)listUrl, (String)"listUrl");
            return new ListLookupRequest(listUrl);
        }

        public static /* synthetic */ ListLookupRequest copy$default(ListLookupRequest listLookupRequest, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = listLookupRequest.listUrl;
            }
            return listLookupRequest.copy(string);
        }

        @NotNull
        public String toString() {
            return "ListLookupRequest(listUrl=" + this.listUrl + ")";
        }

        public int hashCode() {
            return this.listUrl.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ListLookupRequest)) {
                return false;
            }
            ListLookupRequest listLookupRequest = (ListLookupRequest)other;
            return Intrinsics.areEqual((Object)this.listUrl, (Object)listLookupRequest.listUrl);
        }
    }
}

