/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.download.SharedIndexAuthException;
import com.intellij.indexing.shared.download.SharedIndexCompression;
import com.intellij.indexing.shared.download.SharedIndexDownloadJson;
import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.indexing.shared.download.SharedIndexLineup;
import com.intellij.indexing.shared.download.SharedIndexListLookup;
import com.intellij.indexing.shared.download.SharedIndexLookup;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.download.SharedIndexNetworkCache;
import com.intellij.indexing.shared.download.SharedIndexNetworkCacheScope;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorForCollections;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0005\b\u0007\u0018\u0000 $2\u00020\u0001:\u0002#$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002JX\u0010\u000f\u001a\u0004\u0018\u0001H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2/\u0010\u0012\u001a+\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0018\u0012\u0006\u0012\u0004\u0018\u0001H\u00110\u0013\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0007J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0007J&\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0007R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006%"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexLookup;", "", "<init>", "()V", "cache", "com/intellij/indexing/shared/download/SharedIndexLookup$cache$1", "Lcom/intellij/indexing/shared/download/SharedIndexLookup$cache$1;", "lookupSharedIndex", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "request", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "ideVersion", "Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "lookupSharedIndexWithoutCache", "ourVersion", "T", "matchItem", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "url", "", "(Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "invalidateCaches", "", "cacheSize", "", "downloadIndexList", "indexUrl", "parseIndexList", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "CacheEntry", "Companion", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexLookup.kt\ncom/intellij/indexing/shared/download/SharedIndexLookup\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 ProgressIndicatorEx.kt\ncom/intellij/openapi/progress/ProgressIndicatorForCollections\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n42#2,3:194\n55#2:224\n28#3:197\n13#3,4:198\n29#3,14:202\n19#3,2:216\n44#3,6:218\n1#4:225\n*S KotlinDebug\n*F\n+ 1 SharedIndexLookup.kt\ncom/intellij/indexing/shared/download/SharedIndexLookup\n*L\n89#1:194,3\n115#1:224\n99#1:197\n99#1:198,4\n99#1:202,14\n99#1:216,2\n99#1:218,6\n*E\n"})
public final class SharedIndexLookup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final cache.1 cache = new SharedIndexNetworkCache<SharedIndexLookupRequest, CacheEntry>(){

        protected Instant getCreated(CacheEntry $this$created) {
            Intrinsics.checkNotNullParameter((Object)$this$created, (String)"<this>");
            return $this$created.getComputed();
        }
    };

    @Nullable
    public final SharedIndexLookupResult lookupSharedIndex(@NotNull SharedIndexLookupRequest request, @NotNull SharedIndexInfrastructureVersion ideVersion, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)((Object)ideVersion), (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        CacheEntry cacheEntry = (CacheEntry)this.cache.lookupOrCompute(request, indicator, arg_0 -> SharedIndexLookup.lookupSharedIndex$lambda$0(ideVersion, arg_0), arg_0 -> SharedIndexLookup.lookupSharedIndex$lambda$1(this, request, ideVersion, indicator, arg_0));
        return cacheEntry != null ? cacheEntry.getValue() : null;
    }

    private final SharedIndexLookupResult lookupSharedIndexWithoutCache(SharedIndexLookupRequest request, SharedIndexInfrastructureVersion ourVersion, ProgressIndicator indicator) {
        return (SharedIndexLookupResult)this.lookupSharedIndexWithoutCache(request, indicator, (arg_0, arg_1) -> SharedIndexLookup.lookupSharedIndexWithoutCache$lambda$0(ourVersion, arg_0, arg_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final <T> T lookupSharedIndexWithoutCache(@NotNull SharedIndexLookupRequest request, @NotNull ProgressIndicator indicator, @NotNull Function2<? super String, ? super List<SharedIndexLookupResult>, ? extends T> matchItem) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(matchItem, (String)"matchItem");
        boolean $i$f$service22 = false;
        Class<SharedIndexListLookup> serviceClass$iv = SharedIndexListLookup.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        List<String> urlsToProcess = ((SharedIndexListLookup)object).collectUrlsToProcess(request, indicator);
        if (urlsToProcess.isEmpty()) {
            SharedIndexDownloadLoggerKt.getDownloadLogger().debug("No shared indexes are found for " + request + ".");
            return null;
        }
        indicator.setText(SharedIndexesBundle.message("progress.text.resolving.shared.indexes.checking", new Object[0]));
        Collection $i$f$service22 = urlsToProcess;
        ProgressIndicator indicator$iv = indicator;
        boolean $i$f$forEachWithProgress = false;
        ProgressIndicator $this$withPushPop$iv$iv = indicator$iv;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv$iv = $this$withPushPop$iv$iv.isIndeterminate();
        $this$withPushPop$iv$iv.pushState();
        try {
            void $this$forEachWithProgress$iv;
            boolean bl = false;
            indicator$iv.setIndeterminate(false);
            indicator$iv.checkCanceled();
            double size$iv = $this$forEachWithProgress$iv.size();
            Iterator iterator = ((Iterable)$this$forEachWithProgress$iv).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                void subIndicator;
                int i$iv = n++;
                Object y$iv = iterator.next();
                indicator$iv.checkCanceled();
                double lowerBound$iv = (double)i$iv / size$iv;
                double upperBound$iv = (double)(i$iv + 1) / size$iv;
                indicator$iv.setFraction(lowerBound$iv);
                String prevText$iv = indicator$iv.getText();
                String prevText2$iv = indicator$iv.getText2();
                ProgressIndicator progressIndicator = ProgressIndicatorForCollections.scaleFraction((ProgressIndicator)indicator$iv, (double)lowerBound$iv, (double)upperBound$iv);
                String url = (String)y$iv;
                boolean bl2 = false;
                subIndicator.setText2(url);
                char[] cArray = new char[]{'/'};
                String indexUrl = StringsKt.trim((String)url, (char[])cArray) + "/index.json.xz";
                List<SharedIndexLookupResult> results = this.downloadIndexList(request, indexUrl, (ProgressIndicator)subIndicator);
                subIndicator.checkCanceled();
                Object object2 = matchItem.invoke((Object)url, results);
                if (object2 != null) {
                    Object best = object2;
                    boolean bl3 = false;
                    SharedIndexDownloadLoggerKt.getDownloadLogger().info("Selected pre-built shared index " + best + " from " + url + " for " + request);
                    Object object3 = best;
                    return (T)object3;
                }
                indicator$iv.setText(prevText$iv);
                indicator$iv.setText2(prevText2$iv);
            }
            indicator$iv.setFraction(1.0);
        }
        finally {
            $this$withPushPop$iv$iv.setIndeterminate(wasIndeterminate$iv$iv);
            $this$withPushPop$iv$iv.popState();
        }
        SharedIndexDownloadLoggerKt.getDownloadLogger().debug("No suitable shared indexes are found for " + request + ". The following " + urlsToProcess.size() + " URLs were tried: " + CollectionsKt.joinToString$default((Iterable)urlsToProcess, null, null, null, (int)0, null, null, (int)63, null));
        return null;
    }

    public final void invalidateCaches() {
        boolean $i$f$serviceIfCreated = false;
        Application application = ApplicationManager.getApplication();
        SharedIndexListLookup sharedIndexListLookup = (SharedIndexListLookup)(application != null ? application.getServiceIfCreated(SharedIndexListLookup.class) : null);
        if (sharedIndexListLookup != null) {
            sharedIndexListLookup.invalidateCaches();
        }
        this.cache.invalidateCaches();
    }

    @VisibleForTesting
    public final int cacheSize() {
        return this.cache.cacheSize();
    }

    @VisibleForTesting
    @NotNull
    public final List<SharedIndexLookupResult> downloadIndexList(@NotNull SharedIndexLookupRequest request, @NotNull String indexUrl, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indexUrl, (String)"indexUrl");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ObjectNode objectNode = SharedIndexDownloadJson.INSTANCE.downloadJsonXz(request, indexUrl, indicator);
        if (objectNode == null) {
            return CollectionsKt.emptyList();
        }
        ObjectNode json = objectNode;
        return this.parseIndexList(json, indexUrl, request);
    }

    @VisibleForTesting
    @NotNull
    public final List<SharedIndexLookupResult> parseIndexList(@NotNull ObjectNode json, @NotNull String indexUrl, @NotNull SharedIndexLookupRequest request) {
        String listVersion;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)indexUrl, (String)"indexUrl");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        JsonNode jsonNode = json.get("list_version");
        String string = listVersion = jsonNode != null ? jsonNode.asText() : null;
        if (!Intrinsics.areEqual((Object)listVersion, (Object)"1")) {
            SharedIndexDownloadLoggerKt.getDownloadLogger().trace("Index data version mismatch. The current version is " + listVersion + " in " + indexUrl + " for " + request);
            return CollectionsKt.emptyList();
        }
        JsonNode jsonNode2 = json.get("entries");
        ArrayNode arrayNode = jsonNode2 instanceof ArrayNode ? (ArrayNode)jsonNode2 : null;
        if (arrayNode == null) {
            SharedIndexLookup $this$parseIndexList_u24lambda_u240 = this;
            boolean bl = false;
            SharedIndexDownloadLoggerKt.getDownloadLogger().trace("Index data format is incomplete. Missing 'entries' element in " + indexUrl + " for " + request);
            return CollectionsKt.emptyList();
        }
        ArrayNode entries = arrayNode;
        Iterator iterator = entries.elements();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)iterator), arg_0 -> SharedIndexLookup.parseIndexList$lambda$1(indexUrl, this, request, arg_0)));
    }

    private static final boolean lookupSharedIndex$lambda$0(SharedIndexInfrastructureVersion $ideVersion, CacheEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)((Object)it.getIdeVersion()), (Object)((Object)$ideVersion));
    }

    private static final CacheEntry lookupSharedIndex$lambda$1(SharedIndexLookup this$0, SharedIndexLookupRequest $request, SharedIndexInfrastructureVersion $ideVersion, ProgressIndicator $indicator, SharedIndexNetworkCacheScope $this$lookupOrCompute) {
        SharedIndexLookupResult sharedIndexLookupResult;
        Intrinsics.checkNotNullParameter((Object)$this$lookupOrCompute, (String)"$this$lookupOrCompute");
        try {
            sharedIndexLookupResult = this$0.lookupSharedIndexWithoutCache($request, $ideVersion, $indicator);
        }
        catch (Throwable t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            if (t instanceof SharedIndexAuthException) {
                throw t;
            }
            $indicator.checkCanceled();
            SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to lookup shared index for " + $request + ". " + t.getMessage(), t);
            sharedIndexLookupResult = null;
        }
        SharedIndexLookupResult result = sharedIndexLookupResult;
        return new CacheEntry($ideVersion, $this$lookupOrCompute.getNow(), result);
    }

    /*
     * WARNING - void declaration
     */
    private static final SharedIndexLookupResult lookupSharedIndexWithoutCache$lambda$0(SharedIndexInfrastructureVersion $ourVersion, String string, List results) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)results, (String)"results");
        SharedIndexLookupResult bestSuitableIndex = SharedIndexMetadata.Companion.selectBestSuitableIndex($ourVersion, results);
        if (bestSuitableIndex == null && SharedIndexDownloadLoggerKt.getDownloadLogger().isTraceEnabled()) {
            void $this$lookupSharedIndexWithoutCache_u24lambda_u240_u240;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
            boolean bl = false;
            $this$lookupSharedIndexWithoutCache_u24lambda_u240_u240.append("Among " + results.size() + " candidate indexes no one is compatible with current IDE").append('\n');
            $this$lookupSharedIndexWithoutCache_u24lambda_u240_u240.append("Current IDE version:").append('\n');
            $this$lookupSharedIndexWithoutCache_u24lambda_u240_u240.append("    " + $ourVersion).append('\n');
            $this$lookupSharedIndexWithoutCache_u24lambda_u240_u240.append("Candidates:").append('\n');
            Iterator iterator = ((Iterable)results).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                SharedIndexLookupResult result = (SharedIndexLookupResult)iterator.next();
                $this$lookupSharedIndexWithoutCache_u24lambda_u240_u240.append(index + 1 + ") Result : " + result).append('\n');
                $this$lookupSharedIndexWithoutCache_u24lambda_u240_u240.append(index + 1 + ") Version: " + result.getIndexVersion()).append('\n');
            }
            logger.trace(stringBuilder.toString());
        }
        return bestSuitableIndex;
    }

    private static final SharedIndexLookupResult parseIndexList$lambda$1(String $indexUrl, SharedIndexLookup this$0, SharedIndexLookupRequest $request, JsonNode node) {
        Object $this$parseIndexList_u24lambda_u241_u240;
        if (!(node instanceof ObjectNode)) {
            return null;
        }
        Object object = ((ObjectNode)node).get("url");
        if (object == null || (object = object.asText()) == null) {
            return null;
        }
        String string = Companion.resolveRelativeUrl($indexUrl, (String)object);
        if (string == null) {
            return null;
        }
        String url = string;
        Object object2 = ((ObjectNode)node).get("sha256");
        if (object2 == null || (object2 = object2.asText()) == null) {
            return null;
        }
        Object sha = object2;
        JsonNode jsonNode = ((ObjectNode)node).get("size");
        if (jsonNode == null) {
            return null;
        }
        long size = jsonNode.asLong();
        Object object3 = ((ObjectNode)node).get("metadata");
        ObjectNode objectNode = object3 instanceof ObjectNode ? (ObjectNode)object3 : null;
        if (objectNode == null) {
            return null;
        }
        ObjectNode indexVersionJson = objectNode;
        object3 = this$0;
        try {
            SharedIndexLineup sharedIndexLineup;
            $this$parseIndexList_u24lambda_u241_u240 = object3;
            boolean bl = false;
            JsonNode jsonNode2 = ((ObjectNode)node).get("lineup");
            ObjectNode objectNode2 = jsonNode2 instanceof ObjectNode ? (ObjectNode)jsonNode2 : null;
            if (objectNode2 != null) {
                ObjectNode it = objectNode2;
                boolean bl2 = false;
                String string2 = it.get("name").asText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asText(...)");
                sharedIndexLineup = new SharedIndexLineup(string2, it.get("creationStamp").asLong(), it.get("indexedFileCount").asInt());
            } else {
                sharedIndexLineup = null;
            }
            $this$parseIndexList_u24lambda_u241_u240 = Result.constructor-impl(sharedIndexLineup);
        }
        catch (Throwable bl) {
            $this$parseIndexList_u24lambda_u241_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object3 = $this$parseIndexList_u24lambda_u241_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable != null) {
            Object it = $this$parseIndexList_u24lambda_u241_u240 = throwable;
            boolean bl = false;
            SharedIndexDownloadLoggerKt.getDownloadLogger().info((Throwable)it);
        }
        SharedIndexLineup lineup = (SharedIndexLineup)(Result.isFailure-impl((Object)object3) ? null : object3);
        JsonNode jsonNode3 = ((ObjectNode)node).get("format");
        SharedIndexCompression sharedIndexCompression = SharedIndexCompression.Companion.findByType(jsonNode3 != null ? jsonNode3.asText() : null);
        if (sharedIndexCompression == null) {
            return null;
        }
        SharedIndexCompression compression = sharedIndexCompression;
        SharedIndexMetadata sharedIndexMetadata = SharedIndexMetadata.Companion.tryReadSharedIndexMetadata(indexVersionJson);
        if (sharedIndexMetadata == null) {
            return null;
        }
        SharedIndexMetadata indexVersion = sharedIndexMetadata;
        return new SharedIndexLookupResult($request, url, (String)sha, size, compression, indexVersion, lineup);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexLookup$CacheEntry;", "", "ideVersion", "Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "computed", "Ljava/time/Instant;", "value", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "<init>", "(Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;Ljava/time/Instant;Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;)V", "getIdeVersion", "()Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "getComputed", "()Ljava/time/Instant;", "getValue", "()Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.indexing.shared"})
    private static final class CacheEntry {
        @NotNull
        private final SharedIndexInfrastructureVersion ideVersion;
        @NotNull
        private final Instant computed;
        @Nullable
        private final SharedIndexLookupResult value;

        public CacheEntry(@NotNull SharedIndexInfrastructureVersion ideVersion, @NotNull Instant computed, @Nullable SharedIndexLookupResult value) {
            Intrinsics.checkNotNullParameter((Object)((Object)ideVersion), (String)"ideVersion");
            Intrinsics.checkNotNullParameter((Object)computed, (String)"computed");
            this.ideVersion = ideVersion;
            this.computed = computed;
            this.value = value;
        }

        @NotNull
        public final SharedIndexInfrastructureVersion getIdeVersion() {
            return this.ideVersion;
        }

        @NotNull
        public final Instant getComputed() {
            return this.computed;
        }

        @Nullable
        public final SharedIndexLookupResult getValue() {
            return this.value;
        }

        @NotNull
        public final SharedIndexInfrastructureVersion component1() {
            return this.ideVersion;
        }

        @NotNull
        public final Instant component2() {
            return this.computed;
        }

        @Nullable
        public final SharedIndexLookupResult component3() {
            return this.value;
        }

        @NotNull
        public final CacheEntry copy(@NotNull SharedIndexInfrastructureVersion ideVersion, @NotNull Instant computed, @Nullable SharedIndexLookupResult value) {
            Intrinsics.checkNotNullParameter((Object)((Object)ideVersion), (String)"ideVersion");
            Intrinsics.checkNotNullParameter((Object)computed, (String)"computed");
            return new CacheEntry(ideVersion, computed, value);
        }

        public static /* synthetic */ CacheEntry copy$default(CacheEntry cacheEntry, SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion, Instant instant, SharedIndexLookupResult sharedIndexLookupResult, int n, Object object) {
            if ((n & 1) != 0) {
                sharedIndexInfrastructureVersion = cacheEntry.ideVersion;
            }
            if ((n & 2) != 0) {
                instant = cacheEntry.computed;
            }
            if ((n & 4) != 0) {
                sharedIndexLookupResult = cacheEntry.value;
            }
            return cacheEntry.copy(sharedIndexInfrastructureVersion, instant, sharedIndexLookupResult);
        }

        @NotNull
        public String toString() {
            return "CacheEntry(ideVersion=" + this.ideVersion + ", computed=" + this.computed + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result = this.ideVersion.hashCode();
            result = result * 31 + this.computed.hashCode();
            result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheEntry)) {
                return false;
            }
            CacheEntry cacheEntry = (CacheEntry)other;
            if (!Intrinsics.areEqual((Object)((Object)this.ideVersion), (Object)((Object)cacheEntry.ideVersion))) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.computed, (Object)cacheEntry.computed)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)cacheEntry.value);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexLookup$Companion;", "", "<init>", "()V", "resolveRelativeUrl", "", "indexUrl", "relative", "intellij.indexing.shared"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String resolveRelativeUrl(@NotNull String indexUrl, @NotNull String relative) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)indexUrl, (String)"indexUrl");
            Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
            if (StringsKt.startsWith$default((String)relative, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)relative, (String)"https://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)relative, (String)"file:/", (boolean)false, (int)2, null)) {
                return relative;
            }
            try {
                object = new char[]{'/'};
                object = URI.create(StringsKt.trimEnd((String)indexUrl, (char[])object)).resolve(relative).toURL().toExternalForm();
            }
            catch (Throwable t) {
                SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to resolve relative URL " + relative + " with base " + indexUrl);
                object = null;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

