/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.download.SharedIndexAuthHolder;
import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.impl.SharedIndexesFusCollector;
import com.intellij.indexing.shared.util.DownloadUtilKt;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.indexing.diagnostic.SharedIndexDiagnostic;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0019\u0010\t\u001a\u00020\u0001*\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\f\u001a?\u0010\r\u001a\u00020\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015\u001a?\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015\u001a:\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002\u00a8\u0006\u001e"}, d2={"downloadChunk", "", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "targetFile", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "isCancelled", "Lkotlin/Result;", "", "(Ljava/lang/Object;)Z", "processCancelledDownload", "", "request", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "result", "downloadResult", "downloadTime", "Ljava/util/concurrent/atomic/AtomicLong;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;Ljava/lang/Object;Ljava/util/concurrent/atomic/AtomicLong;)V", "processFailedDownload", "processSuccessfulDownload", "sharedIndexSize", "tryExtractMetadata", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "toSpeedKBytesPerSecond", "size", "durationNano", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexLookupResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexLookupResult.kt\ncom/intellij/indexing/shared/download/SharedIndexLookupResultKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 SharedIndexesNetwork.kt\ncom/intellij/indexing/shared/download/SharedIndexesNetworkKt\n*L\n1#1,221:1\n42#2,3:222\n13#3,41:225\n*S KotlinDebug\n*F\n+ 1 SharedIndexLookupResult.kt\ncom/intellij/indexing/shared/download/SharedIndexLookupResultKt\n*L\n64#1:222,3\n69#1:225,41\n*E\n"})
public final class SharedIndexLookupResultKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final boolean downloadChunk(@NotNull SharedIndexLookupResult $this$downloadChunk, @NotNull Path targetFile, @Nullable Project project, @NotNull ProgressIndicator indicator) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$downloadChunk, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Object[] objectArray = new Object[]{$this$downloadChunk.getRequest().getPresentableChunkName()};
        String string = SharedIndexesBundle.message("downloading.shared.indexes", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        if (indicator instanceof SubTaskProgressIndicator) {
            ((SubTaskProgressIndicator)indicator).setText(message);
        } else {
            indicator.setText(message);
            indicator.setText2(null);
        }
        SharedIndexesFusCollector.INSTANCE.reportIndexDownloadStarted(project, $this$downloadChunk.getRequest().getKind(), $this$downloadChunk.getChunkUniqueId());
        boolean $i$f$service = false;
        Class<SharedIndexAuthHolder> serviceClass$iv = SharedIndexAuthHolder.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Map<String, String> headers = ((SharedIndexAuthHolder)object2).resolveHeaders($this$downloadChunk.getUrl(), $this$downloadChunk.getRequest(), indicator);
        AtomicLong downloadTime = new AtomicLong(System.nanoTime());
        SharedIndexLookupResult sharedIndexLookupResult = $this$downloadChunk;
        try {
            SharedIndexLookupRequest sharedIndexLookupRequest;
            SharedIndexLookupResult $this$downloadChunk_u24lambda_u240 = sharedIndexLookupResult;
            boolean bl = false;
            try {
                Long l;
                block30: {
                    void request$iv;
                    sharedIndexLookupRequest = $this$downloadChunk_u24lambda_u240.getRequest();
                    String url$iv = $this$downloadChunk_u24lambda_u240.getUrl();
                    boolean $i$f$handleHttpDownloadExceptions = false;
                    try {
                        boolean bl2 = false;
                        l = DownloadUtilKt.downloadUrlWithValidation($this$downloadChunk_u24lambda_u240.getUrl(), targetFile, $this$downloadChunk_u24lambda_u240.getSize(), $this$downloadChunk_u24lambda_u240.getSha256(), headers, $this$downloadChunk_u24lambda_u240.getCompression(), indicator);
                        break block30;
                    }
                    catch (ConnectException e$iv) {
                        SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Cannot connect to the host for " + url$iv + " for " + request$iv + ". " + e$iv.getMessage(), (Throwable)e$iv);
                    }
                    catch (UnknownHostException e$iv) {
                        SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Cannot resolve host for " + url$iv + " for " + request$iv + ". " + e$iv.getMessage(), (Throwable)e$iv);
                    }
                    catch (SocketTimeoutException e$iv) {
                        if (SharedIndexDownloadLoggerKt.getDownloadLogger().isDebugEnabled()) {
                            SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Connection expired by timeout at " + url$iv + " for " + request$iv + ". Error: " + e$iv.getMessage() + ".", (Throwable)e$iv);
                        } else {
                            SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Connection expired by timeout at " + url$iv + " for " + request$iv + ". Error: " + e$iv.getMessage() + ".");
                        }
                    }
                    catch (HttpRequests.HttpStatusException e$iv) {
                        if (e$iv.getStatusCode() < 500) {
                            SharedIndexDownloadLoggerKt.getDownloadLogger().debug("No data available for " + url$iv + " for " + request$iv + ". " + e$iv.getStatusCode(), (Throwable)e$iv);
                        } else {
                            SharedIndexDownloadLoggerKt.getDownloadLogger().info("No data available for " + url$iv + " for " + request$iv + ". " + e$iv.getStatusCode(), (Throwable)e$iv);
                        }
                    }
                    catch (IOException e$iv) {
                        if (SharedIndexDownloadLoggerKt.getDownloadLogger().isDebugEnabled()) {
                            Serializable serializable;
                            Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
                            String string2 = e$iv.getMessage();
                            if (string2 != null) {
                                serializable = (Serializable)((Object)string2);
                            } else {
                                Throwable throwable = e$iv.getCause();
                                String string3 = throwable != null ? throwable.getMessage() : null;
                                serializable = string3 != null ? (Serializable)((Object)string3) : (Serializable)e$iv.getClass();
                            }
                            logger.warn("Failed to download " + url$iv + " for " + request$iv + ". Error: " + serializable, (Throwable)e$iv);
                        } else {
                            Serializable serializable;
                            Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
                            String string4 = e$iv.getMessage();
                            if (string4 != null) {
                                serializable = (Serializable)((Object)string4);
                            } else {
                                Throwable throwable = e$iv.getCause();
                                String string5 = throwable != null ? throwable.getMessage() : null;
                                serializable = string5 != null ? (Serializable)((Object)string5) : (Serializable)e$iv.getClass();
                            }
                            logger.warn("Failed to download " + url$iv + " for " + request$iv + ". Error: " + serializable);
                        }
                    }
                    catch (Throwable t$iv) {
                        Serializable serializable;
                        if (t$iv instanceof ControlFlowException) {
                            throw t$iv;
                        }
                        Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
                        Class<?> clazz = t$iv.getClass();
                        String string6 = t$iv.getMessage();
                        if (string6 != null) {
                            serializable = (Serializable)((Object)string6);
                        } else {
                            Throwable throwable = t$iv.getCause();
                            String string7 = throwable != null ? throwable.getMessage() : null;
                            serializable = string7 != null ? (Serializable)((Object)string7) : (Serializable)t$iv.getClass();
                        }
                        logger.warn("Failed to download " + url$iv + " due " + clazz + " for " + request$iv + ". Error: " + serializable);
                    }
                    l = null;
                }
                sharedIndexLookupRequest = l;
            }
            finally {
                downloadTime.set(System.nanoTime() - downloadTime.get());
            }
            object = Result.constructor-impl((Object)sharedIndexLookupRequest);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object downloadResult = object;
        Long sharedIndexSize = (Long)(Result.isFailure-impl((Object)downloadResult) ? null : downloadResult);
        if (SharedIndexLookupResultKt.isCancelled(downloadResult)) {
            SharedIndexLookupResultKt.processCancelledDownload(project, $this$downloadChunk.getRequest(), $this$downloadChunk, downloadResult, downloadTime);
            return false;
        }
        if (Result.isFailure-impl((Object)downloadResult) || sharedIndexSize == null || sharedIndexSize <= 0L) {
            SharedIndexLookupResultKt.processFailedDownload(project, $this$downloadChunk.getRequest(), $this$downloadChunk, downloadResult, downloadTime);
            return false;
        }
        SharedIndexLookupResultKt.processSuccessfulDownload(project, $this$downloadChunk.getRequest(), $this$downloadChunk, targetFile, sharedIndexSize, downloadTime);
        return true;
    }

    private static final boolean isCancelled(Object $this$isCancelled) {
        return Result.isFailure-impl((Object)$this$isCancelled) && Result.exceptionOrNull-impl((Object)$this$isCancelled) instanceof ControlFlowException;
    }

    private static final void processCancelledDownload(Project project, SharedIndexLookupRequest request, SharedIndexLookupResult result, Object downloadResult, AtomicLong downloadTime) {
        SharedIndexesFusCollector.INSTANCE.reportIndexDownloadFinished(project, SharedIndexesFusCollector.FinishType.CANCELLED, request.getKind(), result.getChunkUniqueId(), TimeUnit.NANOSECONDS.toMillis(downloadTime.get()), result.getSize(), 0L, SharedIndexLookupResultKt.toSpeedKBytesPerSecond(result.getSize(), downloadTime.get()));
        String string = request.getKind();
        String string2 = result.getChunkUniqueId();
        String string3 = "CANCELLED".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        SharedIndexDiagnostic.INSTANCE.onIndexDownloaded(project, string, string2, string3, downloadTime.get(), result.getSize(), 0L, null);
        Throwable throwable = Result.exceptionOrNull-impl((Object)downloadResult);
        Intrinsics.checkNotNull((Object)throwable);
        Throwable exception = throwable;
        SharedIndexDownloadLoggerKt.getDownloadLogger().info("Shared index download interrupted because of " + exception.getClass().getName());
        throw exception;
    }

    private static final void processFailedDownload(Project project, SharedIndexLookupRequest request, SharedIndexLookupResult result, Object downloadResult, AtomicLong downloadTime) {
        block0: {
            Throwable throwable;
            SharedIndexesFusCollector.INSTANCE.reportIndexDownloadFinished(project, SharedIndexesFusCollector.FinishType.ERROR, request.getKind(), result.getChunkUniqueId(), TimeUnit.NANOSECONDS.toMillis(downloadTime.get()), result.getSize(), 0L, SharedIndexLookupResultKt.toSpeedKBytesPerSecond(result.getSize(), downloadTime.get()));
            String string = request.getKind();
            String string2 = result.getChunkUniqueId();
            String string3 = "ERROR".toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            SharedIndexDiagnostic.INSTANCE.onIndexDownloaded(project, string, string2, string3, downloadTime.get(), result.getSize(), 0L, null);
            Object object = downloadResult;
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) break block0;
            Throwable it = throwable = throwable2;
            boolean bl = false;
            SharedIndexDownloadLoggerKt.getDownloadLogger().error(it);
        }
    }

    private static final void processSuccessfulDownload(Project project, SharedIndexLookupRequest request, SharedIndexLookupResult result, Path targetFile, long sharedIndexSize, AtomicLong downloadTime) {
        SharedIndexMetadata metadata;
        SharedIndexesFusCollector.INSTANCE.reportIndexDownloadFinished(project, SharedIndexesFusCollector.FinishType.SUCCESS, request.getKind(), result.getChunkUniqueId(), TimeUnit.NANOSECONDS.toMillis(downloadTime.get()), result.getSize(), sharedIndexSize, SharedIndexLookupResultKt.toSpeedKBytesPerSecond(result.getSize(), downloadTime.get()));
        SharedIndexMetadata sharedIndexMetadata = metadata = SharedIndexLookupResultKt.tryExtractMetadata(targetFile);
        ZonedDateTime generationStamp = sharedIndexMetadata != null ? sharedIndexMetadata.getGenerationTime() : null;
        Object object = metadata;
        if (object == null || (object = ((SharedIndexMetadata)object).getIndexKind()) == null) {
            object = request.getKind();
        }
        Object kind = object;
        String string = result.getChunkUniqueId();
        String string2 = "SUCCESS".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        SharedIndexDiagnostic.INSTANCE.onIndexDownloaded(project, (String)kind, string, string2, downloadTime.get(), result.getSize(), sharedIndexSize, generationStamp);
        String dlSpeed = new DecimalFormat("0.##").format((double)sharedIndexSize / 1000.0 / (double)downloadTime.get());
        String string3 = StringUtil.formatFileSize((long)sharedIndexSize);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"formatFileSize(...)");
        String size = string3;
        String string4 = StringUtil.formatDuration((long)TimeUnit.NANOSECONDS.toMillis(downloadTime.get()));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"formatDuration(...)");
        String duration = string4;
        SharedIndexDownloadLoggerKt.getDownloadLogger().info("Chunk " + result.getChunkUniqueId() + " is downloaded (" + size + " in " + duration + ": " + dlSpeed + " MB/s)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SharedIndexMetadata tryExtractMetadata(Path targetFile) {
        Object object;
        try {
            SharedIndexMetadata sharedIndexMetadata;
            boolean bl = false;
            Closeable closeable = UncompressedZipFileSystem.create(targetFile);
            Throwable throwable = null;
            try {
                UncompressedZipFileSystem it = (UncompressedZipFileSystem)closeable;
                boolean bl2 = false;
                Path path = it.getRootDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getRootDirectory(...)");
                sharedIndexMetadata = SharedIndexMetadata.Companion.readSharedIndexMetadata(path);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            object = Result.constructor-impl((Object)sharedIndexMetadata);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (SharedIndexMetadata)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static final long toSpeedKBytesPerSecond(long size, long durationNano) {
        long millis = TimeUnit.NANOSECONDS.toMillis(durationNano);
        if (millis == 0L) {
            return 0L;
        }
        double kbPerMs = (double)(size / (long)1024) / (double)millis;
        return (long)(kbPerMs * (double)1000);
    }
}

