/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.hash;

import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.io.ScannableDataEnumeratorEx;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\r0\r2\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentEnumerators;", "", "<init>", "()V", "hashFileName", "", "isRelatedToEnumerator", "", "path", "getHashEnumeratorPath", "Ljava/nio/file/Path;", "chunkRootPath", "openEnumeratorForAttachedSharedIndex", "Lcom/intellij/util/hash/ContentHashEnumerator;", "newEnumeratorForGenerator", "kotlin.jvm.PlatformType", "intellij.indexing.shared"})
public final class SharedIndexContentEnumerators {
    @NotNull
    public static final SharedIndexContentEnumerators INSTANCE = new SharedIndexContentEnumerators();
    @NotNull
    private static final String hashFileName = "hashes";

    private SharedIndexContentEnumerators() {
    }

    public final boolean isRelatedToEnumerator(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.startsWith$default((String)path, (String)hashFileName, (boolean)false, (int)2, null);
    }

    @NotNull
    public final Path getHashEnumeratorPath(@NotNull Path chunkRootPath) {
        Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
        Path path = chunkRootPath.resolve(hashFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final ContentHashEnumerator openEnumeratorForAttachedSharedIndex(@NotNull Path chunkRootPath) {
        Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
        return new ContentHashEnumerator(chunkRootPath){
            private final /* synthetic */ ContentHashEnumerator $$delegate_0;
            {
                this.$$delegate_0 = ContentHashEnumerator.open((Path)SharedIndexContentEnumerators.INSTANCE.getHashEnumeratorPath($chunkRootPath));
            }

            public int enumerate(byte[] value) {
                throw new UnsupportedOperationException("Enumerator is read-only");
            }

            public int enumerateEx(byte[] p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return this.$$delegate_0.enumerateEx(p0);
            }

            public byte[] valueOf(int p0) {
                return this.$$delegate_0.valueOf(p0);
            }

            public int tryEnumerate(@Nullable byte[] p0) {
                return this.$$delegate_0.tryEnumerate((Object)p0);
            }

            public void close() {
                this.$$delegate_0.close();
            }

            public boolean isDirty() {
                return this.$$delegate_0.isDirty();
            }

            public void force() {
                this.$$delegate_0.force();
            }

            public boolean forEach(@NotNull ScannableDataEnumeratorEx.ValueReader<? super byte[]> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return this.$$delegate_0.forEach(p0);
            }

            public int recordsCount() {
                return this.$$delegate_0.recordsCount();
            }

            public void closeAndClean() {
                this.$$delegate_0.closeAndClean();
            }
        };
    }

    public final ContentHashEnumerator newEnumeratorForGenerator(@NotNull Path chunkRootPath) {
        Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
        return ContentHashEnumerator.open((Path)this.getHashEnumeratorPath(chunkRootPath));
    }
}

