/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.hash;

import com.intellij.indexing.shared.platform.hash.HashKeyDescriptor;
import com.intellij.indexing.shared.platform.hash.InternalHashIdExternalizer;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashEnumerator;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashStorage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentMapBuilder;
import com.intellij.util.io.PersistentMapImpl;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0012H\u0016R\u0014\u0010\r\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\u001e\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00140\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/indexing/shared/platform/hash/SharedIndexHashStorageImpl;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashEnumerator;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexHashStorage;", "path", "Ljava/nio/file/Path;", "hash", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "readonly", "", "lifetime", "Lcom/intellij/openapi/Disposable;", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;ZLcom/intellij/openapi/Disposable;)V", "info", "getInfo", "()Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "storage", "Lcom/intellij/util/io/PersistentMapImpl;", "", "kotlin.jvm.PlatformType", "", "enumerate", "", "key", "value", "tryEnumerate", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexHashStorageImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexHashStorageImpl.kt\ncom/intellij/indexing/shared/platform/hash/SharedIndexHashStorageImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
final class SharedIndexHashStorageImpl
implements SharedIndexContentHashEnumerator,
SharedIndexHashStorage {
    @NotNull
    private final SharedIndexContentHash info;
    @NotNull
    private final PersistentMapImpl<byte[], Integer> storage;

    /*
     * WARNING - void declaration
     */
    public SharedIndexHashStorageImpl(@NotNull Path path, @NotNull SharedIndexContentHash hash, boolean readonly, @NotNull Disposable lifetime) {
        void it;
        PersistentMapImpl persistentMapImpl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.info = hash;
        PersistentMapImpl persistentMapImpl2 = persistentMapImpl = new PersistentMapImpl(PersistentMapBuilder.newBuilder((Path)path, (KeyDescriptor)new HashKeyDescriptor(hash.getHashLength()), (DataExternalizer)((DataExternalizer)InternalHashIdExternalizer.INSTANCE)).withReadonly(readonly).withCompactOnClose(!readonly));
        SharedIndexHashStorageImpl sharedIndexHashStorageImpl = this;
        boolean bl = false;
        Disposer.register((Disposable)lifetime, () -> SharedIndexHashStorageImpl.storage$lambda$0$0((PersistentMapImpl)it));
        sharedIndexHashStorageImpl.storage = persistentMapImpl;
    }

    @Override
    @NotNull
    public SharedIndexContentHash getInfo() {
        return this.info;
    }

    @Override
    public void enumerate(@NotNull byte[] key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!(value != 0)) {
            boolean bl = false;
            String string = "Value = 0, it cannot be persisted as we use 0 as 'null' replacement";
            throw new IllegalArgumentException(string.toString());
        }
        Integer oldValue = (Integer)this.storage.get((Object)key);
        if (oldValue != null && oldValue != 0) {
            int n = value;
            if (oldValue != n) {
                this.storage.remove((Object)key);
                throw new RuntimeException("Old value for " + StringUtil.toHexString((byte[])key) + " is " + oldValue + " != " + value + ". Could it be that this provider returns different values for the files which have the same hash with the main hash provider? A weaker hash provider may cause incorrect mapping between a file and a shared index, this key is ignored to avoid it");
            }
        }
        this.storage.put((Object)key, (Object)value);
    }

    @Override
    public int tryEnumerate(@NotNull byte[] hash) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Integer n = (Integer)this.storage.get((Object)hash);
        return n != null ? n : 0;
    }

    private static final void storage$lambda$0$0(PersistentMapImpl $it) {
        $it.close();
    }
}

