/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.download.SharedIndexLineup;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.metadata.SharedIndexMetadataInfo;
import com.intellij.indexing.shared.platform.api.ReplaceableSharedIndexStorage;
import com.intellij.indexing.shared.platform.api.SharedIndexStats;
import com.intellij.indexing.shared.platform.api.layout.SharedChunkLocation;
import com.intellij.indexing.shared.platform.impl.layout.FileBasedSharedChunkLocation;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\b\u0010 \u001a\u00020\u001dH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010&\u001a\u00020\u001dH\u0016J!\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*H\u0002\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0006H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0016\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R+\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/indexing/shared/platform/impl/ReplaceableZipStorage;", "Lcom/intellij/indexing/shared/platform/api/ReplaceableSharedIndexStorage;", "chunkId", "", "lineup", "storageDir", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;)V", "getChunkId", "()Ljava/lang/String;", "getLineup", "storagePath", "kotlin.jvm.PlatformType", "zipStorage", "Lcom/intellij/indexing/shared/util/zipFs/UncompressedZipFileSystem;", "<set-?>", "", "generation", "getGeneration", "()J", "setGeneration", "(J)V", "generation$delegate", "Lkotlin/properties/ReadWriteProperty;", "deleted", "", "closed", "replaceChunk", "", "newChunk", "openZip", "deleteStorage", "getSharedIndexStats", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStats;", "isCompatibleChunk", "getChunkRoot", "Lcom/intellij/indexing/shared/platform/api/layout/SharedChunkLocation;", "close", "ensureValid", "T", "operation", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "readGeneration", "chunkRoot", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nReplaceableZipStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceableZipStorage.kt\ncom/intellij/indexing/shared/platform/impl/ReplaceableZipStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class ReplaceableZipStorage
implements ReplaceableSharedIndexStorage {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String chunkId;
    @NotNull
    private final String lineup;
    private final Path storagePath;
    private UncompressedZipFileSystem zipStorage;
    @NotNull
    private final ReadWriteProperty generation$delegate;
    private boolean deleted;
    private boolean closed;

    public ReplaceableZipStorage(@NotNull String chunkId, @NotNull String lineup, @NotNull Path storageDir) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Intrinsics.checkNotNullParameter((Object)lineup, (String)"lineup");
        Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
        this.chunkId = chunkId;
        this.lineup = lineup;
        this.storagePath = storageDir.resolve(this.getChunkId() + "-" + this.getLineup() + ".ijx");
        this.generation$delegate = Delegates.INSTANCE.notNull();
        this.openZip();
    }

    @Override
    @NotNull
    public String getChunkId() {
        return this.chunkId;
    }

    @Override
    @NotNull
    public String getLineup() {
        return this.lineup;
    }

    @Override
    public long getGeneration() {
        return ((Number)this.generation$delegate.getValue((Object)this, $$delegatedProperties[0])).longValue();
    }

    public void setGeneration(long l) {
        this.generation$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)l);
    }

    @Override
    public void replaceChunk(@NotNull Path newChunk) throws IOException {
        Intrinsics.checkNotNullParameter((Object)newChunk, (String)"newChunk");
        this.ensureValid(() -> ReplaceableZipStorage.replaceChunk$lambda$0(this, newChunk));
    }

    private final void openZip() {
        UncompressedZipFileSystem uncompressedZipFileSystem = UncompressedZipFileSystem.create(this.storagePath);
        Intrinsics.checkNotNullExpressionValue((Object)uncompressedZipFileSystem, (String)"create(...)");
        this.zipStorage = uncompressedZipFileSystem;
        UncompressedZipFileSystem uncompressedZipFileSystem2 = this.zipStorage;
        if (uncompressedZipFileSystem2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"zipStorage");
            uncompressedZipFileSystem2 = null;
        }
        Path path = uncompressedZipFileSystem2.getRootDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getRootDirectory(...)");
        this.setGeneration(this.readGeneration(path));
    }

    @Override
    public void deleteStorage() {
        this.ensureValid(() -> ReplaceableZipStorage.deleteStorage$lambda$0(this));
    }

    @Override
    @NotNull
    public SharedIndexStats getSharedIndexStats() {
        return (SharedIndexStats)this.ensureValid(() -> ReplaceableZipStorage.getSharedIndexStats$lambda$0(this));
    }

    @Override
    public boolean isCompatibleChunk(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        return (Boolean)this.ensureValid(() -> ReplaceableZipStorage.isCompatibleChunk$lambda$0(this, chunkId));
    }

    @Override
    @NotNull
    public SharedChunkLocation getChunkRoot(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        return (SharedChunkLocation)this.ensureValid(() -> ReplaceableZipStorage.getChunkRoot$lambda$0(this));
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private final <T> T ensureValid(Function0<? extends T> operation) {
        boolean bl;
        boolean bl2 = bl = !this.closed && !this.deleted;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return (T)operation.invoke();
    }

    private final long readGeneration(Path chunkRoot) {
        Object object = SharedIndexMetadata.Companion.readSharedIndexMetadata(chunkRoot);
        if (object == null || (object = ((SharedIndexMetadata)object).getSharedIndexInfo()) == null || (object = ((SharedIndexMetadataInfo)object).getLineup()) == null) {
            throw new IOException("can't read generation stamp");
        }
        return ((SharedIndexLineup)object).getCreationStamp();
    }

    private static final Unit replaceChunk$lambda$0(ReplaceableZipStorage this$0, Path $newChunk) {
        UncompressedZipFileSystem uncompressedZipFileSystem = this$0.zipStorage;
        if (uncompressedZipFileSystem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"zipStorage");
            uncompressedZipFileSystem = null;
        }
        uncompressedZipFileSystem.close();
        Path path = this$0.storagePath;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"storagePath");
        PathKt.copy((Path)$newChunk, (Path)path);
        this$0.openZip();
        return Unit.INSTANCE;
    }

    private static final Unit deleteStorage$lambda$0(ReplaceableZipStorage this$0) {
        this$0.close();
        this$0.deleted = true;
        return Unit.INSTANCE;
    }

    private static final SharedIndexStats getSharedIndexStats$lambda$0(ReplaceableZipStorage this$0) {
        Object object;
        Object object2 = this$0;
        try {
            ReplaceableZipStorage $this$getSharedIndexStats_u24lambda_u240_u240 = object2;
            boolean bl = false;
            Path path = $this$getSharedIndexStats_u24lambda_u240_u240.storagePath;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"storagePath");
            object = Result.constructor-impl((Object)Files.size(path));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = 0L;
        long size = ((Number)(Result.isFailure-impl((Object)object2) ? object : object2)).longValue();
        return new SharedIndexStats(size, 1);
    }

    private static final boolean isCompatibleChunk$lambda$0(ReplaceableZipStorage this$0, String $chunkId) {
        return Intrinsics.areEqual((Object)this$0.getChunkId(), (Object)$chunkId);
    }

    private static final FileBasedSharedChunkLocation getChunkRoot$lambda$0(ReplaceableZipStorage this$0) {
        UncompressedZipFileSystem uncompressedZipFileSystem = this$0.zipStorage;
        if (uncompressedZipFileSystem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"zipStorage");
            uncompressedZipFileSystem = null;
        }
        Path path = uncompressedZipFileSystem.getRootDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getRootDirectory(...)");
        return new FileBasedSharedChunkLocation(path);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ReplaceableZipStorage.class, "generation", "getGeneration()J", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

