/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.AttachChunkResult;
import com.intellij.indexing.shared.platform.api.layout.SharedChunkLocation;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashEnumerator;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.indexing.shared.platform.impl.ChunkManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexedFile;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB)\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0010H\u0002J\b\u0010\u001d\u001a\u00020\u0012H\u0016R \u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0019j\b\u0012\u0004\u0012\u00020\u0014`\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexChunk;", "Lcom/intellij/openapi/Disposable;", "hashEnumerators", "", "Lkotlin/Pair;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashEnumerator;", "indexAttachChunkResult", "Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;", "<init>", "(Ljava/util/List;Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;)V", "getIndexAttachChunkResult", "()Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;", "tryEnumerate", "", "fileContent", "Lcom/intellij/util/indexing/IndexedFile;", "attachProject", "", "project", "Lcom/intellij/openapi/project/Project;", "detachProject", "isContentBased", "", "attachedProjects", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getAttachedProjects", "()Ljava/util/HashSet;", "dispose", "Companion", "intellij.indexing.shared"})
@VisibleForTesting
public final class SharedIndexChunk
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Pair<SharedIndexContentHashProvider, SharedIndexContentHashEnumerator>> hashEnumerators;
    @NotNull
    private final AttachChunkResult indexAttachChunkResult;
    @NotNull
    private final HashSet<Project> attachedProjects;

    public SharedIndexChunk(@NotNull List<? extends Pair<? extends SharedIndexContentHashProvider, ? extends SharedIndexContentHashEnumerator>> hashEnumerators, @NotNull AttachChunkResult indexAttachChunkResult) {
        Intrinsics.checkNotNullParameter(hashEnumerators, (String)"hashEnumerators");
        Intrinsics.checkNotNullParameter((Object)indexAttachChunkResult, (String)"indexAttachChunkResult");
        this.hashEnumerators = hashEnumerators;
        this.indexAttachChunkResult = indexAttachChunkResult;
        this.attachedProjects = new HashSet();
    }

    @NotNull
    public final AttachChunkResult getIndexAttachChunkResult() {
        return this.indexAttachChunkResult;
    }

    public final int tryEnumerate(@NotNull IndexedFile fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        for (Pair<SharedIndexContentHashProvider, SharedIndexContentHashEnumerator> pair : this.hashEnumerators) {
            byte[] byArray;
            SharedIndexContentHashProvider hashProvider = (SharedIndexContentHashProvider)pair.component1();
            SharedIndexContentHashEnumerator hashEnumerator = (SharedIndexContentHashEnumerator)pair.component2();
            if (hashProvider.getInfo().getContentBased() && !this.isContentBased(fileContent)) continue;
            try {
                if (hashProvider.computeHash(fileContent) == null) continue;
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Exception e) {
                ChunkManagerKt.access$getLOG$p().error((Throwable)e);
                continue;
            }
            byte[] hash = byArray;
            int hashId = hashEnumerator.tryEnumerate(hash);
            if (hashId == 0) continue;
            return hashId;
        }
        return 0;
    }

    public final void attachProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.attachedProjects.add(project);
    }

    public final void detachProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.attachedProjects.remove(project);
    }

    private final boolean isContentBased(IndexedFile $this$isContentBased) {
        return $this$isContentBased instanceof FileContentImpl;
    }

    @NotNull
    public final HashSet<Project> getAttachedProjects() {
        return this.attachedProjects;
    }

    public void dispose() {
    }

    @JvmStatic
    @NotNull
    public static final SharedIndexChunk formChunkLocation(@NotNull SharedChunkLocation chunkLocation, @NotNull AttachChunkResult indexAttachChunkResult) {
        return Companion.formChunkLocation(chunkLocation, indexAttachChunkResult);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexChunk$Companion;", "", "<init>", "()V", "formChunkLocation", "Lcom/intellij/indexing/shared/platform/impl/SharedIndexChunk;", "chunkLocation", "Lcom/intellij/indexing/shared/platform/api/layout/SharedChunkLocation;", "indexAttachChunkResult", "Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;", "intellij.indexing.shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SharedIndexChunk formChunkLocation(@NotNull SharedChunkLocation chunkLocation, @NotNull AttachChunkResult indexAttachChunkResult) {
            SharedIndexChunk sharedIndexChunk;
            Intrinsics.checkNotNullParameter((Object)chunkLocation, (String)"chunkLocation");
            Intrinsics.checkNotNullParameter((Object)indexAttachChunkResult, (String)"indexAttachChunkResult");
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable disposable2 = disposable;
            List<Pair<SharedIndexContentHashProvider, SharedIndexContentHashEnumerator>> hashEnumerators = chunkLocation.createContentHashEnumerators(disposable2);
            SharedIndexChunk chunk = sharedIndexChunk = new SharedIndexChunk(hashEnumerators, indexAttachChunkResult);
            boolean bl = false;
            Disposer.register((Disposable)chunk, (Disposable)disposable2);
            return sharedIndexChunk;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

