/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonCommonUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.angular2.cli.AngularCliSchematicsRegistryService;
import org.angular2.cli.AngularCliUtil;
import org.angular2.inspections.quickfixes.AngularCliAddQuickFix;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/angular2/inspections/AngularCliAddDependencyInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isEnabledByDefault", "annotate", "", "file", "Lcom/intellij/json/psi/JsonFile;", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "element", "Lcom/intellij/json/psi/JsonValue;", "Companion", "intellij.angular.backend"})
public final class AngularCliAddDependencyInspection
extends LocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long TIMEOUT = 2000L;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new JsonElementVisitor(this, holder){
            final /* synthetic */ AngularCliAddDependencyInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitFile(PsiFile psiFile) {
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                JsonFile packageJson = PackageJsonCommonUtil.asPackageJsonFile((PsiFile)psiFile);
                if (packageJson != null && AngularCliUtil.findCliJson(psiFile.getVirtualFile().getParent()) != null) {
                    AngularCliAddDependencyInspection.access$annotate(this.this$0, packageJson, this.$holder);
                }
            }
        };
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private final void annotate(JsonFile file, ProblemsHolder holder) {
        VirtualFile packageJson = file.getVirtualFile();
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (packageJson == null || !JSLibraryUtil.isInProjectAndOutsideOfLibraryRoots((Project)project2, (VirtualFile)packageJson)) {
            return;
        }
        List list = PackageJsonCommonUtil.getDependencies((JsonFile)file, (Collection)PackageJsonUtil.PROD_DEV_DEPENDENCIES);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDependencies(...)");
        List properties = list;
        if (properties.isEmpty()) {
            return;
        }
        NodeInstalledPackageFinder finder = new NodeInstalledPackageFinder(project2, packageJson);
        for (JsonProperty property : properties) {
            LocalQuickFix[] localQuickFixArray;
            String packageName;
            JsonStringLiteral versionLiteral;
            JsonValue jsonValue = property.getNameElement();
            JsonStringLiteral nameLiteral = jsonValue instanceof JsonStringLiteral ? (JsonStringLiteral)jsonValue : null;
            JsonValue jsonValue2 = property.getValue();
            JsonStringLiteral jsonStringLiteral = versionLiteral = jsonValue2 instanceof JsonStringLiteral ? (JsonStringLiteral)jsonValue2 : null;
            if (nameLiteral == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)property.getName(), (String)"getName(...)");
            Object object = versionLiteral;
            if (object == null || (object = object.getValue()) == null) {
                object = "";
            }
            Object version = object;
            InstalledPackageVersion pkgVersion = finder.findInstalledPackage(packageName);
            AngularCliSchematicsRegistryService schematicsRegistryService = AngularCliSchematicsRegistryService.Companion.getInstance(project2);
            if ((pkgVersion == null || !schematicsRegistryService.supportsNgAdd(pkgVersion)) && (pkgVersion != null || !schematicsRegistryService.supportsNgAdd(packageName, 2000L))) continue;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.wrapWithDoubleQuote((String)packageName), (String)"wrapWithDoubleQuote(...)");
            String message = Angular2Bundle.Companion.message("angular.inspection.install-with-ng-add.message", objectArray);
            AngularCliAddQuickFix quickFix = new AngularCliAddQuickFix(packageJson, packageName, (String)version, pkgVersion != null);
            if (versionLiteral != null) {
                if (pkgVersion == null) {
                    localQuickFixArray = new LocalQuickFix[]{quickFix};
                    holder.registerProblem((PsiElement)versionLiteral, this.getTextRange((JsonValue)versionLiteral), message, localQuickFixArray);
                } else if (holder.isOnTheFly()) {
                    localQuickFixArray = new LocalQuickFix[]{quickFix};
                    holder.registerProblem((PsiElement)versionLiteral, message, ProblemHighlightType.INFORMATION, localQuickFixArray);
                }
            }
            if (!holder.isOnTheFly()) continue;
            localQuickFixArray = new LocalQuickFix[]{quickFix};
            holder.registerProblem((PsiElement)nameLiteral, message, ProblemHighlightType.INFORMATION, localQuickFixArray);
        }
    }

    private final TextRange getTextRange(JsonValue element) {
        TextRange textRange;
        TextRange range = element.getTextRange();
        if (element instanceof JsonStringLiteral && range.getLength() > 2 && StringUtil.isQuotedString((String)element.getText())) {
            textRange = new TextRange(1, range.getLength() - 1);
        } else {
            TextRange textRange2 = TextRange.create((int)0, (int)range.getLength());
            textRange = textRange2;
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"create(...)");
        }
        return textRange;
    }

    public static final /* synthetic */ void access$annotate(AngularCliAddDependencyInspection $this, JsonFile file, ProblemsHolder holder) {
        $this.annotate(file, holder);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/angular2/inspections/AngularCliAddDependencyInspection$Companion;", "", "<init>", "()V", "TIMEOUT", "", "intellij.angular.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

