/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.intentions;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2Component;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\r\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\bH\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J#\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/angular2/intentions/AngularExtractComponentTemplate;", "Lcom/intellij/lang/javascript/intentions/JavaScriptIntention;", "<init>", "()V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getText", "Lcom/intellij/codeInspection/util/IntentionName;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "calculateTemplateFileName", "componentFile", "Lcom/intellij/psi/PsiFile;", "findProperty", "Lcom/intellij/lang/javascript/psi/JSProperty;", "intellij.angular.backend"})
@SourceDebugExtension(value={"SMAP\nAngularExtractComponentTemplate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AngularExtractComponentTemplate.kt\norg/angular2/intentions/AngularExtractComponentTemplate\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,78:1\n18#2:79\n*S KotlinDebug\n*F\n+ 1 AngularExtractComponentTemplate.kt\norg/angular2/intentions/AngularExtractComponentTemplate\n*L\n72#1:79\n*E\n"})
public final class AngularExtractComponentTemplate
extends JavaScriptIntention {
    @NotNull
    public String getFamilyName() {
        return Angular2Bundle.Companion.message("angular.intention.extract.component.template.name", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.findProperty(element) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JSProperty jSProperty = this.findProperty(element);
        if (jSProperty == null) {
            return;
        }
        JSProperty property = jSProperty;
        Angular2Component angular2Component = Angular2EntitiesProvider.getComponent((PsiElement)Angular2DecoratorUtil.getClassForDecoratorElement((PsiElement)property));
        if (angular2Component == null) {
            return;
        }
        Angular2Component component = angular2Component;
        PsiFile psiFile = component.getTemplateFile();
        if (psiFile == null) {
            return;
        }
        PsiFile template = psiFile;
        PsiFile psiFile2 = property.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
        String string = this.calculateTemplateFileName(psiFile2);
        if (string == null) {
            return;
        }
        String templateFileName = string;
        if (!IntentionPreviewUtils.isIntentionPreviewActive()) {
            PsiFile psiFile3 = property.getContainingFile().getContainingDirectory().createFile(templateFileName);
            Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"createFile(...)");
            PsiFile newTemplateFile = psiFile3;
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(newTemplateFile);
            Intrinsics.checkNotNull((Object)document);
            Document document2 = document;
            String string2 = InjectedLanguageManager.getInstance((Project)project).getUnescapedText((PsiElement)template);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUnescapedText(...)");
            char[] cArray = new char[]{'\n'};
            String string3 = StringsKt.trimStart((String)string2, (char[])cArray);
            cArray = new char[]{' ', '\n'};
            document2.setText((CharSequence)(StringsKt.trimIndent((String)StringsKt.trimEnd((String)string3, (char[])cArray)) + "\n"));
            PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        }
        PsiElement psiElement = property.setName("templateUrl");
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSProperty");
        JSProperty newProperty = (JSProperty)psiElement;
        JSExpression jSExpression = newProperty.getInitializer();
        if (jSExpression != null) {
            ASTNode aSTNode = JSChangeUtil.createExpressionWithContext((String)("'./" + templateFileName + "'"), (PsiElement)((PsiElement)property));
            Intrinsics.checkNotNull((Object)aSTNode);
            jSExpression.replace(aSTNode.getPsi());
        }
        FormatFixer.create((PsiElement)((PsiElement)newProperty), (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
    }

    private final String calculateTemplateFileName(PsiFile componentFile) {
        String string = FileUtil.getNameWithoutExtension((String)componentFile.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        String baseName = string;
        String templateFileName = baseName + ".html";
        PsiDirectory psiDirectory = componentFile.getContainingDirectory();
        if (psiDirectory == null) {
            return templateFileName;
        }
        PsiDirectory dir = psiDirectory;
        if (dir.findFile(templateFileName) == null) {
            return templateFileName;
        }
        int i = 1;
        while (dir.findFile(baseName + "." + i + ".html") != null) {
            ++i;
        }
        return baseName + "." + i + ".html";
    }

    private final JSProperty findProperty(PsiElement element) {
        Object object;
        JSProperty jSProperty;
        PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element);
        PsiElement $this$asSafely$iv = (psiLanguageInjectionHost != null ? (PsiElement)psiLanguageInjectionHost : element).getParent();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof JSProperty)) {
            psiElement = null;
        }
        if ((jSProperty = (JSProperty)psiElement) != null) {
            String[] stringArray;
            JSProperty jSProperty2;
            JSProperty it = jSProperty2 = jSProperty;
            boolean bl = false;
            object = Intrinsics.areEqual((Object)it.getName(), (Object)"template") && Angular2DecoratorUtil.INSTANCE.isAngularEntityInitializerProperty(it, false, stringArray = new String[]{"Component"}) ? jSProperty2 : null;
        } else {
            object = null;
        }
        return object;
    }
}

