/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.components.DiagramNodeDeferredIconsEvaluator;
import com.intellij.diagram.util.DiagramIconUtil;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.util.containers.CollectionFactory;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScalableIconWrapper
implements ScalableIcon {
    @NotNull
    private final ScalableIcon myIcon;
    @Nullable
    private final Consumer<Icon> myOnIconEvaluatedCallback;
    @NotNull
    private static final Map<String, ScalableIcon> OUR_SCALED_ICONS_CACHE = CollectionFactory.createConcurrentWeakMap();

    ScalableIconWrapper(@NotNull ScalableIcon icon, @Nullable Consumer<Icon> onIconEvaluatedCallback) {
        if (icon == null) {
            ScalableIconWrapper.$$$reportNull$$$0(0);
        }
        this.myIcon = (ScalableIcon)icon.scale(1.0f);
        this.myOnIconEvaluatedCallback = onIconEvaluatedCallback;
    }

    public float getScale() {
        return this.myIcon.getScale();
    }

    @NotNull
    public Icon scale(float scaleFactor) {
        return new ScalableIconWrapper((ScalableIcon)this.myIcon.scale(scaleFactor), this.myOnIconEvaluatedCallback);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform currTransform = g2.getTransform();
        double zoom = currTransform.getScaleX();
        double rZoom = 1.0 / zoom;
        g2.scale(rZoom, rZoom);
        this.getOrScaleImage(this.myIcon, (float)zoom).paintIcon(c, g2, (int)((double)x * zoom), (int)((double)y * zoom));
        g2.setTransform(currTransform);
    }

    @NotNull
    private static String getKeyForCacheMap(@NotNull Icon icon) {
        if (icon == null) {
            ScalableIconWrapper.$$$reportNull$$$0(1);
        }
        String string = icon.toString();
        if (string == null) {
            ScalableIconWrapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private Icon getOrScaleImage(@NotNull ScalableIcon icon, float scale) {
        String key;
        ScalableIcon cached;
        if (icon == null) {
            ScalableIconWrapper.$$$reportNull$$$0(3);
        }
        if ((cached = OUR_SCALED_ICONS_CACHE.get(key = ScalableIconWrapper.getKeyForCacheMap((Icon)icon))) != null && (double)Math.abs(cached.getScale() - scale) < 0.01) {
            ScalableIcon scalableIcon = cached;
            if (scalableIcon == null) {
                ScalableIconWrapper.$$$reportNull$$$0(4);
            }
            return scalableIcon;
        }
        Icon scaled = DiagramNodeDeferredIconsEvaluator.getInstance().registerEvaluationOrGetReadyIcon(icon.scale(scale), evaluated -> {
            if (evaluated instanceof ScalableIcon) {
                OUR_SCALED_ICONS_CACHE.put(key, (ScalableIcon)evaluated);
            }
            if (this.myOnIconEvaluatedCallback != null) {
                this.myOnIconEvaluatedCallback.accept((Icon)evaluated);
            }
        });
        if (scaled instanceof ScalableIcon) {
            OUR_SCALED_ICONS_CACHE.put(key, (ScalableIcon)scaled);
        }
        Icon icon2 = scaled;
        if (icon2 == null) {
            ScalableIconWrapper.$$$reportNull$$$0(5);
        }
        return icon2;
    }

    public int getIconWidth() {
        return this.myIcon.getIconWidth();
    }

    public int getIconHeight() {
        return this.myIcon.getIconHeight();
    }

    @Nullable
    public static Icon wrap(@Nullable Icon icon) {
        return ScalableIconWrapper.wrap(icon, __ -> {});
    }

    @Nullable
    public static Icon wrap(@Nullable Icon icon, @NotNull Consumer<Icon> onIconEvaluatedCallback) {
        if (onIconEvaluatedCallback == null) {
            ScalableIconWrapper.$$$reportNull$$$0(6);
        }
        if (icon == null) {
            return null;
        }
        Icon scaled = DiagramIconUtil.deepScaleTo(icon, 1.0f);
        return scaled instanceof ScalableIcon ? new ScalableIconWrapper((ScalableIcon)scaled, onIconEvaluatedCallback) : icon;
    }

    @Nullable
    public static Icon unwrap(@Nullable Icon icon) {
        if (icon == null) {
            return null;
        }
        return icon instanceof ScalableIconWrapper ? ((ScalableIconWrapper)((Object)icon)).myIcon : icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/components/ScalableIconWrapper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onIconEvaluatedCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/components/ScalableIconWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyForCacheMap";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrScaleImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getKeyForCacheMap";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrScaleImage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

