/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.util.OptionsUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class InstrumentationUtils {
    public static final String OBJECT_TYPE = "Ljava/lang/Object;";
    public static final String CLASS_INIT = "<clinit>";
    public static final String CONSTRUCTOR = "<init>";
    public static final String CONSTRUCTOR_DESCRIPTOR = "()V";

    /*
     * WARNING - void declaration
     */
    public static void touchById(MethodVisitor mv, int id, boolean calculateHits) {
        MethodVisitor methodVisitor;
        void var2_2;
        void var1_1;
        InstrumentationUtils.pushInt(mv, (int)var1_1);
        if (var2_2 != false) {
            mv.visitInsn(92);
            mv.visitInsn(46);
            mv.visitInsn(4);
            mv.visitInsn(96);
            mv.visitInsn(79);
            return;
        }
        mv.visitInsn(4);
        methodVisitor.visitInsn(84);
    }

    public static int getBytecodeVersion(ClassReader cr) {
        return cr.readInt(4) & 0xFFFF;
    }

    public static boolean isCondyEnabled(ClassReader cr) {
        ClassReader classReader;
        return OptionsUtil.CONDY_ENABLED && InstrumentationUtils.getBytecodeVersion(classReader) >= 55;
    }

    public static boolean isIntConstLoading(int opcode) {
        int n;
        return 2 <= opcode && opcode <= 8 || opcode == 16 || n == 17;
    }

    /*
     * WARNING - void declaration
     */
    public static void pushInt(MethodVisitor mv, int value) {
        void var1_1;
        MethodVisitor methodVisitor;
        if (value >= -1 && value <= 5) {
            mv.visitInsn(value + 3);
            return;
        }
        if (value >= -128 && value <= 127) {
            mv.visitIntInsn(16, value);
            return;
        }
        if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, value);
            return;
        }
        methodVisitor.visitLdcInsn((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void push(MethodVisitor mv, Object o) {
        void var1_1;
        if (o == null) {
            mv.visitInsn(1);
            return;
        }
        if (o instanceof Integer) {
            InstrumentationUtils.pushInt(mv, (Integer)o);
            return;
        }
        if (o instanceof Boolean) {
            InstrumentationUtils.pushInt(mv, (Boolean)o != false ? 1 : 0);
            return;
        }
        if (o instanceof Double || o instanceof Float || o instanceof Long || o instanceof String) {
            MethodVisitor methodVisitor;
            methodVisitor.visitLdcInsn(o);
            return;
        }
        throw new IllegalArgumentException("Cannot push element of type " + var1_1.getClass());
    }

    /*
     * WARNING - void declaration
     */
    public static String getParentClassIfIsInner(ClassReader cr) {
        void var2_2;
        void var1_1;
        ClassReader classReader;
        String className = cr.getClassName();
        String[] result = new String[]{null};
        classReader.accept(new ClassVisitor(589824, (String)var1_1, result){
            final /* synthetic */ String val$className;
            final /* synthetic */ String[] val$result;
            {
                void var1_1;
                this.val$className = string;
                this.val$result = stringArray;
                super((int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitInnerClass(String name, String outerName, String innerName, int access) {
                void var1_1;
                void var3_3;
                super.visitInnerClass(name, outerName, (String)var3_3, access);
                if (this.val$className.equals(var1_1) && outerName != null) {
                    void var2_2;
                    this.val$result[0] = var2_2;
                }
            }
        }, 7);
        return var2_2[0];
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getClassAnnotations(ClassReader cr) {
        void var1_1;
        ClassReader classReader;
        final ArrayList result = new ArrayList();
        classReader.accept(new ClassVisitor(589824){
            {
                void var1_1;
                super((int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                void var2_2;
                void var1_1;
                result.add(descriptor);
                return super.visitAnnotation((String)var1_1, (boolean)var2_2);
            }
        }, 7);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static MethodDescriptor getOuterClass(ClassReader cr) {
        void var1_1;
        ClassReader classReader;
        final MethodDescriptor[] result = new MethodDescriptor[]{null};
        classReader.accept(new ClassVisitor(589824){
            {
                void var1_1;
                super((int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitOuterClass(String owner, String name, String descriptor) {
                void var3_3;
                void var2_2;
                void var1_1;
                super.visitOuterClass(owner, name, descriptor);
                result[0] = new MethodDescriptor((String)var1_1, (String)var2_2, (String)var3_3);
            }
        }, 7);
        return var1_1[0];
    }

    public static class MethodDescriptor {
        public final String owner;
        public final String name;
        public final String descriptor;

        /*
         * WARNING - void declaration
         */
        public MethodDescriptor(String owner, String name, String descriptor) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.owner = var1_1;
            this.name = var2_2;
            this.descriptor = var3_3;
        }
    }
}

