/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.common.ChangeLemma;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.PhraseReplacement;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.NegativePhrases;
import ai.grazie.rules.en.PolarityItemViolations;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Pair;
import one.util.streamex.StreamEx;

class Inclusivity {
    private static final String USE_LESS_VIOLENT_EXPRESSION = "This expression has violent associations for some people; consider using a more neutral alternative";
    private static final String FOLLOWING_INSTRUCTION_SUFFIX = " might sound dismissive or oversimplify what readers consider a complex task";
    private static final String REDUNDANT_OBVIOUS_SUFFIX = " might sound dismissive if the readers find the logic not obvious";
    private static final String EVERYONE_KNOWS_MSG = "Readers might be alienated if they don\u2019t know this";
    private static final NodePattern justSimplyBasicallyEasily = NodePattern.N.form("just|simply|basically|easily");
    private static final NodePattern you = NodePattern.N.form("you");

    Inclusivity() {
    }

    static List<Rule.PatternRule> rules() {
        return List.of(new Rule.PatternRule("Style.NONVIOLENT_LANGUAGE", "Avoid violent language", "Using non-violent language promotes peaceful and respectful communication.\nLanguage that might implicitly promote physical power or dominance, including military associations,\ncan be offensive or alienating to readers.\n", "https://www.opendemocracy.net/en/transformation/how-everyday-use-of-militaristic-jargon-makes-us-more-combative/", () -> Inclusivity.useNonViolentExpression(), new Example("You\u2019re <b>killing it</b>!", "You\u2019re <b>doing really well</b>!", "You\u2019re <b>doing a great job</b>!")).styleFlavor(StyleFlavor.Inclusivity).disableByDefault(), new Rule.PatternRule("Style.DISCRIMINATORY_LANGUAGE", "Avoid words with racial connotations or undertones", "Inclusive language ensures that all individuals feel valued and understood,\nregardless of their race, religion, nationality, origin, or other characteristics.\n", "https://en.wikipedia.org/wiki/Linguistic_discrimination", () -> Inclusivity.racialTerms(), new Example("The <b>master</b> database is the authoritative source.", "The <b>primary</b> database is the authoritative source.", "The <b>default</b> database is the authoritative source.", "The <b>principal</b> database is the authoritative source.", "The <b>reference</b> database is the authoritative source.", "The <b>\"master\"</b> database is the authoritative source."), new Example("She has <b>blacklisted</b> him.", "She has <b>blocklisted</b> him.", "She has <b>banlisted</b> him.", "She has <b>denylisted</b> him."), new Example("He is from a <b>goy</b> family.", "He is from a <b>non-Jewish</b> family.")).styleFlavor(StyleFlavor.Inclusivity).disableByDefault(), new Rule.PatternRule("Style.CONDESCENDING", "Avoid condescending language", "Some words don\u2019t add anything to the sentence meaning, and also can be perceived as condescending.\nThe text can state that something is obvious or simple or known, but that might not be true for the readers,\nwho then might feel alienated or unintelligent at a vulnerable moment.\n", "https://css-tricks.com/words-avoid-educational-writing/", () -> Inclusivity.condescending(), new Example("You can <b>just</b> build a particle accelerator.", List.of("You <b>can build</b> a particle accelerator.", "<b>It\u2019s enough to build</b> a particle accelerator."), Map.of(EnglishParameters.CONTRACTION_USE, "always")), new Example("<b>Obviously,</b> the Fermat\u2019s theorem can be easily proved.", "<b>The</b> Fermat\u2019s theorem can be easily proved."), new Example("<b>Everyone knows that</b> Fomalhaut lies 25 light-years away.", "<b>Fomalhaut</b> lies 25 light-years away.")).styleFlavor(StyleFlavor.Tone).honorCrazyParses().coveringLTRules("IT_IS_OBVIOUS"));
    }

    private static NodePattern nationality() {
        NodePattern nicknames = NodePattern.or(NodePattern.N.form("gyp(po)?s?|g[iy]ps(y|ies)").correct(NodeCorrector.replace("Roma", "Romani")), NodePattern.N.lemma("goy([iu]m)?").andOr(NodePattern.N.withDependent("det", NodePattern.N.form("a|one")).correct(NodeCorrector.replace("non-Jew")), NodePattern.N.correct(NodeCorrector.replace("non-Jewish"))), NodePattern.N.form("hymie").correct(NodeCorrector.replace("Jew")), NodePattern.N.form("japs?").correct(NodeCorrector.replace("Japanese"))).message(Inclusivity.racialMessage("$_"));
        NodePattern oriental = NodePattern.or(NodePattern.N.form("oriental").and(CommonPatterns.possiblyConj(NodePattern.N.withHead("amod", Semantics.Animacy.humanLike.pattern))).correct(NodeCorrector.replace("Asian")), NodePattern.N.form("orientals").correct(NodeCorrector.replace("Asians"))).message("'Oriental' carries associations with colonialism and some people consider it offensive");
        return NodePattern.or(nicknames, oriental, Inclusivity.compound("sand", "niggers?").message("This phrase is derogatory"), Inclusivity.compound("towel", "heads?").message(Inclusivity.racialMessage("towel head") + "; consider referring to a specific nationality instead"));
    }

    private static NodePattern compound(String first, String second) {
        return NodePattern.or(NodePattern.N.form(second).and(CommonPatterns.afterSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.N.form(first).withHeadRelation("compound"))).reportEverythingTouched(), NodePattern.N.form(first + second));
    }

    private static NodePattern racialTerms() {
        NodePattern spiritAnimal = NodePattern.or(NodePattern.N.inFormSequence(0, "spirit", "animals?"), NodePattern.N.inFormSequence(0, "animal", "spirits?")).directlyAfter(NodePattern.N.pos("PRP\\$")).and((node, match) -> EnglishTreePatterns.replaceNominalPhrase(node, node.neighbor(1), match, PhraseReplacement.MatchStrategy.Lemma, List.of("favorite", "inspiration", "personal interest", "personality type"))).message("Some people may perceive talking about spirit animals as native American cultural appropriation");
        NodePattern red = NodePattern.or(NodePattern.N.lemma("redskin").markAs("End"), NodePattern.N.form("red").directlyBefore(NodePattern.N.form("indians?").markAs("End"))).and((node, match) -> {
            Node end = match.getMarkedNode("End");
            return match.withCorrector(NodeCorrector.replaceNodes(node, end, "Native American" + (end.lowForm().endsWith("s") ? "s" : "")));
        }).message("Some people consider this term derogatory");
        NodePattern grandfathering = NodePattern.N.lemma("grandfather").andOr(NodePattern.N.directlyBeforeHead().withHead("compound", NodePattern.N.lemma("clause|policy")).correct(NodeCorrector.replace("legacy", "deprecation")), NodePattern.or(EnglishTreePatterns.withToMark, NodePattern.N.withDependent("nsubj.*").noDependents("cop|det")).correct(EnglishTreePatterns.changeVerbLemma("deprecate"))).message("'Grandfathering' and related terms may evoke negative associations due to their racist origins");
        NodePattern indianGive = NodePattern.N.lemma("giver?").and(CommonPatterns.afterSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("indian").markAs("Start"))).reportEverythingTouched().andOptionally(NodePattern.N.lemma("giver").and((node, match) -> {
            Node start = match.getMarkedNode("Start");
            String replacement = "take-backer" + node.lowForm().substring("giver".length());
            return match.withCorrector(NodeCorrector.rawReplace(start.startOffset(), node.endOffset(), replacement).join(Articles.fixArticle(start, "take")));
        })).message("'Indian-give' is considered derogatory towards native people");
        NodePattern manyChiefs = NodePattern.N.inFormSequence(0, "too", "many", "chiefs", "and", "not", "enough", "indians").message("Referring to native people seems unnecessary and might be considered offensive").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(6), "too many chefs and not enough cooks", "too many cooks in the kitchen", "too many managers and not enough workers"));
        NodePattern totemPole = NodePattern.N.inFormSequence(1, "totem", "pole").andOr(NodePattern.N.withHead("obj", NodePattern.N.lemma("climb")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "corporate ladder")), NodePattern.N.withNeighbor(-2, CommonPatterns.skipBack(NodePattern.N.form("the"), NodePattern.N.form("on").and(CommonPatterns.afterSkipping(NodePattern.N.form("man"), NodePattern.N.form("low").andOr(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("det").markAs("Start")), NodePattern.N.markAs("Start")))))).correct(NodeCorrector.replaceNodes(NodePointer.marked("Start"), NodePointer.anchor(), "the lowest rung on the ladder"))).message("Using 'totem pole' in business contexts can be considered a form of cultural appropriation");
        NodePattern tribe = NodePattern.N.lemma("tribe").correct(NodeCorrector.regexReplace("tribe(s?)", "people$1")).correct(NodeCorrector.regexReplace("tribe(s?)", "nation$1")).correct(NodeCorrector.regexReplace("tribe(s?)", "folk$1")).message("'tribe' can be offensive when referred to a nation of people");
        NodePattern onlyHighlight = NodePattern.or(NodePattern.or(NodePattern.N.lemma("circle").directlyBefore(NodePattern.N.inFormSequence(0, "the", "wagons")), NodePattern.N.inFormSequence(0, "on", "the", "warpath")).reportEverythingTouched().message("This phrase might evoke racist images of Native Americans; consider using neutral terms like 'defend'"), NodePattern.N.inFormSequence(0, "jump|off", "the", "rez|res(ervation)?").reportEverythingTouched().message("This phrase might evoke racist images of Native Americans; consider using neutral terms like 'disobey' or 'oppose'"), NodePattern.or(NodePattern.N.form("natives"), NodePattern.N.inFormSequence(1, "native", "people")).withHead("nsubj", NodePattern.or(NodePattern.N.form("restless"), NodePattern.N.lemma("become|grow|get").withDependent("xcomp", NodePattern.N.form("restless")))).reportEverythingTouched().message("This phrase might evoke racist images; consider changing 'native' and 'restless'"), NodePattern.N.form("eskimos?").message("'Eskimo' is a derogatory name imposed by non-native colonizers; consider 'Inuit' or 'Yupik'")).suggestActions(ActionSuggestion.REPHRASE);
        return NodePattern.or(Inclusivity.masterSlave(), Inclusivity.blackWhiteList(), Inclusivity.nonWhite(), Inclusivity.nationality(), spiritAnimal, onlyHighlight, red, Inclusivity.primitive(), grandfathering, indianGive, manyChiefs, totemPole, tribe).andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.quotations)).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations));
    }

    private static NodePattern primitive() {
        NodePattern humanRelated = NodePattern.or(Semantics.Animacy.humanLike.pattern, NodePattern.N.lemma("culture|civilization"));
        return NodePattern.or(NodePattern.N.form("primitive|savage").markAs("Start").message("Calling people '$_' can be derogatory"), NodePattern.N.form("age").and(CommonPatterns.afterSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("stone").markAs("Start"))).message("Using 'stone age' with people can be derogatory")).and((end, match) -> {
            Node start = match.getMarkedNode("Start");
            StreamEx sug = StreamEx.of((Object[])new String[]{"simple", "native", "indigenous"});
            return match.withCorrectors(sug.map(s -> NodeCorrector.replaceNodes(start, end, s).join(Articles.fixArticle(start, s))).toList());
        }).andOr(CommonPatterns.possiblyConj(NodePattern.N.withHead("amod|compound", humanRelated).markAs("AdjLike")).correct(NodeCorrector.replaceNodes(NodePointer.marked("Start"), NodePointer.anchor(), "hunter-gatherer")), NodePattern.N.withDependent("nsubj", humanRelated)).andNot(NodePattern.N.inPhrase(NegativePhrases.negativeClause));
    }

    private static NodePattern nonWhite() {
        NodeCorrector.Relative removeNonWhite = NodeCorrector.replaceNodes(NodePointer.marked("Non"), NodePointer.marked("White"), "");
        NodePattern ourVariant = EnglishParameters.VARIANT.withValue("GB.*|AU|CA");
        NodePattern noVariant = EnglishParameters.VARIANT.withValue("");
        return NodePattern.N.lemma("person").withDependent("amod", NodePattern.or(NodePattern.N.form("nonwhite").markAs("Non"), NodePattern.N.form("white").and(CommonPatterns.afterSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("non").markAs("Non")))).markAs("White")).andOptionally(NodePattern.or(noVariant, NodePattern.not(ourVariant)).correct(removeNonWhite.join(NodeCorrector.insertAfter(" of color")))).andOptionally(NodePattern.or(noVariant, ourVariant).correct(removeNonWhite.join(NodeCorrector.insertAfter(" of colour")))).message(Inclusivity.racialMessage("non-white"));
    }

    private static NodePattern blackWhiteList() {
        return NodePattern.or(NodePattern.N.lemma("(white|black)list").markAs("Colored").message(Inclusivity.racialMessage("$_")), NodePattern.N.lemma("list").directlyAfter(NodePattern.N.form("white|black").markAs("Colored")).message(Inclusivity.racialMessage("$Colored $_"))).and((list, match) -> {
            Node colored = match.getMarkedNode("Colored");
            String color1 = colored.lowForm().startsWith("black") ? "black" : "white";
            List<String> neutral = color1.equals("black") ? List.of("block", "ban", "deny") : List.of("allow");
            String suffix = list.lowForm().substring(list.lowForm().indexOf("list") + 4);
            List<String> replacements = neutral.stream().map(n -> n + "list" + suffix).toList();
            return match.withCorrector(NodeCorrector.replaceNodes(colored, list, () -> replacements));
        });
    }

    private static NodePattern masterSlave() {
        NodePattern quoteWord = NodePattern.custom((node, match) -> {
            Pair<Character, Character> quotes = EnglishTreePatterns.primaryQuotes(node);
            return match.withCorrector(NodeCorrector.replace(node, String.valueOf(quotes.getFirst()) + "master" + String.valueOf(quotes.getSecond())));
        });
        return NodePattern.or(CommonPatterns.possiblyConj(NodePattern.N.withHead("compound", NodePattern.N.noLemma("class|morality").markAs("Head"))).andOr(NodePattern.N.form("master").noLabel(".*").andNot(NodePattern.N.directlyBefore(NodePattern.N.lemma("theorem"))).andNot(NodePattern.N.withNeighbor(2, NodePattern.N.form("servant|subordinate"))).andNot(NodePattern.N.inFormSequence(2, "remote", "/", ".*")).andNot(NodePattern.N.inFormSequence(0, ".*", "data", "management")).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("to")).directlyBefore(NodePattern.or(NodePattern.N.pos("NN.*"), NodePattern.N.noPos()))).andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.markedNodeMatches("Head", NodePattern.or(NodePattern.N.lemma("degree|qualification|diploma|certificate|program(me)?|thesis|art(work)?|work|painting|sculpture|piece|artist|doctor|musician|reader|hitchhiker|(di)?rector|president|driver|producer|extremist|refugee|farmer|soldier|student|teacher|admin(istrator)?|professor|developer|engineer|programmer|linguist|investor|pala?eontologist|politician|electrician|consultant|writer|painter|blogger|essayist|novelist|portraitist|landscapist|scholar|golfer|worker|researcher|careerist|governor|warden|principal|harbormaster|conductor|officer|captain|superintendent|senior|official|philosopher|logician|scientist|architect|dean|mayor|specialist|analyst|notary|registrar|clerk|minister|advisor|(police|fire|post|chair|fore)(wo)?man|lecturer|representative|librarian|commandor|CEO|manager|deputy|executive|agent|ambassador|nurse|midwife|secretary|master|bachelor|associate"), NodePattern.N.withDependent("obj"), CommonPatterns.skipUp("compound", NodePattern.N.withHeadRelation("appos|root").noDependents("det|nmod:poss|case"))))).andOr(NodePattern.markedNodeMatches("Head", NodePattern.N.lemma("branch")).correct(NodeCorrector.replace("main")).and(quoteWord), NodePattern.markedNodeMatches("Head", NodePattern.N.lemma("page")).correct(NodeCorrector.replace("parent")), NodePattern.markedNodeMatches("Head", NodePattern.N.lemma("election")).correct(NodeCorrector.replace("leader")), NodePattern.N.inFormSequence(0, "master", "plan").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "grand scheme", "guiding principles")), NodePattern.N.directlyBefore(NodePattern.N.lemma("copy|key").correct(NodeCorrector.replace(NodePointer.neighbor(-1), "pass").join(ChangeLemma.to("key")))).correct(NodeCorrector.replace("original")), NodePattern.N.correct(NodeCorrector.replace("primary", "default", "principal", "reference")).and(quoteWord)), NodePattern.N.form("slave").andNot(NodePattern.markedNodeMatches("Head", NodePattern.N.lemma("labou?r(er)?|trader?"))).correct(NodeCorrector.replace("secondary", "subordinate", "peripheral", "replica"))), NodePattern.N.inFormSequence(0, "master(ed|ing|s)?", "the", "art", "of").correct(EnglishTreePatterns.changeVerbLemma("become").join(NodeCorrector.replaceNodes(NodePointer.neighbor(1), NodePointer.neighbor(3), "skilled in"))), NodePattern.N.inFormSequence(0, "masters?", "of", "ceremonies").correct(ChangeLemma.to("emcee").join(NodeCorrector.removeNodes(NodePointer.neighbor(1), NodePointer.neighbor(2)))).correct(ChangeLemma.to("moderator").join(NodeCorrector.removeNodes(NodePointer.neighbor(1), NodePointer.neighbor(2)))).correct(ChangeLemma.to("convenor").join(NodeCorrector.removeNodes(NodePointer.neighbor(1), NodePointer.neighbor(2))))).message("Some people may perceive '$_' here as insensitive");
    }

    private static String racialMessage(String phrase) {
        return "Some people may perceive '" + phrase + "' as racially offensive";
    }

    private static NodePattern useNonViolentExpression() {
        Map<String, List<PhraseReplacement>> entries = PhraseReplacement.parseLines(WordSet.loadLines("en/words/violent_expressions.txt"));
        Set<String> keys = entries.keySet();
        NodePattern definitelyVerb = NodePattern.N.pos("VB.*").noDependents("cop");
        NodePattern fromFile = NodePattern.or(NodePattern.N.lemma(keys), NodePattern.N.form(keys)).and((node, match) -> {
            for (PhraseReplacement.MatchStrategy strategy : List.of(PhraseReplacement.MatchStrategy.Form, PhraseReplacement.MatchStrategy.Lemma)) {
                PhraseReplacement phrase = strategy.findRule(node, entries);
                if (phrase == null) continue;
                return EnglishTreePatterns.replaceNominalPhrase(node, match, phrase, strategy);
            }
            return null;
        });
        NodePattern killIt = NodePattern.N.lemma("kill|nail").directlyBefore(NodePattern.N.form("it").markAs("It").directlyAfterHead()).andNot(NodePattern.N.lemma("kill").and(CommonPatterns.skipConjUp(NodePattern.N.withDependent("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N.lemma("process|program(me)?"))))).andOr(NodePattern.or(CommonPatterns.skipConjUp(NodePattern.ROOT.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")), CommonPatterns.skipUp("[xc]comp", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")).withDependent("obl", NodePattern.N.withDependent("case")), NodePattern.N.withHead("[xc]comp", NodePattern.ROOT.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?").withDependent("advmod", Semantics.frequencyAdverb))).andOptionally(NodePattern.N.withDependent("advmod", Semantics.intensifier.markAs("Intensifier"))).and((node, match) -> {
            Node it = match.getMarkedNode("It");
            Node intensifier = match.findMarkedNode("Intensifier");
            NodeCorrector corrector = EnglishTreePatterns.changeVerbLemma("do").corrector(node).join(NodeCorrector.replace(it, List.of("really well", "a great job")));
            if (intensifier != null) {
                corrector = corrector.join(NodeCorrector.replaceNodes(intensifier.phraseStart(), intensifier.phraseEnd(), ""));
            }
            return match.withCorrector(corrector);
        }), NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?").noHeadRelation("parataxis"));
        NodePattern shotTarget = NodePattern.or(Semantics.animalPattern, NodePattern.N.form("target"));
        NodePattern shotsOrStabs = NodePattern.or(NodePattern.or(NodePattern.N.lemma("take|have|make").withDependent("obj", NodePattern.N.inFormSequence(1, "a", "stab", "at").markAs("Obj")), NodePattern.N.lemma("take|have").withDependent("obj", NodePattern.N.inFormSequence(0, "shots?", "at").noDependents("nmod", shotTarget).markAs("Obj")).noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("with"))).noDependents("obl", shotTarget), NodePattern.N.lemma("give").withDependent("iobj").withDependent("obj", NodePattern.N.form("shot").markAs("Obj").correct(NodeCorrector.replace("try")).andOptionally(NodePattern.N.inFormSequence(1, "a", "shot").correct(NodeCorrector.replace("chance"))))).reportRangeTo("Obj"), NodePattern.N.inFormSequence(0, "shot", "in", "the", "dark").withDependent("det", NodePattern.N.form("an?").markAs("Det")).withDependent("cop").correct(NodeCorrector.replaceNodes(NodePointer.marked("Det"), NodePointer.neighbor(3), "a random guess")));
        NodePattern itBeatsMe = NodePattern.N.inFormSequence(2, "it", "beats", "me").directlyBefore(Questions.whWord).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), "I don\u2019t understand"));
        NodePattern target = NodePattern.or(definitelyVerb.lemma("target").markAs("Target").withDependent("obj", NodePattern.N.directlyAfterHead().markAs("Obj")).noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("at"))).andOr(NodePattern.N.withHeadRelation("acl").pos("VBG").noDependents("mark").and(NodePattern.markedNodeMatches("Obj", CommonPatterns.possiblySkipDown("compound", NodePattern.N.label("PRODUCT|ORGANIZATION")))).correct(NodeCorrector.replace("built for", "compatible with")), NodePattern.N.correct(EnglishTreePatterns.changeVerbLemma("focus").join(NodeCorrector.insertAfter(" on")))), NodePattern.N.inFormSequence(2, "a|the", "moving", "target").reportEverythingTouched().withHeadRelation("root|xcomp"));
        NodePattern bullet = NodePattern.or(definitelyVerb.lemma("bite").directlyBefore(NodePattern.N.inFormSequence(0, "the", "bullet")).andOptionally(NodePattern.N.pos("VB").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "give it a go")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "get it done"))), definitelyVerb.lemma("sweat").directlyBefore(NodePattern.N.form("bullets").markAs("Obj")).reportRangeTo("Obj").andOptionally(NodePattern.N.pos("VBG").withDependent("aux").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "nervous"))));
        NodePattern itHangs = NodePattern.or(NodePattern.N.lemma("screen|program|phone|window|panel|app(lication)?|process|computer|device|system|UI|IDE|display|editor|tab|page|browser|Chrome|Safari|Firefox"), NodePattern.N.formCaseSensitive("IDEA|Windows"));
        NodePattern hang = NodePattern.N.lemma("hang").andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("IN"))).andNot(NodePattern.N.withDependent("compound:prt", NodePattern.N.afterHead())).andOr(NodePattern.N.withDependent("nsubj", itHangs).correct(EnglishTreePatterns.changeVerbLemma("freeze")).correct(EnglishTreePatterns.changeVerbLemma("stop").join(NodeCorrector.insertAfter(" responding"))), NodePattern.or(NodePattern.N.withDependent("obj", itHangs), NodePattern.N.withPrevSibling(itHangs.withHeadRelation("obj|nsubj"))).andNot(NodePattern.N.withDependent("nsubj", Semantics.humanLikePattern)).correct(EnglishTreePatterns.changeVerbLemma("freeze")));
        return NodePattern.or(fromFile, killIt, shotsOrStabs, itBeatsMe, target, bullet, hang, NodePattern.N.inFormSequence(2, "under", "the", "gun").reportEverythingTouched().withDependent("cop"), NodePattern.N.inFormSequence(0, "rally", "the", "troops").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "encourage people")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "urge everyone to work harder")), NodePattern.N.lemma("blow").withDependent("compound:prt", NodePattern.N.form("up")).withDependent("obl", NodePattern.N.form("face").markAs("Obj").withDependent("nmod:poss").withDependent("case", NodePattern.N.form("in"))).reportRangeTo("Obj")).message(USE_LESS_VIOLENT_EXPRESSION);
    }

    static NodePattern condescending() {
        NodePattern negationAccentedByJust = NodePattern.or(NegativePhrases.negativeClause, NodePattern.N.withDependent("conj|parataxis|advcl|obl", NodePattern.or(NegativePhrases.negativeClause, CommonPatterns.possiblySkipDown("obl", NodePattern.N.withDependent("case|mark", PolarityItemViolations.without)))));
        NodePattern conditionalClause = NodePattern.N.withDependent("mark", NodePattern.N.form("if|when"));
        NodePattern conditionalJust = NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.comma, EnglishTreePatterns.dashes)).and(NodePattern.markedNodeMatches("Clause", NodePattern.N.withHead("parataxis|conj", NodePattern.or(EnglishTreePatterns.imperativeVB.noDependents("conj", NodePattern.N.after("Clause")), EnglishTreePatterns.withModal.withDependent("nsubj", you)))));
        NodePattern justExceptions = NodePattern.N.form("just").andOr(NodePattern.markedNodeMatches("Clause", NodePattern.or(negationAccentedByJust, conditionalClause, Semantics.saySynonym)), NodePattern.N.directlyBefore(NodePattern.N.form("to|like|so|in|because|imagine")), NodePattern.N.directlyAfter(NodePattern.N.lemma("like")), conditionalJust, NodePattern.N.directlyAfter(NodePattern.N.form("or")));
        NodePattern hasExplanation = NodePattern.or(NodePattern.N.withDependent("punct", CommonPatterns.colon), NodePattern.N.withDependent("advcl", NodePattern.N.withDependent("mark", NodePattern.N.form("because|since|for"))), NodePattern.N.withDependent("obl", NodePattern.N.lemma("reason")));
        NodePattern actionVerbs = NodePattern.or(NodePattern.N.lemma("create|add|delete|remove|play|follow|implement|see|achieve|provide|deploy|write|read|please|manage|crack|remember|remind|test|consume|walk|run|look|catch|set|grasp|understand|use|utilize|invite|keep|get|traverse|clean|profile|debug|execute|stop|launch|start|find|replace|deal|handle|process|edit|copy|integrate|differentiate|solve|share|support|rearrange|return|call|invoke|rename|move|refactor|put|configure|track|do|release|press|control|migrate|develop|encode|decode|decipher|(dis)?(assemble|connect)|interpret|deliver|buy|make|grab|comprehend|maintain|build|compile|analyze|decompose|structure"), NodePattern.N.lemma("go").noDependents("xcomp", NodePattern.N.pos("JJ.*")));
        NodePattern byAccident = NodePattern.or(NodePattern.N.withDependent("obl", NodePattern.N.form("accident|chance|mistake").withDependent("case", NodePattern.N.form("by"))), NodePattern.N.withDependent("advmod", NodePattern.N.form("accidentally|unintentionally|unwittingly|mistakenly|conincidentally")));
        return NodePattern.or(justSimplyBasicallyEasily.and(CommonPatterns.possiblyConj(NodePattern.N.beforeHead().withHead("advmod", NodePattern.N.pos("VB").noLemma("want|wish").andOr(NodePattern.not(CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?"), NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.noLemma("do"))))), CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj", you).andNot(PolarityItemViolations.conditionClause))).andNot(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("xcomp"))).noDependents("mark", NodePattern.N.form("to|like|as")).andNot(NodePattern.N.withHeadRelation("acl").potentialPos("VBN")).markAs("Clause")))).andOr(NodePattern.N.withDependent("cc", NodePattern.N.markAs("CC")).noDependents(NodePattern.not(NodePattern.N.alreadyMarkedAs("CC"))).correct(NodeCorrector.replaceNodes(NodePointer.marked("CC"), NodePointer.anchor(), "")), NodePattern.N.noDependents().correct(NodeCorrector.replace(""))).includeIntoReport().andOptionally(Inclusivity.suggestEnough()).andNot(justExceptions).andNot(NodePattern.N.form("easily").and(NodePattern.markedNodeMatches("Clause", NodePattern.N.withDependent("advcl", conditionalClause)))).message("'$_' might sound dismissive or oversimplify what readers consider a complex task"), NodePattern.N.form("obviously|clearly").beforeHead().andNot(NodePattern.N.directlyBeforeHead()).withHead("advmod", NodePattern.N.noDependents("mark", NodePattern.N.form("to"))).includeIntoReport().noDependents(NodePattern.not(NodePattern.PUNCT)).and((node, match) -> EnglishTreePatterns.removeWithSurroundingPunctuation(node, node, match)).message("'$_' might sound dismissive if the readers find the logic not obvious"), NodePattern.N.form("obvious|simple").and(CommonPatterns.possiblyConj(NodePattern.N.withDependent("cop").noHeadRelation("ccomp").noDependents("mark", NodePattern.N.form("(al)?though")))).andNot(CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withDependent("aux", NodePattern.N.lemma("should|can|might|may")), hasExplanation))).andOr(NodePattern.N.noDependents("csubj|xcomp|ccomp", EnglishTreePatterns.withToMark), NodePattern.N.withDependent("csubj|xcomp|ccomp", EnglishTreePatterns.withToMark.and(actionVerbs).noDependents("advcl", NodePattern.N.pos("VBG").withDependent("mark", NodePattern.N.form("by"))).noDependents("xcomp", NodePattern.N.pos("VBN").withNextSibling(NodePattern.N.pos("VBG").withHeadRelation("advcl"))).andNot(byAccident))).andNot(NodePattern.N.inFormSequence(1, "past|present|future", "simple")).andNot(NodePattern.N.withDependent("cop").withDependent("expl").noDependents("ccomp|xcomp|csubj", EnglishTreePatterns.clause)).andNot(NodePattern.N.withDependent("cop").and(CommonPatterns.skipUp("xcomp", CommonPatterns.possiblySkipDown("cop|aux|aux:pass", NodePattern.N.pos("VBD"))))).andNot(CommonPatterns.possiblySkipDown("csubj|xcomp|ccomp", NodePattern.N.withDependent("obl|nsubj", NodePattern.N.inFormSequence(1, "for|to", "me|us")))).andNot(NodePattern.N.inPhrase(NodePattern.or(NegativePhrases.negativeClause, Questions.possiblyQuestion, conditionalClause))).andNot(NodePattern.N.inSentenceWith(NodePattern.N.lemma("difficult|hard|complex|complicated|sophisticated")).trace("contrasting")).andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("RB"))).noDependents("advmod", NodePattern.N.directlyBeforeHead().noForm("pretty")).message("Avoid using '$_', as you may underestimate the reader\u2019s effort and accidentally sound condescending; it\u2019s also often a redundant filler").andOptionally(NodePattern.or(NodePattern.N.form("obvious").correct(NodeCorrector.replace("clear")), NodePattern.N.correct(NodeCorrector.replace("straightforward")))).suggestActions(ActionSuggestion.REPHRASE), NodePattern.or(NodePattern.N.inFormSequence(1, "everyone|everybody", "knows"), NodePattern.N.inFormSequence(2, "we", "all", "know")).reportEverythingTouched().markAs("Know").withDependent("nsubj", NodePattern.N.markAs("Subj")).andOr(NodePattern.N.withHeadRelation("advcl").withDependent("mark", NodePattern.N.form("as").directlyBefore("Subj").includeIntoReport()).noDependents(NodePattern.not(NodePattern.PUNCT).afterHead()).correct(NodeCorrector.replaceNodes(NodePointer.neighbor("Subj", -1), NodePointer.anchor(), "")), NodePattern.N.withDependent("ccomp", NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter("Know"))).andOr(NodePattern.N.directlyBefore(NodePattern.N.form("that").withHeadRelation("mark").includeIntoReport()).correct(NodeCorrector.replaceNodes(NodePointer.marked("Subj"), NodePointer.neighbor(1), "")), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.marked("Subj"), NodePointer.anchor(), "")))).message(EVERYONE_KNOWS_MSG)).andNot(CommonPatterns.insideQuotes).andNot(NodePattern.custom(n -> n.back().anyMatch(Semantics.directSpeech.and(EnglishTreePatterns.clause)::matches)));
    }

    private static NodePattern suggestEnough() {
        return NodePattern.N.form("just").withHead("advmod", NodePattern.N.withDependent("nsubj", you.markAs("You")).andOr(NodePattern.N.withDependent("aux", NodePattern.N.lemma("can").markAs("Aux")), NodePattern.N.lemma("need").directlyBefore(NodePattern.N.form("to")).markAs("NeedTo")).noDependents("cop|aux|aux:pass", NodePattern.not(NodePattern.N.alreadyMarkedAs("Aux"))).noDependents("cc", NodePattern.N.form("or"))).and((adv, match) -> {
            boolean present;
            Node you = match.getMarkedNode("You");
            Node need = match.findMarkedNode("NeedTo");
            NodeCorrector corrector = need != null ? NodeCorrector.replace(need, "enough").join(NodeCorrector.replace(adv, "")) : NodeCorrector.replace(adv, "enough to");
            Node aux = match.findMarkedNode("Aux");
            boolean bl = need != null ? need.hasForm("need") : (present = aux == null || aux.hasForm("can"));
            if (aux != null) {
                corrector = corrector.join(NodeCorrector.replace(aux, ""));
            }
            for (Node a : Objects.requireNonNull(adv.head()).findDependents("advmod")) {
                if (a == adv || !justSimplyBasicallyEasily.matches(a)) continue;
                corrector = corrector.join(NodeCorrector.replace(a, ""));
                match = match.withReportedNode(a);
            }
            if (present && EnglishParameters.suggestContractedForms.matches(adv)) {
                match = match.withCorrector(corrector.join(NodeCorrector.replace(you, "it\u2019s")));
            }
            if (!present || EnglishParameters.suggestFullForms.matches(adv)) {
                match = match.withCorrector(corrector.join(NodeCorrector.replace(you, "it " + (present ? "is" : "was"))));
            }
            return match.withReportedNode(adv);
        });
    }
}

