/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\u00020\u0001:\u00012B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000J\u0013\u0010\"\u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u0004\u0018\u00010\u0000J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020'H\u0016J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,J\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020*0.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020*0.J\u000e\u0010)\u001a\u0002002\u0006\u00101\u001a\u000200J\u000e\u0010)\u001a\u00020*2\u0006\u0010/\u001a\u00020*R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0016\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000eR\u0011\u0010\u0018\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000eR\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000eR\u0011\u0010\u001c\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000eR\u0011\u0010\u001e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000e\u00a8\u00063"}, d2={"Lorg/jetbrains/letsPlot/commons/geometry/AffineTransform;", "", "m00", "", "m10", "m01", "m11", "m02", "m12", "(DDDDDD)V", "isIdentity", "", "()Z", "getM00", "()D", "getM01", "getM02", "getM10", "getM11", "getM12", "rx", "getRx", "ry", "getRy", "sx", "getSx", "sy", "getSy", "tx", "getTx", "ty", "getTy", "concat", "other", "equals", "hashCode", "", "inverse", "repr", "", "toString", "transform", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "x", "", "y", "", "p", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "r", "Companion", "commons"})
@SourceDebugExtension(value={"SMAP\nAffineTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AffineTransform.kt\norg/jetbrains/letsPlot/commons/geometry/AffineTransform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n1549#2:227\n1620#2,3:228\n*S KotlinDebug\n*F\n+ 1 AffineTransform.kt\norg/jetbrains/letsPlot/commons/geometry/AffineTransform\n*L\n52#1:227\n52#1:228,3\n*E\n"})
public final class AffineTransform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double m00;
    private final double m10;
    private final double m01;
    private final double m11;
    private final double m02;
    private final double m12;
    private final boolean isIdentity;
    @NotNull
    private static final AffineTransform IDENTITY = new AffineTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);

    public AffineTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
        this.isIdentity = this.m00 == 1.0 && this.m10 == 0.0 && this.m01 == 0.0 && this.m11 == 1.0 && this.m02 == 0.0 && this.m12 == 0.0;
    }

    public final double getM00() {
        return this.m00;
    }

    public final double getM10() {
        return this.m10;
    }

    public final double getM01() {
        return this.m01;
    }

    public final double getM11() {
        return this.m11;
    }

    public final double getM02() {
        return this.m02;
    }

    public final double getM12() {
        return this.m12;
    }

    public final boolean isIdentity() {
        return this.isIdentity;
    }

    public final double getSx() {
        return this.m00;
    }

    public final double getSy() {
        return this.m11;
    }

    public final double getRx() {
        return this.m01;
    }

    public final double getRy() {
        return this.m10;
    }

    public final double getTx() {
        return this.m02;
    }

    public final double getTy() {
        return this.m12;
    }

    @NotNull
    public final DoubleVector transform(@NotNull DoubleVector p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (this.isIdentity) {
            return p;
        }
        return this.transform(p.getX(), p.getY());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DoubleVector> transform(@NotNull List<DoubleVector> p) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(p, (String)"p");
        if (this.isIdentity) {
            return p;
        }
        Iterable $this$map$iv = p;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DoubleVector doubleVector = (DoubleVector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.transform((DoubleVector)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final DoubleRectangle transform(@NotNull DoubleRectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        if (this.isIdentity) {
            return r;
        }
        DoubleVector lt = this.transform(r.getLeft(), r.getTop());
        DoubleVector rt = this.transform(r.getRight(), r.getTop());
        DoubleVector rb = this.transform(r.getRight(), r.getBottom());
        DoubleVector lb = this.transform(r.getLeft(), r.getBottom());
        Object[] objectArray = new Double[]{lt.getX(), rt.getX(), rb.getX(), lb.getX()};
        List xs = CollectionsKt.listOf((Object[])objectArray);
        Object[] objectArray2 = new Double[]{lt.getY(), rt.getY(), rb.getY(), lb.getY()};
        List ys = CollectionsKt.listOf((Object[])objectArray2);
        return DoubleRectangle.Companion.LTRB(CollectionsKt.minOrThrow((Iterable)xs), CollectionsKt.minOrThrow((Iterable)ys), CollectionsKt.maxOrThrow((Iterable)xs), CollectionsKt.maxOrThrow((Iterable)ys));
    }

    @NotNull
    public final DoubleVector transform(@NotNull Number x2, @NotNull Number y2) {
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y2, (String)"y");
        if (this.isIdentity) {
            return new DoubleVector(x2.doubleValue(), y2.doubleValue());
        }
        return new DoubleVector(this.m00 * x2.doubleValue() + this.m01 * y2.doubleValue() + this.m02, this.m10 * x2.doubleValue() + this.m11 * y2.doubleValue() + this.m12);
    }

    @NotNull
    public final AffineTransform concat(@NotNull AffineTransform other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new AffineTransform(this.m00 * other.m00 + this.m01 * other.m10, this.m10 * other.m00 + this.m11 * other.m10, this.m00 * other.m01 + this.m01 * other.m11, this.m10 * other.m01 + this.m11 * other.m11, this.m00 * other.m02 + this.m01 * other.m12 + this.m02, this.m10 * other.m02 + this.m11 * other.m12 + this.m12);
    }

    @Nullable
    public final AffineTransform inverse() {
        double det = this.m00 * this.m11 - this.m01 * this.m10;
        if (det == 0.0) {
            return null;
        }
        return new AffineTransform(this.m11 / det, -this.m10 / det, -this.m01 / det, this.m00 / det, (this.m01 * this.m12 - this.m02 * this.m11) / det, (this.m02 * this.m10 - this.m00 * this.m12) / det);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AffineTransform cfr_ignored_0 = (AffineTransform)other;
        if (!(this.m00 == ((AffineTransform)other).m00)) {
            return false;
        }
        if (!(this.m11 == ((AffineTransform)other).m11)) {
            return false;
        }
        if (!(this.m02 == ((AffineTransform)other).m02)) {
            return false;
        }
        if (!(this.m12 == ((AffineTransform)other).m12)) {
            return false;
        }
        if (!(this.m10 == ((AffineTransform)other).m10)) {
            return false;
        }
        return this.m01 == ((AffineTransform)other).m01;
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.m00);
        result2 = 31 * result2 + Double.hashCode(this.m11);
        result2 = 31 * result2 + Double.hashCode(this.m02);
        result2 = 31 * result2 + Double.hashCode(this.m12);
        result2 = 31 * result2 + Double.hashCode(this.m10);
        result2 = 31 * result2 + Double.hashCode(this.m01);
        return result2;
    }

    @NotNull
    public final String repr() {
        if (this.m00 == 1.0 && this.m10 == 0.0 && this.m01 == 0.0 && this.m11 == 1.0 && this.m02 == 0.0 && this.m12 == 0.0) {
            return "IDENTITY";
        }
        return "sx=" + this.getSx() + ", ry=" + this.getRy() + ", rx=" + this.getRx() + ", sy=" + this.getSy() + ", tx=" + this.getTx() + ", ty=" + this.getTy();
    }

    @NotNull
    public String toString() {
        return "AffineTransform(" + this.repr() + ')';
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u001a\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\tJ\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\t2\b\b\u0002\u0010\u0011\u001a\u00020\t2\b\b\u0002\u0010\u0012\u001a\u00020\tJ\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tJ\u0016\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tJB\u0010\u0019\u001a\u00020\u00042\b\b\u0002\u0010\u0014\u001a\u00020\t2\b\b\u0002\u0010\u0018\u001a\u00020\t2\b\b\u0002\u0010\u0017\u001a\u00020\t2\b\b\u0002\u0010\u0015\u001a\u00020\t2\b\b\u0002\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\tJ\u0016\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u0016\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tJ\u0018\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006#"}, d2={"Lorg/jetbrains/letsPlot/commons/geometry/AffineTransform$Companion;", "", "()V", "IDENTITY", "Lorg/jetbrains/letsPlot/commons/geometry/AffineTransform;", "getIDENTITY", "()Lorg/jetbrains/letsPlot/commons/geometry/AffineTransform;", "makeMatrix", "m00", "", "m10", "m01", "m11", "m02", "m12", "makeRotation", "angle", "centerX", "centerY", "makeScale", "sx", "sy", "makeShear", "rx", "ry", "makeTransform", "tx", "ty", "makeTranslate", "dx", "dy", "makeTranslation", "restoreTransform", "current", "next", "commons"})
    @SourceDebugExtension(value={"SMAP\nAffineTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AffineTransform.kt\norg/jetbrains/letsPlot/commons/geometry/AffineTransform$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1#2:227\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AffineTransform getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final AffineTransform makeScale(@NotNull Number sx, @NotNull Number sy) {
            Intrinsics.checkNotNullParameter((Object)sx, (String)"sx");
            Intrinsics.checkNotNullParameter((Object)sy, (String)"sy");
            return org.jetbrains.letsPlot.commons.geometry.AffineTransform$Companion.makeTransform$default(this, sx, null, null, sy, null, null, 54, null);
        }

        @NotNull
        public final AffineTransform makeTranslation(@NotNull Number tx, @NotNull Number ty) {
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter((Object)ty, (String)"ty");
            return org.jetbrains.letsPlot.commons.geometry.AffineTransform$Companion.makeTransform$default(this, null, null, null, null, tx, ty, 15, null);
        }

        @NotNull
        public final AffineTransform makeShear(@NotNull Number rx, @NotNull Number ry) {
            Intrinsics.checkNotNullParameter((Object)rx, (String)"rx");
            Intrinsics.checkNotNullParameter((Object)ry, (String)"ry");
            return org.jetbrains.letsPlot.commons.geometry.AffineTransform$Companion.makeTransform$default(this, null, ry, rx, null, null, null, 57, null);
        }

        @NotNull
        public final AffineTransform makeRotation(@NotNull Number angle, @NotNull Number centerX, @NotNull Number centerY) {
            Intrinsics.checkNotNullParameter((Object)angle, (String)"angle");
            Intrinsics.checkNotNullParameter((Object)centerX, (String)"centerX");
            Intrinsics.checkNotNullParameter((Object)centerY, (String)"centerY");
            double tolerance = 2.44140625E-4;
            Double d = Math.sin(angle.doubleValue());
            double it = ((Number)d).doubleValue();
            boolean bl = false;
            Double d2 = Math.abs(it) > tolerance ? d : null;
            double sin = d2 != null ? d2 : 0.0;
            Double d3 = Math.cos(angle.doubleValue());
            double it2 = ((Number)d3).doubleValue();
            boolean bl2 = false;
            Double d4 = Math.abs(it2) > tolerance ? d3 : null;
            double cos = d4 != null ? d4 : 0.0;
            DoubleVector center = new DoubleVector(centerX, centerY);
            double d5 = -sin;
            double d6 = center.getX() * (1.0 - cos) + center.getY() * sin;
            double d7 = center.getY() * (1.0 - cos) - center.getX() * sin;
            return this.makeTransform(cos, sin, d5, cos, d6, d7);
        }

        public static /* synthetic */ AffineTransform makeRotation$default(Companion companion, Number number, Number number2, Number number3, int n, Object object) {
            if ((n & 2) != 0) {
                number2 = 0;
            }
            if ((n & 4) != 0) {
                number3 = 0;
            }
            return companion.makeRotation(number, number2, number3);
        }

        @NotNull
        public final AffineTransform makeTransform(@NotNull Number sx, @NotNull Number ry, @NotNull Number rx, @NotNull Number sy, @NotNull Number tx, @NotNull Number ty) {
            Intrinsics.checkNotNullParameter((Object)sx, (String)"sx");
            Intrinsics.checkNotNullParameter((Object)ry, (String)"ry");
            Intrinsics.checkNotNullParameter((Object)rx, (String)"rx");
            Intrinsics.checkNotNullParameter((Object)sy, (String)"sy");
            Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
            Intrinsics.checkNotNullParameter((Object)ty, (String)"ty");
            return new AffineTransform(sx.doubleValue(), ry.doubleValue(), rx.doubleValue(), sy.doubleValue(), tx.doubleValue(), ty.doubleValue());
        }

        public static /* synthetic */ AffineTransform makeTransform$default(Companion companion, Number number, Number number2, Number number3, Number number4, Number number5, Number number6, int n, Object object) {
            if ((n & 1) != 0) {
                number = 1;
            }
            if ((n & 2) != 0) {
                number2 = 0;
            }
            if ((n & 4) != 0) {
                number3 = 0;
            }
            if ((n & 8) != 0) {
                number4 = 1;
            }
            if ((n & 0x10) != 0) {
                number5 = 0;
            }
            if ((n & 0x20) != 0) {
                number6 = 0;
            }
            return companion.makeTransform(number, number2, number3, number4, number5, number6);
        }

        @NotNull
        public final AffineTransform makeMatrix(@NotNull Number m00, @NotNull Number m10, @NotNull Number m01, @NotNull Number m11, @NotNull Number m02, @NotNull Number m12) {
            Intrinsics.checkNotNullParameter((Object)m00, (String)"m00");
            Intrinsics.checkNotNullParameter((Object)m10, (String)"m10");
            Intrinsics.checkNotNullParameter((Object)m01, (String)"m01");
            Intrinsics.checkNotNullParameter((Object)m11, (String)"m11");
            Intrinsics.checkNotNullParameter((Object)m02, (String)"m02");
            Intrinsics.checkNotNullParameter((Object)m12, (String)"m12");
            return new AffineTransform(m00.doubleValue(), m10.doubleValue(), m01.doubleValue(), m11.doubleValue(), m02.doubleValue(), m12.doubleValue());
        }

        public static /* synthetic */ AffineTransform makeMatrix$default(Companion companion, Number number, Number number2, Number number3, Number number4, Number number5, Number number6, int n, Object object) {
            if ((n & 1) != 0) {
                number = 1;
            }
            if ((n & 2) != 0) {
                number2 = 0;
            }
            if ((n & 4) != 0) {
                number3 = 0;
            }
            if ((n & 8) != 0) {
                number4 = 1;
            }
            if ((n & 0x10) != 0) {
                number5 = 0;
            }
            if ((n & 0x20) != 0) {
                number6 = 0;
            }
            return companion.makeMatrix(number, number2, number3, number4, number5, number6);
        }

        @NotNull
        public final AffineTransform makeTranslate(@NotNull Number dx, @NotNull Number dy) {
            Intrinsics.checkNotNullParameter((Object)dx, (String)"dx");
            Intrinsics.checkNotNullParameter((Object)dy, (String)"dy");
            return this.makeTranslation(dx, dy);
        }

        @Nullable
        public final AffineTransform restoreTransform(@NotNull AffineTransform current, @NotNull AffineTransform next) {
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            Intrinsics.checkNotNullParameter((Object)next, (String)"next");
            AffineTransform affineTransform = current.inverse();
            if (affineTransform == null) {
                return null;
            }
            AffineTransform inv = affineTransform;
            return next.concat(inv);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

