/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.values;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.values.Color;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bJ\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bJ\u001e\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0015\u001a\u00020\u0004H\u0007J!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0007J\u0016\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004J\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0007J\u001a\u0010#\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\b\b\u0002\u0010\u0015\u001a\u00020\u0004H\u0007J\u000e\u0010$\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\bJ\u001e\u0010%\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\bJ\u0010\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0002J\u000e\u0010*\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0007J,\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\b\b\u0002\u0010\u001f\u001a\u00020\u00042\b\b\u0002\u0010&\u001a\u00020\u0004H\u0007J\u000e\u0010-\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\bJ\u0016\u0010.\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010/\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/letsPlot/commons/values/Colors;", "", "()V", "DEFAULT_FACTOR", "", "baseColors", "", "", "Lorg/jetbrains/letsPlot/commons/values/Color;", "grayscaleColors", "namedColors", "transparentColors", "colorLuminance", "componentValue", "", "contrast", "color", "other", "contrastRatio", "darker", "c", "factor", "distributeEvenly", "", "count", "saturation", "(ID)[Lorg/jetbrains/letsPlot/commons/values/Color;", "forName", "colorName", "generateColor", "s", "v", "generateHueColor", "isColorName", "", "lighter", "luminance", "mimicTransparency", "alpha", "background", "normalizeColorName", "name", "parseColor", "rgbFromHsv", "h", "solid", "withOpacity", "opacity", "commons"})
@SourceDebugExtension(value={"SMAP\nColors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Colors.kt\norg/jetbrains/letsPlot/commons/values/Colors\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,353:1\n1179#2,2:354\n1253#2,4:356\n*S KotlinDebug\n*F\n+ 1 Colors.kt\norg/jetbrains/letsPlot/commons/values/Colors\n*L\n15#1:354,2\n15#1:356,4\n*E\n"})
public final class Colors {
    @NotNull
    public static final Colors INSTANCE;
    private static final double DEFAULT_FACTOR = 0.7;
    @NotNull
    private static final Map<String, Color> grayscaleColors;
    @NotNull
    private static final Map<String, Color> transparentColors;
    @NotNull
    private static final Map<String, Color> baseColors;
    @NotNull
    private static final Map<String, Color> namedColors;

    private Colors() {
    }

    @NotNull
    public final Color parseColor(@NotNull String c) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (StringsKt.indexOf$default((CharSequence)c, (char)'(', (int)0, (boolean)false, (int)6, null) > 0) {
            color = Color.Companion.parseRGB(c);
        } else if (StringsKt.startsWith$default((String)c, (String)"#", (boolean)false, (int)2, null)) {
            color = Color.Companion.parseHex(c);
        } else if (this.isColorName(c)) {
            color = this.forName(c);
        } else {
            throw new IllegalArgumentException("Error parsing color value: " + c);
        }
        return color;
    }

    private final String normalizeColorName(String name) {
        String string = StringsKt.replace$default((String)StringsKt.replace$default((String)name, (String)"-", (String)"", (boolean)false, (int)4, null), (String)"_", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return StringsKt.replace$default((String)string, (String)"grey", (String)"gray", (boolean)false, (int)4, null);
    }

    public final boolean isColorName(@NotNull String colorName) {
        Intrinsics.checkNotNullParameter((Object)colorName, (String)"colorName");
        return namedColors.containsKey(this.normalizeColorName(colorName));
    }

    @NotNull
    public final Color forName(@NotNull String colorName) {
        Intrinsics.checkNotNullParameter((Object)colorName, (String)"colorName");
        Color color = namedColors.get(this.normalizeColorName(colorName));
        if (color == null) {
            throw new IllegalArgumentException();
        }
        return color;
    }

    public final double generateHueColor() {
        return (double)360 * Random.Default.nextDouble();
    }

    @NotNull
    public final Color generateColor(double s, double v) {
        return Colors.rgbFromHsv$default(this, (double)360 * Random.Default.nextDouble(), s, v, 0.0, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Color rgbFromHsv(double h, double s, double v, double alpha) {
        double hd = h / (double)60;
        double c = v * s;
        double x2 = c * (1.0 - Math.abs(hd % (double)2 - 1.0));
        double r = 0.0;
        double g = 0.0;
        double b2 = 0.0;
        if (hd < 1.0) {
            r = c;
            g = x2;
        } else if (hd < 2.0) {
            r = x2;
            g = c;
        } else if (hd < 3.0) {
            g = c;
            b2 = x2;
        } else if (hd < 4.0) {
            g = x2;
            b2 = c;
        } else if (hd < 5.0) {
            r = x2;
            b2 = c;
        } else {
            r = c;
            b2 = x2;
        }
        double m = v - c;
        return new Color(MathKt.roundToInt((double)((double)255 * (r + m))), MathKt.roundToInt((double)((double)255 * (g + m))), MathKt.roundToInt((double)((double)255 * (b2 + m))), MathKt.roundToInt((double)((double)255 * alpha)));
    }

    public static /* synthetic */ Color rgbFromHsv$default(Colors colors, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 4) != 0) {
            d3 = 1.0;
        }
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        return colors.rgbFromHsv(d, d2, d3, d4);
    }

    @JvmOverloads
    @Nullable
    public final Color darker(@Nullable Color c, double factor) {
        Color color;
        Color color2 = c;
        if (color2 != null) {
            Color it = color2;
            boolean bl = false;
            color = new Color(Math.max((int)((double)c.getRed() * factor), 0), Math.max((int)((double)c.getGreen() * factor), 0), Math.max((int)((double)c.getBlue() * factor), 0), c.getAlpha());
        } else {
            color = null;
        }
        return color;
    }

    public static /* synthetic */ Color darker$default(Colors colors, Color color, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.7;
        }
        return colors.darker(color, d);
    }

    @JvmOverloads
    @NotNull
    public final Color lighter(@NotNull Color c, double factor) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        int r = c.getRed();
        int g = c.getGreen();
        int b2 = c.getBlue();
        int alpha = c.getAlpha();
        int i = (int)(1.0 / (1.0 - factor));
        if (r == 0 && g == 0 && b2 == 0) {
            return new Color(i, i, i, alpha);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b2 > 0 && b2 < i) {
            b2 = i;
        }
        return new Color(Math.min((int)((double)r / factor), 255), Math.min((int)((double)g / factor), 255), Math.min((int)((double)b2 / factor), 255), alpha);
    }

    public static /* synthetic */ Color lighter$default(Colors colors, Color color, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.7;
        }
        return colors.lighter(color, d);
    }

    @NotNull
    public final Color mimicTransparency(@NotNull Color color, double alpha, @NotNull Color background) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        int red = (int)((double)color.getRed() * alpha + (double)background.getRed() * (1.0 - alpha));
        int green = (int)((double)color.getGreen() * alpha + (double)background.getGreen() * (1.0 - alpha));
        int blue = (int)((double)color.getBlue() * alpha + (double)background.getBlue() * (1.0 - alpha));
        return new Color(red, green, blue, 0, 8, null);
    }

    @NotNull
    public final Color withOpacity(@NotNull Color c, double opacity) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return c.changeAlpha(Math.max(0, Math.min(255, (int)Math.rint((double)255 * opacity))));
    }

    public final double contrast(@NotNull Color color, @NotNull Color other) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (this.luminance(color) + 0.05) / (this.luminance(other) + 0.05);
    }

    public final double contrastRatio(@NotNull Color color, @NotNull Color other) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double l1 = this.luminance(color);
        double l2 = this.luminance(other);
        return (Math.max(l1, l2) + 0.05) / (Math.min(l1, l2) + 0.05);
    }

    public final double luminance(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return 0.2126 * this.colorLuminance(color.getRed()) + 0.7152 * this.colorLuminance(color.getGreen()) + 0.0722 * this.colorLuminance(color.getBlue());
    }

    private final double colorLuminance(int componentValue) {
        return componentValue <= 10 ? (double)componentValue / 3294.0 : Math.pow((double)componentValue / 269.0 + 0.0513, 2.4);
    }

    public final boolean solid(@NotNull Color c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return c.getAlpha() == 255;
    }

    @NotNull
    public final Color[] distributeEvenly(int count2, double saturation) {
        Color[] result2 = new Color[count2];
        int sector = 360 / count2;
        for (int i = 0; i < count2; ++i) {
            result2[i] = Colors.rgbFromHsv$default(this, sector * i, saturation, 0.0, 0.0, 12, null);
        }
        return result2;
    }

    @JvmOverloads
    @NotNull
    public final Color rgbFromHsv(double h, double s, double v) {
        return Colors.rgbFromHsv$default(this, h, s, v, 0.0, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Color rgbFromHsv(double h, double s) {
        return Colors.rgbFromHsv$default(this, h, s, 0.0, 0.0, 12, null);
    }

    @JvmOverloads
    @Nullable
    public final Color darker(@Nullable Color c) {
        return Colors.darker$default(this, c, 0.0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Color lighter(@NotNull Color c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return Colors.lighter$default(this, c, 0.0, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateTo$iv$iv;
        INSTANCE = new Colors();
        Iterable $this$associate$iv = (Iterable)new IntRange(0, 100);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        Iterator iterator2 = $this$associateTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv$iv = ((IntIterator)iterator2).nextInt();
            Map map2 = destination$iv$iv;
            int i = element$iv$iv;
            boolean bl = false;
            Pair pair2 = TuplesKt.to((Object)("gray" + i), (Object)Color.Companion.gray(i));
            map2.put(pair2.getFirst(), pair2.getSecond());
        }
        grayscaleColors = destination$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"transparent", (Object)Color.Companion.getTRANSPARENT()), TuplesKt.to((Object)"blank", (Object)Color.Companion.getTRANSPARENT()), TuplesKt.to((Object)"", (Object)Color.Companion.getTRANSPARENT())};
        transparentColors = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"aliceblue", (Object)Color.Companion.getALICE_BLUE()), TuplesKt.to((Object)"antiquewhite", (Object)Color.Companion.getANTIQUE_WHITE()), TuplesKt.to((Object)"aqua", (Object)Color.Companion.getAQUA()), TuplesKt.to((Object)"aquamarine", (Object)Color.Companion.getAQUAMARINE()), TuplesKt.to((Object)"azure", (Object)Color.Companion.getAZURE()), TuplesKt.to((Object)"beige", (Object)Color.Companion.getBEIGE()), TuplesKt.to((Object)"bisque", (Object)Color.Companion.getBISQUE()), TuplesKt.to((Object)"black", (Object)Color.Companion.getBLACK()), TuplesKt.to((Object)"blanchedalmond", (Object)Color.Companion.getBLANCHED_ALMOND()), TuplesKt.to((Object)"blue", (Object)Color.Companion.getBLUE()), TuplesKt.to((Object)"blueviolet", (Object)Color.Companion.getBLUE_VIOLET()), TuplesKt.to((Object)"brown", (Object)Color.Companion.getBROWN()), TuplesKt.to((Object)"burlywood", (Object)Color.Companion.getBURLY_WOOD()), TuplesKt.to((Object)"cadetblue", (Object)Color.Companion.getCADET_BLUE()), TuplesKt.to((Object)"chartreuse", (Object)Color.Companion.getCHARTREUSE()), TuplesKt.to((Object)"chocolate", (Object)Color.Companion.getCHOCOLATE()), TuplesKt.to((Object)"coral", (Object)Color.Companion.getCORAL()), TuplesKt.to((Object)"cornflowerblue", (Object)Color.Companion.getCORNFLOWER_BLUE()), TuplesKt.to((Object)"cornsilk", (Object)Color.Companion.getCORNSILK()), TuplesKt.to((Object)"crimson", (Object)Color.Companion.getCRIMSON()), TuplesKt.to((Object)"cyan", (Object)Color.Companion.getCYAN()), TuplesKt.to((Object)"darkblue", (Object)Color.Companion.getDARK_BLUE()), TuplesKt.to((Object)"darkcyan", (Object)Color.Companion.getDARK_CYAN()), TuplesKt.to((Object)"darkgoldenrod", (Object)Color.Companion.getDARK_GOLDENROD()), TuplesKt.to((Object)"darkgray", (Object)Color.Companion.getDARK_GRAY()), TuplesKt.to((Object)"darkgreen", (Object)Color.Companion.getDARK_GREEN()), TuplesKt.to((Object)"darkkhaki", (Object)Color.Companion.getDARK_KHAKI()), TuplesKt.to((Object)"darkmagenta", (Object)Color.Companion.getDARK_MAGENTA()), TuplesKt.to((Object)"darkolivegreen", (Object)Color.Companion.getDARK_OLIVE_GREEN()), TuplesKt.to((Object)"darkorange", (Object)Color.Companion.getDARK_ORANGE()), TuplesKt.to((Object)"darkorchid", (Object)Color.Companion.getDARK_ORCHID()), TuplesKt.to((Object)"darkred", (Object)Color.Companion.getDARK_RED()), TuplesKt.to((Object)"darksalmon", (Object)Color.Companion.getDARK_SALMON()), TuplesKt.to((Object)"darkseagreen", (Object)Color.Companion.getDARK_SEA_GREEN()), TuplesKt.to((Object)"darkslateblue", (Object)Color.Companion.getDARK_SLATE_BLUE()), TuplesKt.to((Object)"darkslategray", (Object)Color.Companion.getDARK_SLATE_GRAY()), TuplesKt.to((Object)"darkturquoise", (Object)Color.Companion.getDARK_TURQUOISE()), TuplesKt.to((Object)"darkviolet", (Object)Color.Companion.getDARK_VIOLET()), TuplesKt.to((Object)"deeppink", (Object)Color.Companion.getDEEP_PINK()), TuplesKt.to((Object)"deepskyblue", (Object)Color.Companion.getDEEP_SKY_BLUE()), TuplesKt.to((Object)"dimgray", (Object)Color.Companion.getDIM_GRAY()), TuplesKt.to((Object)"dodgerblue", (Object)Color.Companion.getDODGER_BLUE()), TuplesKt.to((Object)"firebrick", (Object)Color.Companion.getFIREBRICK()), TuplesKt.to((Object)"floralwhite", (Object)Color.Companion.getFLORAL_WHITE()), TuplesKt.to((Object)"forestgreen", (Object)Color.Companion.getFOREST_GREEN()), TuplesKt.to((Object)"fuchsia", (Object)Color.Companion.getFUCHSIA()), TuplesKt.to((Object)"gainsboro", (Object)Color.Companion.getGAINSBORO()), TuplesKt.to((Object)"ghostwhite", (Object)Color.Companion.getGHOST_WHITE()), TuplesKt.to((Object)"gold", (Object)Color.Companion.getGOLD()), TuplesKt.to((Object)"goldenrod", (Object)Color.Companion.getGOLDENROD()), TuplesKt.to((Object)"gray", (Object)Color.Companion.getGRAY()), TuplesKt.to((Object)"green", (Object)Color.Companion.getGREEN()), TuplesKt.to((Object)"greenyellow", (Object)Color.Companion.getGREEN_YELLOW()), TuplesKt.to((Object)"honeydew", (Object)Color.Companion.getHONEY_DEW()), TuplesKt.to((Object)"hotpink", (Object)Color.Companion.getHOT_PINK()), TuplesKt.to((Object)"indianred", (Object)Color.Companion.getINDIAN_RED()), TuplesKt.to((Object)"indigo", (Object)Color.Companion.getINDIGO()), TuplesKt.to((Object)"ivory", (Object)Color.Companion.getIVORY()), TuplesKt.to((Object)"khaki", (Object)Color.Companion.getKHAKI()), TuplesKt.to((Object)"lavender", (Object)Color.Companion.getLAVENDER()), TuplesKt.to((Object)"lavenderblush", (Object)Color.Companion.getLAVENDER_BLUSH()), TuplesKt.to((Object)"lawngreen", (Object)Color.Companion.getLAWN_GREEN()), TuplesKt.to((Object)"lemonchiffon", (Object)Color.Companion.getLEMON_CHIFFON()), TuplesKt.to((Object)"lightblue", (Object)Color.Companion.getLIGHT_BLUE()), TuplesKt.to((Object)"lightcoral", (Object)Color.Companion.getLIGHT_CORAL()), TuplesKt.to((Object)"lightcyan", (Object)Color.Companion.getLIGHT_CYAN()), TuplesKt.to((Object)"lightgoldenrod", (Object)Color.Companion.getLIGHT_GOLDENROD()), TuplesKt.to((Object)"lightgoldenrodyellow", (Object)Color.Companion.getLIGHT_GOLDENROD_YELLOW()), TuplesKt.to((Object)"lightgray", (Object)Color.Companion.getLIGHT_GRAY()), TuplesKt.to((Object)"lightgreen", (Object)Color.Companion.getLIGHT_GREEN()), TuplesKt.to((Object)"lightmagenta", (Object)Color.Companion.getLIGHT_MAGENTA()), TuplesKt.to((Object)"lightpink", (Object)Color.Companion.getLIGHT_PINK()), TuplesKt.to((Object)"lightsalmon", (Object)Color.Companion.getLIGHT_SALMON()), TuplesKt.to((Object)"lightseagreen", (Object)Color.Companion.getLIGHT_SEA_GREEN()), TuplesKt.to((Object)"lightskyblue", (Object)Color.Companion.getLIGHT_SKY_BLUE()), TuplesKt.to((Object)"lightslateblue", (Object)Color.Companion.getLIGHT_SLATE_BLUE()), TuplesKt.to((Object)"lightslategray", (Object)Color.Companion.getLIGHT_SLATE_GRAY()), TuplesKt.to((Object)"lightsteelblue", (Object)Color.Companion.getLIGHT_STEEL_BLUE()), TuplesKt.to((Object)"lightyellow", (Object)Color.Companion.getLIGHT_YELLOW()), TuplesKt.to((Object)"lime", (Object)Color.Companion.getLIME()), TuplesKt.to((Object)"limegreen", (Object)Color.Companion.getLIME_GREEN()), TuplesKt.to((Object)"linen", (Object)Color.Companion.getLINEN()), TuplesKt.to((Object)"magenta", (Object)Color.Companion.getMAGENTA()), TuplesKt.to((Object)"maroon", (Object)Color.Companion.getMAROON()), TuplesKt.to((Object)"mediumaquamarine", (Object)Color.Companion.getMEDIUM_AQUAMARINE()), TuplesKt.to((Object)"mediumblue", (Object)Color.Companion.getMEDIUM_BLUE()), TuplesKt.to((Object)"mediumorchid", (Object)Color.Companion.getMEDIUM_ORCHID()), TuplesKt.to((Object)"mediumpurple", (Object)Color.Companion.getMEDIUM_PURPLE()), TuplesKt.to((Object)"mediumseagreen", (Object)Color.Companion.getMEDIUM_SEA_GREEN()), TuplesKt.to((Object)"mediumslateblue", (Object)Color.Companion.getMEDIUM_SLATE_BLUE()), TuplesKt.to((Object)"mediumspringgreen", (Object)Color.Companion.getMEDIUM_SPRING_GREEN()), TuplesKt.to((Object)"mediumturquoise", (Object)Color.Companion.getMEDIUM_TURQUOISE()), TuplesKt.to((Object)"mediumvioletred", (Object)Color.Companion.getMEDIUM_VIOLET_RED()), TuplesKt.to((Object)"midnightblue", (Object)Color.Companion.getMIDNIGHT_BLUE()), TuplesKt.to((Object)"mintcream", (Object)Color.Companion.getMINT_CREAM()), TuplesKt.to((Object)"mistyrose", (Object)Color.Companion.getMISTY_ROSE()), TuplesKt.to((Object)"moccasin", (Object)Color.Companion.getMOCCASIN()), TuplesKt.to((Object)"navajowhite", (Object)Color.Companion.getNAVAJO_WHITE()), TuplesKt.to((Object)"navy", (Object)Color.Companion.getNAVY()), TuplesKt.to((Object)"navyblue", (Object)Color.Companion.getNAVY()), TuplesKt.to((Object)"oldlace", (Object)Color.Companion.getOLD_LACE()), TuplesKt.to((Object)"olive", (Object)Color.Companion.getOLIVE()), TuplesKt.to((Object)"olivedrab", (Object)Color.Companion.getOLIVE_DRAB()), TuplesKt.to((Object)"orange", (Object)Color.Companion.getORANGE()), TuplesKt.to((Object)"orangered", (Object)Color.Companion.getORANGE_RED()), TuplesKt.to((Object)"orchid", (Object)Color.Companion.getORCHID()), TuplesKt.to((Object)"pacificblue", (Object)Color.Companion.getPACIFIC_BLUE()), TuplesKt.to((Object)"palegoldenrod", (Object)Color.Companion.getPALE_GOLDENROD()), TuplesKt.to((Object)"palegreen", (Object)Color.Companion.getPALE_GREEN()), TuplesKt.to((Object)"paleturquoise", (Object)Color.Companion.getPALE_TURQUOISE()), TuplesKt.to((Object)"palevioletred", (Object)Color.Companion.getPALE_VIOLET_RED()), TuplesKt.to((Object)"papayawhip", (Object)Color.Companion.getPAPAYA_WHIP()), TuplesKt.to((Object)"peachpuff", (Object)Color.Companion.getPEACH_PUFF()), TuplesKt.to((Object)"peru", (Object)Color.Companion.getPERU()), TuplesKt.to((Object)"pink", (Object)Color.Companion.getPINK()), TuplesKt.to((Object)"plum", (Object)Color.Companion.getPLUM()), TuplesKt.to((Object)"powderblue", (Object)Color.Companion.getPOWDERBLUE()), TuplesKt.to((Object)"purple", (Object)Color.Companion.getPURPLE()), TuplesKt.to((Object)"rebeccapurple", (Object)Color.Companion.getREBECCAPURPLE()), TuplesKt.to((Object)"red", (Object)Color.Companion.getRED()), TuplesKt.to((Object)"rosybrown", (Object)Color.Companion.getROSY_BROWN()), TuplesKt.to((Object)"royalblue", (Object)Color.Companion.getROYAL_BLUE()), TuplesKt.to((Object)"saddlebrown", (Object)Color.Companion.getSADDLE_BROWN()), TuplesKt.to((Object)"salmon", (Object)Color.Companion.getSALMON()), TuplesKt.to((Object)"sandybrown", (Object)Color.Companion.getSANDY_BROWN()), TuplesKt.to((Object)"seagreen", (Object)Color.Companion.getSEA_GREEN()), TuplesKt.to((Object)"seashell", (Object)Color.Companion.getSEA_SHELL()), TuplesKt.to((Object)"sienna", (Object)Color.Companion.getSIENNA()), TuplesKt.to((Object)"silver", (Object)Color.Companion.getSILVER()), TuplesKt.to((Object)"skyblue", (Object)Color.Companion.getSKY_BLUE()), TuplesKt.to((Object)"slateblue", (Object)Color.Companion.getSLATE_BLUE()), TuplesKt.to((Object)"slategray", (Object)Color.Companion.getSLATE_GRAY()), TuplesKt.to((Object)"snow", (Object)Color.Companion.getSNOW()), TuplesKt.to((Object)"springgreen", (Object)Color.Companion.getSPRING_GREEN()), TuplesKt.to((Object)"steelblue", (Object)Color.Companion.getSTEEL_BLUE()), TuplesKt.to((Object)"tan", (Object)Color.Companion.getTAN()), TuplesKt.to((Object)"teal", (Object)Color.Companion.getTEAL()), TuplesKt.to((Object)"thistle", (Object)Color.Companion.getTHISTLE()), TuplesKt.to((Object)"tomato", (Object)Color.Companion.getTOMATO()), TuplesKt.to((Object)"turquoise", (Object)Color.Companion.getTURQUOISE()), TuplesKt.to((Object)"violet", (Object)Color.Companion.getVIOLET()), TuplesKt.to((Object)"violetred", (Object)Color.Companion.getVIOLET_RED()), TuplesKt.to((Object)"wheat", (Object)Color.Companion.getWHEAT()), TuplesKt.to((Object)"white", (Object)Color.Companion.getWHITE()), TuplesKt.to((Object)"whitesmoke", (Object)Color.Companion.getWHITE_SMOKE()), TuplesKt.to((Object)"yellow", (Object)Color.Companion.getYELLOW()), TuplesKt.to((Object)"yellowgreen", (Object)Color.Companion.getYELLOW_GREEN())};
        baseColors = MapsKt.mapOf((Pair[])pairArray);
        namedColors = MapsKt.plus((Map)MapsKt.plus(baseColors, grayscaleColors), transparentColors);
    }
}

