/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.axis.label;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeometryUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AbstractFixedBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.BreakLabelsLayoutUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0011H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/HorizontalRotatedLabelsLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AbstractFixedBreaksLabelsLayout;", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;)V", "myRotationAngle", "", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "axisLength", "hAnchorForVerticalLabels", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "vjust", "labelBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "labelNormalSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "vAnchorForVerticalLabels", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;", "hjust", "yOffsetCoefficient", "isLabelDirectedFromTick", "", "horizontalAnchor", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nHorizontalRotatedLabelsLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HorizontalRotatedLabelsLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/HorizontalRotatedLabelsLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1#2:194\n1789#3,3:195\n1549#3:198\n1620#3,3:199\n1549#3:202\n1620#3,3:203\n1549#3:206\n1620#3,3:207\n*S KotlinDebug\n*F\n+ 1 HorizontalRotatedLabelsLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/HorizontalRotatedLabelsLayout\n*L\n46#1:195,3\n136#1:198\n136#1:199,3\n140#1:202\n140#1:203,3\n151#1:206\n151#1:207,3\n*E\n"})
public final class HorizontalRotatedLabelsLayout
extends AbstractFixedBreaksLabelsLayout {
    private final double myRotationAngle;

    /*
     * WARNING - void declaration
     */
    public HorizontalRotatedLabelsLayout(@NotNull Orientation orientation, @NotNull ScaleBreaks breaks, @NotNull AxisTheme theme2) {
        void it;
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        super(orientation, breaks, theme2);
        Double d = theme2.labelAngle();
        double d2 = ((Number)d).doubleValue();
        HorizontalRotatedLabelsLayout horizontalRotatedLabelsLayout = this;
        boolean bl = false;
        boolean bl2 = !Double.isNaN((double)it);
        Double d3 = bl2 ? d : null;
        horizontalRotatedLabelsLayout.myRotationAngle = d3 != null ? d3 : 0.0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AxisLabelsLayoutInfo doLayout(@NotNull DoubleSpan axisDomain, double axisLength) {
        Iterable $this$mapTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        double vJust;
        boolean bl;
        double d;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        if (this.getBreaks().isEmpty()) {
            return this.noLabelsLayoutInfo(axisLength, this.getOrientation());
        }
        if (!this.getTheme().showLabels()) {
            return this.noLabelsLayoutInfo(axisLength, this.getOrientation());
        }
        List<Double> ticks = this.getBreaks().projectOnAxis(axisDomain, axisLength, true);
        List<DoubleRectangle> labelBoundsList2 = this.labelBoundsList(ticks, this.getBreaks().getLabels(), AbstractFixedBreaksLabelsLayout.Companion.getHORIZONTAL_TICK_LOCATION());
        boolean overlap = false;
        Iterable iterable = labelBoundsList2;
        DoubleRectangle initial$iv = null;
        boolean $i$f$fold = false;
        DoubleRectangle accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void b2;
            DoubleRectangle doubleRectangle = (DoubleRectangle)element$iv;
            DoubleRectangle acc = accumulator$iv;
            boolean bl2 = false;
            overlap = overlap || acc != null && acc.xRange().connected(b2.xRange().expanded(4.0));
            accumulator$iv = GeometryUtil.INSTANCE.union((DoubleRectangle)b2, acc);
        }
        DoubleRectangle doubleRectangle = accumulator$iv;
        Intrinsics.checkNotNull(doubleRectangle);
        DoubleRectangle bounds = doubleRectangle;
        Iterator iterator2 = ((Iterable)labelBoundsList2).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        DoubleRectangle it = (DoubleRectangle)iterator2.next();
        boolean bl3 = false;
        double b2 = it.getHeight();
        while (iterator2.hasNext()) {
            DoubleRectangle it2 = (DoubleRectangle)iterator2.next();
            $i$a$-maxOf-HorizontalRotatedLabelsLayout$doLayout$maxLabelHeight$1 = false;
            double d2 = it2.getHeight();
            b2 = Math.max(b2, d2);
        }
        double maxLabelHeight = b2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getOrientation().ordinal()]) {
            case 1: {
                d = -1.0;
                break;
            }
            case 2: {
                d = 1.0;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported orientation " + (Object)((Object)this.getOrientation()));
            }
        }
        double orientationSign = d;
        double radAngle = MathKt.toRadians(this.myRotationAngle);
        double sinA = Math.sin(radAngle);
        double cosA = Math.cos(radAngle);
        boolean isVertical = Math.abs(cosA) < 1.0E-6;
        boolean isUpsideDown = cosA < 0.0;
        boolean isHorizontal = Math.abs(sinA) < 1.0E-6 && !isUpsideDown;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getOrientation().ordinal()]) {
            case 1: {
                if (sinA > 0.0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (sinA < 0.0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported orientation " + (Object)((Object)this.getOrientation()));
            }
        }
        boolean isLabelDirectedFromTick = bl;
        double d3 = Double.isNaN(this.getTheme().labelVJust()) ? (this.getOrientation() == Orientation.BOTTOM ? 1.0 : 0.0) : (vJust = this.getTheme().labelVJust());
        double hJust = Double.isNaN(this.getTheme().labelHJust()) ? (isHorizontal || isVertical ? 0.5 : (isLabelDirectedFromTick ? 0.0 : 1.0)) : this.getTheme().labelHJust();
        Text.HorizontalAnchor horizontalAnchor = isVertical ? this.hAnchorForVerticalLabels(vJust) : (isUpsideDown ? Text.HorizontalAnchor.MIDDLE : (hJust == 0.0 && (isHorizontal || isLabelDirectedFromTick) ? Text.HorizontalAnchor.LEFT : (hJust == 1.0 && (isHorizontal || !isLabelDirectedFromTick) ? Text.HorizontalAnchor.RIGHT : Text.HorizontalAnchor.MIDDLE)));
        boolean isCornerCase = !isHorizontal && horizontalAnchor != Text.HorizontalAnchor.MIDDLE;
        Function1 yBBoxOffset2 = (Function1)new Function1<DoubleRectangle, Double>(orientationSign, maxLabelHeight, vJust){
            final /* synthetic */ double $orientationSign;
            final /* synthetic */ double $maxLabelHeight;
            final /* synthetic */ double $vJust;
            {
                this.$orientationSign = $orientationSign;
                this.$maxLabelHeight = $maxLabelHeight;
                this.$vJust = $vJust;
                super(1);
            }

            @NotNull
            public final Double invoke(@NotNull DoubleRectangle rect2) {
                Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                return this.$orientationSign * this.$maxLabelHeight / (double)2 + (this.$maxLabelHeight - rect2.getHeight()) * (0.5 - this.$vJust);
            }
        };
        Function1 xBBoxOffset2 = (Function1)new Function1<DoubleRectangle, Double>(hJust){
            final /* synthetic */ double $hJust;
            {
                this.$hJust = $hJust;
                super(1);
            }

            @NotNull
            public final Double invoke(@NotNull DoubleRectangle rect2) {
                Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                return rect2.getWidth() * (0.5 - this.$hJust);
            }
        };
        Text.VerticalAnchor verticalAnchor = isVertical ? this.vAnchorForVerticalLabels(hJust) : (isHorizontal && vJust == 0.0 ? Text.VerticalAnchor.BOTTOM : (isHorizontal && vJust == 1.0 ? Text.VerticalAnchor.TOP : (isCornerCase && this.getOrientation() == Orientation.BOTTOM ? Text.VerticalAnchor.TOP : (isCornerCase && this.getOrientation() == Orientation.TOP ? Text.VerticalAnchor.BOTTOM : Text.VerticalAnchor.CENTER))));
        double yOffsetSpecial = orientationSign * maxLabelHeight * this.yOffsetCoefficient(isLabelDirectedFromTick, horizontalAnchor);
        Function1 yOffset2 = (Function1)new Function1<DoubleRectangle, Double>(isVertical, horizontalAnchor, yOffsetSpecial, isCornerCase, maxLabelHeight, orientationSign, vJust, isHorizontal, verticalAnchor, (Function1<? super DoubleRectangle, Double>)yBBoxOffset2){
            final /* synthetic */ boolean $isVertical;
            final /* synthetic */ Text.HorizontalAnchor $horizontalAnchor;
            final /* synthetic */ double $yOffsetSpecial;
            final /* synthetic */ boolean $isCornerCase;
            final /* synthetic */ double $maxLabelHeight;
            final /* synthetic */ double $orientationSign;
            final /* synthetic */ double $vJust;
            final /* synthetic */ boolean $isHorizontal;
            final /* synthetic */ Text.VerticalAnchor $verticalAnchor;
            final /* synthetic */ Function1<DoubleRectangle, Double> $yBBoxOffset;
            {
                this.$isVertical = $isVertical;
                this.$horizontalAnchor = $horizontalAnchor;
                this.$yOffsetSpecial = $yOffsetSpecial;
                this.$isCornerCase = $isCornerCase;
                this.$maxLabelHeight = $maxLabelHeight;
                this.$orientationSign = $orientationSign;
                this.$vJust = $vJust;
                this.$isHorizontal = $isHorizontal;
                this.$verticalAnchor = $verticalAnchor;
                this.$yBBoxOffset = $yBBoxOffset;
                super(1);
            }

            @NotNull
            public final Double invoke(@NotNull DoubleRectangle rect2) {
                Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                return this.$isVertical && this.$horizontalAnchor != Text.HorizontalAnchor.MIDDLE ? this.$yOffsetSpecial : (this.$isCornerCase ? (this.$maxLabelHeight - rect2.getHeight()) * ((this.$orientationSign + 1.0) / (double)2 - this.$vJust) : (this.$isHorizontal && this.$verticalAnchor == Text.VerticalAnchor.TOP ? ((Number)this.$yBBoxOffset.invoke((Object)rect2)).doubleValue() - rect2.getHeight() / (double)2 : (this.$isHorizontal && this.$verticalAnchor == Text.VerticalAnchor.BOTTOM ? ((Number)this.$yBBoxOffset.invoke((Object)rect2)).doubleValue() + rect2.getHeight() / (double)2 : ((Number)this.$yBBoxOffset.invoke((Object)rect2)).doubleValue())));
            }
        };
        Function1 xOffset2 = (Function1)new Function1<DoubleRectangle, Double>(isVertical, horizontalAnchor, (Function1<? super DoubleRectangle, Double>)xBBoxOffset2){
            final /* synthetic */ boolean $isVertical;
            final /* synthetic */ Text.HorizontalAnchor $horizontalAnchor;
            final /* synthetic */ Function1<DoubleRectangle, Double> $xBBoxOffset;
            {
                this.$isVertical = $isVertical;
                this.$horizontalAnchor = $horizontalAnchor;
                this.$xBBoxOffset = $xBBoxOffset;
                super(1);
            }

            @NotNull
            public final Double invoke(@NotNull DoubleRectangle rect2) {
                Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                return this.$isVertical ? 0.0 : (this.$horizontalAnchor != Text.HorizontalAnchor.MIDDLE ? 0.0 : ((Number)this.$xBBoxOffset.invoke((Object)rect2)).doubleValue());
            }
        };
        Iterable $this$map$iv = labelBoundsList2;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            DoubleRectangle doubleRectangle2 = (DoubleRectangle)item$iv$iv;
            object = destination$iv$iv;
            boolean bl4 = false;
            object.add(new DoubleVector(((Number)xOffset2.invoke((Object)it3)).doubleValue(), ((Number)yOffset2.invoke((Object)it3)).doubleValue()));
        }
        List labelAdditionalOffsets = (List)destination$iv$iv;
        Iterable $this$map$iv2 = labelBoundsList2;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it4;
            DoubleRectangle bl4 = (DoubleRectangle)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl5 = false;
            DoubleVector origin = new DoubleVector(((Number)xBBoxOffset2.invoke((Object)it4)).doubleValue() + it4.getOrigin().getX(), ((Number)yBBoxOffset2.invoke((Object)it4)).doubleValue() + it4.getOrigin().getY() - orientationSign * it4.getHeight() / (double)2);
            object.add(new DoubleRectangle(origin, it4.getDimension()));
        }
        List adjustedLabelBoundsList = (List)destination$iv$iv2;
        $this$map$iv2 = adjustedLabelBoundsList;
        object = this.createAxisLabelsLayoutInfoBuilder(bounds, overlap).labelHorizontalAnchor(horizontalAnchor).labelVerticalAnchor(verticalAnchor).labelRotationAngle(-this.myRotationAngle).labelAdditionalOffsets(labelAdditionalOffsets);
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            DoubleRectangle it4 = (DoubleRectangle)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl6 = false;
            collection.add(this.alignToLabelMargin((DoubleRectangle)p0));
        }
        return ((AxisLabelsLayoutInfo.Builder)object).labelBoundsList((List)destination$iv$iv2).build();
    }

    @Override
    @NotNull
    protected DoubleRectangle labelBounds(@NotNull DoubleVector labelNormalSize) {
        Intrinsics.checkNotNullParameter((Object)labelNormalSize, (String)"labelNormalSize");
        DoubleRectangle it = BreakLabelsLayoutUtil.INSTANCE.rotatedLabelBounds(labelNormalSize, this.myRotationAngle);
        boolean bl = false;
        return BreakLabelsLayoutUtil.INSTANCE.horizontalCenteredLabelBounds(it.getDimension());
    }

    private final Text.VerticalAnchor vAnchorForVerticalLabels(double hjust) {
        if (!(hjust == 0.0) && !(hjust == 1.0)) {
            return Text.VerticalAnchor.CENTER;
        }
        double d = this.myRotationAngle;
        return d == 90.0 ? (hjust == 0.0 ? Text.VerticalAnchor.TOP : Text.VerticalAnchor.BOTTOM) : (d == -90.0 ? (hjust == 0.0 ? Text.VerticalAnchor.BOTTOM : Text.VerticalAnchor.TOP) : Text.VerticalAnchor.CENTER);
    }

    private final Text.HorizontalAnchor hAnchorForVerticalLabels(double vjust) {
        if (!(vjust == 0.0) && !(vjust == 1.0)) {
            return Text.HorizontalAnchor.MIDDLE;
        }
        double d = this.myRotationAngle;
        return d == 90.0 ? (vjust == 1.0 ? Text.HorizontalAnchor.RIGHT : Text.HorizontalAnchor.LEFT) : (d == -90.0 ? (vjust == 1.0 ? Text.HorizontalAnchor.LEFT : Text.HorizontalAnchor.RIGHT) : Text.HorizontalAnchor.MIDDLE);
    }

    private final double yOffsetCoefficient(boolean isLabelDirectedFromTick, Text.HorizontalAnchor horizontalAnchor) {
        return isLabelDirectedFromTick && horizontalAnchor == Text.HorizontalAnchor.RIGHT ? 1.0 : (!isLabelDirectedFromTick && horizontalAnchor == Text.HorizontalAnchor.LEFT ? 1.0 : (horizontalAnchor != Text.HorizontalAnchor.MIDDLE ? 0.0 : 0.5));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

