/*
 * Decompiled with CFR 0.152.
 */
package fleet.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0006\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0003H\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0003H\u0002\u001a0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u0001*\u00060\bj\u0002`\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0017"}, d2={"convertGlobToRegEx", "", "globString", "", "ranges", "", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "matchingBraces", "", "getNumericRange", "choice", "findChar", "", "c", "", "stopAt", "pattern", "length", "start", "escapeToRegex", "fleet.util.core"})
@SourceDebugExtension(value={"SMAP\nGlob.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Glob.kt\nfleet/util/GlobKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class GlobKt {
    public static final void convertGlobToRegEx(@NotNull String globString, @NotNull List<int[]> ranges, @NotNull StringBuilder result) {
        Intrinsics.checkNotNullParameter((Object)globString, (String)"globString");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        int length = globString.length();
        int i = 0;
        int braceLevel = 0;
        boolean matchingBraces = GlobKt.matchingBraces(globString);
        boolean escaped = false;
        boolean inBrackets = false;
        while (i < length) {
            char current = globString.charAt(i);
            ++i;
            if (current == '*') {
                if (i < length && globString.charAt(i) == '*') {
                    result.append(".*");
                    v0 = i++;
                } else {
                    v0 = result.append("[^/]*");
                }
            } else if (current == '?') {
                result.append(".");
            } else if (current == '[') {
                boolean seenSlash;
                boolean bl = seenSlash = GlobKt.findChar('/', ']', globString, length, i) >= 0;
                if (seenSlash || escaped) {
                    v2 = result.append("\\[");
                } else if (i < length && StringsKt.indexOf$default((CharSequence)"!^", (char)globString.charAt(i), (int)0, (boolean)false, (int)6, null) >= 0) {
                    ++i;
                    v2 = result.append("[^");
                } else {
                    v2 = result.append("[");
                }
                inBrackets = true;
            } else if (current == ']' || current == '-' && inBrackets) {
                if (escaped) {
                    result.append("\\");
                }
                result.append(current);
                inBrackets = current != ']' || escaped;
            } else if (current == '{') {
                int j = GlobKt.findChar(',', '}', globString, length, i);
                if (j < 0 && -j < length) {
                    String choice;
                    Intrinsics.checkNotNullExpressionValue((Object)globString.substring(i, -j), (String)"substring(...)");
                    int[] range = GlobKt.getNumericRange(choice);
                    if (range != null) {
                        result.append("(\\d+)");
                        v3 = ranges.add(range);
                    } else {
                        result.append("\\{");
                        GlobKt.convertGlobToRegEx(choice, ranges, result);
                        v3 = result.append("\\}");
                    }
                    i = -j + 1;
                } else if (matchingBraces) {
                    result.append("(?:");
                    ++braceLevel;
                } else {
                    result.append("\\{");
                }
            } else if (current == ',') {
                result.append(braceLevel > 0 && !escaped ? "|" : ",");
            } else if (current == '/') {
                if (i < length && globString.charAt(i) == '*') {
                    if (i + 1 < length && globString.charAt(i + 1) == '*' && i + 2 < length && globString.charAt(i + 2) == '/') {
                        result.append("(?:/|/.*/)");
                        v4 = i += 3;
                    } else {
                        v4 = result.append(current);
                    }
                } else {
                    v4 = result.append(current);
                }
            } else if (current == '}') {
                if (braceLevel > 0 && !escaped) {
                    result.append(")");
                    v5 = braceLevel--;
                } else {
                    v5 = result.append("}");
                }
            } else if (current != '\\') {
                GlobKt.escapeToRegex(result, current);
            }
            if (current == '\\') {
                if (escaped) {
                    result.append("\\\\");
                }
                escaped = !escaped;
                continue;
            }
            escaped = false;
        }
    }

    private static final boolean matchingBraces(String $this$matchingBraces) {
        int i = 0;
        int len = $this$matchingBraces.length();
        int openedCount = 0;
        while (i < len) {
            switch ($this$matchingBraces.charAt(i++)) {
                case '\\': {
                    ++i;
                    break;
                }
                case '{': {
                    ++openedCount;
                    break;
                }
                case '}': {
                    --openedCount;
                }
            }
        }
        return openedCount == 0;
    }

    private static final int[] getNumericRange(String choice) {
        int[] nArray;
        Integer n = StringsKt.indexOf$default((CharSequence)choice, (String)"..", (int)0, (boolean)false, (int)6, null);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it >= 0 ? n : null;
        if (n2 != null) {
            int[] nArray2;
            int separator = ((Number)n2).intValue();
            boolean bl2 = false;
            try {
                String string = choice.substring(0, separator);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int start = Integer.parseInt(string);
                String string2 = choice.substring(separator + 2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                int end = Integer.parseInt(string2);
                int[] nArray3 = new int[]{start, end};
                nArray2 = nArray3;
            }
            catch (NumberFormatException numberFormatException) {
                nArray2 = null;
            }
            nArray = nArray2;
        } else {
            nArray = null;
        }
        return nArray;
    }

    private static final int findChar(char c, char stopAt, String pattern, int length, int start) {
        int j;
        boolean escapedChar = false;
        for (j = start; j < length && (pattern.charAt(j) != stopAt || escapedChar); ++j) {
            if (pattern.charAt(j) == c && !escapedChar) {
                return j;
            }
            escapedChar = pattern.charAt(j) == '\\' && !escapedChar;
        }
        return -j;
    }

    private static final void escapeToRegex(StringBuilder $this$escapeToRegex, char c) {
        StringBuilder stringBuilder = c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-' ? $this$escapeToRegex.append(c) : (c == '\n' ? $this$escapeToRegex.append("\\n") : $this$escapeToRegex.append('\\').append(c));
    }
}

