/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.CanISilentlyChange;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlighterRecycler;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.SilentChangeVetoer;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class HighlightingSessionImpl
implements HighlightingSession {
    private static final Logger LOG = Logger.getInstance(HighlightingSessionImpl.class);
    @NotNull
    private final PsiFile myPsiFile;
    @NotNull
    private final CodeInsightContext myCodeInsightContext;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    private final EditorColorsScheme myEditorColorsScheme;
    @NotNull
    private final Project myProject;
    private final Document myDocument;
    @NotNull
    private final ProperTextRange myVisibleRange;
    @NotNull
    private final CanISilentlyChange.Result myCanChangeFileSilently;
    private final Number myDaemonCancelEventCount;
    private final int myDaemonInitialCancelEventCount;
    private volatile boolean myIsEssentialHighlightingOnly;
    private volatile boolean myInContent;
    private volatile ThreeState extensionsAllowToChangeFileSilently;
    private final List<RunnableFuture<?>> pendingFileLevelHighlightRequests;
    private volatile HighlightSeverity myMinimumSeverity;
    private static final Key<Map<PsiFile, List<HighlightingSession>>> HIGHLIGHTING_SESSION = Key.create((String)"HIGHLIGHTING_SESSION");

    private HighlightingSessionImpl(@NotNull PsiFile psiFile, @NotNull CodeInsightContext codeInsightContext, @NotNull DaemonProgressIndicator progressIndicator, @Nullable EditorColorsScheme editorColorsScheme, @NotNull ProperTextRange visibleRange, @NotNull CanISilentlyChange.Result canChangeFileSilently, @NotNull Number daemonCancelEventCount) {
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(0);
        }
        if (codeInsightContext == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(1);
        }
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(2);
        }
        if (visibleRange == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(3);
        }
        if (canChangeFileSilently == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(4);
        }
        if (daemonCancelEventCount == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(5);
        }
        this.pendingFileLevelHighlightRequests = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myPsiFile = psiFile;
        this.myCodeInsightContext = codeInsightContext;
        this.myProgressIndicator = progressIndicator;
        this.myEditorColorsScheme = editorColorsScheme;
        this.myProject = (Project)ReadAction.compute(() -> psiFile.getProject());
        this.myDocument = (Document)ReadAction.compute(() -> psiFile.getOriginalFile().getViewProvider().getDocument());
        this.myVisibleRange = visibleRange;
        this.myCanChangeFileSilently = canChangeFileSilently;
        this.myDaemonCancelEventCount = daemonCancelEventCount;
        this.myDaemonInitialCancelEventCount = daemonCancelEventCount.intValue();
        assert (!(psiFile.getViewProvider() instanceof InjectedFileViewProvider)) : "Expected top-level file, but got: " + String.valueOf(psiFile.getViewProvider());
    }

    @ApiStatus.Internal
    public boolean canChangeFileSilently() {
        return this.myCanChangeFileSilently.canIReally(this.myInContent, this.extensionsAllowToChangeFileSilently);
    }

    @ApiStatus.Internal
    public void setMinimumSeverity(@Nullable HighlightSeverity minimumSeverity) {
        this.myMinimumSeverity = minimumSeverity;
    }

    @ApiStatus.Internal
    public HighlightSeverity getMinimumSeverity() {
        return this.myMinimumSeverity;
    }

    @ApiStatus.Internal
    @NotNull
    public static HighlightingSession getFromCurrentIndicator(@NotNull PsiFile psiFile) {
        DaemonProgressIndicator indicator;
        Map map;
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(6);
        }
        if ((map = (Map)(indicator = GlobalInspectionContextBase.assertUnderDaemonProgress()).getUserData(HIGHLIGHTING_SESSION)) == null) {
            throw new IllegalStateException("No HighlightingSession stored in " + String.valueOf((Object)indicator));
        }
        List sessions = (List)map.get(psiFile);
        if (sessions == null) {
            String mapStr = map.entrySet().stream().map(e -> {
                PsiFile storedFile = (PsiFile)e.getKey();
                return String.valueOf(storedFile) + ": " + System.identityHashCode(storedFile) + " (" + String.valueOf(storedFile.getClass()) + ") -> " + String.valueOf(e.getValue());
            }).collect(Collectors.joining("; "));
            throw new IllegalStateException("No HighlightingSession found for " + String.valueOf(psiFile) + ": " + System.identityHashCode(psiFile) + " (" + String.valueOf(psiFile.getClass()) + ") in " + String.valueOf((Object)indicator) + " in map (" + map.size() + "): " + mapStr);
        }
        HighlightingSession highlightingSession = (HighlightingSession)ContainerUtil.getLastItem((List)sessions);
        if (highlightingSession == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(7);
        }
        return highlightingSession;
    }

    @ApiStatus.Internal
    public static HighlightingSession getOrCreateHighlightingSession(@NotNull PsiFile psiFile, @NotNull CodeInsightContext codeInsightContext, @NotNull DaemonProgressIndicator progressIndicator, @NotNull ProperTextRange visibleRange) {
        Map map;
        List sessions;
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(8);
        }
        if (codeInsightContext == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(9);
        }
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(10);
        }
        if (visibleRange == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(11);
        }
        List list = sessions = (map = (Map)progressIndicator.getUserData(HIGHLIGHTING_SESSION)) == null ? null : (List)map.get(psiFile);
        if (sessions == null) {
            return HighlightingSessionImpl.createHighlightingSession(psiFile, codeInsightContext, progressIndicator, null, visibleRange, CanISilentlyChange.Result.UH_UH, 0);
        }
        return (HighlightingSession)sessions.get(0);
    }

    @RequiresEdt
    @ApiStatus.Internal
    @NotNull
    public static HighlightingSessionImpl createHighlightingSession(@NotNull PsiFile psiFile, @NotNull CodeInsightContext codeInsightContext, @Nullable Editor editor, @Nullable EditorColorsScheme editorColorsScheme, @NotNull DaemonProgressIndicator progressIndicator, @NotNull Number daemonCancelEventCount) {
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(12);
        }
        if (codeInsightContext == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(13);
        }
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(14);
        }
        if (daemonCancelEventCount == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(15);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ThreadingAssertions.assertEventDispatchThread();
        ProperTextRange visibleRange = editor == null ? ProperTextRange.create((int)0, (int)psiFile.getViewProvider().getDocument().getTextLength()) : editor.calculateVisibleRange();
        CanISilentlyChange.Result canChangeFileSilently = CanISilentlyChange.thisFile((PsiFileSystemItem)psiFile);
        return HighlightingSessionImpl.createHighlightingSession(psiFile, codeInsightContext, progressIndicator, editorColorsScheme, visibleRange, canChangeFileSilently, daemonCancelEventCount);
    }

    @NotNull
    private static HighlightingSessionImpl createHighlightingSession(@NotNull PsiFile psiFile, @NotNull CodeInsightContext codeInsightContext, @NotNull DaemonProgressIndicator progressIndicator, @Nullable EditorColorsScheme editorColorsScheme, @NotNull ProperTextRange visibleRange, @NotNull CanISilentlyChange.Result canChangeFileSilently, @NotNull Number daemonCancelEventCount) {
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(16);
        }
        if (codeInsightContext == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(17);
        }
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(18);
        }
        if (visibleRange == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(19);
        }
        if (canChangeFileSilently == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(20);
        }
        if (daemonCancelEventCount == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(21);
        }
        Map map = (Map)ConcurrencyUtil.computeIfAbsent((UserDataHolder)progressIndicator, HIGHLIGHTING_SESSION, () -> new ConcurrentHashMap());
        HighlightingSessionImpl session = new HighlightingSessionImpl(psiFile, codeInsightContext, progressIndicator, editorColorsScheme, visibleRange, canChangeFileSilently, daemonCancelEventCount);
        map.compute(psiFile, (__, oldSessions) -> ContainerUtil.append((List)ContainerUtil.notNullize((List)oldSessions), (Object[])new HighlightingSession[]{session}));
        HighlightingSessionImpl highlightingSessionImpl = session;
        if (highlightingSessionImpl == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(22);
        }
        return highlightingSessionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    @ApiStatus.Internal
    public static void runInsideHighlightingSession(@NotNull PsiFile psiFile, @NotNull CodeInsightContext codeInsightContext, @Nullable EditorColorsScheme editorColorsScheme, @NotNull ProperTextRange visibleRange, boolean canChangeFileSilently, @NotNull @NotNull Consumer<? super @NotNull HighlightingSession> runnable) {
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(23);
        }
        if (codeInsightContext == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(24);
        }
        if (visibleRange == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(25);
        }
        if (runnable == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(26);
        }
        ThreadingAssertions.assertBackgroundThread();
        ThreadingAssertions.assertBackgroundThread();
        DaemonProgressIndicator indicator = GlobalInspectionContextBase.assertUnderDaemonProgress();
        CanISilentlyChange.Result result = canChangeFileSilently ? CanISilentlyChange.Result.UH_HUH : CanISilentlyChange.Result.UH_UH;
        HighlightingSessionImpl session = HighlightingSessionImpl.createHighlightingSession(psiFile, codeInsightContext, indicator, editorColorsScheme, visibleRange, result, 0);
        try {
            session.additionalSetupFromBackground(psiFile);
            runnable.accept(session);
        }
        finally {
            HighlightingSessionImpl.clearHighlightingSession(indicator, psiFile, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    static void runInsideHighlightingSessionInEDT(@NotNull PsiFile psiFile, @NotNull CodeInsightContext codeInsightContext, @Nullable EditorColorsScheme editorColorsScheme, @NotNull ProperTextRange visibleRange, boolean canChangeFileSilently, @NotNull @NotNull Consumer<? super @NotNull HighlightingSession> runnable) {
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(27);
        }
        if (codeInsightContext == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(28);
        }
        if (visibleRange == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(29);
        }
        if (runnable == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(30);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (!(ProgressIndicatorProvider.getGlobalProgressIndicator() instanceof DaemonProgressIndicator)) {
            ProgressManager.getInstance().executeProcessUnderProgress(() -> HighlightingSessionImpl.runInsideHighlightingSessionInEDT(psiFile, codeInsightContext, editorColorsScheme, visibleRange, canChangeFileSilently, runnable), (ProgressIndicator)new DaemonProgressIndicator());
            return;
        }
        DaemonProgressIndicator indicator = GlobalInspectionContextBase.assertUnderDaemonProgress();
        CanISilentlyChange.Result result = canChangeFileSilently ? CanISilentlyChange.Result.UH_HUH : CanISilentlyChange.Result.UH_UH;
        HighlightingSessionImpl session = HighlightingSessionImpl.createHighlightingSession(psiFile, codeInsightContext, indicator, editorColorsScheme, visibleRange, result, 0);
        session.myInContent = true;
        try {
            runnable.accept(session);
        }
        finally {
            HighlightingSessionImpl.clearHighlightingSession(indicator, psiFile, session);
        }
    }

    @ApiStatus.Internal
    public static void waitForAllSessionsHighlightInfosApplied(@NotNull DaemonProgressIndicator progressIndicator) {
        Map map;
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(31);
        }
        if ((map = (Map)progressIndicator.getUserData(HIGHLIGHTING_SESSION)) != null) {
            for (List sessions : map.values()) {
                for (HighlightingSession session : sessions) {
                    ((HighlightingSessionImpl)session).applyFileLevelHighlightsRequests();
                }
            }
        }
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(32);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(33);
        }
        return document;
    }

    @Override
    @NotNull
    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = this.myProgressIndicator;
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(34);
        }
        return progressIndicator;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(35);
        }
        return project;
    }

    @Override
    public EditorColorsScheme getColorsScheme() {
        return this.myEditorColorsScheme;
    }

    @ApiStatus.Internal
    public void applyFileLevelHighlightsRequests() {
        ThreadingAssertions.assertEventDispatchThread();
        ArrayList requests = new ArrayList(this.pendingFileLevelHighlightRequests);
        for (RunnableFuture runnableFuture : requests) {
            runnableFuture.run();
        }
        this.pendingFileLevelHighlightRequests.removeAll(requests);
    }

    @ApiStatus.Internal
    public static void clearAllHighlightingSessions(@NotNull DaemonProgressIndicator indicator) {
        if (indicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(36);
        }
        indicator.putUserData(HIGHLIGHTING_SESSION, null);
        if (LOG.isTraceEnabled()) {
            LOG.trace("HighlightingSessionImpl.clearAllHighlightingSessions");
        }
    }

    private static void clearHighlightingSession(@NotNull DaemonProgressIndicator progressIndicator, @NotNull PsiFile psiFile, @NotNull HighlightingSessionImpl session) {
        Map map;
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(37);
        }
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(38);
        }
        if (session == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(39);
        }
        if ((map = (Map)progressIndicator.getUserData(HIGHLIGHTING_SESSION)) != null) {
            map.compute(psiFile, (__, oldSessions) -> ContainerUtil.getLastItem((List)oldSessions) == session ? (List)ContainerUtil.nullize(List.copyOf(oldSessions.subList(0, oldSessions.size() - 1))) : oldSessions);
            if (LOG.isTraceEnabled()) {
                LOG.trace("HighlightingSessionImpl.clearHighlightingSession(" + String.valueOf(psiFile.getVirtualFile()) + "); " + map.size() + " remain");
            }
        }
    }

    @Override
    @NotNull
    public ProperTextRange getVisibleRange() {
        ProperTextRange properTextRange = this.myVisibleRange;
        if (properTextRange == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(40);
        }
        return properTextRange;
    }

    @Override
    public boolean isEssentialHighlightingOnly() {
        return this.myIsEssentialHighlightingOnly;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public CodeInsightContext getCodeInsightContext() {
        CodeInsightContext codeInsightContext = this.myCodeInsightContext;
        if (codeInsightContext == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(41);
        }
        return codeInsightContext;
    }

    public String toString() {
        return "HighlightingSessionImpl: myVisibleRange:" + String.valueOf(this.myVisibleRange) + "; myPsiFile: " + String.valueOf(this.myPsiFile) + ": " + System.identityHashCode(this.myPsiFile) + " (" + String.valueOf(this.myPsiFile.getClass()) + ")" + (this.myIsEssentialHighlightingOnly ? "; essentialHighlightingOnly" : "") + (this.isCanceled() ? "; canceled" : "") + (String)(this.myProgressIndicator.isCanceled() ? "; indicator: " + String.valueOf(this.myProgressIndicator) : "");
    }

    @ApiStatus.Internal
    @RequiresBackgroundThread
    public void additionalSetupFromBackground(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(42);
        }
        ThreadingAssertions.assertBackgroundThread();
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ReadAction.run(() -> {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (!psiFile.isValid() || virtualFile != null && !virtualFile.isValid()) {
                throw new ProcessCanceledException((Throwable)new RuntimeException(psiFile.getName() + " is invalid"));
            }
            this.myIsEssentialHighlightingOnly = HighlightingLevelManager.getInstance(psiFile.getProject()).runEssentialHighlightingOnly((PsiElement)psiFile);
            this.myInContent = virtualFile != null && ModuleUtilCore.projectContainsFile((Project)psiFile.getProject(), (VirtualFile)virtualFile, (boolean)false);
            this.extensionsAllowToChangeFileSilently = virtualFile == null ? ThreeState.UNSURE : SilentChangeVetoer.extensionsAllowToChangeFileSilently(this.getProject(), virtualFile);
        });
    }

    @Override
    public boolean isCanceled() {
        return this.myDaemonCancelEventCount.intValue() != this.myDaemonInitialCancelEventCount;
    }

    @Deprecated
    void updateFileLevelHighlights(@NotNull List<? extends HighlightInfo> fileLevelHighlights, int group, boolean cleanOldHighlights, @NotNull HighlighterRecycler recycler) {
        boolean shouldUpdate;
        if (fileLevelHighlights == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(43);
        }
        if (recycler == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(44);
        }
        Project project = this.getProject();
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        PsiFile psiFile = this.getPsiFile();
        boolean bl = shouldUpdate = !fileLevelHighlights.isEmpty() || codeAnalyzer.hasFileLevelHighlights(group, psiFile);
        if (shouldUpdate) {
            List reusedHighlighters = ContainerUtil.map(fileLevelHighlights, info -> recycler.pickupFileLevelRangeHighlighter(psiFile.getTextLength(), info.getDescription()));
            Future future = EdtExecutorService.getInstance().submit(() -> {
                if (project.isDisposed() || this.isCanceled()) {
                    return;
                }
                if (cleanOldHighlights) {
                    codeAnalyzer.cleanFileLevelHighlights(group, psiFile);
                }
                for (int i = 0; i < fileLevelHighlights.size(); ++i) {
                    HighlightInfo fileLevelInfo = (HighlightInfo)fileLevelHighlights.get(i);
                    RangeHighlighter reused = (RangeHighlighter)reusedHighlighters.get(i);
                    codeAnalyzer.addFileLevelHighlight(group, fileLevelInfo, psiFile, reused, this.getCodeInsightContext());
                }
            });
            this.pendingFileLevelHighlightRequests.add((RunnableFuture)future);
        }
    }

    void replaceFileLevelHighlight(@NotNull HighlightInfo oldFileLevelInfo, @NotNull HighlightInfo newFileLevelInfo, @Nullable RangeHighlighterEx toReuse) {
        if (oldFileLevelInfo == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(45);
        }
        if (newFileLevelInfo == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(46);
        }
        Project project = this.getProject();
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        Future future = EdtExecutorService.getInstance().submit(() -> {
            if (!project.isDisposed() && !this.isCanceled()) {
                codeAnalyzer.replaceFileLevelHighlight(oldFileLevelInfo, newFileLevelInfo, this.getPsiFile(), (RangeHighlighter)toReuse, this.getCodeInsightContext());
            }
        });
        this.pendingFileLevelHighlightRequests.add((RunnableFuture)future);
    }

    void removeFileLevelHighlight(@NotNull HighlightInfo fileLevelHighlightInfo) {
        if (fileLevelHighlightInfo == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(47);
        }
        assert (fileLevelHighlightInfo.isFileLevelAnnotation());
        Project project = this.getProject();
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        Future future = EdtExecutorService.getInstance().submit(() -> {
            if (!project.isDisposed()) {
                codeAnalyzer.removeFileLevelHighlight(this.getPsiFile(), fileLevelHighlightInfo);
            }
        });
        this.pendingFileLevelHighlightRequests.add((RunnableFuture)future);
    }

    void addFileLevelHighlight(@NotNull HighlightInfo fileLevelHighlightInfo, @Nullable RangeHighlighterEx toReuse) {
        if (fileLevelHighlightInfo == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(48);
        }
        Project project = this.getProject();
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        Future future = EdtExecutorService.getInstance().submit(() -> {
            if (!project.isDisposed() && !this.isCanceled()) {
                codeAnalyzer.addFileLevelHighlight(fileLevelHighlightInfo.getGroup(), fileLevelHighlightInfo, this.getPsiFile(), (RangeHighlighter)toReuse, this.getCodeInsightContext());
            }
        });
        this.pendingFileLevelHighlightRequests.add((RunnableFuture)future);
    }

    @ApiStatus.Internal
    @RequiresEdt
    public static boolean canChangeFileSilently(@NotNull PsiFileSystemItem file, boolean isInContent, @NotNull ThreeState extensionsAllowToChangeFileSilently) {
        if (file == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(49);
        }
        if (extensionsAllowToChangeFileSilently == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(50);
        }
        ThreadingAssertions.assertEventDispatchThread();
        return CanISilentlyChange.thisFile(file).canIReally(isInContent, extensionsAllowToChangeFileSilently);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 22, 32, 33, 34, 35, 40, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 9: 
            case 13: 
            case 17: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeInsightContext";
                break;
            }
            case 2: 
            case 10: 
            case 14: 
            case 18: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 3: 
            case 11: 
            case 19: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRange";
                break;
            }
            case 4: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canChangeFileSilently";
                break;
            }
            case 5: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "daemonCancelEventCount";
                break;
            }
            case 7: 
            case 22: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLevelHighlights";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recycler";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFileLevelInfo";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileLevelInfo";
                break;
            }
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLevelHighlightInfo";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionsAllowToChangeFileSilently";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromCurrentIndicator";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlightingSession";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressIndicator";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleRange";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeInsightContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFromCurrentIndicator";
                break;
            }
            case 7: 
            case 22: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 41: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateHighlightingSession";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightingSession";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "runInsideHighlightingSession";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "runInsideHighlightingSessionInEDT";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "waitForAllSessionsHighlightInfosApplied";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "clearAllHighlightingSessions";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "clearHighlightingSession";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "additionalSetupFromBackground";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "updateFileLevelHighlights";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "replaceFileLevelHighlight";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "removeFileLevelHighlight";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addFileLevelHighlight";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "canChangeFileSilently";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 22, 32, 33, 34, 35, 40, 41 -> new IllegalStateException(string);
        };
    }
}

