/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.HighlightingPassTracer;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.EditorContextManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerEx;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import io.opentelemetry.api.trace.SpanBuilder;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TextEditorBackgroundHighlighter
implements BackgroundEditorHighlighter {
    private static final int[] IGNORE_FOR_COMPILED = new int[]{1, 3, 7, 8};
    private static final Logger LOG = Logger.getInstance(TextEditorBackgroundHighlighter.class);
    private final Project project;
    private final Editor editor;

    @ApiStatus.Internal
    public TextEditorBackgroundHighlighter(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(1);
        }
        this.project = project;
        this.editor = editor;
    }

    @NotNull
    private List<TextEditorHighlightingPass> createPasses() {
        int[] effectivePassesToIgnore;
        CodeInsightContext context;
        PsiFile psiFile;
        Document document;
        ThreadingAssertions.assertBackgroundThread();
        if (this.project.isDisposed()) {
            List<TextEditorHighlightingPass> list = List.of();
            if (list == null) {
                TextEditorBackgroundHighlighter.$$$reportNull$$$0(2);
            }
            return list;
        }
        PsiDocumentManagerEx documentManager = (PsiDocumentManagerEx)PsiDocumentManager.getInstance((Project)this.project);
        if (!documentManager.isCommitted(document = this.editor.getDocument())) {
            LOG.error(String.valueOf(document) + documentManager.someDocumentDebugInfo(document));
        }
        if ((psiFile = TextEditorBackgroundHighlighter.renewFile(this.project, document, context = EditorContextManager.getEditorContext((Editor)this.editor, (Project)this.project))) == null) {
            List<TextEditorHighlightingPass> list = List.of();
            if (list == null) {
                TextEditorBackgroundHighlighter.$$$reportNull$$$0(3);
            }
            return list;
        }
        Object object = psiFile.getOriginalFile() instanceof PsiCompiledFile ? IGNORE_FOR_COMPILED : (effectivePassesToIgnore = (Object)(DaemonCodeAnalyzer.getInstance((Project)this.project).isHighlightingAvailable(psiFile) ? ArrayUtil.EMPTY_INT_ARRAY : null));
        if (effectivePassesToIgnore == null) {
            List<TextEditorHighlightingPass> list = List.of();
            if (list == null) {
                TextEditorBackgroundHighlighter.$$$reportNull$$$0(4);
            }
            return list;
        }
        try {
            HighlightingSessionImpl.getFromCurrentIndicator(psiFile);
        }
        catch (IllegalStateException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
        List list = (List)TraceKt.use((SpanBuilder)HighlightingPassTracer.HIGHLIGHTING_PASS_TRACER.spanBuilder("passes instantiation"), span -> {
            Activity startupActivity = StartUpMeasurer.startActivity((String)"highlighting passes instantiation");
            boolean cancelled = false;
            try {
                TextEditorHighlightingPassRegistrarEx passRegistrar = TextEditorHighlightingPassRegistrarEx.getInstanceEx(this.project);
                List<TextEditorHighlightingPass> list = passRegistrar.instantiatePasses(psiFile, this.editor, effectivePassesToIgnore);
                return list;
            }
            catch (CancellationException e) {
                cancelled = true;
                throw e;
            }
            finally {
                startupActivity.end();
                span.setAttribute(HighlightingPassTracer.FILE_ATTR_SPAN_KEY, (Object)psiFile.getName());
                span.setAttribute(HighlightingPassTracer.FILE_ATTR_SPAN_KEY, (Object)("" + cancelled));
            }
        });
        if (list == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public @NotNull TextEditorHighlightingPass @NotNull [] createPassesForEditor() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        GlobalInspectionContextBase.assertUnderDaemonProgress();
        List<TextEditorHighlightingPass> passes = this.createPasses();
        TextEditorHighlightingPass[] textEditorHighlightingPassArray = passes.isEmpty() ? TextEditorHighlightingPass.EMPTY_ARRAY : passes.toArray(TextEditorHighlightingPass.EMPTY_ARRAY);
        if (textEditorHighlightingPassArray == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(6);
        }
        return textEditorHighlightingPassArray;
    }

    @ApiStatus.Internal
    @Nullable
    public static PsiFile renewFile(@NotNull Project project, @NotNull Document document, @NotNull CodeInsightContext context) {
        PsiFile psiFile;
        if (project == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(7);
        }
        if (document == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(8);
        }
        if (context == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(9);
        }
        if ((psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document, context)) instanceof PsiCompiledFile) {
            PsiCompiledFile compiled = (PsiCompiledFile)psiFile;
            psiFile = compiled.getDecompiledPsiFile();
        }
        if (psiFile == null) {
            return null;
        }
        psiFile.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)true);
        return psiFile;
    }

    @ApiStatus.Internal
    @Nullable
    public static PsiFile getCachedFileToHighlight(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull CodeInsightContext context) {
        PsiDocumentManagerEx psiDocumentManager;
        PsiFile psiFile;
        if (project == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(10);
        }
        if (virtualFile == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(11);
        }
        if (context == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(12);
        }
        if ((psiFile = (psiDocumentManager = (PsiDocumentManagerEx)PsiDocumentManager.getInstance((Project)project)).getRawCachedFile(virtualFile, context)) instanceof PsiCompiledFile) {
            PsiCompiledFile compiled = (PsiCompiledFile)psiFile;
            psiFile = (PsiFile)compiled.getCachedMirror();
        }
        if (psiFile == null) {
            return null;
        }
        psiFile.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)true);
        return psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPassesForEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "renewFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCachedFileToHighlight";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

