/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class IdIndexEntry {
    private static final boolean USE_STRONGER_HASH = !TrigramIndex.isEnabled() || SystemProperties.getBooleanProperty((String)"idea.id.index.use.stronger.hash", (boolean)true);
    private final int myWordHashCode;

    public IdIndexEntry(@NotNull String word, boolean caseSensitive) {
        if (word == null) {
            IdIndexEntry.$$$reportNull$$$0(0);
        }
        this(word, 0, word.length(), caseSensitive);
    }

    public IdIndexEntry(@NotNull CharSequence seq, int start, int end, boolean caseSensitive) {
        if (seq == null) {
            IdIndexEntry.$$$reportNull$$$0(1);
        }
        this(IdIndexEntry.getWordHash(seq, start, end, caseSensitive));
    }

    public IdIndexEntry(int wordHash) {
        this.myWordHashCode = wordHash;
    }

    public int getWordHashCode() {
        return this.myWordHashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdIndexEntry that = (IdIndexEntry)o;
        return this.myWordHashCode == that.myWordHashCode;
    }

    public int hashCode() {
        return this.myWordHashCode;
    }

    public String toString() {
        return "IdIndexEntry[hash: " + this.myWordHashCode + "]";
    }

    static int getWordHash(@NotNull CharSequence line, int start, int end, boolean caseSensitive) {
        if (line == null) {
            IdIndexEntry.$$$reportNull$$$0(2);
        }
        if (IdIndexEntry.useStrongerHash()) {
            return caseSensitive ? StringUtil.stringHashCode((CharSequence)line, (int)start, (int)end) : StringUtil.stringHashCodeInsensitive((CharSequence)line, (int)start, (int)end);
        }
        if (start == end) {
            return 0;
        }
        char firstChar = line.charAt(start);
        char lastChar = line.charAt(end - 1);
        if (!caseSensitive) {
            firstChar = StringUtil.toLowerCase((char)firstChar);
            lastChar = StringUtil.toLowerCase((char)lastChar);
        }
        return (firstChar << 8) + (lastChar << 4) + (end - start);
    }

    static int getUsedHashAlgorithmVersion() {
        return IdIndexEntry.useStrongerHash() ? 1 : 0;
    }

    @ApiStatus.Internal
    public static boolean useStrongerHash() {
        return USE_STRONGER_HASH;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdIndexEntry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getWordHash";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

