/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.model.search.LeafOccurrence;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.search.BulkOccurrenceProcessor;
import com.intellij.psi.impl.search.HelperKt;
import com.intellij.psi.impl.search.InjectionAwareOccurrenceProcessor;
import com.intellij.psi.impl.search.LowLevelSearchUtilKt;
import com.intellij.psi.impl.search.RequestProcessors;
import com.intellij.util.text.StringSearcher;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/psi/impl/search/MyBulkOccurrenceProcessor;", "Lcom/intellij/psi/impl/search/BulkOccurrenceProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "processors", "Lcom/intellij/psi/impl/search/RequestProcessors;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/impl/search/RequestProcessors;)V", "execute", "", "scope", "Lcom/intellij/psi/PsiElement;", "offsetsInScope", "", "searcher", "Lcom/intellij/util/text/StringSearcher;", "executeInner", "Companion", "intellij.platform.indexing.impl"})
public final class MyBulkOccurrenceProcessor
implements BulkOccurrenceProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RequestProcessors processors;
    @NotNull
    private static final Logger LOG;

    public MyBulkOccurrenceProcessor(@NotNull Project project, @NotNull RequestProcessors processors) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)processors, (String)"processors");
        this.project = project;
        this.processors = processors;
    }

    @Override
    public boolean execute(@NotNull PsiElement scope, @NotNull int[] offsetsInScope, @NotNull StringSearcher searcher) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)offsetsInScope, (String)"offsetsInScope");
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        if (offsetsInScope.length == 0) {
            return true;
        }
        try {
            return this.executeInner(scope, offsetsInScope, searcher);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return true;
        }
        catch (Error e) {
            LOG.error((Throwable)e);
            return true;
        }
    }

    private final boolean executeInner(PsiElement scope, int[] offsetsInScope, StringSearcher searcher) {
        ProgressIndicator progress = HelperKt.getIndicatorOrEmpty();
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)this.project);
        Intrinsics.checkNotNull((Object)manager);
        InjectionAwareOccurrenceProcessor topOccurrenceProcessor = new InjectionAwareOccurrenceProcessor(progress, this.processors, manager, searcher);
        return LowLevelSearchUtilKt.processOffsets(scope, offsetsInScope, searcher.getPatternLength(), progress, (Function1<? super LeafOccurrence, Boolean>)((Function1)topOccurrenceProcessor));
    }

    static {
        Logger logger = Logger.getInstance(MyBulkOccurrenceProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/psi/impl/search/MyBulkOccurrenceProcessor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.indexing.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

