/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FileIndexingStateWithExplanation {
    private static final FileIndexingStateWithExplanation NOT_INDEXED_WITHOUT_EXPLANATION = new FileIndexingStateWithExplanation(FileIndexingState.NOT_INDEXED, () -> "not indexed");
    private static final FileIndexingStateWithExplanation UP_TO_DATE_WITHOUT_EXPLANATION = new FileIndexingStateWithExplanation(FileIndexingState.UP_TO_DATE, () -> "up-to-date");
    private final FileIndexingState state;
    private final Explanation explanation;

    private FileIndexingStateWithExplanation(FileIndexingState state, Explanation explanation) {
        this.state = state;
        this.explanation = explanation;
    }

    public String getExplanationAsString() {
        return this.explanation.explain();
    }

    public String toString() {
        return String.valueOf((Object)this.state) + "(" + this.getExplanationAsString() + ")";
    }

    public boolean isIndexedButOutdated() {
        return this.state == FileIndexingState.OUT_DATED;
    }

    public boolean updateRequired() {
        return this.state != FileIndexingState.UP_TO_DATE;
    }

    public boolean isUpToDate() {
        return this.state == FileIndexingState.UP_TO_DATE;
    }

    public boolean isNotIndexed() {
        return this.state == FileIndexingState.NOT_INDEXED;
    }

    public static FileIndexingStateWithExplanation outdated(String reason) {
        return FileIndexingStateWithExplanation.outdated(() -> reason);
    }

    public static FileIndexingStateWithExplanation outdated(Explanation explanation) {
        return new FileIndexingStateWithExplanation(FileIndexingState.OUT_DATED, explanation);
    }

    public static FileIndexingStateWithExplanation notIndexed() {
        return NOT_INDEXED_WITHOUT_EXPLANATION;
    }

    public static FileIndexingStateWithExplanation upToDate() {
        return UP_TO_DATE_WITHOUT_EXPLANATION;
    }

    private static enum FileIndexingState {
        NOT_INDEXED,
        OUT_DATED,
        UP_TO_DATE;

    }

    @FunctionalInterface
    public static interface Explanation {
        public String explain();
    }
}

