/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.modcommand;

import com.intellij.modcommand.ModCommand;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public record ModUpdateFileText(@NotNull VirtualFile file, @NotNull String oldText, @NotNull String newText, @NotNull @NotNull List<@NotNull Fragment> updatedRanges) implements ModCommand
{
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final String oldText;
    @NotNull
    private final String newText;
    @NotNull
    private final @NotNull List<@NotNull Fragment> updatedRanges;

    public ModUpdateFileText(@NotNull VirtualFile file, @NotNull String oldText, @NotNull String newText, @NotNull List<Fragment> updatedRanges) {
        if (file == null) {
            ModUpdateFileText.$$$reportNull$$$0(0);
        }
        if (oldText == null) {
            ModUpdateFileText.$$$reportNull$$$0(1);
        }
        if (newText == null) {
            ModUpdateFileText.$$$reportNull$$$0(2);
        }
        if (updatedRanges == null) {
            ModUpdateFileText.$$$reportNull$$$0(3);
        }
        for (int i = 0; i < updatedRanges.size(); ++i) {
            Fragment next;
            Fragment prev = updatedRanges.get(i);
            if (prev.offset() + prev.newLength > newText.length()) {
                throw new IllegalArgumentException("Range out of bounds: " + String.valueOf(prev) + "; newText.length()=" + newText.length());
            }
            if (i >= updatedRanges.size() - 1 || (next = updatedRanges.get(i + 1)).offset() > prev.offset() + prev.newLength()) continue;
            throw new IllegalArgumentException("Invalid ranges: " + String.valueOf(updatedRanges));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.oldText.equals(this.newText);
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull VirtualFile> modifiedFiles() {
        Set<VirtualFile> set = Set.of(this.file);
        if (set == null) {
            ModUpdateFileText.$$$reportNull$$$0(4);
        }
        return set;
    }

    public int translateOffset(int offset, boolean leanRight) {
        for (Fragment range : this.updatedRanges) {
            offset = leanRight ? range.adjustForwardLeanRight(offset) : range.adjustForward(offset);
        }
        return offset;
    }

    public ModUpdateFileText shrinkFragments() {
        ArrayList<Fragment> changed = null;
        int diff = 0;
        for (Fragment range : this.updatedRanges) {
            int newLen;
            int oldLen = range.oldLength;
            for (newLen = range.newLength; oldLen > 0 && newLen > 0 && this.oldText.charAt(range.offset + diff + oldLen - 1) == this.newText.charAt(range.offset + newLen - 1); --oldLen, --newLen) {
            }
            if (oldLen != range.oldLength) {
                if (changed == null) {
                    changed = new ArrayList<Fragment>();
                }
                range = new Fragment(range.offset, oldLen, newLen);
            }
            if (changed != null) {
                changed.add(range);
            }
            diff += range.oldLength - range.newLength;
        }
        if (changed == null) {
            return this;
        }
        return new ModUpdateFileText(this.file, this.oldText, this.newText, ContainerUtil.concat(this.updatedRanges.subList(0, this.updatedRanges.size() - changed.size()), changed));
    }

    @NotNull
    public VirtualFile file() {
        VirtualFile virtualFile = this.file;
        if (virtualFile == null) {
            ModUpdateFileText.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @NotNull
    public String oldText() {
        String string = this.oldText;
        if (string == null) {
            ModUpdateFileText.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String newText() {
        String string = this.newText;
        if (string == null) {
            ModUpdateFileText.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public @NotNull List<@NotNull Fragment> updatedRanges() {
        List<Fragment> list = this.updatedRanges;
        if (list == null) {
            ModUpdateFileText.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedRanges";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/modcommand/ModUpdateFileText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/modcommand/ModUpdateFileText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "modifiedFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "file";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "oldText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "updatedRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    public record Fragment(int offset, int oldLength, int newLength) {
        public Fragment {
            if (offset < 0) {
                throw new IllegalArgumentException("Negative offset");
            }
            if (oldLength < 0) {
                throw new IllegalArgumentException("Negative oldLength");
            }
            if (newLength < 0) {
                throw new IllegalArgumentException("Negative newLength");
            }
        }

        @NotNull
        public Fragment shift(int diff) {
            return diff == 0 ? this : new Fragment(this.offset + diff, this.oldLength, this.newLength);
        }

        public boolean intersects(@NotNull Fragment other) {
            if (other == null) {
                Fragment.$$$reportNull$$$0(0);
            }
            return Math.max(this.offset, other.offset) <= Math.min(this.offset + this.newLength, other.offset + other.oldLength);
        }

        private int adjustForward(int pos) {
            if (pos <= this.offset) {
                return pos;
            }
            if (pos <= this.offset + this.oldLength) {
                return this.offset;
            }
            return pos - this.oldLength + this.newLength;
        }

        private int adjustForwardLeanRight(int pos) {
            if (pos < this.offset) {
                return pos;
            }
            if (pos <= this.offset + this.oldLength) {
                return this.offset + this.newLength;
            }
            return pos - this.oldLength + this.newLength;
        }

        private int adjustBackward(int pos) {
            if (pos <= this.offset) {
                return pos;
            }
            if (pos <= this.offset + this.newLength) {
                return this.offset;
            }
            return pos - this.newLength + this.oldLength;
        }

        @NotNull
        public Fragment mergeWithNext(@NotNull Fragment next) {
            if (next == null) {
                Fragment.$$$reportNull$$$0(1);
            }
            int newStartOffset = Math.min(this.offset, next.offset);
            int newOrigEndOffset = Math.max(this.offset + this.oldLength, this.adjustBackward(next.offset + next.oldLength));
            int newUpdatedEndOffset = Math.max(next.adjustForward(this.offset + this.newLength), next.offset + next.newLength);
            return new Fragment(newStartOffset, newOrigEndOffset - newStartOffset, newUpdatedEndOffset - newStartOffset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "next";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/modcommand/ModUpdateFileText$Fragment";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "intersects";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeWithNext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

