/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaObjectStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSchemaReader {
    private static final int MAX_SCHEMA_LENGTH = FileSizeLimit.getDefaultContentLoadLimit();

    @NotNull
    public static JsonSchemaObject readFromFile(@NotNull Project project, @NotNull VirtualFile file) throws Exception {
        JsonSchemaObject object;
        if (project == null) {
            JsonSchemaReader.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JsonSchemaReader.$$$reportNull$$$0(1);
        }
        if (!file.isValid()) {
            throw new Exception(JsonBundle.message((String)"schema.reader.cant.load.file", (Object[])new Object[]{file.getName()}));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        JsonSchemaObject jsonSchemaObject = object = psiFile == null ? null : new JsonSchemaReader().read(psiFile);
        if (object == null) {
            throw new Exception(JsonBundle.message((String)"schema.reader.cant.load.model", (Object[])new Object[]{file.getName()}));
        }
        JsonSchemaObject jsonSchemaObject2 = object;
        if (jsonSchemaObject2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(2);
        }
        return jsonSchemaObject2;
    }

    @NlsContexts.DialogMessage
    @Nullable
    public static String checkIfValidJsonSchema(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JsonSchemaReader.$$$reportNull$$$0(3);
        }
        if (file == null) {
            JsonSchemaReader.$$$reportNull$$$0(4);
        }
        long length = file.getLength();
        String fileName = file.getName();
        if (length > (long)MAX_SCHEMA_LENGTH) {
            return JsonBundle.message((String)"schema.reader.file.too.large", (Object[])new Object[]{fileName, length});
        }
        if (length == 0L) {
            return JsonBundle.message((String)"schema.reader.file.empty", (Object[])new Object[]{fileName});
        }
        try {
            JsonSchemaReader.readFromFile(project, file);
        }
        catch (Exception e) {
            String message = JsonBundle.message((String)"schema.reader.file.not.found.or.error", (Object[])new Object[]{fileName, e.getMessage()});
            Logger.getInstance(JsonSchemaReader.class).info(message);
            return message;
        }
        return null;
    }

    @Nullable
    public static JsonSchemaObject getOrComputeSchemaObjectForSchemaFile(@NotNull VirtualFile schemaFile, @NotNull Project project) {
        if (schemaFile == null) {
            JsonSchemaReader.$$$reportNull$$$0(5);
        }
        if (project == null) {
            JsonSchemaReader.$$$reportNull$$$0(6);
        }
        return JsonSchemaObjectStorage.getInstance(project).getOrComputeSchemaRootObject(schemaFile);
    }

    @Nullable
    public JsonSchemaObject read(@NotNull PsiFile file) {
        if (file == null) {
            JsonSchemaReader.$$$reportNull$$$0(7);
        }
        return JsonSchemaReader.getOrComputeSchemaObjectForSchemaFile(file.getOriginalFile().getVirtualFile(), file.getProject());
    }

    @NotNull
    public static String getNewPointer(@NotNull String name, String oldPointer) {
        if (name == null) {
            JsonSchemaReader.$$$reportNull$$$0(8);
        }
        String string = oldPointer.equals("/") ? oldPointer + name : oldPointer + "/" + name;
        if (string == null) {
            JsonSchemaReader.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public static JsonSchemaType parseType(@NotNull String typeString) {
        if (typeString == null) {
            JsonSchemaReader.$$$reportNull$$$0(10);
        }
        try {
            return JsonSchemaType.valueOf("_" + typeString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaReader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaReader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFromFile";
                break;
            }
            case 2: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkIfValidJsonSchema";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrComputeSchemaObjectForSchemaFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNewPointer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 9 -> new IllegalStateException(string);
        };
    }
}

