/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlowJSAnnotation {
    private FlowJSAnnotation() {
    }

    public static boolean hasFlowAnnotation(@NotNull PsiFile file) {
        if (file == null) {
            FlowJSAnnotation.$$$reportNull$$$0(0);
        }
        return file instanceof JSFile && ((JSFile)file).getPragmaFlags().containsKey("@flow");
    }

    public static boolean isFlowComment(@Nullable PsiComment element) {
        return element != null && FlowJSAnnotation.isFlowComment(element.getText());
    }

    public static boolean isFlowComment(@NotNull String commentText) {
        if (commentText == null) {
            FlowJSAnnotation.$$$reportNull$$$0(1);
        }
        return commentText.contains("@flow") || commentText.contains("@noflow");
    }

    @Nullable
    public static PsiComment findFlowFlagComment(@NotNull PsiFile file) {
        if (file == null) {
            FlowJSAnnotation.$$$reportNull$$$0(2);
        }
        CommonProcessors.FindProcessor<PsiComment> findProcessor = new CommonProcessors.FindProcessor<PsiComment>(){

            protected boolean accept(PsiComment comment) {
                return FlowJSAnnotation.isFlowComment(comment);
            }
        };
        JSPsiImplUtils.processTopLevelComment(file, (Processor<? super PsiComment>)findProcessor);
        return (PsiComment)findProcessor.getFoundValue();
    }

    public static boolean hasFlowPrefix(@NotNull VirtualFile file) {
        CharSequence text;
        Document document;
        if (file == null) {
            FlowJSAnnotation.$$$reportNull$$$0(3);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(file)) != null) {
            v0 = document.getCharsSequence();
        } else if (file instanceof LightVirtualFile) {
            LightVirtualFile lightVirtualFile = (LightVirtualFile)file;
            v0 = lightVirtualFile.getContent();
        } else {
            v0 = text = FileSizeLimit.isTooLargeForContentLoading((long)file.getLength(), (String)file.getExtension()) ? null : LoadTextUtil.loadText((VirtualFile)file);
        }
        if (text == null) {
            return false;
        }
        return FlowJSAnnotation.hasFlowPragma(text);
    }

    public static boolean hasFlowPragma(@NotNull CharSequence text) {
        if (text == null) {
            FlowJSAnnotation.$$$reportNull$$$0(4);
        }
        JSFlexAdapter lexer = new JSFlexAdapter(DialectOptionHolder.JS_WITH_JSX);
        lexer.start(text, 0, text.length());
        int tokenCountLeft = 10;
        while (tokenCountLeft > 0) {
            IElementType tokenType = lexer.getTokenType();
            if (JSElementTypes.COMMENTS.contains(tokenType)) {
                --tokenCountLeft;
                String tokenText = lexer.getTokenText();
                if (FlowJSAnnotation.isFlowComment(tokenText)) {
                    return true;
                }
            } else if (tokenType != JSTokenTypes.WHITE_SPACE) {
                return false;
            }
            lexer.advance();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSAnnotation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasFlowAnnotation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFlowComment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findFlowFlagComment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasFlowPrefix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasFlowPragma";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

