/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.cloud;

import ai.grazie.api.gateway.client.SuspendableAPIGatewayClient;
import ai.grazie.client.common.SuspendableHTTPClient;
import ai.grazie.client.common.WithCloudAuth;
import ai.grazie.client.common.auth.GrazieAgents;
import ai.grazie.client.common.model.RequestOptions;
import ai.grazie.model.auth.GrazieAgent;
import ai.grazie.model.auth.v5.AuthData;
import ai.grazie.model.cloud.AuthType;
import ai.grazie.model.cloud.AuthVersion;
import ai.grazie.model.cloud.HeaderCollection;
import ai.grazie.model.cloud.HeaderCollectionKt;
import ai.grazie.model.cloud.exceptions.HTTPConnectionError;
import com.intellij.codeWithMe.ClientId;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.cloud.GrazieHttpClientManager;
import com.intellij.grazie.cloud.license.EnterpriseState;
import com.intellij.grazie.cloud.license.GrazieLoginManager;
import com.intellij.grazie.cloud.license.GrazieLoginState;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ApplicationKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/grazie/cloud/GrazieCloudConfig;", "", "<init>", "()V", "STGN_URL", "", "apiUrl", "getApiUrl", "()Ljava/lang/String;", "obtainAgent", "Lai/grazie/model/auth/GrazieAgent;", "api", "Lai/grazie/api/gateway/client/SuspendableAPIGatewayClient;", "httpClient", "Lai/grazie/client/common/SuspendableHTTPClient;", "enterpriseClient", "state", "Lcom/intellij/grazie/cloud/license/EnterpriseState;", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nGrazieCloudConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieCloudConfig.kt\ncom/intellij/grazie/cloud/GrazieCloudConfig\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n42#2,3:84\n466#3:87\n415#3:88\n1266#4,4:89\n*S KotlinDebug\n*F\n+ 1 GrazieCloudConfig.kt\ncom/intellij/grazie/cloud/GrazieCloudConfig\n*L\n46#1:84,3\n70#1:87\n70#1:88\n70#1:89,4\n*E\n"})
public final class GrazieCloudConfig {
    @NotNull
    public static final GrazieCloudConfig INSTANCE = new GrazieCloudConfig();
    @NotNull
    private static final String STGN_URL = "https://api.app.stgn.grazie.aws.intellij.net";

    private GrazieCloudConfig() {
    }

    private final String getApiUrl() {
        String string;
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return STGN_URL;
        }
        String string2 = Registry.Companion.stringValue("grazie.cloud.stage");
        if (Intrinsics.areEqual((Object)string2, (Object)"PROD")) {
            string = Registry.Companion.stringValue("grazie.cloud.production.url");
        } else if (Intrinsics.areEqual((Object)string2, (Object)"STGN")) {
            string = STGN_URL;
        } else {
            throw new IllegalStateException("Unknown stage for Grazie Cloud -- should be either STGN or PROD".toString());
        }
        return string;
    }

    private final GrazieAgent obtainAgent() {
        String version = String.valueOf(ApplicationInfo.getInstance().getBuild().getBaselineVersion());
        return ApplicationKt.getApplication().isUnitTestMode() ? new GrazieAgent("grazie-professional-test-plugin", version) : GrazieAgents.Plugin.INSTANCE.Professional(version);
    }

    @NotNull
    public final SuspendableAPIGatewayClient api(@NotNull SuspendableHTTPClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        GrazieLoginState loginState = GrazieLoginManager.Companion.getLastState();
        if (loginState instanceof GrazieLoginState.Enterprise) {
            return this.enterpriseClient(((GrazieLoginState.Enterprise)loginState).getState(), httpClient);
        }
        GrazieLoginState.Cloud cloud = loginState instanceof GrazieLoginState.Cloud ? (GrazieLoginState.Cloud)loginState : null;
        String string = cloud != null ? cloud.getGrazieToken() : null;
        if (string == null) {
            string = "";
        }
        SuspendableHTTPClient.WithV5 v5 = new SuspendableHTTPClient.WithV5(httpClient, new AuthData(string, null, null, null, this.obtainAgent(), null, null, null, 224, null), null, 4, null);
        return new SuspendableAPIGatewayClient(this.getApiUrl(), (SuspendableHTTPClient)v5, System.getenv("TEAMCITY_VERSION") != null ? AuthType.Application : AuthType.User, null, null, null, 56, null);
    }

    public static /* synthetic */ SuspendableAPIGatewayClient api$default(GrazieCloudConfig grazieCloudConfig, SuspendableHTTPClient suspendableHTTPClient, int n, Object object) {
        if ((n & 1) != 0) {
            boolean $i$f$service = false;
            Class<GrazieHttpClientManager> serviceClass$iv = GrazieHttpClientManager.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            suspendableHTTPClient = ((GrazieHttpClientManager)object2).getInstance();
        }
        return grazieCloudConfig.api(suspendableHTTPClient);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SuspendableAPIGatewayClient enterpriseClient(@NotNull EnterpriseState state, @NotNull SuspendableHTTPClient httpClient) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Map<String, String> map = state.getHeaders();
        HeaderCollection.Companion companion = HeaderCollection.Companion;
        boolean $i$f$mapValues = false;
        void var6_6 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            List list = CollectionsKt.listOf(it.getValue());
            map3.put(k, list);
        }
        HeaderCollection headers = HeaderCollectionKt.of((HeaderCollection.Companion)companion, (Map)destination$iv$iv$iv);
        WithCloudAuth wrapper2 = new WithCloudAuth(httpClient, headers, state){
            private final AuthVersion authVersion;
            final /* synthetic */ EnterpriseState $state;
            {
                this.$state = $state;
                super($httpClient, $headers);
                this.authVersion = AuthVersion.V5;
            }

            public AuthVersion getAuthVersion() {
                return this.authVersion;
            }

            protected Object appendHeaders(RequestOptions options, Continuation<? super RequestOptions> $completion) {
                if (!this.$state.isAIEnterpriseConnected()) {
                    Object[] objectArray = new Object[1];
                    String string = this.$state.getError();
                    if (string == null) {
                        string = "";
                    }
                    objectArray[0] = string;
                    throw new HTTPConnectionError(GrazieBundle.message("ai.enterprise.error.message", objectArray), null, 2, null);
                }
                return super.appendHeaders(options, $completion);
            }
        };
        String string = state.getEndpoint();
        if (string == null) {
            string = "no AI Enterprise server";
        }
        return new SuspendableAPIGatewayClient(string, (SuspendableHTTPClient)wrapper2, AuthType.User, null, null, null, 56, null);
    }
}

