/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.xdebugger.XDebuggerBundle;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u001a&\u0010\u0000\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001aF\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\t0\u0001\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\f\u001a\u00020\r2\u001c\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u0002H\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a8\u0006\u0012"}, d2={"open", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/Vm;", "Lorg/jetbrains/debugger/connection/RemoteVmConnection;", "address", "Ljava/net/InetSocketAddress;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "chooseDebuggee", "T", "targets", "", "selectedIndex", "", "renderer", "Lkotlin/Function2;", "Lcom/intellij/ui/ColoredListCellRenderer;", "", "intellij.platform.scriptDebugger.ui"})
public final class RemoteVmConnectionKt {
    @NotNull
    public static final Promise<? extends Vm> open(@NotNull RemoteVmConnection<?> $this$open, @NotNull InetSocketAddress address, @NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter($this$open, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        return $this$open.open(address, (Condition<Void>)((Condition)arg_0 -> RemoteVmConnectionKt.open$lambda$0(processHandler, arg_0)));
    }

    @NotNull
    public static final <T> Promise<T> chooseDebuggee(@NotNull Collection<? extends T> targets, int selectedIndex, @NotNull Function2<? super T, ? super ColoredListCellRenderer<?>, Unit> renderer) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        if (targets.size() == 1) {
            return Promises.resolvedPromise((Object)CollectionsKt.first((Iterable)targets));
        }
        if (targets.isEmpty()) {
            return Promises.rejectedPromise((String)"No tabs to inspect");
        }
        AsyncPromise result = new AsyncPromise();
        ApplicationManager.getApplication().invokeLater(() -> RemoteVmConnectionKt.chooseDebuggee$lambda$0(targets, selectedIndex, renderer, result));
        return (Promise)result;
    }

    private static final boolean open$lambda$0(ProcessHandler $processHandler, Void it) {
        return $processHandler.isProcessTerminating() || $processHandler.isProcessTerminated();
    }

    private static final Unit chooseDebuggee$lambda$0$0(AtomicReference $selected, Object value) {
        $selected.set(value);
        return Unit.INSTANCE;
    }

    private static final void chooseDebuggee$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void chooseDebuggee$lambda$0(Collection $targets, int $selectedIndex, Function2 $renderer, AsyncPromise $result) {
        List model = CollectionsKt.toMutableList((Collection)$targets);
        AtomicReference selected = new AtomicReference();
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(model).setRenderer((ListCellRenderer)new ColoredListCellRenderer<T>($renderer){
            final /* synthetic */ Function2<T, ColoredListCellRenderer<?>, Unit> $renderer;
            {
                this.$renderer = $renderer;
            }

            protected void customizeCellRenderer(JList<? extends T> list, T value, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                this.$renderer.invoke(value, (Object)((Object)this));
            }
        }).setTitle(XDebuggerBundle.message((String)"script.debugger.popup.title.choose.page", (Object[])new Object[0])).setCancelOnWindowDeactivation(true).setCancelOnClickOutside(true).setRequestFocus(true).setItemSelectedCallback(arg_0 -> RemoteVmConnectionKt.chooseDebuggee$lambda$0$1(arg_0 -> RemoteVmConnectionKt.chooseDebuggee$lambda$0$0(selected, arg_0), arg_0)).addListener(new JBPopupListener(selected, $result){
            final /* synthetic */ AtomicReference<T> $selected;
            final /* synthetic */ AsyncPromise<T> $result;
            {
                this.$selected = $selected;
                this.$result = $result;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                T value = this.$selected.get();
                if (event.isOk() && value != null) {
                    this.$result.setResult(value);
                } else {
                    String string = XDebuggerBundle.message((String)"script.debugger.popup.canceled", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.$result.setError(string);
                }
            }
        });
        if ($selectedIndex != -1) {
            builder2.setSelectedValue(model.get($selectedIndex), false);
        }
        builder2.createPopup().showInFocusCenter();
    }
}

