/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.testing.utplsql;

import com.intellij.database.actions.OracleDbmsOutputHandler;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.InterruptibleDatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlHandler;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlHandlerKt;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessagesParser;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001:B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0015\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J \u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0082@\u00a2\u0006\u0002\u0010 J4\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00160'H\u0002J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\bH\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\b2\u0006\u0010*\u001a\u00020\bH\u0002J \u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0082@\u00a2\u0006\u0002\u0010 J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\b01H\u0002J\u0016\u00102\u001a\u00020\b2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001e01H\u0002J\n\u00104\u001a\u0004\u0018\u000105H\u0016J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020\u0016H\u0014J\b\u00109\u001a\u00020\u0016H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler;", "Lcom/intellij/execution/process/ProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "paths", "", "", "tags", "coveragePath", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDs", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getTags", "()Ljava/util/List;", "job", "Lkotlinx/coroutines/Job;", "start", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "genUuid", "hookReporterTermination", "tests", "reporter", "attachReporter", "testsReporter", "Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler$Reporter;", "coverageReporter", "(Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler$Reporter;Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler$Reporter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchReporter", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "fetchSize", "", "consumer", "Lkotlin/Function1;", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "reportOutput", "input", "expected", "Lkotlin/text/Regex;", "preprocessOutput", "startTests", "testReporter", "allSchemas", "", "runScript", "reporters", "getProcessInput", "Ljava/io/OutputStream;", "detachIsDefault", "", "detachProcessImpl", "destroyProcessImpl", "Reporter", "intellij.database.dialects.oracle.ex"})
@SourceDebugExtension(value={"SMAP\nUtPlSqlHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UtPlSqlHandler.kt\ncom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n1#2:253\n*E\n"})
public final class UtPlSqlHandler
extends ProcessHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final LocalDataSource ds;
    @NotNull
    private final List<String> paths;
    @NotNull
    private final List<String> tags;
    @Nullable
    private final String coveragePath;
    @Nullable
    private Job job;
    @NotNull
    private final Regex expected;

    public UtPlSqlHandler(@NotNull Project project, @NotNull LocalDataSource ds, @NotNull List<String> paths, @NotNull List<String> tags, @Nullable String coveragePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.project = project;
        this.ds = ds;
        this.paths = paths;
        this.tags = tags;
        this.coveragePath = coveragePath;
        this.expected = new Regex("Actual: (.*?)(?: \\(.*\\))? was expected to equal: (.*?)(?: \\(.*\\))?");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LocalDataSource getDs() {
        return this.ds;
    }

    @NotNull
    public final List<String> getTags() {
        return this.tags;
    }

    @Nullable
    public final Object start(@NotNull Continuation<? super Unit> $completion) {
        Reporter reporter2;
        Reporter testReporter = new Reporter("tests_reporter", "ut_teamcity_reporter", this.genUuid());
        String string = this.coveragePath;
        if (string != null) {
            String it = string;
            boolean bl = false;
            reporter2 = new Reporter("coverage_reporter", "ut_coveralls_reporter", this.genUuid());
        } else {
            reporter2 = null;
        }
        Reporter coverageReporter = reporter2;
        Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, testReporter, coverageReporter, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ UtPlSqlHandler this$0;
            final /* synthetic */ Reporter $testReporter;
            final /* synthetic */ Reporter $coverageReporter;
            {
                this.this$0 = $receiver;
                this.$testReporter = $testReporter;
                this.$coverageReporter = $coverageReporter;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$coroutineScope;
                        ResultKt.throwOnFailure((Object)$result);
                        boolean $i$f$currentCoroutineContext = false;
                        UtPlSqlHandler.access$setJob$p(this.this$0, JobKt.getJob((CoroutineContext)this.getContext()));
                        Job tests2 = BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$testReporter, this.$coverageReporter, null){
                            int label;
                            final /* synthetic */ UtPlSqlHandler this$0;
                            final /* synthetic */ Reporter $testReporter;
                            final /* synthetic */ Reporter $coverageReporter;
                            {
                                this.this$0 = $receiver;
                                this.$testReporter = $testReporter;
                                this.$coverageReporter = $coverageReporter;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = UtPlSqlHandler.access$startTests(this.this$0, this.$testReporter, this.$coverageReporter, (Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        Job reporter2 = BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$testReporter, this.$coverageReporter, null){
                            int label;
                            final /* synthetic */ UtPlSqlHandler this$0;
                            final /* synthetic */ Reporter $testReporter;
                            final /* synthetic */ Reporter $coverageReporter;
                            {
                                this.this$0 = $receiver;
                                this.$testReporter = $testReporter;
                                this.$coverageReporter = $coverageReporter;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = UtPlSqlHandler.access$attachReporter(this.this$0, this.$testReporter, this.$coverageReporter, (Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        this.this$0.startNotify();
                        this.this$0.notifyTextAvailable(ServiceMessageBuilder.testsStarted().toString(), ProcessOutputTypes.STDOUT);
                        UtPlSqlHandler.access$hookReporterTermination(this.this$0, tests2, reporter2);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final String genUuid() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null);
    }

    private final void hookReporterTermination(Job tests2, Job reporter2) {
        tests2.invokeOnCompletion(arg_0 -> UtPlSqlHandler.hookReporterTermination$lambda$0(reporter2, arg_0));
        reporter2.invokeOnCompletion(arg_0 -> UtPlSqlHandler.hookReporterTermination$lambda$1(this, arg_0));
    }

    private final Object attachReporter(Reporter testsReporter, Reporter coverageReporter, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, testsReporter, coverageReporter, null){
            int label;
            final /* synthetic */ UtPlSqlHandler this$0;
            final /* synthetic */ Reporter $testsReporter;
            final /* synthetic */ Reporter $coverageReporter;
            {
                this.this$0 = $receiver;
                this.$testsReporter = $testsReporter;
                this.$coverageReporter = $coverageReporter;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        this.label = 2;
                        v1 = DatabaseSessionManager.getFacade((Project)this.this$0.getProject(), (DatabaseConnectionPoint)((DatabaseConnectionPoint)this.this$0.getDs()), null, null, (boolean)false, null, (DatabaseDepartment)((DatabaseDepartment)DGDepartment.TEST_RUNNER)).run((Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlHandler com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlHandler$Reporter com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlHandler$Reporter com.intellij.database.dataSource.InterruptibleDatabaseConnection ), (Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;)Lkotlin/Unit;)((UtPlSqlHandler)this.this$0, (Reporter)this.$testsReporter, (Reporter)this.$coverageReporter), (Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl22
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0$1$0(OutputStreamWriter $writer, RemoteResultSet rs) {
                $writer.write(rs.getString(1));
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$0$0(UtPlSqlHandler this$0, RemoteResultSet rs) {
                String string = rs.getString(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                UtPlSqlHandler.access$reportOutput(this$0, string);
                return Unit.INSTANCE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final Unit invokeSuspend$lambda$0(UtPlSqlHandler this$0, Reporter $testsReporter, Reporter $coverageReporter, InterruptibleDatabaseConnection connection) {
                block8: {
                    try {
                        UtPlSqlHandler.access$fetchReporter(this$0, (DatabaseConnection)connection, $testsReporter, 1, arg_0 -> attachReporter.2.invokeSuspend$lambda$0$0(this$0, arg_0));
                        if ($coverageReporter == null) break block8;
                        String string = UtPlSqlHandler.access$getCoveragePath$p(this$0);
                        Intrinsics.checkNotNull((Object)string);
                        Closeable closeable = new OutputStreamWriter((OutputStream)new FileOutputStream(string), StandardCharsets.UTF_8);
                        Throwable throwable = null;
                        try {
                            OutputStreamWriter writer = (OutputStreamWriter)closeable;
                            boolean bl = false;
                            UtPlSqlHandler.access$fetchReporter(this$0, (DatabaseConnection)connection, $coverageReporter, 10000, arg_0 -> attachReporter.2.invokeSuspend$lambda$0$1$0(writer, arg_0));
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    catch (Throwable th) {
                        UtPlSqlHandlerKt.access$getLOG$p().warn(th);
                        String string = th.getMessage();
                        if (string == null) {
                            string = th.toString();
                        }
                        this$0.notifyTextAvailable(string, ProcessOutputTypes.STDERR);
                    }
                }
                return Unit.INSTANCE;
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void fetchReporter(DatabaseConnection connection, Reporter reporter2, int fetchSize, Function1<? super RemoteResultSet, Unit> consumer) {
        SmartStatements.Companion.poweredBy(connection).call(new Configuration(false, null, null, Integer.valueOf(fetchSize), null, null, 55, null)).noisy().execute((Object)new StatementParameters().parameter((OutParameter)new CallableStatementData.SimpleOutParameter(1, -10, 0, null, null, 28, null)).asCallData(StringsKt.trimIndent((String)("\n        declare\n          l_reporter " + reporter2.getType() + " := " + reporter2.getType() + "();\n        begin\n          l_reporter.set_reporter_id('" + reporter2.getUuid() + "');\n          ? := l_reporter.get_lines_cursor();\n        end;"))), (ExecutionMode)StandardExecutionMode.GENERIC, StandardResultsProcessors.firstResult(arg_0 -> UtPlSqlHandler.fetchReporter$lambda$0(consumer, arg_0)));
    }

    private final void reportOutput(String input) {
        block0: {
            String string = this.preprocessOutput(input);
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.notifyTextAvailable(it + "\n", ProcessOutputTypes.STDOUT);
        }
    }

    private final String preprocessOutput(String input) {
        Ref.ObjectRef result = new Ref.ObjectRef();
        new ServiceMessagesParser().parse(input, new ServiceMessageParserCallback((Ref.ObjectRef<String>)result, this){
            final /* synthetic */ Ref.ObjectRef<String> $result;
            final /* synthetic */ UtPlSqlHandler this$0;
            {
                this.$result = $result;
                this.this$0 = $receiver;
            }

            public void parseException(ParseException parseException, String text) {
                Intrinsics.checkNotNullParameter((Object)parseException, (String)"parseException");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                UtPlSqlHandlerKt.access$getLOG$p().warn((Throwable)parseException);
                this.$result.element = text;
            }

            /*
             * WARNING - void declaration
             */
            public void serviceMessage(ServiceMessage message) {
                Object object;
                String it;
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Map map = message.getAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAttributes(...)");
                Map attrs = MapsKt.toMutableMap((Map)map);
                String string = (String)attrs.get("name");
                if (string != null && (string = this.fixName(string)) != null) {
                    it = string;
                    boolean bl = false;
                    attrs.put("name", it);
                }
                Ref.ObjectRef<String> objectRef = this.$result;
                ServiceMessage serviceMessage = message;
                if (serviceMessage instanceof TestStarted) {
                    String testName = ((TestStarted)message).getTestName();
                    if (((TestStarted)message).getLocationHint() == null) {
                        String string2;
                        Map map2 = attrs;
                        it = "locationHint";
                        String string3 = testName;
                        if (string3 != null) {
                            void it2;
                            String string4 = string3;
                            Ref.ObjectRef<String> objectRef2 = objectRef;
                            boolean bl = false;
                            string2 = "db://" + (String)it2;
                            objectRef = objectRef2;
                        } else {
                            string2 = null;
                        }
                        String bl = string2;
                        map2.put(it, bl);
                    }
                    object = ServiceMessage.asString((String)((TestStarted)message).getMessageName(), (Map)attrs);
                } else if (serviceMessage instanceof TestStdErr) {
                    void it3;
                    String string5 = ((TestStdErr)message).getStdErr();
                    Ref.ObjectRef<String> objectRef3 = objectRef;
                    boolean bl = false;
                    boolean bl2 = it3 == null || StringsKt.startsWith$default((String)it3, (String)"Test exception:", (boolean)false, (int)2, null);
                    objectRef = objectRef3;
                    object = bl2 ? null : ServiceMessage.asString((String)((TestStdErr)message).getMessageName(), (Map)attrs);
                } else if (serviceMessage instanceof TestFailed) {
                    if (((TestFailed)message).getFailureMessage() == null) {
                        String string6 = (String)attrs.remove("details");
                        if (string6 != null) {
                            MatchResult matchResult;
                            void details;
                            String string7 = string6;
                            UtPlSqlHandler utPlSqlHandler = this.this$0;
                            String bl = string7;
                            Ref.ObjectRef<String> objectRef4 = objectRef;
                            boolean bl3 = false;
                            attrs.put("message", details);
                            MatchResult matchResult2 = UtPlSqlHandler.access$getExpected$p(utPlSqlHandler).matchEntire((CharSequence)details);
                            if (matchResult2 != null) {
                                MatchResult matchResult3;
                                MatchResult $this$serviceMessage_u24lambda_u243_u240 = matchResult3 = matchResult2;
                                boolean bl4 = false;
                                Map map3 = attrs;
                                String string8 = "actual";
                                MatchGroup matchGroup = $this$serviceMessage_u24lambda_u243_u240.getGroups().get(1);
                                String string9 = matchGroup != null ? matchGroup.getValue() : null;
                                map3.put(string8, string9);
                                map3 = attrs;
                                string8 = "expected";
                                MatchGroup matchGroup2 = $this$serviceMessage_u24lambda_u243_u240.getGroups().get(2);
                                string9 = matchGroup2 != null ? matchGroup2.getValue() : null;
                                map3.put(string8, string9);
                                attrs.put("type", "comparisonFailure");
                                matchResult = matchResult3;
                            } else {
                                matchResult = null;
                            }
                            v11 = matchResult;
                            objectRef = objectRef4;
                        } else {
                            v11 = null;
                        }
                    }
                    object = ServiceMessage.asString((String)((TestFailed)message).getMessageName(), (Map)attrs);
                } else {
                    object = serviceMessage instanceof TestIgnored ? ServiceMessage.asString((String)((TestIgnored)message).getMessageName(), (Map)attrs) + "\n" + ServiceMessage.asString((String)"testFinished", (Map)attrs) : ServiceMessage.asString((String)message.getMessageName(), (Map)attrs);
                }
                objectRef.element = object;
            }

            private final String fixName(String $this$fixName) {
                String string = $this$fixName;
                return string != null ? StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null) : null;
            }

            public void regularText(String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.$result.element = text;
            }
        });
        return (String)result.element;
    }

    private final Object startTests(Reporter testReporter, Reporter coverageReporter, Continuation<? super Unit> $completion) {
        Object object = DatabaseSessionManager.getFacade((Project)this.project, (DatabaseConnectionPoint)((DatabaseConnectionPoint)this.ds), null, null, (boolean)false, null, (DatabaseDepartment)((DatabaseDepartment)DGDepartment.TEST_RUNNER)).run(arg_0 -> UtPlSqlHandler.startTests$lambda$0(this, testReporter, coverageReporter, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Iterable<String> allSchemas() {
        TreePattern sc = this.ds.getIntrospectionScope();
        boolean bl = false;
        JBTreeTraverser jBTreeTraverser = ((JBTreeTraverser)((JBTreeTraverser)this.ds.getModel().traverser().expand(arg_0 -> UtPlSqlHandler.allSchemas$lambda$0$1(UtPlSqlHandler::allSchemas$lambda$0$0, arg_0))).filter(arg_0 -> UtPlSqlHandler.allSchemas$lambda$0$3(arg_0 -> UtPlSqlHandler.allSchemas$lambda$0$2(sc, arg_0), arg_0))).map(arg_0 -> UtPlSqlHandler.allSchemas$lambda$0$5(UtPlSqlHandler::allSchemas$lambda$0$4, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBTreeTraverser, (String)"let(...)");
        return (Iterable)jBTreeTraverser;
    }

    private final String runScript(Iterable<Reporter> reporters) {
        return "\n    declare" + CollectionsKt.joinToString$default(reporters, (CharSequence)"", null, null, (int)0, null, UtPlSqlHandler::runScript$lambda$0, (int)30, null) + "\n    begin " + CollectionsKt.joinToString$default(reporters, (CharSequence)"", null, null, (int)0, null, UtPlSqlHandler::runScript$lambda$1, (int)30, null) + "\n      ut_runner.run(\n        ut_varchar2_list (" + CollectionsKt.joinToString$default((Iterable)this.paths, null, null, null, (int)0, null, UtPlSqlHandler::runScript$lambda$2, (int)31, null) + "),\n        ut_reporters(" + CollectionsKt.joinToString$default(reporters, null, null, null, (int)0, null, UtPlSqlHandler::runScript$lambda$3, (int)31, null) + "),\n        false,\n        ut_varchar2_list(" + CollectionsKt.joinToString$default(this.allSchemas(), null, null, null, (int)0, null, UtPlSqlHandler::runScript$lambda$4, (int)31, null) + "),\n        a_tags => " + (this.tags.isEmpty() ? "null" : ScriptGeneratorHelperKt.getSqlString((String)CollectionsKt.joinToString$default((Iterable)this.tags, (CharSequence)",", null, null, (int)0, null, UtPlSqlHandler::runScript$lambda$5, (int)30, null))) + "\n      );\n    end;";
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    public boolean detachIsDefault() {
        return false;
    }

    protected void detachProcessImpl() {
        this.notifyProcessDetached();
    }

    protected void destroyProcessImpl() {
        block0: {
            Job job = this.job;
            if (job == null) break block0;
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
    }

    private static final Unit hookReporterTermination$lambda$0(Job $reporter, Throwable e) {
        if (e != null) {
            Job.DefaultImpls.cancel$default((Job)$reporter, null, (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit hookReporterTermination$lambda$1(UtPlSqlHandler this$0, Throwable e) {
        if (!this$0.isProcessTerminated()) {
            if (e != null) {
                if (!AsyncUtil.isCancellation((Throwable)e)) {
                    String string = e.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    this$0.notifyTextAvailable(string, ProcessOutputTypes.STDERR);
                }
                this$0.notifyProcessTerminated(1);
            } else {
                this$0.notifyProcessTerminated(0);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void fetchReporter$lambda$0(Function1 $consumer, RemoteResultSet it) {
        Cancellation.checkCancelled();
        Intrinsics.checkNotNull((Object)it);
        $consumer.invoke((Object)it);
    }

    private static final Unit startTests$lambda$0$0(ResultsProducer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit startTests$lambda$0(UtPlSqlHandler this$0, Reporter $testReporter, Reporter $coverageReporter, InterruptibleDatabaseConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        new OracleDbmsOutputHandler().enable((DatabaseConnection)connection, 10000000);
        Object[] objectArray = new Reporter[]{$testReporter, $coverageReporter};
        SmartStatements.Companion.poweredBy((DatabaseConnection)connection).simple().noisy().execute((Object)this$0.runScript(CollectionsKt.listOfNotNull((Object[])objectArray)), UtPlSqlHandler::startTests$lambda$0$0);
        return Unit.INSTANCE;
    }

    private static final boolean allSchemas$lambda$0$0(DasObject it) {
        return Intrinsics.areEqual((Object)it.getKind(), (Object)ObjectKind.ROOT);
    }

    private static final boolean allSchemas$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean allSchemas$lambda$0$2(TreePattern $sc, DasObject it) {
        return Intrinsics.areEqual((Object)it.getKind(), (Object)ObjectKind.SCHEMA) && DataSourceSchemaMapping.isIntrospected((TreePattern)$sc, (DasObject)it);
    }

    private static final boolean allSchemas$lambda$0$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String allSchemas$lambda$0$4(DasObject it) {
        return it.getName();
    }

    private static final String allSchemas$lambda$0$5(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final CharSequence runScript$lambda$0(Reporter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Reporter $this$runScript_u24lambda_u240_u240 = it;
        boolean bl = false;
        return "\n      " + $this$runScript_u24lambda_u240_u240.getName() + " " + $this$runScript_u24lambda_u240_u240.getType() + " := " + $this$runScript_u24lambda_u240_u240.getType() + "();";
    }

    private static final CharSequence runScript$lambda$1(Reporter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Reporter $this$runScript_u24lambda_u241_u240 = it;
        boolean bl = false;
        return "\n      " + $this$runScript_u24lambda_u241_u240.getName() + ".set_reporter_id('" + $this$runScript_u24lambda_u241_u240.getUuid() + "');\n      " + $this$runScript_u24lambda_u241_u240.getName() + ".output_buffer.init();";
    }

    private static final CharSequence runScript$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ScriptGeneratorHelperKt.getSqlString((String)it);
    }

    private static final CharSequence runScript$lambda$3(Reporter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence runScript$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ScriptGeneratorHelperKt.getSqlString((String)it);
    }

    private static final CharSequence runScript$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    public static final /* synthetic */ void access$setJob$p(UtPlSqlHandler $this, Job job) {
        $this.job = job;
    }

    public static final /* synthetic */ Object access$startTests(UtPlSqlHandler $this, Reporter testReporter, Reporter coverageReporter, Continuation $completion) {
        return $this.startTests(testReporter, coverageReporter, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$attachReporter(UtPlSqlHandler $this, Reporter testsReporter, Reporter coverageReporter, Continuation $completion) {
        return $this.attachReporter(testsReporter, coverageReporter, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$hookReporterTermination(UtPlSqlHandler $this, Job tests2, Job reporter2) {
        $this.hookReporterTermination(tests2, reporter2);
    }

    public static final /* synthetic */ void access$reportOutput(UtPlSqlHandler $this, String input) {
        $this.reportOutput(input);
    }

    public static final /* synthetic */ void access$fetchReporter(UtPlSqlHandler $this, DatabaseConnection connection, Reporter reporter2, int fetchSize, Function1 consumer) {
        $this.fetchReporter(connection, reporter2, fetchSize, (Function1<? super RemoteResultSet, Unit>)consumer);
    }

    public static final /* synthetic */ String access$getCoveragePath$p(UtPlSqlHandler $this) {
        return $this.coveragePath;
    }

    public static final /* synthetic */ Regex access$getExpected$p(UtPlSqlHandler $this) {
        return $this.expected;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHandler$Reporter;", "", "name", "", "type", "uuid", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getType", "getUuid", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.dialects.oracle.ex"})
    private static final class Reporter {
        @NotNull
        private final String name;
        @NotNull
        private final String type;
        @NotNull
        private final String uuid;

        public Reporter(@NotNull String name, @NotNull String type, @NotNull String uuid) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            this.name = name;
            this.type = type;
            this.uuid = uuid;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getUuid() {
            return this.uuid;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final String component3() {
            return this.uuid;
        }

        @NotNull
        public final Reporter copy(@NotNull String name, @NotNull String type, @NotNull String uuid) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return new Reporter(name, type, uuid);
        }

        public static /* synthetic */ Reporter copy$default(Reporter reporter2, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = reporter2.name;
            }
            if ((n & 2) != 0) {
                string2 = reporter2.type;
            }
            if ((n & 4) != 0) {
                string3 = reporter2.uuid;
            }
            return reporter2.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Reporter(name=" + this.name + ", type=" + this.type + ", uuid=" + this.uuid + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + this.uuid.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Reporter)) {
                return false;
            }
            Reporter reporter2 = (Reporter)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)reporter2.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)reporter2.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.uuid, (Object)reporter2.uuid);
        }
    }
}

