/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.completion;

import com.intellij.codeInsight.lookup.LookupElementInsertStopper;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.EmptyIcon;
import com.jetbrains.rd.ide.completion.IProtocolLookupItem;
import com.jetbrains.rd.ide.model.CompletionItem;
import com.jetbrains.rd.ide.model.LookupSummaryInfo;
import com.jetbrains.rd.ui.completion.RdLookupItemBase;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0016\u0018\u0000 \"2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\"B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0004J\u0006\u0010\u0019\u001a\u00020\tJ\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010!\u001a\u00020\tH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n\u0018\u00010\u0015j\u0004\u0018\u0001`\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lcom/jetbrains/rdclient/completion/ProtocolLookupItemBase;", "Lcom/jetbrains/rd/ide/completion/IProtocolLookupItem;", "Lcom/jetbrains/rd/ui/completion/RdLookupItemBase;", "Lcom/intellij/codeInsight/lookup/LookupElementInsertStopper;", "completionItem", "Lcom/jetbrains/rd/ide/model/CompletionItem;", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "suppressJavadoc", "", "<init>", "(Lcom/jetbrains/rd/ide/model/CompletionItem;Lcom/jetbrains/rd/util/lifetime/Lifetime;Z)V", "getSessionLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "summaryInfo", "Lcom/jetbrains/rd/ide/model/LookupSummaryInfo;", "getSummaryInfo", "()Lcom/jetbrains/rd/ide/model/LookupSummaryInfo;", "setSummaryInfo", "(Lcom/jetbrains/rd/ide/model/LookupSummaryInfo;)V", "lifetimeTerminationStacktrace", "Ljava/lang/Exception;", "Lkotlin/Exception;", "checkLifetime", "", "shouldRequestUpdate", "renderElement", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "priority", "", "getPriority", "()J", "shouldStopLookupInsertion", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nProtocolLookupItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolLookupItem.kt\ncom/jetbrains/rdclient/completion/ProtocolLookupItemBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,74:1\n67#2,4:75\n13#2:81\n1#3:79\n13#4:80\n*S KotlinDebug\n*F\n+ 1 ProtocolLookupItem.kt\ncom/jetbrains/rdclient/completion/ProtocolLookupItemBase\n*L\n41#1:75,4\n26#1:81\n26#1:80\n*E\n"})
public class ProtocolLookupItemBase
extends RdLookupItemBase
implements IProtocolLookupItem,
LookupElementInsertStopper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime sessionLifetime;
    @Nullable
    private LookupSummaryInfo summaryInfo;
    @Nullable
    private Exception lifetimeTerminationStacktrace;
    @NotNull
    private static final Logger logger;

    public ProtocolLookupItemBase(@NotNull CompletionItem completionItem, @NotNull Lifetime sessionLifetime, boolean suppressJavadoc) {
        Intrinsics.checkNotNullParameter((Object)completionItem, (String)"completionItem");
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        super(completionItem);
        this.sessionLifetime = sessionLifetime;
        if (suppressJavadoc) {
            this.putUserData(LookupManagerImpl.Companion.getSUPPRESS_AUTOPOPUP_JAVADOC(), true);
        }
        if (logger.isTraceEnabled() && RLifetimeKt.isNotAlive((Lifetime)this.sessionLifetime)) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Lifetime of lookup item " + this + " is terminated");
            }
        }
        this.sessionLifetime.onTerminationIfAlive(() -> ProtocolLookupItemBase._init_$lambda$1(this));
    }

    public /* synthetic */ ProtocolLookupItemBase(CompletionItem completionItem, Lifetime lifetime, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(completionItem, lifetime, bl);
    }

    @NotNull
    public final Lifetime getSessionLifetime() {
        return this.sessionLifetime;
    }

    @Nullable
    public final LookupSummaryInfo getSummaryInfo() {
        return this.summaryInfo;
    }

    public final void setSummaryInfo(@Nullable LookupSummaryInfo lookupSummaryInfo) {
        this.summaryInfo = lookupSummaryInfo;
    }

    protected final void checkLifetime() {
        if (logger.isTraceEnabled() && RLifetimeKt.isNotAlive((Lifetime)this.sessionLifetime)) {
            logger.error("Session lifetime of lookup item " + this + " was terminated from following stack", (Throwable)this.lifetimeTerminationStacktrace);
        }
        if (!RLifetimeKt.isAlive((Lifetime)this.sessionLifetime)) {
            boolean bl = false;
            String string = "Session lifetime of lookup item " + this + " is terminated";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final boolean shouldRequestUpdate() {
        return this.getDisplayName() == null;
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        super.renderElement(presentation);
        if (presentation.getIcon() == null) {
            presentation.setIcon(EmptyIcon.ICON_16);
        }
    }

    public long getPriority() {
        return this.getCompletionItem().getPriority();
    }

    public boolean shouldStopLookupInsertion() {
        return Intrinsics.areEqual((Object)this.getCompletionItem().getShouldStopLookupInsertion(), (Object)true);
    }

    private static final Unit _init_$lambda$1(ProtocolLookupItemBase this$0) {
        if (logger.isTraceEnabled()) {
            this$0.lifetimeTerminationStacktrace = new Exception();
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProtocolLookupItemBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProtocolLookupItemBase.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/completion/ProtocolLookupItemBase$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

