/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant.actions;

import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.plugins.vagrant.VagrantBundle;
import com.jetbrains.plugins.vagrant.VagrantFileConfig;
import com.jetbrains.plugins.vagrant.VagrantInstance;
import com.jetbrains.plugins.vagrant.VagrantManager;
import com.jetbrains.plugins.vagrant.actions.VagrantActionBase;
import com.jetbrains.plugins.vagrant.actions.VagrantTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class VagrantMultipleVmAwareAction
extends VagrantActionBase {
    public static final String RUN_ALL_CONFIGURATIONS = "Run all configurations";

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            VagrantMultipleVmAwareAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            Messages.showErrorDialog((Project)project, (String)VagrantBundle.message("vagrant.error.project.is.null", new Object[0]), (String)VagrantBundle.message("vagrant.error.title", new Object[0]));
            return;
        }
        VagrantInstance instance = VagrantManager.getInstance(project).currentInstance();
        if (instance != null) {
            VagrantFileConfig vagrantfile = instance.getVagrantFile();
            if (vagrantfile != null) {
                List<String> vms = vagrantfile.getMachineConfigurationNames();
                if (vms != null && vms.size() > 1) {
                    vms.add(0, RUN_ALL_CONFIGURATIONS);
                    BaseListPopupStep<String> vmsStep = new BaseListPopupStep<String>(VagrantBundle.message("vagrant.select.vm.configuration", new Object[0]), vms){

                        public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                            if (VagrantMultipleVmAwareAction.RUN_ALL_CONFIGURATIONS.equals(selectedValue)) {
                                VagrantMultipleVmAwareAction.this.createVagrantTask(project, task -> VagrantMultipleVmAwareAction.this.performTask(project, (VagrantTask)task));
                            } else {
                                VagrantMultipleVmAwareAction.this.createVagrantTask(project, task -> {
                                    if (task != null) {
                                        ArrayList commands = Lists.newArrayList((Object[])task.getCommands());
                                        commands.add(selectedValue);
                                        task.setCommands(ArrayUtilRt.toStringArray((Collection)commands));
                                    }
                                    VagrantMultipleVmAwareAction.this.performTask(project, (VagrantTask)task);
                                });
                            }
                            return FINAL_CHOICE;
                        }
                    };
                    ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)vmsStep);
                    popup.showInBestPositionFor(e.getDataContext());
                } else {
                    super.actionPerformed(e);
                }
            } else {
                Messages.showErrorDialog((Project)project, (String)VagrantBundle.message("vagrant.no.vagrantfile.in", instance.getFolder()), (String)VagrantBundle.message("vagrant.no.vagrantfile.title", new Object[0]));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/vagrant/actions/VagrantMultipleVmAwareAction", "actionPerformed"));
    }
}

