/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant.state.global;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.jetbrains.plugins.vagrant.state.FileCacheKt;
import com.jetbrains.plugins.vagrant.state.FileCacheWithDefaultResolver;
import com.jetbrains.plugins.vagrant.state.global.MachineIndex;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugins/vagrant/state/global/GlobalStatus;", "", "<init>", "()V", "myMachineIndexCache", "Lkotlin/Lazy;", "Lcom/jetbrains/plugins/vagrant/state/FileCacheWithDefaultResolver;", "Lcom/jetbrains/plugins/vagrant/state/global/MachineIndex;", "vagrantHome", "", "getMachineIndexPath", "Ljava/nio/file/Path;", "getMachineIndexLastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "getMachineIndex", "Companion", "intellij.vagrant"})
public final class GlobalStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy<FileCacheWithDefaultResolver<MachineIndex>> myMachineIndexCache = LazyKt.lazy(() -> GlobalStatus.myMachineIndexCache$lambda$0(this));
    @NotNull
    private final Lazy<String> vagrantHome = LazyKt.lazy(GlobalStatus::vagrantHome$lambda$0);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String VAGRANT_HOME_ENV = "VAGRANT_HOME";
    @NotNull
    private static final String DEFAULT_VAGRANT_HOME = "~/.vagrant.d";

    @NotNull
    public final Path getMachineIndexPath() {
        String[] stringArray = new String[]{"data", "machine-index", "index"};
        Path path = Paths.get((String)this.vagrantHome.getValue(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public final FileTime getMachineIndexLastModifiedTime() throws IOException {
        FileTime fileTime = Files.getLastModifiedTime(this.getMachineIndexPath(), new LinkOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
        return fileTime;
    }

    @NotNull
    public final MachineIndex getMachineIndex() throws IOException {
        return (MachineIndex)((FileCacheWithDefaultResolver)this.myMachineIndexCache.getValue()).getContent();
    }

    private static final MachineIndex myMachineIndexCache$lambda$0$0(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        LOG.debug("Updating Vagrant machine-index cache from \"" + path + "\"");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return MachineIndex.Factory.parse(file);
    }

    private static final FileCacheWithDefaultResolver myMachineIndexCache$lambda$0(GlobalStatus this$0) {
        return new FileCacheWithDefaultResolver(this$0.getMachineIndexPath(), FileCacheKt.resolver(GlobalStatus::myMachineIndexCache$lambda$0$0));
    }

    private static final String vagrantHome$lambda$0() {
        Object object;
        String vagrantHome;
        String string;
        String env = System.getenv(VAGRANT_HOME_ENV);
        if (env != null) {
            LOG.debug("Using VAGRANT_HOME=" + env + " environment variable");
        }
        if ((string = env) == null) {
            string = DEFAULT_VAGRANT_HOME;
        }
        if (StringsKt.startsWith$default((String)(vagrantHome = string), (String)"~", (boolean)false, (int)2, null)) {
            String string2 = SystemProperties.getUserHome();
            String string3 = vagrantHome.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            object = string2 + string3;
        } else {
            object = vagrantHome;
        }
        return object;
    }

    static {
        Logger logger = Logger.getInstance(GlobalStatus.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/plugins/vagrant/state/global/GlobalStatus$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "VAGRANT_HOME_ENV", "", "DEFAULT_VAGRANT_HOME", "intellij.vagrant"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

