/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginCpuArchRequirement;
import com.intellij.ide.plugins.PluginNonLoadReason;
import com.intellij.util.system.CpuArch;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015R\u0019\u0010\u0019\u001a\u00070\u0012\u00a2\u0006\u0002\b\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/intellij/ide/plugins/PluginIsIncompatibleWithHostCpu;", "Lcom/intellij/ide/plugins/PluginNonLoadReason;", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "requiredCpuArch", "Lcom/intellij/ide/plugins/PluginCpuArchRequirement;", "hostCpu", "Lcom/intellij/util/system/CpuArch;", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptor;Lcom/intellij/ide/plugins/PluginCpuArchRequirement;Lcom/intellij/util/system/CpuArch;)V", "getPlugin", "()Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getRequiredCpuArch", "()Lcom/intellij/ide/plugins/PluginCpuArchRequirement;", "getHostCpu", "()Lcom/intellij/util/system/CpuArch;", "detailedMessage", "", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "getDetailedMessage", "()Ljava/lang/String;", "shortMessage", "Lcom/intellij/openapi/util/NlsContexts$Label;", "getShortMessage", "logMessage", "Lorg/jetbrains/annotations/NonNls;", "getLogMessage", "shouldNotifyUser", "", "getShouldNotifyUser", "()Z", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginIsIncompatibleWithHostCpu
implements PluginNonLoadReason {
    @NotNull
    private final IdeaPluginDescriptor plugin;
    @NotNull
    private final PluginCpuArchRequirement requiredCpuArch;
    @NotNull
    private final CpuArch hostCpu;
    private final boolean shouldNotifyUser;

    public PluginIsIncompatibleWithHostCpu(@NotNull IdeaPluginDescriptor plugin, @NotNull PluginCpuArchRequirement requiredCpuArch, @NotNull CpuArch hostCpu) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)requiredCpuArch, (String)"requiredCpuArch");
        Intrinsics.checkNotNullParameter((Object)hostCpu, (String)"hostCpu");
        this.plugin = plugin;
        this.requiredCpuArch = requiredCpuArch;
        this.hostCpu = hostCpu;
        this.shouldNotifyUser = true;
    }

    @Override
    @NotNull
    public IdeaPluginDescriptor getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final PluginCpuArchRequirement getRequiredCpuArch() {
        return this.requiredCpuArch;
    }

    @NotNull
    public final CpuArch getHostCpu() {
        return this.hostCpu;
    }

    @Override
    @NotNull
    public String getDetailedMessage() {
        Object[] objectArray = new Object[]{this.getPlugin().getName(), this.getPlugin().getVersion(), this.requiredCpuArch, this.hostCpu};
        return CoreBundle.message((String)"plugin.loading.error.long.incompatible.with.cpu", (Object[])objectArray);
    }

    @Override
    @NotNull
    public String getShortMessage() {
        Object[] objectArray = new Object[]{this.requiredCpuArch};
        return CoreBundle.message((String)"plugin.loading.error.short.incompatible.with.platform", (Object[])objectArray);
    }

    @Override
    @NotNull
    public String getLogMessage() {
        return "Plugin '" + this.getPlugin().getName() + "' (" + this.getPlugin().getPluginId() + ", version=" + this.getPlugin().getVersion() + ") requires CPU " + this.requiredCpuArch + " but the current platform is " + this.hostCpu;
    }

    @Override
    public boolean getShouldNotifyUser() {
        return this.shouldNotifyUser;
    }
}

